/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.engine.ai;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import net.yura.domination.engine.ai.AISubmissive;
import net.yura.domination.engine.core.Country;
import net.yura.domination.engine.core.Player;

public class AITest
extends AISubmissive {
    public int getType() {
        return 5;
    }

    public String getCommand() {
        return "test";
    }

    public String getPlaceArmies() {
        if (!this.game.NoEmptyCountries()) {
            return "autoplace";
        }
        Vector t = this.player.getTerritoriesOwned();
        String name = null;
        name = AITest.findAttackableTerritory(this.player);
        if (name == null) {
            return "placearmies " + ((Country)t.get(0)).getColor() + " " + this.player.getExtraArmies();
        }
        if (this.game.getSetupDone()) {
            return "placearmies " + name + " " + this.player.getExtraArmies();
        }
        return "placearmies " + name + " 1";
    }

    public String getAttack() {
        List outputs = new ArrayList();
        outputs = AITest.findAttackableNeighbors(this.player, 0.0);
        if (outputs.size() > 0) {
            Attack move = (Attack)outputs.get((int)Math.round(Math.random() * (double)(outputs.size() - 1)));
            return move.toString();
        }
        return "endattack";
    }

    public String getRoll() {
        int n = this.game.getAttacker().getArmies() - 1;
        if (n > 3) {
            return "roll 3";
        }
        return "roll " + n;
    }

    public static String findAttackableTerritory(Player p) {
        Vector countries = p.getTerritoriesOwned();
        for (int i = 0; i < countries.size(); ++i) {
            Vector neighbors = ((Country)countries.get(i)).getNeighbours();
            for (int j = 0; j < neighbors.size(); ++j) {
                if (((Country)neighbors.get(j)).getOwner() == p || p.getCapital() != null && (p.getCapital() == null || ((Country)countries.get(i)).getColor() == p.getCapital().getColor())) continue;
                return String.valueOf(((Country)countries.get(i)).getColor());
            }
        }
        return null;
    }

    public static List findAttackableNeighbors(Player player, double ratio) {
        Vector t = player.getTerritoriesOwned();
        ArrayList<Attack> output = new ArrayList<Attack>();
        if (ratio < 0.0) {
            ratio = 0.0;
        }
        for (int a = 0; a < t.size(); ++a) {
            Country source = (Country)t.get(a);
            if (source.getOwner() != player || source.getArmies() <= 1) continue;
            Vector n = source.getNeighbours();
            for (int b = 0; b < n.size(); ++b) {
                Country target = (Country)n.get(b);
                if (target.getOwner() == player || !((double)source.getArmies() / (double)target.getArmies() > ratio)) continue;
                output.add(new Attack(source, target));
            }
        }
        return output;
    }

    public static class Attack {
        public final Country source;
        public final Country destination;

        public Attack(Country s, Country d) {
            this.source = s;
            this.destination = d;
        }

        public String toString() {
            if (this.source == null || this.destination == null) {
                return "";
            }
            return "attack " + this.source.getColor() + " " + this.destination.getColor();
        }
    }
}

