/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.engine.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.yura.domination.engine.core.StatType;

public class Statistic
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int[] statistics = new int[13];
    private double dice;
    private int diceCount;

    public void endGoStatistics(int countries, int armies, int continents, int conectedEmpire, int cards) {
        this.statistics[StatType.COUNTRIES.ordinal()] = countries;
        this.statistics[StatType.ARMIES.ordinal()] = armies;
        this.statistics[StatType.CONTINENTS.ordinal()] = continents;
        this.statistics[StatType.CONNECTED_EMPIRE.ordinal()] = conectedEmpire;
        this.statistics[StatType.CARDS.ordinal()] = cards;
    }

    public void addReinforcements(int a) {
        int n = StatType.REINFORCEMENTS.ordinal();
        this.statistics[n] = this.statistics[n] + a;
    }

    public void addKill() {
        int n = StatType.KILLS.ordinal();
        this.statistics[n] = this.statistics[n] + 1;
    }

    public void addCasualty() {
        int n = StatType.CASUALTIES.ordinal();
        this.statistics[n] = this.statistics[n] + 1;
    }

    public void addAttack() {
        int n = StatType.ATTACKS.ordinal();
        this.statistics[n] = this.statistics[n] + 1;
    }

    public void addAttacked() {
        int n = StatType.ATTACKED.ordinal();
        this.statistics[n] = this.statistics[n] + 1;
    }

    public void addRetreat() {
        int n = StatType.RETREATS.ordinal();
        this.statistics[n] = this.statistics[n] + 1;
    }

    public void addCountriesWon() {
        int n = StatType.COUNTRIES_WON.ordinal();
        this.statistics[n] = this.statistics[n] + 1;
    }

    public void addCountriesLost() {
        int n = StatType.COUNTRIES_LOST.ordinal();
        this.statistics[n] = this.statistics[n] + 1;
    }

    public void addDice(int diceValue) {
        this.dice = (this.dice * (double)this.diceCount + (double)diceValue + 1.0) / (double)(this.diceCount + 1);
        ++this.diceCount;
    }

    public double get(StatType statType) {
        if (statType == StatType.DICE) {
            if (this.diceCount == 0) {
                return Double.NaN;
            }
            return this.dice;
        }
        return this.statistics[statType.ordinal()];
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.statistics.length < 13) {
            int[] old = this.statistics;
            this.statistics = new int[13];
            System.arraycopy(old, 0, this.statistics, 0, old.length);
        }
    }
}

