/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.engine.p2pclient;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import net.yura.domination.engine.OnlineRisk;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.engine.core.RiskGame;
import net.yura.domination.engine.p2pclient.ChatDisplayThread;

public class ChatClient
implements OnlineRisk {
    private String myUID;
    private PrintWriter outChat = null;
    private BufferedReader inChat = null;
    private Socket chatSocket = null;
    private ChatDisplayThread myReader = null;

    public ChatClient(Risk risk, String uid, String host, int port) throws Exception {
        this.myUID = uid;
        this.chatSocket = new Socket(host, port);
        this.outChat = new PrintWriter((Writer)new OutputStreamWriter(this.chatSocket.getOutputStream(), RiskUtil.UTF_8), true);
        this.inChat = new BufferedReader(new InputStreamReader(this.chatSocket.getInputStream(), RiskUtil.UTF_8));
        this.myReader = new ChatDisplayThread(risk, this.inChat);
        this.myReader.start();
        this.outChat.println("14 " + uid + " " + RiskGame.getDefaultMap());
    }

    public void sendGameCommand(String gameCommand) {
        this.outChat.println(gameCommand);
    }

    public void sendUserCommand(String command) {
        this.outChat.println(this.myUID + " " + command);
    }

    public void closeGame() {
        try {
            this.outChat.close();
            this.inChat.close();
            this.chatSocket.shutdownInput();
            this.chatSocket.shutdownOutput();
            this.chatSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.chatSocket = null;
    }

    public void playerRenamed(String oldName, String newName, String newAddress, int newType) {
    }
}

