/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.engine.translation;

import java.util.Locale;
import java.util.ResourceBundle;
import net.yura.domination.engine.RiskUtil;

public class TranslationBundle {
    private static ResourceBundle resBundle = null;
    private static String strLanguage = null;

    public static ResourceBundle getBundle() {
        if (resBundle == null) {
            TranslationBundle.loadBundle();
        }
        return resBundle;
    }

    private static void loadBundle() {
        Locale loc;
        if (strLanguage == null) {
            loc = Locale.getDefault();
        } else {
            loc = TranslationBundle.getLocale(strLanguage);
            Locale.setDefault(loc);
        }
        resBundle = RiskUtil.getResourceBundle(TranslationBundle.class, "Risk", loc);
    }

    public static Locale getLocale(String localeString) {
        if ("".equals(localeString)) {
            return new Locale("");
        }
        String[] splitname = localeString.split("\\_");
        switch (splitname.length) {
            case 1: {
                return new Locale(splitname[0]);
            }
            case 2: {
                return new Locale(splitname[0], splitname[1]);
            }
            case 3: {
                return new Locale(splitname[0], splitname[1], splitname[2]);
            }
        }
        throw new IllegalArgumentException("bad local name: " + localeString);
    }

    public static void setLanguage(String strL) {
        strLanguage = strL;
        TranslationBundle.loadBundle();
    }

    public static void parseArgs(String[] args) {
        for (int nA = 0; nA < args.length; ++nA) {
            if (args[nA].length() <= 7 || !args[nA].substring(0, 7).equals("--lang=")) continue;
            TranslationBundle.setLanguage(args[nA].substring(7));
        }
    }
}

