/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.guishared;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.plaf.UIResource;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.core.Player;
import net.yura.domination.engine.core.StatType;
import net.yura.domination.guishared.RiskUIUtil;
import net.yura.swing.GraphicsUtil;

public class StatsPanel
extends JPanel {
    private Risk risk;
    private BufferedImage graph;
    private int ZeroX;
    private int ZeroY;
    private double gridSizeX;
    private double gridSizeY;

    public StatsPanel(Risk r) {
        this.risk = r;
        Font font = this.getFont();
        Font newFont = font.deriveFont((float)((double)font.getSize() * GraphicsUtil.scale));
        if (newFont instanceof UIResource) {
            System.out.println("ERROR: deriveFont returned a UIResource " + newFont);
            newFont = new Font(font.getName(), font.getStyle(), (int)((double)font.getSize2D() * GraphicsUtil.scale));
        }
        this.setFont(newFont);
    }

    public void paintComponent(Graphics g) {
        if (this.graph != null) {
            g.drawImage(this.graph, 0, 0, this.getWidth(), this.getHeight(), this);
        } else {
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public void repaintStats(StatType a) {
        double scale = GraphicsUtil.scale;
        BufferedImage tempgraph = new BufferedImage((int)((double)this.getWidth() * scale), (int)((double)this.getHeight() * scale), 1);
        Vector players = this.risk.getGame().getPlayersStats();
        int maxValue = 0;
        int maxTurns = 0;
        for (int i = 0; i < players.size(); ++i) {
            Player p = (Player)players.get(i);
            double[] pstats = p.getStatistics(a);
            int max = pstats.length;
            if (max > maxTurns) {
                maxTurns = max;
            }
            double sum = 0.0;
            for (int j = 0; j < pstats.length; ++j) {
                if (a.isSummable()) {
                    sum += pstats[j];
                    continue;
                }
                if (!(pstats[j] > (double)maxValue)) continue;
                maxValue = (int)pstats[j];
            }
            if (!(sum > (double)maxValue)) continue;
            maxValue = (int)sum;
        }
        ++maxValue;
        Graphics2D g2 = tempgraph.createGraphics();
        g2.setFont(this.getFont());
        int xOffset = this.scale(35);
        int yOffset = this.scale(25);
        this.gridSizeX = ((float)(tempgraph.getWidth() - xOffset) - (float)this.scale(20)) / (float)(++maxTurns);
        this.gridSizeY = ((float)(tempgraph.getHeight() - yOffset) - (float)this.scale(20)) / (float)maxValue;
        this.ZeroX = xOffset;
        this.ZeroY = tempgraph.getHeight() - yOffset;
        int bob = (int)Math.round((double)g2.getFontMetrics().getHeight() / this.gridSizeY);
        for (int i = 0; i <= maxValue; ++i) {
            if (i != maxValue && bob != 0 && i % bob != 0) continue;
            g2.setColor(Color.gray);
            g2.drawLine(this.ZeroX, (int)((double)this.ZeroY - (double)i * this.gridSizeY), (int)((double)maxTurns * this.gridSizeX) + this.ZeroX, (int)((double)this.ZeroY - (double)i * this.gridSizeY));
            g2.setColor(Color.white);
            String label = String.valueOf(i);
            int labelWidth = g2.getFontMetrics().stringWidth(label);
            g2.drawString(label, this.ZeroX - (this.scale(6) + labelWidth), (int)((double)this.ZeroY - (double)i * this.gridSizeY + (double)this.scale(5)));
        }
        int fred = (int)Math.round((double)g2.getFontMetrics().stringWidth(String.valueOf(maxTurns)) / this.gridSizeX);
        for (int i = 0; i <= maxTurns; ++i) {
            g2.setColor(Color.gray);
            g2.drawLine((int)((double)this.ZeroX + (double)i * this.gridSizeX), this.ZeroY, (int)((double)this.ZeroX + (double)i * this.gridSizeX), (int)((double)this.ZeroY - (double)maxValue * this.gridSizeY));
            if (i != maxTurns && fred != 0 && i % fred != 0) continue;
            g2.setColor(Color.white);
            int labelHeight = g2.getFontMetrics().getHeight();
            g2.drawString(String.valueOf(i), (int)((double)i * this.gridSizeX + (double)this.ZeroX - (double)this.scale(3)), this.ZeroY + labelHeight);
        }
        g2.setColor(Color.white);
        g2.drawLine(this.ZeroX, this.ZeroY, (int)((double)this.ZeroX + (double)maxTurns * this.gridSizeX), this.ZeroY);
        g2.drawLine(this.ZeroX, this.ZeroY, this.ZeroX, (int)((double)this.ZeroY - (double)maxValue * this.gridSizeY));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        BasicStroke bs = new BasicStroke(2.0f, 1, 0);
        g2.setStroke(bs);
        for (int i = 0; i < players.size(); ++i) {
            this.drawPlayerGraph(a, (Player)players.get(i), g2);
        }
        g2.dispose();
        this.graph = tempgraph;
    }

    private int scale(int n) {
        return (int)(GraphicsUtil.density * (double)n);
    }

    private void drawPlayerGraph(StatType a, Player p, Graphics2D g) {
        int i;
        double[] PointToDraw = p.getStatistics(a);
        g.setColor(new Color(p.getColor()));
        Image icon = RiskUIUtil.getIconForColor(p.getColor());
        int iconSize = this.scale(15);
        double oldPoint = Double.NaN;
        double newPoint = 0.0;
        for (i = 0; i < PointToDraw.length; ++i) {
            newPoint = a.isSummable() ? (newPoint += PointToDraw[i]) : PointToDraw[i];
            if (!Double.isNaN(newPoint)) {
                int y1;
                int x1;
                if (!Double.isNaN(oldPoint)) {
                    x1 = (int)((double)this.ZeroX + (double)i * this.gridSizeX);
                    y1 = (int)((double)this.ZeroY - oldPoint * this.gridSizeY);
                } else {
                    x1 = (int)((double)this.ZeroX + (double)(i + 1) * this.gridSizeX) - 3;
                    y1 = (int)((double)this.ZeroY - newPoint * this.gridSizeY);
                }
                int x2 = (int)((double)this.ZeroX + (double)(i + 1) * this.gridSizeX);
                int y2 = (int)((double)this.ZeroY - newPoint * this.gridSizeY);
                Color color = g.getColor();
                Stroke stroke = g.getStroke();
                if (Color.BLACK.equals(color)) {
                    g.setColor(Color.WHITE);
                    g.setStroke(new BasicStroke(3.0f));
                    g.drawLine(x1, y1, x2, y2);
                    g.setColor(color);
                    g.setStroke(stroke);
                }
                g.drawLine(x1, y1, x2, y2);
                if (!Double.isNaN(oldPoint) && icon != null) {
                    GraphicsUtil.drawImageInRect(g, icon, x1 - iconSize / 2, y1 - iconSize / 2, iconSize, iconSize, this);
                }
            }
            oldPoint = newPoint;
        }
        int x = (int)((double)this.ZeroX + (double)i * this.gridSizeX);
        int y = (int)((double)this.ZeroY - oldPoint * this.gridSizeY + 11.0);
        Color color = g.getColor();
        if (Color.BLACK.equals(color)) {
            g.setColor(Color.WHITE);
            g.drawString(p.getName(), x + 1, y + 1);
            g.drawString(p.getName(), x - 1, y - 1);
            g.drawString(p.getName(), x + 1, y - 1);
            g.drawString(p.getName(), x - 1, y + 1);
            g.setColor(color);
        }
        String playerName = p.getName();
        int textWidth = g.getFontMetrics().stringWidth(playerName);
        g.drawString(playerName, Math.min(x, (int)((double)this.getWidth() * GraphicsUtil.scale) - textWidth), y);
    }
}

