/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.lobby.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import java.util.Observer;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import javax.swing.Icon;
import net.yura.domination.engine.OnlineRisk;
import net.yura.domination.engine.OnlineUtil;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskIO;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.engine.core.Player;
import net.yura.domination.engine.core.RiskGame;
import net.yura.domination.guishared.RiskUIUtil;
import net.yura.domination.lobby.client.GameSetupPanel;
import net.yura.domination.lobby.client.GameSidePanel;
import net.yura.domination.lobby.client.RiskMap;
import net.yura.domination.mapstore.MapPreview;
import net.yura.domination.ui.flashgui.FlashRiskAdapter;
import net.yura.domination.ui.flashgui.GameFrame;
import net.yura.lobby.client.LobbyClientGUI;
import net.yura.lobby.client.ResBundle;
import net.yura.lobby.client.TurnBasedAdapter;
import net.yura.lobby.model.Game;

public class ClientGameRisk
extends TurnBasedAdapter
implements OnlineRisk {
    private static final Logger logger = Logger.getLogger(ClientGameRisk.class.getName());
    private GameSetupPanel gsp;
    Map<String, String> optionsToMapUID = new WeakHashMap<String, String>();
    private Risk myrisk;
    private GameFrame frame;
    private GameSidePanel sidepanel;

    public Game newGameDialog(Frame parent, String serveroptions, String myname) {
        if (this.gsp == null) {
            this.gsp = new GameSetupPanel();
        }
        return this.gsp.showDialog(parent, serveroptions, OnlineUtil.getDefaultOnlineGameName(myname));
    }

    public Icon getIcon(String options, Component comp) {
        String mapUID = OnlineUtil.getMapNameFromLobbyStartGameOption(options);
        this.optionsToMapUID.put(options, mapUID);
        return RiskMap.getRiskMap(mapUID).getIcon(32, 20, comp);
    }

    public String getGameDescription(String string) {
        return OnlineUtil.getGameDescriptionFromLobbyStartGameOption(string);
    }

    public void startNewGame(Game game) {
        String mapUID = OnlineUtil.getMapNameFromLobbyStartGameOption(game.getOptions());
        if (!MapPreview.haveLocalMap(mapUID)) {
            throw new UnsupportedOperationException("Lobby Client does not support downloading map: " + mapUID);
        }
        if (this.frame == null) {
            this.myrisk = new Risk();
            this.makeNewGameFrame();
        }
        this.sidepanel.setGameName(game.getName(), String.valueOf(game.getId()));
    }

    private void makeNewGameFrame() {
        this.sidepanel = new GameSidePanel(this.timer, this.startButton, this.playerListArea, this.chatBoxArea);
        FlashRiskAdapter riskadapter = new FlashRiskAdapter(this.myrisk){

            public void addPlayer(int type, String name, Color color, String ip) {
            }

            public void sendDebug(String a) {
            }

            public void noInput() {
                if (this.gameFrame != null) {
                    this.gameFrame.noInput();
                }
            }

            public void startGame(boolean s) {
                this.gameFrame.setup(s);
                this.gameFrame.setVisible(true);
                this.gameFrame.requestFocus();
            }

            public void closeGame() {
                this.gameFrame.setVisible(false);
            }
        };
        this.frame = riskadapter.getGameFrame();
        this.frame.setSidePanel(this.sidepanel);
        this.frame.pack();
        RiskUIUtil.setMinimumSize(this.frame, this.frame.getPreferredSize());
    }

    public void closegame() {
        if (this.myrisk.getGame() != null) {
            this.myrisk.parser("closegame");
        } else {
            this.leaveGame();
        }
    }

    public void blockInput() {
        this.myrisk.closeBattle();
        this.frame.blockInput();
    }

    public void gameString(String message) {
        this.myrisk.parserFromNetwork(message);
    }

    public void gameObject(Object object) {
        if (object instanceof RiskGame) {
            RiskGame thegame = (RiskGame)object;
            Player player = thegame.getPlayer(this.lgml.whoAmI());
            String address = player == null ? "_watch_" : player.getAddress();
            this.myrisk.setOnlinePlay(this);
            this.myrisk.setAddress(address);
            this.myrisk.setGame(thegame);
            this.updateButtons();
        } else if (object instanceof Map) {
            Map map = (Map)object;
            String command = (String)map.get("command");
            if ("game".equals(command)) {
                String address = (String)map.get("playerId");
                RiskGame thegame = (RiskGame)map.get("game");
                this.myrisk.setOnlinePlay(this);
                this.myrisk.setAddress(address);
                this.myrisk.setGame(thegame);
                this.updateButtons();
            } else {
                System.out.println("ClientGameRisk unknown command " + command + " " + map);
            }
        } else {
            System.out.println("unknown object " + object);
        }
    }

    private void updateButtons() {
        Player player = this.myrisk.getGame().getPlayer(this.lgml.whoAmI());
        this.updateButton(player != null && player.isAlive(), this.myrisk.findEmptySpot() != null);
    }

    public void sendUserCommand(String messagefromgui) {
        this.sendGameMessage(messagefromgui);
    }

    public void sendGameCommand(String gameCommand) {
        logger.info("ignore GameCommand " + gameCommand);
    }

    public boolean isThisMe(String name) {
        return name.equals(this.lgml.whoAmI());
    }

    public void closeGame() {
        this.leaveGame();
    }

    public void playerRenamed(String oldName, String newName, String newAddress, int newType) {
        if (oldName.equals(this.lgml.whoAmI())) {
            this.myrisk.setAddress("_watch_");
        }
        if (newName.equals(this.lgml.whoAmI())) {
            this.myrisk.setAddress(newAddress);
        }
        this.updateButtons();
    }

    static {
        final String RISK_PATH = RiskUtil.GAME_NAME + "/";
        String MAP_PATH = "maps/";
        RiskUtil.streamOpener = new RiskIO(){

            public InputStream openStream(String name) throws IOException {
                return LobbyClientGUI.openStream((String)(RISK_PATH + name));
            }

            public InputStream openMapStream(String name) throws IOException {
                return this.openStream("maps/" + name);
            }

            public ResourceBundle getResourceBundle(Class a, String n, Locale l) {
                return ResBundle.getBundle((Class)a, (String)n, (Locale)l);
            }

            public void openURL(URL url) throws Exception {
                LobbyClientGUI.openURL((URL)url);
            }

            public void openDocs(String doc) throws Exception {
                this.openURL(new URL(LobbyClientGUI.getCodeBase(), RISK_PATH + doc));
            }

            public void saveGameFile(String name, RiskGame obj) throws Exception {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public InputStream loadGameFile(String file) throws Exception {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void getMap(String filename, Observer observer) {
                observer.update(null, RiskUtil.ERROR);
            }

            public OutputStream saveMapFile(String fileName) throws Exception {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void renameMapFile(String oldName, String newName) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public boolean deleteMapFile(String mapName) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
    }
}

