/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.lobby.mini;

import java.util.List;
import net.yura.domination.mapstore.Map;
import net.yura.domination.mapstore.MapPreview;
import net.yura.domination.mapstore.MapServerClient;
import net.yura.domination.mapstore.MapServerListener;
import net.yura.mobile.gui.Icon;
import net.yura.mobile.logging.Logger;

public abstract class MapPreviewClient
implements MapServerListener {
    private MapServerClient mapServerClient;

    public Icon getIconForMap(String mapUID) {
        if (MapPreview.haveLocalMap(mapUID)) {
            Map map = MapPreview.createMap(mapUID);
            this.publishMap(map);
            Icon icon = MapPreview.getLocalIconForMap(map);
            return icon;
        }
        if (this.mapServerClient == null) {
            this.mapServerClient = new MapServerClient(this);
            this.mapServerClient.start();
        }
        return MapPreview.getRemoteIconForMap(mapUID, this.mapServerClient);
    }

    public void shutdown() {
        if (this.mapServerClient != null) {
            this.mapServerClient.kill();
            this.mapServerClient = null;
        }
    }

    public abstract void publishMap(Map var1);

    public abstract void publishImg(String var1);

    public void gotResultCategories(String url, List categories) {
    }

    public void gotResultMaps(String url, List maps) {
        if (maps.size() != 1) {
            Logger.warn((String)("wrong number of maps found on MapServer for " + url + " " + maps));
            return;
        }
        Map map = (Map)maps.get(0);
        this.publishMap(map);
        String mapUIDkey = MapPreview.getFileUID(map.getMapUrl());
        boolean fromCache = MapPreview.getRemoteImage(mapUIDkey, MapPreview.getURL(url, map.getPreviewUrl()), this.mapServerClient);
        if (fromCache) {
            this.publishImg((Object)mapUIDkey);
        }
    }

    public void onXMLError(String string) {
        Logger.info((String)("ERROR " + string));
    }

    public void downloadFinished(String mapUID) {
    }

    public void onDownloadError(String string) {
    }

    public final void publishImg(Object key) {
        this.publishImg((String)key);
    }
}

