/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.mapstore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.WeakHashMap;
import javax.microedition.lcdui.Image;
import net.yura.cache.Cache;
import net.yura.domination.ImageManager;
import net.yura.domination.engine.JavaCompatUtil;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.mapstore.Map;
import net.yura.domination.mapstore.MapServerClient;
import net.yura.domination.mapstore.MapServerListener;
import net.yura.mobile.gui.Icon;
import net.yura.mobile.gui.layout.XULLoader;
import net.yura.mobile.io.FileUtil;
import net.yura.mobile.logging.Logger;
import net.yura.mobile.util.ImageUtil;

public class MapPreview {
    public static final String PREVIEW_FILE_PREFIX = "preview/";
    private static final java.util.Map localMapsCache = Collections.synchronizedMap(new WeakHashMap());
    private static Cache repo;
    private static final ImageManager iconCache;

    public static Map createMap(String file) {
        Map map;
        WeakReference wr = (WeakReference)localMapsCache.get(file);
        if (wr != null && (map = (Map)wr.get()) != null) {
            return map;
        }
        java.util.Map info = RiskUtil.loadInfo(file, false);
        Map map2 = new Map();
        map2.setMapUrl(file);
        String name = (String)info.get("name");
        if (name == null) {
            String filename = file.toLowerCase().endsWith(".map") ? RiskUtil.getFileNameWithoutExtension(file) : file;
            name = JavaCompatUtil.replaceAll(filename, "_", " ");
        }
        map2.setName(name);
        map2.setDescription((String)info.get("comment"));
        String prv = (String)info.get("prv");
        if (prv != null && !MapPreview.fileExists(prv = PREVIEW_FILE_PREFIX + prv)) {
            Logger.info((String)("MAP ERROR: preview file specifies but not found: " + prv));
            prv = null;
        }
        if (prv == null) {
            prv = (String)info.get("pic");
        }
        map2.setPreviewUrl(prv);
        String ver = (String)info.get("ver");
        map2.setVersion(ver == null ? "1" : ver);
        localMapsCache.put(file, new WeakReference<Map>(map2));
        return map2;
    }

    public static boolean haveLocalMap(String mapUID) {
        if (localMapsCache.containsKey(mapUID)) {
            return true;
        }
        return MapPreview.fileExists(mapUID);
    }

    public static boolean fileExists(String fileUID) {
        InputStream file = null;
        try {
            file = RiskUtil.openMapStream(fileUID);
        }
        catch (Exception exception) {
        }
        finally {
            FileUtil.close((Object)file);
        }
        return file != null;
    }

    public static void clearFromCache(String mapUID) {
        localMapsCache.remove(mapUID);
    }

    public static void cache(String url, byte[] data) {
        if (repo != null && !repo.containsKey(url)) {
            repo.put(url, data);
        }
    }

    public static InputStream getRemoteMapPreview(String url) {
        return repo != null ? repo.get(url) : null;
    }

    public static InputStream getLocalMapPreview(String url) {
        InputStream in;
        if (url.startsWith(PREVIEW_FILE_PREFIX)) {
            in = null;
            try {
                in = RiskUtil.openMapStream(url);
                if (in == null) {
                    throw new IllegalStateException("local preview stream null " + url);
                }
            }
            catch (Exception ex) {
                Logger.warn((String)("cant open " + url), (Throwable)ex);
            }
        } else {
            InputStream inputStream = in = repo != null ? repo.get(url) : null;
            if (in == null) {
                try {
                    System.out.println("[MapChooser] ### Going to re-encode img: " + url);
                    InputStream min = RiskUtil.openMapStream(url);
                    Image img = MapPreview.createImage(min);
                    img = ImageUtil.scaleImage((Image)img, (int)150, (int)94);
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    ImageUtil.saveImage((Image)img, (OutputStream)out);
                    img = null;
                    byte[] bytes = out.toByteArray();
                    out = null;
                    if (bytes.length == 0) {
                        throw new IllegalStateException("img failed to save " + url);
                    }
                    MapPreview.cache(url, bytes);
                    in = new ByteArrayInputStream(bytes);
                }
                catch (OutOfMemoryError err) {
                    Logger.info((String)("cant resize " + url), (Throwable)err);
                }
                catch (Exception ex) {
                    Logger.warn((String)("cant resize " + url), (Throwable)ex);
                }
            }
        }
        return in;
    }

    public static String getFileUID(String mapUrl) {
        int i = mapUrl.lastIndexOf(47);
        return i >= 0 ? mapUrl.substring(i + 1) : mapUrl;
    }

    public static String getURL(String context, String mapUrl) {
        if (mapUrl.indexOf(58) < 0 && context != null) {
            mapUrl = mapUrl.startsWith("/") ? context.substring(0, context.indexOf(47, "http://.".length())) + mapUrl : context + mapUrl;
        }
        return mapUrl;
    }

    public static String getContext(String url) {
        int i;
        if (url != null && (i = url.lastIndexOf(47)) > "http://.".length()) {
            url = url.substring(0, i + 1);
        }
        return url;
    }

    public static Image createImage(InputStream in) throws IOException {
        try {
            Image img = Image.createImage((InputStream)in);
            if (img == null) {
                throw new IOException("Image.createImage returned null");
            }
            Image image = img;
            return image;
        }
        finally {
            FileUtil.close((Object)in);
        }
    }

    public static Icon getLocalIconForMap(Map map) {
        Icon icon = MapPreview.getIconForMapOrCategory(map, null, map.getPreviewUrl(), null);
        if (icon == null) {
            throw new RuntimeException("could not find local icon for " + map + " " + map.getPreviewUrl());
        }
        return icon;
    }

    public static boolean getRemoteImage(Object key, String url, MapServerClient c) {
        InputStream in = MapPreview.getRemoteMapPreview(url);
        if (in != null) {
            try {
                MapPreview.gotImg(key, in);
                return true;
            }
            catch (Exception ex) {
                Logger.warn((String)("can not load image in cache " + key + " " + url), (Throwable)ex);
            }
        }
        if (c != null) {
            c.getImage(url, key);
        }
        return false;
    }

    public static Icon getIconForMapOrCategory(Object key, String context, String iconUrl, MapServerClient c) {
        ImageManager.LazyIcon aicon = iconCache.get(key);
        if (aicon == null) {
            aicon = iconCache.newIcon(key);
            String url = MapPreview.getURL(context, iconUrl);
            if (url.indexOf("://") > 0) {
                MapPreview.getRemoteImage(key, url, c);
            } else {
                InputStream in = MapPreview.getLocalMapPreview(url);
                if (in != null) {
                    MapPreview.gotImg(key, in);
                }
            }
        }
        return aicon;
    }

    public static Icon getRemoteIconForMap(String mapUID, MapServerClient mapServerClient) {
        ImageManager.LazyIcon aicon = iconCache.get(mapUID);
        if (aicon == null) {
            aicon = iconCache.newIcon(mapUID);
            mapServerClient.makeRequestXML(MapServerClient.MAP_PAGE, "mapfile", mapUID);
        }
        return aicon;
    }

    public static void gotImgFromServer(Object obj, String url, byte[] data, MapServerListener msl) {
        try {
            MapPreview.gotImg(obj, new ByteArrayInputStream(data));
            if (msl != null) {
                msl.publishImg(obj);
            }
        }
        catch (RuntimeException ex) {
            System.err.println("error in image from server with url: " + url);
            throw ex;
        }
        MapPreview.cache(url, data);
    }

    private static void gotImg(Object obj, InputStream in) {
        try {
            Image img = MapPreview.createImage(in);
            iconCache.gotImg(obj, img);
        }
        catch (OutOfMemoryError err) {
            Logger.info((String)("cant load " + obj), (Throwable)err);
        }
        catch (Exception ex) {
            throw new RuntimeException("failed to decode img " + obj, ex);
        }
    }

    static {
        try {
            repo = new Cache("net.yura.domination");
        }
        catch (Throwable ex) {
            System.err.println("[MapChooser] no cache: " + ex);
        }
        iconCache = new ImageManager(XULLoader.adjustSizeToDensity((int)150), XULLoader.adjustSizeToDensity((int)94));
    }
}

