/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.tools.mapeditor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import net.yura.domination.engine.ColorUtil;
import net.yura.domination.engine.JavaCompatUtil;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.engine.core.Card;
import net.yura.domination.engine.core.Continent;
import net.yura.domination.engine.core.Country;
import net.yura.domination.engine.core.Mission;
import net.yura.domination.engine.core.Player;
import net.yura.domination.engine.core.RiskGame;
import net.yura.domination.guishared.RiskFileFilter;
import net.yura.domination.guishared.RiskUIUtil;
import net.yura.domination.mapstore.Category;
import net.yura.domination.mapstore.Map;
import net.yura.domination.mapstore.MapPreview;
import net.yura.domination.mapstore.MapUpdateService;
import net.yura.domination.tools.mapeditor.MapEditorPanel;
import net.yura.domination.tools.mapeditor.MapEditorViews;
import net.yura.domination.tools.mapeditor.MapSave;
import net.yura.domination.tools.mapeditor.MapsTools;
import net.yura.domination.tools.mapeditor.TegMapLoader;
import net.yura.domination.ui.swinggui.GameTab;
import net.yura.domination.ui.swinggui.SwingGUIPanel;
import net.yura.domination.ui.swinggui.SwingGUITab;
import net.yura.swing.GraphicsUtil;
import net.yura.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapEditor
extends JPanel
implements ActionListener,
ChangeListener,
SwingGUITab {
    private static final String IMAGE_MAP_EXTENSION;
    private static final String IMAGE_PIC_EXTENSION = "png";
    private static final float ZOOM_MAX = 8.0f;
    private static final float ZOOM_MIN = 0.25f;
    private Risk myrisk;
    private RiskGame myMap;
    private String fileName;
    private boolean usesDefaultCards;
    private File imgFile;
    private MapEditorPanel editPanel;
    private JToolBar toolbar;
    private MapEditorViews views;
    private JRadioButton move;
    private JRadioButton moveall;
    private JRadioButton join;
    private JRadioButton join1way;
    private JRadioButton disjoin;
    private JRadioButton draw;
    private JSlider fader;
    private JSlider brush;
    private JSpinner circle;
    private JButton save;
    private JButton play;
    private JButton publish;
    private JButton loadimagepic;
    private JButton loadimagemap;
    private JButton delBadColorsButton;
    private JButton smartFill;
    private JButton autoDrawButton;
    private JButton cleanIslands;
    private JButton zoomin;
    private JButton zoomout;
    private JTextField zoom;
    private boolean strictcards;
    private boolean unsavedChanges;
    private SwingGUIPanel panel;

    public MapEditor(Risk r, SwingGUIPanel panel) {
        this.panel = panel;
        this.setName("Map Editor");
        this.setOpaque(false);
        this.myrisk = r;
        this.toolbar = new JToolBar();
        this.toolbar.setRollover(true);
        this.toolbar.setFloatable(false);
        JButton newmap = new JButton("New map");
        newmap.setActionCommand("newmap");
        newmap.addActionListener(this);
        this.toolbar.add(newmap);
        JButton load = new JButton("Load map");
        load.setActionCommand("load");
        load.addActionListener(this);
        this.toolbar.add(load);
        JButton load2 = new JButton("Load current");
        load2.setActionCommand("load2");
        load2.addActionListener(this);
        this.toolbar.add(load2);
        this.save = new JButton("Save map");
        this.save.setActionCommand("save");
        this.save.addActionListener(this);
        this.toolbar.add(this.save);
        this.play = new JButton("Play Map");
        this.play.setActionCommand("play");
        this.play.addActionListener(this);
        this.toolbar.add(this.play);
        this.publish = new JButton("Publish");
        this.publish.setActionCommand("publish");
        this.publish.addActionListener(this);
        this.toolbar.add(this.publish);
        this.toolbar.addSeparator();
        this.loadimagepic = new JButton("Load Image Pic", new ImageIcon(this.getClass().getResource("edit_pic.png")));
        this.loadimagepic.setActionCommand("loadimagepic");
        this.loadimagepic.addActionListener(this);
        this.toolbar.add(this.loadimagepic);
        this.loadimagemap = new JButton("Load Image Map", new ImageIcon(this.getClass().getResource("edit_map.png")));
        this.loadimagemap.setActionCommand("loadimagemap");
        this.loadimagemap.addActionListener(this);
        this.toolbar.add(this.loadimagemap);
        this.toolbar.addSeparator();
        this.zoomin = new JButton("Zoom in");
        this.zoomin.setActionCommand("zoomin");
        this.zoomin.addActionListener(this);
        this.toolbar.add(this.zoomin);
        this.zoomout = new JButton("Zoom out");
        this.zoomout.setActionCommand("zoomout");
        this.zoomout.addActionListener(this);
        this.toolbar.add(this.zoomout);
        this.toolbar.add(Box.createHorizontalGlue());
        this.zoom = new JTextField(3);
        this.zoom.setEditable(false);
        Dimension size = GraphicsUtil.newDimension(25, 25);
        this.zoom.setMaximumSize(size);
        this.zoom.setMinimumSize(size);
        this.zoom.setPreferredSize(size);
        this.toolbar.add(new JLabel("Zoom:"));
        this.toolbar.add(this.zoom);
        this.save.setEnabled(false);
        this.play.setEnabled(false);
        this.publish.setEnabled(false);
        this.loadimagepic.setEnabled(false);
        this.loadimagemap.setEnabled(false);
        this.editPanel = new MapEditorPanel(this);
        JScrollPane scroll = new JScrollPane(this.editPanel);
        size = GraphicsUtil.newDimension(677, 425);
        scroll.setPreferredSize(size);
        scroll.setMinimumSize(size);
        scroll.setMaximumSize(size);
        scroll.setBorder(null);
        this.setLayout(new BorderLayout());
        JPanel tmp = new JPanel(new BorderLayout());
        tmp.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10), BorderFactory.createLineBorder(Color.BLACK, 1)));
        tmp.setOpaque(false);
        tmp.add(scroll);
        this.add(tmp);
        ButtonGroup modes = new ButtonGroup();
        JPanel modesPanel = new JPanel();
        modesPanel.setOpaque(false);
        modesPanel.add(new JLabel("Tools: "));
        this.move = this.newJRadioButton("move", true, modes, modesPanel);
        this.moveall = this.newJRadioButton("move all", false, modes, modesPanel);
        this.join = this.newJRadioButton("join", false, modes, modesPanel);
        this.join1way = this.newJRadioButton("join 1 way", false, modes, modesPanel);
        this.disjoin = this.newJRadioButton("disjoin", false, modes, modesPanel);
        this.draw = this.newJRadioButton("draw", false, modes, modesPanel);
        this.smartFill = new JButton("Smart Fill");
        this.smartFill.setActionCommand("smartFill");
        this.smartFill.addActionListener(this);
        modesPanel.add(this.smartFill);
        this.smartFill.setEnabled(false);
        this.smartFill.setMnemonic(70);
        this.autoDrawButton = new JButton("Auto Draw");
        this.autoDrawButton.setActionCommand("autodraw");
        this.autoDrawButton.addActionListener(this);
        modesPanel.add(this.autoDrawButton);
        this.autoDrawButton.setEnabled(false);
        this.cleanIslands = new JButton("del islands");
        this.cleanIslands.setActionCommand("islands");
        this.cleanIslands.addActionListener(this);
        modesPanel.add(this.cleanIslands);
        this.cleanIslands.setEnabled(false);
        this.delBadColorsButton = new JButton("del bad map colors");
        this.delBadColorsButton.setActionCommand("fix");
        this.delBadColorsButton.addActionListener(this);
        this.add((Component)modesPanel, "South");
        JPanel topPanel = new JPanel();
        topPanel.setOpaque(false);
        this.fader = new JSlider(0, 100, 0);
        this.fader.addChangeListener(this);
        this.fader.setOpaque(false);
        this.fader.setMajorTickSpacing(20);
        this.fader.setPaintLabels(true);
        this.brush = new JSlider(1, 100, 5);
        this.brush.addChangeListener(this);
        this.brush.setOpaque(false);
        this.brush.setMajorTickSpacing(20);
        this.brush.setPaintLabels(true);
        this.circle = new JSpinner(new SpinnerNumberModel(20, 15, 100, 5));
        this.circle.addChangeListener(this);
        this.circle.setOpaque(false);
        topPanel.add(new JLabel("Image/Map Fade:"));
        topPanel.add(this.fader);
        topPanel.add(new JLabel("Draw Brush Size:"));
        topPanel.add(this.brush);
        topPanel.add(new JLabel("Circles:"));
        topPanel.add(this.circle);
        this.add((Component)topPanel, "North");
        this.setZoom(GraphicsUtil.scale(1));
    }

    private JRadioButton newJRadioButton(String a, boolean sel, ButtonGroup bg, JPanel jp) {
        JRadioButton b = new JRadioButton(a, sel);
        b.setActionCommand("mode");
        b.addActionListener(this);
        b.setOpaque(false);
        bg.add(b);
        jp.add(b);
        return b;
    }

    public void setMapChanged(boolean changed) {
        this.unsavedChanges = changed;
        JRootPane rp = SwingUtilities.getRootPane(this);
        if (rp != null) {
            rp.putClientProperty("Window.documentModified", changed ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.fader) {
            this.editPanel.setAlpha(this.fader.getValue());
            this.editPanel.repaint();
        } else if (e.getSource() == this.brush) {
            this.editPanel.setBrush(this.brush.getValue());
        } else if (e.getSource() == this.circle && this.myMap != null) {
            this.myMap.setCircleSize((Integer)this.circle.getValue());
            this.setMapChanged(true);
            this.editPanel.repaint();
        }
    }

    @Override
    public JToolBar getToolBar() {
        return this.toolbar;
    }

    @Override
    public JMenu getMenu() {
        return null;
    }

    @Override
    public void setVisible(boolean v) {
        super.setVisible(v);
        if (v && this.views == null) {
            this.views = new MapEditorViews(RiskUIUtil.findParentFrame(this), this.editPanel);
            Frame frame = RiskUIUtil.findParentFrame(this);
            Dimension frameSize = frame.getSize();
            Point frameLocation = frame.getLocation();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int x = frameLocation.x + frameSize.width;
            int width = GraphicsUtil.scale(200);
            if (x + width > screenSize.width) {
                x = screenSize.width - width;
            }
            this.views.setLocation(x, frameLocation.y);
            this.views.setSize(width, frameSize.height);
        }
        if (this.views != null) {
            this.views.setVisible(v);
        }
    }

    public void setNewMap(RiskGame m, BufferedImage ip, BufferedImage im, String fname, String cardsFile, File img) {
        this.myMap = m;
        this.editPanel.setMap(this.myMap);
        this.views.setMap(this.myMap);
        this.editPanel.setImagePic(ip, false);
        this.editPanel.setImageMap(im);
        this.save.setEnabled(true);
        this.play.setEnabled(true);
        this.publish.setEnabled(true);
        this.loadimagepic.setEnabled(true);
        this.loadimagemap.setEnabled(true);
        this.smartFill.setEnabled(true);
        this.autoDrawButton.setEnabled(true);
        this.cleanIslands.setEnabled(true);
        this.fileName = fname;
        this.imgFile = img;
        this.usesDefaultCards = "risk.cards".equals(cardsFile);
        this.circle.setValue(new Integer(m.getCircleSize()));
        this.revalidate();
        this.repaint();
    }

    public RiskGame makeNewMap() throws Exception {
        RiskGame rg = new RiskGame();
        for (int c = 1; c <= RiskGame.MAX_PLAYERS; ++c) {
            rg.addPlayer(0, "PLAYER" + c, ColorUtil.getColor(this.myrisk.getRiskConfig("default.player" + c + ".color")), null);
        }
        return rg;
    }

    private void loadMap(String name) throws Exception {
        String folderIfNotDefault = RiskUtil.getContext(name);
        RiskGame map = this.makeNewMap();
        map.setMapfile(name);
        String cardsFile = map.getCardsFile();
        map.loadMap();
        map.loadCards(true);
        InputStream in = RiskUtil.openMapStream(folderIfNotDefault + map.getImagePic());
        BufferedImage ipic = MapEditor.makeRGBImage(RiskUIUtil.read(in));
        BufferedImage imap = MapEditor.makeRGBImage(RiskUIUtil.read(RiskUtil.openMapStream(folderIfNotDefault + map.getImageMap())));
        map.setMemoryLoad();
        File file = null;
        if (in instanceof RiskUIUtil.FileInputStream) {
            file = ((RiskUIUtil.FileInputStream)in).getFile();
        }
        this.setNewMap(map, ipic, imap, name, cardsFile, file);
        this.setMapChanged(false);
    }

    void setImagePic(BufferedImage bufferedImage, File file, boolean checkmap) {
        this.editPanel.setImagePic(bufferedImage, checkmap);
        this.imgFile = file;
        this.revalidate();
        this.repaint();
    }

    void setImageMap(BufferedImage bufferedImage) {
        this.editPanel.setImageMap(bufferedImage);
        this.repaint();
    }

    static BufferedImage newImageMap(int w, int h) {
        BufferedImage imap = new BufferedImage(w, h, 4);
        Graphics g = imap.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, w, h);
        g.dispose();
        return imap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent a) {
        String action = a.getActionCommand();
        if ("newmap".equals(action)) {
            try {
                RiskGame map = this.makeNewMap();
                map.setupNewMap();
                BufferedImage ipic = new BufferedImage(677, 425, 4);
                BufferedImage imap = MapEditor.newImageMap(677, 425);
                this.setNewMap(map, ipic, imap, null, null, null);
                this.setMapChanged(true);
                return;
            }
            catch (Exception ex) {
                this.showError(ex);
            }
            return;
        }
        if ("load".equals(action)) {
            try {
                String name = RiskUIUtil.getNewMapsFile(RiskUIUtil.findParentFrame(this), "map", "xml");
                this.setCursor(Cursor.getPredefinedCursor(3));
                if (name == null) return;
                if (name.endsWith(".xml")) {
                    File file = new File(name);
                    this.loadMap("teg.map");
                    TegMapLoader loader = new TegMapLoader();
                    loader.load(file, this.myMap, this);
                    this.myMap.setMapName(null);
                    this.myMap.setPreviewPic(null);
                    this.fileName = file.getParentFile().getName();
                    this.setMapChanged(true);
                    return;
                }
                this.loadMap(name);
                return;
            }
            catch (Exception ex) {
                this.showError(ex);
                return;
            }
            finally {
                this.setCursor(null);
            }
        }
        if ("load2".equals(action)) {
            RiskGame game = this.myrisk.getGame();
            try {
                if (game == null || game.getMapFile() == null) {
                    String name = RiskUIUtil.getNewMap(RiskUIUtil.findParentFrame(this));
                    if (name == null) return;
                    this.loadMap(name);
                    return;
                }
                this.loadMap(game.getMapFile());
                return;
            }
            catch (Exception ex) {
                this.showError(ex);
            }
            return;
        }
        if (a.getActionCommand().equals("save")) {
            this.checkMap();
            if (!RiskUIUtil.checkForNoSandbox()) {
                RiskUIUtil.showAppletWarning(RiskUIUtil.findParentFrame(this));
                return;
            }
            JFileChooser fc = new JFileChooser(RiskUIUtil.getSaveMapDir());
            RiskFileFilter filter = new RiskFileFilter("map");
            fc.setFileFilter(filter);
            String newFileName = this.fileName;
            while (true) {
                int returnVal;
                if (newFileName != null) {
                    fc.setSelectedFile(new File(newFileName));
                }
                if ((returnVal = fc.showSaveDialog(RiskUIUtil.findParentFrame(this))) != 0) return;
                File file = fc.getSelectedFile();
                newFileName = file.getName();
                if (!MapsTools.isValidName(newFileName)) {
                    JOptionPane.showMessageDialog(this, "please use only standard ASCII characters in the file name.");
                    continue;
                }
                if (!newFileName.endsWith(".map")) {
                    newFileName = newFileName + "." + "map";
                }
                try {
                    boolean result = this.saveMap(new File(file.getParentFile(), newFileName));
                    if (!result) continue;
                    this.fileName = newFileName;
                    return;
                }
                catch (Throwable ex) {
                    this.showError(ex);
                    continue;
                }
                break;
            }
        }
        if (a.getActionCommand().equals("play")) {
            if (!this.checkMap()) return;
            try {
                this.myrisk.newMemoryGame(this.myMap, MapSave.buildMapFile(this.myMap, "mem.map", "mem.cards", "mem_map", "mem_pic"));
                this.panel.showMapImage(new ImageIcon(this.editPanel.getImagePic().getScaledInstance(203, 127, 4)));
                this.panel.setSelectedTab(GameTab.class);
                return;
            }
            catch (Exception e) {
                this.showError(e);
            }
            return;
        }
        if (a.getActionCommand().equals("publish")) {
            String version;
            JList list;
            if (!this.checkMap()) {
                return;
            }
            if (this.fileName == null || this.unsavedChanges) {
                JOptionPane.showMessageDialog(this, "please save to disk first!");
                this.save.doClick();
                return;
            }
            if (!MapsTools.isValidName(this.fileName)) {
                JOptionPane.showMessageDialog(this, "please save the map using only standard ASCII characters in the file name.");
                this.save.doClick();
                return;
            }
            List maps = MapsTools.loadMaps();
            Map map2 = MapsTools.findMap(maps, this.fileName);
            List categories = MapsTools.getCategories();
            if (map2 == null) {
                Map map = MapUpdateService.getOnlineMap(this.fileName);
                if (map != null) {
                    int onlineVersion;
                    String mapUID = MapPreview.getFileUID(map.getMapUrl());
                    if (!this.fileName.equals(mapUID)) {
                        JOptionPane.showMessageDialog(this, "File name clashes with existing map: \"" + this.fileName + "\" and \"" + mapUID + "\"\nplease pick a new unique file name for your map.");
                        this.save.doClick();
                        return;
                    }
                    int result = JOptionPane.showConfirmDialog(this, "There is already a map with the filename " + this.fileName + " in the MapStore,\nis this a new version of that map?", null, 0);
                    if (result == 1) {
                        JOptionPane.showMessageDialog(this, "please pick a new unique file name for your map.");
                        this.save.doClick();
                        return;
                    }
                    int localVersion = this.myMap.getVersion();
                    if (localVersion <= (onlineVersion = MapEditor.getVersion(map))) {
                        JOptionPane.showMessageDialog(this, "MapStore version: " + onlineVersion + "\nLocal version:" + localVersion + "\nSaving map with new version: " + (onlineVersion + 1));
                        this.myMap.setVersion(onlineVersion + 1);
                        boolean successfulSave = false;
                        try {
                            successfulSave = this.saveMap(new File(RiskUIUtil.getSaveMapDir(), this.fileName));
                        }
                        catch (Exception ex) {
                            this.showError(ex);
                        }
                        if (!successfulSave) {
                            this.myMap.setVersion(localVersion);
                            return;
                        }
                    }
                }
                MapPreview.clearFromCache(this.fileName);
                map2 = MapPreview.createMap(this.fileName);
                map2.setDateAdded(String.valueOf(System.currentTimeMillis()));
                if (map != null) {
                    map2.setName(map.getName());
                    map2.setAuthorName(map.getAuthorName());
                    map2.setDescription(map.getDescription());
                } else {
                    try {
                        map2.setAuthorName(System.getProperty("user.name"));
                    }
                    catch (Throwable mapUID) {
                        // empty catch block
                    }
                }
                maps.add(map2);
            }
            JTextField authorName = new JTextField(map2.getAuthorName());
            MapEditorViews.OptionPaneTextArea description = new MapEditorViews.OptionPaneTextArea(map2.getDescription());
            JTextField mapName = new JTextField(map2.getName());
            JTextField authorEmail = new JTextField(map2.getAuthorId());
            int result = this.showInputDialog(new String[]{"Author's Full Name:", "Email:", "Map Name:", "Description:", "Categories:", "Filename (Unique Map ID):", "version:"}, new JComponent[]{authorName, authorEmail, mapName, description, list = new JList(JavaCompatUtil.asVector(categories)), new JLabel(this.fileName), new JLabel(version = String.valueOf(this.myMap.getVersion()))}, "edit info");
            if (result != 0) return;
            Object[] myCategories = list.getSelectedValues();
            String[] myCategoriesIds = new String[myCategories.length];
            for (int c = 0; c < myCategories.length; ++c) {
                myCategoriesIds[c] = ((Category)myCategories[c]).getId();
            }
            map2.setAuthorName(authorName.getText());
            map2.setDescription(description.getText());
            map2.setName(mapName.getText());
            map2.setAuthorId(authorEmail.getText());
            BufferedImage fullimg = this.editPanel.getImagePic();
            map2.setMapWidth(fullimg.getWidth());
            map2.setMapHeight(fullimg.getHeight());
            map2.setVersion(version);
            if (map2.getPreviewUrl() == null || !map2.getPreviewUrl().startsWith("preview/")) {
                String previewFileName;
                BufferedImage prvimg = new BufferedImage(150, 94, 4);
                Graphics g = prvimg.getGraphics();
                g.drawImage(fullimg, 0, 0, prvimg.getWidth(), prvimg.getHeight(), this);
                g.dispose();
                File mapsDir = RiskUIUtil.getSaveMapDir();
                File previewDir = new File(mapsDir, "preview");
                if (!previewDir.isDirectory() && !previewDir.mkdirs()) {
                    throw new RuntimeException("can not create dir " + previewDir);
                }
                try {
                    previewFileName = MapsTools.makePreview(this.fileName, prvimg, previewDir, "jpg");
                }
                catch (Exception ex) {
                    try {
                        previewFileName = MapsTools.makePreview(this.fileName, prvimg, previewDir, IMAGE_PIC_EXTENSION);
                    }
                    catch (Exception ex2) {
                        RiskUtil.printStackTrace(ex);
                        throw new RuntimeException(ex2);
                    }
                }
                map2.setPreviewUrl(previewFileName);
            }
            MapsTools.saveMaps(maps);
            if (myCategoriesIds.length > 0) {
                try {
                    String responce = MapsTools.publish(map2, myCategoriesIds);
                    JEditorPane editorPane = new JEditorPane();
                    editorPane.setEditable(false);
                    editorPane.setContentType("text/html");
                    editorPane.getDocument().putProperty("IgnoreCharsetDirective", Boolean.TRUE);
                    editorPane.setText(responce);
                    JScrollPane scroll = new JScrollPane(editorPane);
                    scroll.setPreferredSize(GraphicsUtil.newDimension(500, 250));
                    JOptionPane.showMessageDialog(this, new Object[]{"Congratulations! Your map has been sent to the MapStore server.\nIt will appear in the MapStore once it has been approved by one of the moderators.", scroll});
                    return;
                }
                catch (Exception ex) {
                    RiskUtil.printStackTrace(ex);
                    JOptionPane.showMessageDialog(this, "something went wrong! did you enter a valid email?\n" + ex.toString());
                }
                return;
            } else {
                JOptionPane.showMessageDialog(this, "map info has been saved to disk, it has NOT been sent to the server as you did not select any Categories.");
            }
            return;
        }
        if (a.getActionCommand().equals("loadimagepic")) {
            NewImage img = this.getNewImage(true);
            if (img == null) return;
            this.setImagePic(img.bufferedImage, img.file, true);
            return;
        } else if (a.getActionCommand().equals("loadimagemap")) {
            NewImage img = this.getNewImage(false);
            if (img == null || !this.checkNewImageMap(img.bufferedImage)) return;
            this.setImageMap(img.bufferedImage);
            return;
        } else if (a.getActionCommand().equals("mode")) {
            if (this.move.isSelected()) {
                this.editPanel.setMode(0);
                return;
            } else if (this.moveall.isSelected()) {
                this.editPanel.setMode(1);
                return;
            } else if (this.join.isSelected()) {
                this.editPanel.setMode(2);
                return;
            } else if (this.join1way.isSelected()) {
                this.editPanel.setMode(3);
                return;
            } else if (this.disjoin.isSelected()) {
                this.editPanel.setMode(4);
                return;
            } else {
                if (!this.draw.isSelected()) throw new RuntimeException("unknown mode");
                this.editPanel.setMode(5);
            }
            return;
        } else if (a.getActionCommand().equals("zoomin")) {
            Rectangle rect = this.editPanel.getVisibleRect();
            this.zoom(true, new Point(rect.x + rect.width / 2, rect.y + rect.height / 2));
            return;
        } else if (a.getActionCommand().equals("zoomout")) {
            Rectangle rect = this.editPanel.getVisibleRect();
            this.zoom(false, new Point(rect.x + rect.width / 2, rect.y + rect.height / 2));
            return;
        } else if (a.getActionCommand().equals("fix")) {
            this.removeBadMapColors();
            return;
        } else if (a.getActionCommand().equals("autodraw")) {
            Collection<Country> selectedCountries = this.views.getSelectedCountries();
            if (selectedCountries.isEmpty()) {
                selectedCountries = Arrays.asList(this.myMap.getCountries());
            }
            Object[] options = new String[]{"Dots", "Flood Fill", "Cancel"};
            int result = JOptionPane.showOptionDialog(this, new Object[]{new ImageIcon(this.getClass().getResource("bam.png")), MapEditor.getCountiresListMessage(selectedCountries), "Are you sure you want to add country regions wherever the country badge is?\nThis action is not reversible so please save a copy of your map first."}, "Auto Draw?", 1, 3, null, options, options[0]);
            if (result != 0 && result != 1) return;
            this.editPanel.autodraw(selectedCountries, result == 0);
            return;
        } else if ("smartFill".equals(a.getActionCommand())) {
            Collection<Country> selectedCountries = this.views.getSelectedCountries();
            if (selectedCountries.isEmpty()) {
                selectedCountries = Arrays.asList(this.myMap.getCountries());
            }
            this.editPanel.smartDraw(selectedCountries);
            return;
        } else {
            if (!a.getActionCommand().equals("islands")) throw new RuntimeException("unknown command: " + action);
            Collection<Country> selectedCountries = this.views.getSelectedCountries();
            if (selectedCountries.isEmpty()) {
                selectedCountries = Arrays.asList(this.myMap.getCountries());
            }
            this.editPanel.delIslands(selectedCountries);
        }
    }

    public static String getCountiresListMessage(Collection<Country> selectedCountries) {
        if (selectedCountries.size() == 1) {
            return "One selected country: " + selectedCountries.iterator().next();
        }
        if (selectedCountries.size() > 10) {
            return selectedCountries.size() + " selected countries";
        }
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        for (Country country : selectedCountries) {
            numbers.add(country.getColor());
        }
        return "Selected countries: " + numbers;
    }

    private int showInputDialog(String[] labels, JComponent[] comps, String title) {
        if (labels.length != comps.length) {
            throw new RuntimeException();
        }
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(3, 3, 3, 3);
        c.fill = 1;
        for (int i = 0; i < labels.length; ++i) {
            JLabel label = new JLabel(labels[i]);
            label.setHorizontalAlignment(4);
            c.gridx = 0;
            c.gridy = i;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            panel.add((Component)label, c);
            c.gridx = 1;
            c.gridy = i;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.weightx = 1.0;
            c.weighty = comps[i] instanceof JScrollPane ? 1.0 : 0.0;
            panel.add((Component)comps[i], c);
        }
        return JOptionPane.showConfirmDialog(this, panel, title, 2);
    }

    private NewImage getNewImage(boolean jpeg) {
        if (!RiskUIUtil.checkForNoSandbox()) {
            RiskUIUtil.showAppletWarning(RiskUIUtil.findParentFrame(this));
            return null;
        }
        try {
            String[] extensions = ImageIO.getReaderFormatNames();
            final ArrayList<String> list = new ArrayList<String>();
            for (int c = 0; c < extensions.length; ++c) {
                String extension = extensions[c].toLowerCase();
                if (list.contains(extension)) continue;
                list.add(extension);
            }
            if (!jpeg) {
                list.remove("jpg");
                list.remove("jpeg");
            }
            JFileChooser fc = new JFileChooser(new File(new URI(RiskUIUtil.mapsdir.toString())));
            fc.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    String name = file.getName().toLowerCase();
                    for (int c = 0; c < list.size(); ++c) {
                        if (!name.endsWith((String)list.get(c))) continue;
                        return true;
                    }
                    return false;
                }

                public String getDescription() {
                    return "Images " + list;
                }
            });
            int returnVal = fc.showOpenDialog(RiskUIUtil.findParentFrame(this));
            if (returnVal == 0) {
                File newFile = fc.getSelectedFile();
                BufferedImage img = ImageIO.read(newFile);
                if (img != null) {
                    return new NewImage(MapEditor.makeRGBImage(img), newFile);
                }
                JOptionPane.showMessageDialog(this, "no registered ImageReader claims to be able to read this file:\n" + newFile + "\nsupported file formats are:\n" + list);
            }
        }
        catch (Throwable ex) {
            RiskUtil.printStackTrace(ex);
            this.showError(ex);
        }
        return null;
    }

    private void removeBadMapColors() {
        HashMap<Integer, Integer> updateMap = new HashMap<Integer, Integer>();
        for (int c = 0; c < 256; ++c) {
            if (this.myMap.getCountryInt(c) != null) {
                updateMap.put(new Integer(c), new Integer(c));
                continue;
            }
            updateMap.put(new Integer(c), new Integer(255));
        }
        this.editPanel.update(updateMap);
        this.editPanel.repaint();
    }

    static BufferedImage makeRGBImage(BufferedImage INipic) {
        BufferedImage ipic = new BufferedImage(INipic.getWidth(), INipic.getHeight(), 4);
        Graphics g1 = ipic.getGraphics();
        g1.setColor(Color.WHITE);
        g1.fillRect(0, 0, INipic.getWidth(), INipic.getHeight());
        g1.drawImage(INipic, 0, 0, null);
        g1.dispose();
        return ipic;
    }

    public void zoom(boolean in, Point fixed) {
        Dimension size1 = this.editPanel.getPreferredSize();
        Rectangle rect = this.editPanel.getVisibleRect();
        float oldZoom = this.editPanel.getZoom();
        float newZoom = in ? (oldZoom < 1.0f ? oldZoom * 2.0f : oldZoom + 1.0f) : (oldZoom > 1.0f ? oldZoom - 1.0f : oldZoom / 2.0f);
        this.setZoom(newZoom);
        Dimension size2 = this.editPanel.getPreferredSize();
        if (!size1.equals(size2)) {
            rect.x = fixed.x * size2.width / size1.width - (fixed.x - rect.x);
            rect.y = fixed.y * size2.height / size1.height - (fixed.y - rect.y);
            this.editPanel.getParent().validate();
            this.editPanel.scrollRectToVisible(rect);
        }
    }

    private void setZoom(float zoom) {
        if (zoom < 0.25f || zoom > 8.0f) {
            return;
        }
        this.zoomout.setEnabled(zoom != 0.25f);
        this.zoomin.setEnabled(zoom != 8.0f);
        this.zoom.setText(zoom + "x");
        this.editPanel.zoom(zoom);
    }

    public void showError(Throwable ex) {
        JOptionPane.showMessageDialog(this, "Error: " + ex.toString(), "ERROR!", 0);
        RiskUtil.printStackTrace(ex);
    }

    public BufferedImage getImageMap() {
        return this.editPanel.getImageMap();
    }

    public BufferedImage getImagePic() {
        return this.editPanel.getImagePic();
    }

    private boolean checkNewImageMap(BufferedImage map) {
        int[] pixels = MapEditor.getAllPixels(map);
        int badPixels = 0;
        HashSet<Color> bad = new HashSet<Color>();
        for (int c = 0; c < pixels.length; ++c) {
            Color color = new Color(pixels[c], true);
            if (color.getRed() == color.getBlue() && color.getRed() == color.getGreen()) continue;
            bad.add(color);
            ++badPixels;
        }
        if (!bad.isEmpty()) {
            this.showMessageDialog(this, "This image is not grayscale, (" + bad.size() + " non greyscale colors, " + badPixels + " pixels)\nThe ImageMap image should be grayscale.");
            return false;
        }
        return true;
    }

    public boolean checkMap() {
        List missions;
        String errors = "";
        if (this.myMap.getNoCountries() < 6) {
            errors = errors + "\n* Less then 6 countries on this map.";
        } else {
            ArrayList<Country> t = new ArrayList<Country>(Arrays.asList(this.myMap.getCountries()));
            ArrayList<Country> a = new ArrayList<Country>();
            Country country = (Country)t.remove(0);
            a.add(country);
            this.myMap.getConnectedEmpire(t, a, country.getNeighbours(), null);
            if (a.size() != this.myMap.getNoCountries()) {
                errors = errors + "\n* Some countries are isolated from the rest: " + t;
            }
        }
        Country[] countries = this.myMap.getCountries();
        for (int a = 0; a < countries.length - 1; ++a) {
            for (int b = a + 1; b < countries.length; ++b) {
                if (countries[a].getX() <= countries[b].getX() - this.myMap.getCircleSize() / 2 || countries[a].getX() >= countries[b].getX() + this.myMap.getCircleSize() / 2 || countries[a].getY() <= countries[b].getY() - this.myMap.getCircleSize() / 2 || countries[a].getY() >= countries[b].getY() + this.myMap.getCircleSize() / 2) continue;
                errors = errors + "\n* " + countries[a] + " circle overlaps " + countries[b] + " circle";
            }
        }
        Continent[] continents = this.myMap.getContinents();
        block2: for (int c = 0; c < continents.length; ++c) {
            if (continents[c].getTerritoriesContained().size() == 0) {
                errors = errors + "\n* The continent \"" + continents[c] + "\" is empty.";
            }
            for (int i = c + 1; i < continents.length; ++i) {
                if (continents[c].getColor() != continents[i].getColor()) continue;
                errors = errors + "\n* The continent \"" + continents[c] + "\" and \"" + continents[i] + "\" are the same color.";
                continue block2;
            }
        }
        BufferedImage map = this.editPanel.getImageMap();
        BufferedImage pic = this.editPanel.getImagePic();
        if (pic.getWidth() != map.getWidth() || pic.getHeight() != map.getHeight()) {
            errors = errors + "\n* ImagePic and ImageMap are not the same size.";
        }
        int[] pixels = MapEditor.getAllPixels(map);
        int noc = this.myMap.getNoCountries();
        HashSet<Integer> bad = new HashSet<Integer>();
        HashSet<Country> good = new HashSet<Country>(Arrays.asList(this.myMap.getCountries()));
        for (int c = 0; c < pixels.length; ++c) {
            int color = pixels[c] & 0xFF;
            if (color == 255) continue;
            if (color == 0 || color > noc) {
                bad.add(new Integer(color));
                continue;
            }
            good.remove(this.myMap.getCountryInt(color));
        }
        if (bad.size() > 0) {
            errors = errors + "\n* Image Map uses colors that do not match any country: " + bad;
        }
        if (good.size() > 0) {
            errors = errors + "\n* Image Map does not contain areas for some countries: " + good;
        }
        if ((missions = this.myMap.getMissions()).size() > 0 && missions.size() < 6) {
            errors = errors + "\n* You have chosen to have missions but you have less then is needed for a game with 6 players.";
        }
        for (int i = 0; i < missions.size(); ++i) {
            Player p;
            Mission m = (Mission)missions.get(i);
            if ("".equals(m.getDiscription())) {
                errors = errors + "\n* You have a mission with an empty Discription";
            }
            if ((p = m.getPlayer()) != null && m.getDiscription().indexOf(p.getName()) == -1) {
                errors = errors + "\n* You have a mission that is to destroy " + p.getName() + ", yet you do NOT have the text \"" + p.getName() + "\" in the description.";
            }
            if (m.getNoofcountries() <= 0 || m.getNoofarmies() > 0) continue;
            errors = errors + "\n* You have a mission with impossible option: occupy " + m.getNoofcountries() + " countries with " + m.getNoofarmies() + " troops";
        }
        String warnings = "";
        Vector cards = this.myMap.getCards();
        if (cards.isEmpty()) {
            warnings = this.myMap.getMissions().isEmpty() ? warnings + "\n* You have no cards and no missions" : warnings + "*\n You have no cards";
        } else if (this.strictcards) {
            for (int i = 0; i < cards.size(); ++i) {
                Card c = (Card)cards.get(i);
                if (c.getCountry() == null || c.getCountry().getColor() == i + 1) continue;
                errors = errors + "\n* Strict cards missmatch with pos/id/color: " + c;
            }
        }
        if (errors.length() > 0) {
            String errorMessage = "There are errors in this map that need to be fixed before it can be used:" + errors + warnings;
            if (bad.size() > 0) {
                this.showMessageDialog(this, new Object[]{errorMessage, this.delBadColorsButton});
            } else {
                this.showMessageDialog(this, errorMessage);
            }
            return false;
        }
        if (warnings.length() > 0) {
            int result = JOptionPane.showConfirmDialog(this, "Are you sure you are happy with:" + warnings, "Warning", 0);
            return result == 0;
        }
        return true;
    }

    private static int[] getAllPixels(BufferedImage map) {
        return map.getRGB(0, 0, map.getWidth(), map.getHeight(), null, 0, map.getWidth());
    }

    private void showMessageDialog(Component c, Object string) {
        System.out.println(string);
        JOptionPane pane = new JOptionPane(){

            public int getMaxCharactersPerLineCount() {
                return 100;
            }
        };
        pane.setMessage(string);
        JDialog dialog = pane.createDialog(c, UIManager.getString("OptionPane.messageDialogTitle"));
        dialog.setVisible(true);
    }

    public static int getVersion(Map map) {
        String version = map.getVersion();
        if (version == null || "".equals(version)) {
            return 1;
        }
        return Integer.parseInt(version);
    }

    public boolean saveMap(File mapFile) throws Exception {
        int result;
        String mapName = mapFile.getName();
        Map map2 = MapsTools.findMap(MapsTools.loadMaps(), mapName);
        if (map2 != null) {
            int newVersion = MapEditor.getVersion(map2) + 1;
            this.myMap.setVersion(newVersion);
        }
        String safeName = MapsTools.getSafeMapID(mapName);
        String cardsName = safeName + "." + "cards";
        String imageMapName = safeName + "_map." + IMAGE_MAP_EXTENSION;
        String pic_extension = IMAGE_PIC_EXTENSION;
        boolean doCopy = false;
        if (this.imgFile != null && this.imgFile.exists()) {
            String extension = MapsTools.getExtension(this.imgFile).toLowerCase();
            if ("jpeg".equals(extension)) {
                extension = "jpg";
            }
            if ("jpg".equals(extension) || IMAGE_PIC_EXTENSION.equals(extension) || "gif".equals(extension)) {
                doCopy = true;
                pic_extension = extension;
            }
        }
        String imagePicName = safeName + "_pic." + pic_extension;
        File cardsFile = new File(mapFile.getParentFile(), cardsName);
        File imageMapFile = new File(mapFile.getParentFile(), imageMapName);
        File imagePicFile = new File(mapFile.getParentFile(), imagePicName);
        if ((mapFile.exists() || cardsFile.exists() || imageMapFile.exists() || imagePicFile.exists()) && (result = JOptionPane.showConfirmDialog(this, "Are you sure you want to replace:\n" + (mapFile.exists() ? mapFile + "\n" : "") + (cardsFile.exists() ? cardsFile + "\n" : "") + (imageMapFile.exists() ? imageMapFile + "\n" : "") + (imagePicFile.exists() ? imagePicFile + "\n" : ""), "Replace?", 0)) != 0) {
            return false;
        }
        if (this.usesDefaultCards && this.cardsSameAsDefaultRiskCards()) {
            cardsName = "risk.cards";
            cardsFile = null;
        }
        MapSave.saveMapWithImages(this.myMap, mapFile, cardsFile, imageMapFile, imagePicFile, mapName, cardsName, imageMapName, imagePicName, doCopy ? null : this.editPanel.getImagePic(), IMAGE_PIC_EXTENSION, doCopy ? this.imgFile : null, this.editPanel.getImageMap(), IMAGE_MAP_EXTENSION);
        this.setMapChanged(false);
        return true;
    }

    private boolean cardsSameAsDefaultRiskCards() {
        try {
            RiskGame risk = this.makeNewMap();
            risk.setMapfile("risk.map");
            risk.loadMap();
            risk.loadCards(true);
            if (!risk.getCards().equals(this.myMap.getCards()) || risk.getNoMissions() != this.myMap.getNoMissions()) {
                return false;
            }
            for (int c = 0; c < this.myMap.getNoMissions(); ++c) {
                Mission m1 = (Mission)this.myMap.getMissions().get(c);
                Mission m2 = (Mission)risk.getMissions().get(c);
                if (MapSave.getMissionString(m1, this.myMap).equals(MapSave.getMissionString(m2, risk))) continue;
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            RiskUtil.printStackTrace(ex);
            return false;
        }
    }

    static {
        boolean usegif = false;
        String[] writerNames = ImageIO.getWriterFormatNames();
        for (int c = 0; c < writerNames.length; ++c) {
            if (!"gif".equalsIgnoreCase(writerNames[c])) continue;
            usegif = true;
            break;
        }
        IMAGE_MAP_EXTENSION = usegif ? "gif" : IMAGE_PIC_EXTENSION;
    }

    static class NewImage {
        public final BufferedImage bufferedImage;
        public final File file;

        public NewImage(BufferedImage bufferedImage, File file) {
            this.bufferedImage = bufferedImage;
            this.file = file;
        }
    }
}

