/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.ui.flashgui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.Random;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.Timer;
import net.yura.domination.audio.GameSound;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.core.Country;
import net.yura.domination.engine.translation.TranslationBundle;
import net.yura.domination.guishared.RiskUIUtil;
import net.yura.domination.ui.flashgui.GameFrame;
import net.yura.domination.ui.flashgui.MoveDialog;
import net.yura.domination.ui.flashgui.NewGameFrame;
import net.yura.swing.GraphicsUtil;

public class BattleDialog
extends JDialog
implements MouseListener {
    private GameFrame gui;
    private Risk myrisk;
    private BufferedImage c1img;
    private BufferedImage c2img;
    private int c1num;
    private int c2num;
    private Image Battle;
    private Image Back;
    private JButton button;
    private JButton retreat;
    private AbstractButton annihilate;
    private Country country1;
    private Country country2;
    private Color color1;
    private Color color2;
    private boolean canRetreat;
    private Timer timer;
    private int[] att;
    private int[] def;
    private int max;
    private int noda;
    private int nodd;
    private boolean spinA;
    private boolean spinD;
    private Image[] attackerSpins;
    private Image[] defenderSpins;
    private ResourceBundle resb;
    private JPanel battle;
    private static Random r = new Random();
    static final int MINI_DICE_X = 481;
    static final int MINI_DICE_Y = 306;
    static final int MINI_DICE_WIDTH = 21;
    static final int MINI_DICE_HEIGHT = 21;
    static final int DRAW_DICE_Y = 170;

    public BattleDialog(GameFrame parent, boolean modal, Risk r) {
        super((Frame)parent, modal);
        this.gui = parent;
        this.myrisk = r;
        this.setDefaultCloseOperation(0);
        this.Battle = RiskUIUtil.getUIImage(this.getClass(), "battle.jpg");
        this.Back = GraphicsUtil.getSubimage(this.Battle, 0, 0, 480, 350);
        int x = 580;
        int i = 0;
        int w = 29;
        int h = 29;
        this.attackerSpins = new Image[6];
        this.attackerSpins[0] = GraphicsUtil.getSubimage(this.Battle, x, h * i++, w, h);
        this.attackerSpins[1] = GraphicsUtil.getSubimage(this.Battle, x, h * i++, w, h);
        this.attackerSpins[2] = GraphicsUtil.getSubimage(this.Battle, x, h * i++, w, h);
        this.attackerSpins[3] = GraphicsUtil.getSubimage(this.Battle, x, h * i++, w, h);
        this.attackerSpins[4] = GraphicsUtil.getSubimage(this.Battle, x, h * i++, w, h);
        this.attackerSpins[5] = GraphicsUtil.getSubimage(this.Battle, x, h * i++, w, h);
        this.defenderSpins = new Image[6];
        this.defenderSpins[0] = GraphicsUtil.getSubimage(this.Battle, x, h * i++, w, h);
        this.defenderSpins[1] = GraphicsUtil.getSubimage(this.Battle, x, h * i++, w, h);
        this.defenderSpins[2] = GraphicsUtil.getSubimage(this.Battle, x, h * i++, w, h);
        this.defenderSpins[3] = GraphicsUtil.getSubimage(this.Battle, x, h * i++, w, h);
        this.defenderSpins[4] = GraphicsUtil.getSubimage(this.Battle, x, h * i++, w, h);
        this.defenderSpins[5] = GraphicsUtil.getSubimage(this.Battle, x, h * i++, w, h);
        this.initGUI();
        this.pack();
    }

    private void initGUI() {
        this.resb = TranslationBundle.getBundle();
        this.setResizable(false);
        this.battle = new BattlePanel();
        this.battle.setLayout(null);
        this.battle.addMouseListener(this);
        Dimension bSize = GraphicsUtil.newDimension(480, 350);
        this.battle.setPreferredSize(bSize);
        this.battle.setMinimumSize(bSize);
        this.battle.setMaximumSize(bSize);
        int w = 88;
        int h = 31;
        this.button = GameFrame.makeRiskButton(GraphicsUtil.getSubimage(this.Battle, 196, 270, w, h), GraphicsUtil.getSubimage(this.Battle, 481, 242, w, h), GraphicsUtil.getSubimage(this.Battle, 481, 210, w, h), GraphicsUtil.getSubimage(this.Battle, 481, 274, w, h));
        this.button.setText(this.resb.getString("battle.roll"));
        GraphicsUtil.setBounds(this.button, 196, 270, 88, 31);
        this.retreat = GameFrame.makeRiskButton(GraphicsUtil.getSubimage(this.Battle, 487, 110, w, h), GraphicsUtil.getSubimage(this.Battle, 481, 178, w, h), GraphicsUtil.getSubimage(this.Battle, 481, 146, w, h), GraphicsUtil.getSubimage(this.Battle, 487, 110, w, h));
        this.retreat.setText(this.resb.getString("battle.retreat"));
        GraphicsUtil.setBounds(this.retreat, 342, 270, 88, 31);
        this.annihilate = new JToggleButton(this.resb.getString("battle.annihilate"));
        NewGameFrame.sortOutButton(this.annihilate, GraphicsUtil.getSubimage(this.Battle, 485, 5, w, h), GraphicsUtil.getSubimage(this.Battle, 481, 73, w, h), GraphicsUtil.getSubimage(this.Battle, 481, 41, w, h));
        GraphicsUtil.setBounds(this.annihilate, 50, 270, 88, 31);
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GameSound.INSTANCE.playSound("dice_roll");
                BattleDialog.this.gui.go("roll " + (BattleDialog.this.canRetreat ? BattleDialog.this.noda : BattleDialog.this.nodd));
            }
        });
        this.retreat.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GameSound.INSTANCE.playSound("battle_retreat");
                BattleDialog.this.gui.go("retreat");
            }
        });
        this.annihilate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (BattleDialog.this.annihilate.isSelected()) {
                    GameSound.INSTANCE.playSound("dice_roll");
                    BattleDialog.this.gui.go("roll " + (BattleDialog.this.canRetreat ? BattleDialog.this.noda : BattleDialog.this.nodd));
                }
            }
        });
        this.battle.add(this.retreat);
        this.battle.add(this.button);
        this.battle.add(this.annihilate);
        this.getContentPane().add(this.battle);
        this.timer = new Timer(10, this.spinDiceAction());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                if (BattleDialog.this.canRetreat) {
                    GameSound.INSTANCE.playSound("battle_retreat");
                    BattleDialog.this.gui.go("retreat");
                }
            }
        });
    }

    public Action spinDiceAction() {
        return new AbstractAction("spin dice action"){

            public void actionPerformed(ActionEvent e) {
                BattleDialog.this.drawDiceAnimated(BattleDialog.this.battle.getGraphics());
            }
        };
    }

    public void setup(int a, int b, BufferedImage ai, BufferedImage bi, Country country1, Country country2, Color c1, Color c2) {
        this.c1num = a;
        this.c2num = b;
        this.c1img = ai;
        this.c2img = bi;
        this.country1 = country1;
        this.country2 = country2;
        this.color1 = c1;
        this.color2 = c2;
        this.att = null;
        this.def = null;
        this.noda = 0;
        this.nodd = 0;
        this.spinA = false;
        this.spinD = false;
        this.annihilate.setSelected(false);
        this.blockInput();
    }

    public void blockInput() {
        this.button.setEnabled(false);
        this.retreat.setVisible(false);
        this.annihilate.setVisible(false);
        this.canRetreat = false;
        this.max = 0;
        this.setTitle(this.resb.getString("battle.title"));
    }

    public void setNODAttacker(int n) {
        this.att = null;
        this.def = null;
        this.noda = n;
        this.spinA = true;
        this.battle.repaint();
        this.timer.start();
    }

    public void setNODDefender(int n) {
        this.nodd = n;
        this.spinD = true;
        this.battle.repaint();
    }

    public void showDiceResults(int[] atti, int[] defi) {
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        this.att = atti;
        this.def = defi;
        this.spinA = false;
        this.spinD = false;
        this.battle.repaint();
    }

    public void needInput(int n, boolean c) {
        this.max = n;
        this.canRetreat = c;
        if (this.canRetreat) {
            if (this.noda == 0 || this.noda > this.max) {
                this.noda = this.max;
            }
        } else if (this.nodd == 0 || this.nodd > this.max) {
            this.nodd = this.max;
        }
        this.att = null;
        this.def = null;
        this.button.setEnabled(true);
        this.setTitle(this.resb.getString(this.canRetreat ? "battle.select.attack" : "battle.select.defend"));
        this.retreat.setVisible(this.canRetreat);
        this.annihilate.setVisible(this.canRetreat);
        this.battle.repaint();
        if (this.canRetreat && this.annihilate.isSelected()) {
            this.gui.go("roll " + (this.canRetreat ? this.noda : this.nodd));
        }
    }

    private void drawDiceSelect(Graphics g) {
        int deadDiceD = this.myrisk.hasArmiesInt(this.c2num);
        if (deadDiceD > this.myrisk.getGame().getMaxDefendDice()) {
            deadDiceD = this.myrisk.getGame().getMaxDefendDice();
        }
        Image liveA = GraphicsUtil.getSubimage(this.Battle, 481, 306, 21, 21);
        Image liveD = GraphicsUtil.getSubimage(this.Battle, 481, 327, 21, 21);
        Image deadA = GraphicsUtil.getSubimage(this.Battle, 502, 306, 21, 21);
        Image deadD = GraphicsUtil.getSubimage(this.Battle, 502, 327, 21, 21);
        if (this.max != 0) {
            if (this.canRetreat) {
                GraphicsUtil.drawImage(g, liveA, 120, 174, this);
                if (this.noda > 1) {
                    GraphicsUtil.drawImage(g, liveA, 120, 205, this);
                } else if (this.max > 1) {
                    GraphicsUtil.drawImage(g, deadA, 120, 205, this);
                }
                if (this.noda > 2) {
                    GraphicsUtil.drawImage(g, liveA, 120, 236, this);
                } else if (this.max > 2) {
                    GraphicsUtil.drawImage(g, deadA, 120, 236, this);
                }
                GraphicsUtil.drawImage(g, deadD, 339, 174, this);
                if (deadDiceD > 1) {
                    GraphicsUtil.drawImage(g, deadD, 339, 205, this);
                }
                if (deadDiceD > 2) {
                    GraphicsUtil.drawImage(g, deadD, 339, 236, this);
                }
            } else {
                GraphicsUtil.drawImage(g, liveD, 339, 174, this);
                if (this.nodd > 1) {
                    GraphicsUtil.drawImage(g, liveD, 339, 205, this);
                } else if (this.max > 1) {
                    GraphicsUtil.drawImage(g, deadD, 339, 205, this);
                }
                if (this.nodd > 2) {
                    GraphicsUtil.drawImage(g, liveD, 339, 236, this);
                } else if (this.max > 2) {
                    GraphicsUtil.drawImage(g, deadD, 339, 236, this);
                }
            }
        } else if (this.att == null && this.def == null && !this.spinD) {
            GraphicsUtil.drawImage(g, deadD, 339, 174, this);
            if (deadDiceD > 1) {
                GraphicsUtil.drawImage(g, deadD, 339, 205, this);
            }
            if (deadDiceD > 2) {
                GraphicsUtil.drawImage(g, deadD, 339, 236, this);
            }
            if (!this.spinA) {
                int deadDiceA = this.myrisk.hasArmiesInt(this.c1num) - 1;
                GraphicsUtil.drawImage(g, deadA, 120, 174, this);
                if (deadDiceA > 1) {
                    GraphicsUtil.drawImage(g, deadA, 120, 205, this);
                }
                if (deadDiceA > 2) {
                    GraphicsUtil.drawImage(g, deadA, 120, 236, this);
                }
            }
        }
    }

    public void drawDiceAnimated(Graphics g) {
        if (this.spinA) {
            GraphicsUtil.drawImage(g, this.attackerSpins[r.nextInt(6)], 116, 170, this);
            if (this.noda > 1) {
                GraphicsUtil.drawImage(g, this.attackerSpins[r.nextInt(6)], 116, 201, this);
            }
            if (this.noda > 2) {
                GraphicsUtil.drawImage(g, this.attackerSpins[r.nextInt(6)], 116, 232, this);
            }
            if (this.spinD) {
                GraphicsUtil.drawImage(g, this.defenderSpins[r.nextInt(6)], 335, 170, this);
                if (this.nodd > 1) {
                    GraphicsUtil.drawImage(g, this.defenderSpins[r.nextInt(6)], 335, 201, this);
                }
                if (this.nodd > 2) {
                    GraphicsUtil.drawImage(g, this.defenderSpins[r.nextInt(6)], 335, 232, this);
                }
            }
        }
    }

    private void drawDiceResults(Graphics g2) {
        int[] atti = this.att;
        int[] defi = this.def;
        if (atti != null && defi != null) {
            if (defi[0] >= atti[0]) {
                g2.setColor(Color.blue);
                g2.fillPolygon(GraphicsUtil.newPolygon(new int[]{339, 339, 140}, new int[]{174, 194, 184}));
            } else {
                g2.setColor(Color.red);
                g2.fillPolygon(GraphicsUtil.newPolygon(new int[]{140, 140, 339}, new int[]{174, 194, 184}));
            }
            if (atti.length > 1 && defi.length > 1) {
                if (defi[1] >= atti[1]) {
                    g2.setColor(Color.blue);
                    g2.fillPolygon(GraphicsUtil.newPolygon(new int[]{339, 339, 140}, new int[]{205, 225, 215}));
                } else {
                    g2.setColor(Color.red);
                    g2.fillPolygon(GraphicsUtil.newPolygon(new int[]{140, 140, 339}, new int[]{205, 225, 215}));
                }
            }
            if (atti.length > 2 && defi.length > 2) {
                if (defi[2] >= atti[2]) {
                    g2.setColor(Color.blue);
                    g2.fillPolygon(GraphicsUtil.newPolygon(new int[]{339, 339, 140}, new int[]{236, 256, 246}));
                } else {
                    g2.setColor(Color.red);
                    g2.fillPolygon(GraphicsUtil.newPolygon(new int[]{140, 140, 339}, new int[]{236, 256, 246}));
                }
            }
            this.drawDice(true, atti[0], 120, 174, g2);
            if (atti.length > 1) {
                this.drawDice(true, atti[1], 120, 205, g2);
            }
            if (atti.length > 2) {
                this.drawDice(true, atti[2], 120, 236, g2);
            }
            this.drawDice(false, defi[0], 339, 174, g2);
            if (defi.length > 1) {
                this.drawDice(false, defi[1], 339, 205, g2);
            }
            if (defi.length > 2) {
                this.drawDice(false, defi[2], 339, 236, g2);
            }
        }
    }

    public void drawDice(boolean isAttacker, int result, int dx, int dy, Graphics g) {
        g.translate(GraphicsUtil.scale(dx), GraphicsUtil.scale(dy));
        if (isAttacker) {
            GraphicsUtil.drawImage(g, GraphicsUtil.getSubimage(this.Battle, 481, 306, 21, 21), 0, 0, this);
        } else {
            GraphicsUtil.drawImage(g, GraphicsUtil.getSubimage(this.Battle, 481, 327, 21, 21), 0, 0, this);
        }
        int size = 3;
        g.setColor(new Color(255, 255, 255, 200));
        if (result == 0) {
            GraphicsUtil.fillOval(g, 9, 9, size, size);
        } else if (result == 1) {
            GraphicsUtil.fillOval(g, 3, 3, size, size);
            GraphicsUtil.fillOval(g, 15, 15, size, size);
        } else if (result == 2) {
            GraphicsUtil.fillOval(g, 3, 3, size, size);
            GraphicsUtil.fillOval(g, 9, 9, size, size);
            GraphicsUtil.fillOval(g, 15, 15, size, size);
        } else if (result == 3) {
            GraphicsUtil.fillOval(g, 3, 3, size, size);
            GraphicsUtil.fillOval(g, 15, 3, size, size);
            GraphicsUtil.fillOval(g, 15, 15, size, size);
            GraphicsUtil.fillOval(g, 3, 15, size, size);
        } else if (result == 4) {
            GraphicsUtil.fillOval(g, 3, 3, size, size);
            GraphicsUtil.fillOval(g, 15, 3, size, size);
            GraphicsUtil.fillOval(g, 15, 15, size, size);
            GraphicsUtil.fillOval(g, 3, 15, size, size);
            GraphicsUtil.fillOval(g, 9, 9, size, size);
        } else if (result == 5) {
            GraphicsUtil.fillOval(g, 3, 3, size, size);
            GraphicsUtil.fillOval(g, 15, 3, size, size);
            GraphicsUtil.fillOval(g, 15, 15, size, size);
            GraphicsUtil.fillOval(g, 3, 15, size, size);
            GraphicsUtil.fillOval(g, 9, 3, size, size);
            GraphicsUtil.fillOval(g, 9, 15, size, size);
        }
        g.translate(-GraphicsUtil.scale(dx), -GraphicsUtil.scale(dy));
    }

    public int insideButton(int x, int y) {
        int ax = 120;
        int dx = 339;
        int W = 21;
        int H = 21;
        if (GraphicsUtil.insideButton(x, y, ax, 174, W, H)) {
            return 1;
        }
        if (GraphicsUtil.insideButton(x, y, ax, 205, W, H)) {
            return 2;
        }
        if (GraphicsUtil.insideButton(x, y, ax, 236, W, H)) {
            return 3;
        }
        if (GraphicsUtil.insideButton(x, y, dx, 174, W, H)) {
            return 4;
        }
        if (GraphicsUtil.insideButton(x, y, dx, 205, W, H)) {
            return 5;
        }
        if (GraphicsUtil.insideButton(x, y, dx, 236, W, H)) {
            return 6;
        }
        return 0;
    }

    public void mouseReleased(MouseEvent e) {
        int click = this.insideButton(e.getX(), e.getY());
        if (this.max != 0) {
            if (this.canRetreat) {
                if (click == 1) {
                    this.noda = 1;
                }
                if (click == 2 && this.max > 1) {
                    this.noda = 2;
                }
                if (click == 3 && this.max > 2) {
                    this.noda = 3;
                }
            } else {
                if (click == 4) {
                    this.nodd = 1;
                }
                if (click == 5 && this.max > 1) {
                    this.nodd = 2;
                }
                if (click == 6 && this.max > 2) {
                    this.nodd = 3;
                }
            }
            this.battle.repaint();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    class BattlePanel
    extends JPanel {
        BattlePanel() {
        }

        public void paintComponent(Graphics g) {
            GraphicsUtil.drawImage(g, BattleDialog.this.Back, 0, 0, this);
            if (BattleDialog.this.canRetreat) {
                GraphicsUtil.drawImage(g, GraphicsUtil.getSubimage(BattleDialog.this.Battle, 481, 105, 98, 40), 336, 265, this);
                GraphicsUtil.drawImage(g, GraphicsUtil.getSubimage(BattleDialog.this.Battle, 481, 0, 98, 40), 46, 265, this);
            }
            MoveDialog.paintMove(g, BattleDialog.this.c1img, BattleDialog.this.c2img, BattleDialog.this.color1, BattleDialog.this.color2, BattleDialog.this.gui.getCountryCapital(BattleDialog.this.country1), BattleDialog.this.gui.getCountryCapital(BattleDialog.this.country2), BattleDialog.this.country1.getName(), BattleDialog.this.country2.getName(), BattleDialog.this.myrisk.hasArmiesInt(BattleDialog.this.c1num), BattleDialog.this.myrisk.hasArmiesInt(BattleDialog.this.c2num), BattleDialog.this.gui);
            g.setColor(Color.BLACK);
            GraphicsUtil.drawStringCenteredAt(g, BattleDialog.this.resb.getString("battle.select.dice"), 240, 320);
            BattleDialog.this.drawDiceSelect(g);
            BattleDialog.this.drawDiceAnimated(g);
            BattleDialog.this.drawDiceResults(g);
        }
    }
}

