/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.ui.flashgui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.yura.domination.audio.GameSound;
import net.yura.domination.engine.core.Country;
import net.yura.domination.engine.core.Player;
import net.yura.domination.engine.translation.TranslationBundle;
import net.yura.domination.guishared.RiskUIUtil;
import net.yura.domination.ui.flashgui.GameFrame;
import net.yura.domination.ui.flashgui.NewGameFrame;
import net.yura.swing.GraphicsUtil;

public class MoveDialog
extends JDialog {
    private GameFrame gui;
    private boolean tacmove;
    private Image Move;
    private Image MoveBack;
    private BufferedImage c1img;
    private BufferedImage c2img;
    private Country country1;
    private Country country2;
    private int move;
    private int csrc;
    private int cdes;
    private Color color;
    private JSlider slider;
    private ResourceBundle resb;
    private JButton cancel;
    private static final Polygon arrow;
    private movePanel movepanel;

    public MoveDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.gui = (GameFrame)parent;
        this.Move = RiskUIUtil.getUIImage(this.getClass(), "move.jpg");
        this.MoveBack = GraphicsUtil.getSubimage(this.Move, 0, 0, 480, 330);
        this.initGUI();
        this.setResizable(false);
        this.pack();
    }

    private void initGUI() {
        this.resb = TranslationBundle.getBundle();
        this.setDefaultCloseOperation(0);
        Dimension d = GraphicsUtil.newDimension(480, 330);
        this.movepanel = new movePanel();
        this.movepanel.setPreferredSize(d);
        this.movepanel.setMinimumSize(d);
        this.movepanel.setMaximumSize(d);
        this.movepanel.setLayout(null);
        this.slider = new JSlider();
        this.movepanel.add(this.slider);
        int w = 88;
        int h = 31;
        this.cancel = new JButton(this.resb.getString("move.cancel"));
        NewGameFrame.sortOutButton(this.cancel, GraphicsUtil.getSubimage(this.Move, 484, 5, w, h), GraphicsUtil.getSubimage(this.Move, 480, 72, w, h), GraphicsUtil.getSubimage(this.Move, 480, 41, w, h));
        GraphicsUtil.setBounds(this.cancel, 50, 250, w, h);
        this.cancel.setActionCommand("cancel");
        JButton moveall = new JButton(this.resb.getString("move.moveall"));
        NewGameFrame.sortOutButton(moveall, GraphicsUtil.getSubimage(this.Move, 196, 250, w, h), GraphicsUtil.getSubimage(this.Move, 480, 134, w, h), GraphicsUtil.getSubimage(this.Move, 480, 103, w, h));
        GraphicsUtil.setBounds(moveall, 196, 250, w, h);
        moveall.setActionCommand("all");
        JButton moveButton = new JButton(this.resb.getString("move.move"));
        NewGameFrame.sortOutButton(moveButton, GraphicsUtil.getSubimage(this.Move, 342, 250, w, h), GraphicsUtil.getSubimage(this.Move, 480, 196, w, h), GraphicsUtil.getSubimage(this.Move, 480, 165, w, h));
        GraphicsUtil.setBounds(moveButton, 343, 250, w, h);
        moveButton.setActionCommand("move");
        w = 35;
        h = 25;
        JButton b1 = new JButton(this.resb.getString("move.min"));
        NewGameFrame.sortOutButton(b1, GraphicsUtil.getSubimage(this.Move, 25, 192, w, h), GraphicsUtil.getSubimage(this.Move, 480, 252, w, h), GraphicsUtil.getSubimage(this.Move, 515, 252, w, h));
        GraphicsUtil.setBounds(b1, 25, 192, w, h);
        b1.setActionCommand("b1");
        JButton b4 = new JButton(this.resb.getString("move.max"));
        NewGameFrame.sortOutButton(b4, GraphicsUtil.getSubimage(this.Move, 25, 192, w, h), GraphicsUtil.getSubimage(this.Move, 480, 252, w, h), GraphicsUtil.getSubimage(this.Move, 515, 252, w, h));
        GraphicsUtil.setBounds(b4, 420, 192, w, h);
        b4.setActionCommand("b4");
        w = 25;
        h = 25;
        JButton b2 = new JButton(this.resb.getString("move.minus"));
        NewGameFrame.sortOutButton(b2, GraphicsUtil.getSubimage(this.Move, 60, 192, w, h), GraphicsUtil.getSubimage(this.Move, 480, 227, w, h), GraphicsUtil.getSubimage(this.Move, 505, 227, w, h));
        GraphicsUtil.setBounds(b2, 60, 192, w, h);
        b2.setActionCommand("b2");
        JButton b3 = new JButton(this.resb.getString("move.plus"));
        NewGameFrame.sortOutButton(b3, GraphicsUtil.getSubimage(this.Move, 60, 192, w, h), GraphicsUtil.getSubimage(this.Move, 480, 227, w, h), GraphicsUtil.getSubimage(this.Move, 505, 227, w, h));
        GraphicsUtil.setBounds(b3, 395, 192, w, h);
        b3.setActionCommand("b3");
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String actionCommand = e.getActionCommand();
                if (!MoveDialog.this.isVisible()) {
                    Logger.getLogger(MoveDialog.class.getName()).info("WARNING! actionPerformed but window not Visible! " + actionCommand + " " + e);
                    return;
                }
                if ("cancel".equals(actionCommand)) {
                    MoveDialog.this.exitForm();
                } else if ("all".equals(actionCommand)) {
                    if (MoveDialog.this.tacmove) {
                        GameSound.INSTANCE.playSound("move_tactical");
                        MoveDialog.this.gui.go("movearmies " + MoveDialog.this.country1.getColor() + " " + MoveDialog.this.country2.getColor() + " " + (MoveDialog.this.csrc - 1));
                    } else {
                        GameSound.INSTANCE.playSound("move_armies");
                        MoveDialog.this.gui.go("move " + (MoveDialog.this.csrc - 1));
                    }
                } else if ("move".equals(actionCommand)) {
                    if (MoveDialog.this.tacmove) {
                        GameSound.INSTANCE.playSound("move_tactical");
                        MoveDialog.this.gui.go("movearmies " + MoveDialog.this.country1.getColor() + " " + MoveDialog.this.country2.getColor() + " " + MoveDialog.this.move);
                    } else {
                        GameSound.INSTANCE.playSound("move_armies");
                        MoveDialog.this.gui.go("move " + MoveDialog.this.move);
                    }
                } else if ("b1".equals(actionCommand)) {
                    MoveDialog.this.slider.setValue(MoveDialog.this.slider.getMinimum());
                } else if ("b2".equals(actionCommand)) {
                    MoveDialog.this.slider.setValue(MoveDialog.this.move - 1);
                } else if ("b3".equals(actionCommand)) {
                    MoveDialog.this.slider.setValue(MoveDialog.this.move + 1);
                } else if ("b4".equals(actionCommand)) {
                    MoveDialog.this.slider.setValue(MoveDialog.this.slider.getMaximum());
                }
            }
        };
        this.cancel.addActionListener(al);
        moveall.addActionListener(al);
        moveButton.addActionListener(al);
        b1.addActionListener(al);
        b2.addActionListener(al);
        b3.addActionListener(al);
        b4.addActionListener(al);
        this.movepanel.add(b1);
        this.movepanel.add(b2);
        this.movepanel.add(b3);
        this.movepanel.add(b4);
        this.movepanel.add(this.cancel);
        this.movepanel.add(moveall);
        this.movepanel.add(moveButton);
        this.getContentPane().add(this.movepanel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                if (MoveDialog.this.tacmove) {
                    MoveDialog.this.exitForm();
                }
            }
        });
    }

    public void setup(boolean tm, int m, int a, int b, BufferedImage ai, BufferedImage bi, Country country1, Country country2, Color c) {
        this.tacmove = tm;
        this.c1img = ai;
        this.c2img = bi;
        this.country1 = country1;
        this.country2 = country2;
        this.move = m;
        this.csrc = a;
        this.cdes = b;
        this.color = c;
        if (this.tacmove) {
            this.setTitle(this.resb.getString("move.title.tactical"));
            this.cancel.setVisible(true);
        } else {
            this.setTitle(this.resb.getString("move.title.captured"));
            this.cancel.setVisible(false);
        }
        this.movepanel.remove(this.slider);
        this.slider = new JSlider(this.move, this.csrc - 1, this.move);
        int spacig = Math.round((float)(this.csrc - 1) / 10.0f);
        if (spacig == 0) {
            this.slider.setMajorTickSpacing(1);
        } else {
            this.slider.setMajorTickSpacing(spacig);
            this.slider.setMinorTickSpacing(1);
        }
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(true);
        this.slider.setSnapToTicks(true);
        this.slider.setOpaque(false);
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                MoveDialog.this.move = MoveDialog.this.slider.getValue();
                MoveDialog.this.movepanel.repaint();
            }
        });
        GraphicsUtil.setBounds(this.slider, 90, 180, 300, 50);
        this.movepanel.add(this.slider);
    }

    public void exitForm() {
        this.setVisible(false);
    }

    static void paintMove(Graphics g, BufferedImage c1img, BufferedImage c2img, Color playerColor1, Color playerColor2, Player capital1, Player capital2, String name1, String name2, int noa1i, int noa2i, GameFrame gf) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GraphicsUtil.drawImageInRect(g2, c1img, 30, 30, 200, 140, null);
        GraphicsUtil.drawImageInRect(g2, c2img, 250, 30, 200, 140, null);
        g2.setColor(Color.black);
        GraphicsUtil.drawStringCenteredAt(g, name1, 130, 40);
        GraphicsUtil.drawStringCenteredAt(g, name2, 350, 40);
        gf.drawArmy(g2, playerColor1, noa1i, 130, 100, 20, capital1);
        gf.drawArmy(g2, playerColor2, noa2i, 350, 100, 20, capital2);
        g2.setColor(new Color(playerColor1.getRed(), playerColor1.getGreen(), playerColor1.getBlue(), 150));
        g2.fillPolygon(arrow);
    }

    static {
        int x = 110;
        int y = 40;
        int[] xCoords = new int[]{x + 60, x + 130, x + 130, x + 200, x + 130, x + 130, x + 60};
        int[] yCoords = new int[]{y + 40, y + 40, y + 20, y + 60, y + 100, y + 80, y + 80};
        arrow = GraphicsUtil.newPolygon(xCoords, yCoords);
    }

    class movePanel
    extends JPanel {
        movePanel() {
        }

        public void paintComponent(Graphics g) {
            GraphicsUtil.drawImage(g, MoveDialog.this.MoveBack, 0, 0, this);
            if (MoveDialog.this.tacmove) {
                GraphicsUtil.drawImage(g, GraphicsUtil.getSubimage(MoveDialog.this.Move, 480, 0, 98, 41), 46, 245, this);
            }
            MoveDialog.paintMove(g, MoveDialog.this.c1img, MoveDialog.this.c2img, MoveDialog.this.color, MoveDialog.this.color, MoveDialog.this.gui.getCountryCapital(MoveDialog.this.country1), MoveDialog.this.gui.getCountryCapital(MoveDialog.this.country2), MoveDialog.this.country1.getName(), MoveDialog.this.country2.getName(), MoveDialog.this.csrc - MoveDialog.this.move, MoveDialog.this.cdes + MoveDialog.this.move, MoveDialog.this.gui);
            g.setColor(RiskUIUtil.getTextColorFor(MoveDialog.this.color));
            GraphicsUtil.drawStringCenteredAt(g, Integer.toString(MoveDialog.this.move), 240, 104);
        }
    }
}

