/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.ui.flashgui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import net.yura.domination.audio.GameSound;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskSettings;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.engine.core.RiskGame;
import net.yura.domination.engine.translation.TranslationBundle;
import net.yura.domination.guishared.AboutDialog;
import net.yura.domination.guishared.BadgeButton;
import net.yura.domination.guishared.RiskUIUtil;
import net.yura.domination.ui.flashgui.ImageButtonFocusListener;
import net.yura.swing.GraphicsUtil;
import net.yura.swing.ImageIcon;

public class NewGameFrame
extends JFrame
implements ActionListener,
MouseListener,
KeyListener {
    private Image newgame;
    private Risk myrisk;
    private boolean localgame;
    private JLabel mapPic;
    private JTextField cardsFile;
    private JPanel PlayersPanel;
    private JButton chooseMap;
    private JButton defaultMap;
    private JButton chooseCards;
    private JButton defaultCards;
    private JButton resetplayers;
    private JButton addplayer;
    private JButton start;
    private JButton help;
    private JButton cancel;
    private JRadioButton domination;
    private JRadioButton capital;
    private JRadioButton mission;
    private JRadioButton human;
    private JRadioButton ai;
    private JRadioButton aismart;
    private JRadioButton aiaverage;
    private JRadioButton fixed;
    private JRadioButton increasing;
    private JRadioButton italianLike;
    private JCheckBox AutoPlaceAll;
    private JCheckBox recycle;
    private JTextField playerName;
    private JToggleButton playerColor;
    private String color;
    private Color thecolor;
    private JPanel nothing;
    private JPanel colorChooser;
    private MyColor[] Colors;
    private ResourceBundle resb = TranslationBundle.getBundle();
    Component[] arCycleList;
    private int nRemoveButtonPos = 8;

    public NewGameFrame(Risk r) {
        this.myrisk = r;
        this.newgame = RiskUIUtil.getUIImage(this.getClass(), "newgame.jpg");
        this.initGUI();
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(AboutDialog.class.getResource("icon.gif")));
        this.setResizable(false);
        this.pack();
        this.chooseCards.requestFocus();
    }

    private void initGUI() {
        this.setFocusTraversalPolicy(new NewGameFrameFocusTraversalPolicy());
        this.Colors = new MyColor[12];
        this.Colors[0] = new MyColor(Color.PINK, "pink", 385, 410, 25, 25, 80);
        this.Colors[1] = new MyColor(Color.RED, "red", 410, 410, 25, 25, 82);
        this.Colors[2] = new MyColor(Color.ORANGE, "orange", 435, 410, 25, 25, 79);
        this.Colors[3] = new MyColor(Color.YELLOW, "yellow", 460, 410, 25, 25, 89);
        this.Colors[4] = new MyColor(Color.GREEN, "green", 385, 435, 25, 25, 71);
        this.Colors[5] = new MyColor(Color.CYAN, "cyan", 410, 435, 25, 25, 67);
        this.Colors[6] = new MyColor(Color.BLUE, "blue", 435, 435, 25, 25, 66);
        this.Colors[7] = new MyColor(Color.MAGENTA, "magenta", 460, 435, 25, 25, 77);
        this.Colors[8] = new MyColor(Color.WHITE, "white", 385, 460, 25, 25, 87);
        this.Colors[9] = new MyColor(Color.LIGHT_GRAY, "lightgray", 410, 460, 25, 25, 76);
        this.Colors[10] = new MyColor(Color.DARK_GRAY, "darkgray", 435, 460, 25, 25, 68);
        this.Colors[11] = new MyColor(Color.BLACK, "black", 460, 460, 25, 25, 75);
        Dimension d = GraphicsUtil.newDimension(700, 600);
        JLayeredPane layeredPane = new JLayeredPane();
        layeredPane.setPreferredSize(d);
        layeredPane.setMinimumSize(d);
        layeredPane.setMaximumSize(d);
        NewGamePanel ngp = new NewGamePanel();
        ngp.setLayout(null);
        ngp.setBounds(0, 0, (int)d.getWidth(), (int)d.getHeight());
        this.mapPic = new JLabel();
        GraphicsUtil.setBounds(this.mapPic, 51, 51, 203, 127);
        int w = 93;
        int h = 32;
        this.chooseMap = new BadgeButton(this.resb.getString("newgame.choosemap"));
        NewGameFrame.sortOutButton(this.chooseMap, GraphicsUtil.getSubimage(this.newgame, 54, 191, w, h), GraphicsUtil.getSubimage(this.newgame, 700, 105, w, h), GraphicsUtil.getSubimage(this.newgame, 700, 137, w, h));
        this.chooseMap.addActionListener(this);
        GraphicsUtil.setBounds(this.chooseMap, 54, 192, w, h);
        this.defaultMap = new JButton(this.resb.getString("newgame.defaultmap"));
        NewGameFrame.sortOutButton(this.defaultMap, GraphicsUtil.getSubimage(this.newgame, 159, 192, w, h), GraphicsUtil.getSubimage(this.newgame, 700, 169, w, h), GraphicsUtil.getSubimage(this.newgame, 700, 201, w, h));
        this.defaultMap.addActionListener(this);
        GraphicsUtil.setBounds(this.defaultMap, 159, 192, 93, 32);
        this.cardsFile = new JTextField("");
        this.cardsFile.setEditable(false);
        this.cardsFile.setBorder(null);
        this.cardsFile.setOpaque(false);
        GraphicsUtil.setBounds(this.cardsFile, 54, 260, 200, 27);
        this.chooseCards = new JButton(this.resb.getString("newgame.choosecards"));
        NewGameFrame.sortOutButton(this.chooseCards, GraphicsUtil.getSubimage(this.newgame, 54, 191, w, h), GraphicsUtil.getSubimage(this.newgame, 700, 105, w, h), GraphicsUtil.getSubimage(this.newgame, 700, 137, w, h));
        this.chooseCards.addActionListener(this);
        GraphicsUtil.setBounds(this.chooseCards, 54, 301, 93, 32);
        this.defaultCards = new JButton(this.resb.getString("newgame.defaultcards"));
        NewGameFrame.sortOutButton(this.defaultCards, GraphicsUtil.getSubimage(this.newgame, 159, 192, w, h), GraphicsUtil.getSubimage(this.newgame, 700, 169, w, h), GraphicsUtil.getSubimage(this.newgame, 700, 201, w, h));
        this.defaultCards.addActionListener(this);
        GraphicsUtil.setBounds(this.defaultCards, 159, 301, 93, 32);
        ButtonGroup GameTypeButtonGroup = new ButtonGroup();
        ButtonGroup CardTypeButtonGroup = new ButtonGroup();
        int col1offset = 40;
        int col2offset = 160;
        int col1width = 119;
        int col2width = 130;
        int bh = 25;
        this.domination = new JRadioButton(this.resb.getString("newgame.mode.domination"), true);
        NewGameFrame.sortOutButton(this.domination);
        GraphicsUtil.setBounds(this.domination, col1offset, 370, col1width, bh);
        this.domination.addActionListener(this);
        this.capital = new JRadioButton(this.resb.getString("newgame.mode.capital"));
        NewGameFrame.sortOutButton(this.capital);
        GraphicsUtil.setBounds(this.capital, col1offset, 390, col1width, bh);
        this.capital.addActionListener(this);
        this.mission = new JRadioButton(this.resb.getString("newgame.mode.mission"));
        NewGameFrame.sortOutButton(this.mission);
        GraphicsUtil.setBounds(this.mission, col1offset, 410, col1width, bh);
        this.mission.addActionListener(this);
        this.AutoPlaceAll = new JCheckBox(this.resb.getString("newgame.autoplace"));
        this.AutoPlaceAll.setToolTipText(this.resb.getString("newgame.autoplace"));
        NewGameFrame.sortOutButton(this.AutoPlaceAll);
        GraphicsUtil.setBounds(this.AutoPlaceAll, col1offset, 440, col1width, bh);
        this.AutoPlaceAll.setSelected("true".equals(this.myrisk.getRiskConfig("default.autoplaceall")));
        this.recycle = new JCheckBox(this.resb.getString("newgame.recycle"));
        this.recycle.setToolTipText(this.resb.getString("newgame.recycle"));
        NewGameFrame.sortOutButton(this.recycle);
        GraphicsUtil.setBounds(this.recycle, col2offset, 440, col2width, bh);
        this.recycle.setSelected("true".equals(this.myrisk.getRiskConfig("default.recyclecards")));
        this.increasing = new JRadioButton(this.resb.getString("newgame.cardmode.increasing"), true);
        NewGameFrame.sortOutButton(this.increasing);
        GraphicsUtil.setBounds(this.increasing, col2offset, 370, col2width, bh);
        this.fixed = new JRadioButton(this.resb.getString("newgame.cardmode.fixed"));
        NewGameFrame.sortOutButton(this.fixed);
        GraphicsUtil.setBounds(this.fixed, col2offset, 390, col2width, bh);
        this.italianLike = new JRadioButton(this.resb.getString("newgame.cardmode.italianlike"));
        NewGameFrame.sortOutButton(this.italianLike);
        GraphicsUtil.setBounds(this.italianLike, col2offset, 410, col2width, bh);
        GameTypeButtonGroup.add(this.domination);
        GameTypeButtonGroup.add(this.capital);
        GameTypeButtonGroup.add(this.mission);
        CardTypeButtonGroup.add(this.italianLike);
        CardTypeButtonGroup.add(this.fixed);
        CardTypeButtonGroup.add(this.increasing);
        this.PlayersPanel = new JPanel();
        GraphicsUtil.setBounds(this.PlayersPanel, 340, 51, 309, 210);
        this.PlayersPanel.setOpaque(false);
        this.PlayersPanel.setLayout(new BoxLayout(this.PlayersPanel, 1));
        w = 115;
        h = 31;
        this.resetplayers = new JButton(this.resb.getString("newgame.resetplayers"));
        NewGameFrame.sortOutButton(this.resetplayers, GraphicsUtil.getSubimage(this.newgame, 705, 488, w, h), GraphicsUtil.getSubimage(this.newgame, 700, 357, w, h), GraphicsUtil.getSubimage(this.newgame, 700, 388, w, h));
        GraphicsUtil.setBounds(this.resetplayers, 437, 268, 115, 31);
        this.resetplayers.addActionListener(this);
        this.playerName = new JTextField(this.resb.getString("newgame.newplayername")){

            protected Document createDefaultModel() {
                return new LimitedDocument();
            }
        };
        this.playerName.setBorder(null);
        this.playerName.setOpaque(false);
        GraphicsUtil.setBounds(this.playerName, 403, 335, 97, 25);
        ButtonGroup playerTypeButtonGroup = new ButtonGroup();
        int typeX = 520;
        int typeY = 325;
        int typeGap = 18;
        int typeW = 160;
        int typeH = 25;
        this.human = new JRadioButton(this.resb.getString("newgame.player.type.human"), true);
        NewGameFrame.sortOutButton(this.human);
        GraphicsUtil.setBounds(this.human, typeX, typeY, typeW, typeH);
        this.ai = new JRadioButton(this.resb.getString("newgame.player.type.easyai"));
        NewGameFrame.sortOutButton(this.ai);
        GraphicsUtil.setBounds(this.ai, typeX, typeY += typeGap, typeW, typeH);
        this.aiaverage = new JRadioButton(this.resb.getString("newgame.player.type.averageai"));
        NewGameFrame.sortOutButton(this.aiaverage);
        GraphicsUtil.setBounds(this.aiaverage, typeX, typeY += typeGap, typeW, typeH);
        this.aismart = new JRadioButton(this.resb.getString("newgame.player.type.hardai"));
        NewGameFrame.sortOutButton(this.aismart);
        GraphicsUtil.setBounds(this.aismart, typeX, typeY += typeGap, typeW, typeH);
        playerTypeButtonGroup.add(this.human);
        playerTypeButtonGroup.add(this.ai);
        playerTypeButtonGroup.add(this.aiaverage);
        playerTypeButtonGroup.add(this.aismart);
        this.color = "black";
        this.thecolor = Color.black;
        this.playerColor = new JToggleButton("");
        NewGameFrame.sortOutButton(this.playerColor, GraphicsUtil.getSubimage(this.newgame, 793, 105, 19, 19), GraphicsUtil.getSubimage(this.newgame, 793, 125, 19, 19), GraphicsUtil.getSubimage(this.newgame, 793, 145, 19, 19));
        this.playerColor.addActionListener(this);
        GraphicsUtil.setBounds(this.playerColor, 475, 370, 25, 25);
        this.addplayer = new JButton(this.resb.getString("newgame.addplayer"));
        NewGameFrame.sortOutButton(this.addplayer, GraphicsUtil.getSubimage(this.newgame, 437, 413, w, h), GraphicsUtil.getSubimage(this.newgame, 700, 419, w, h), GraphicsUtil.getSubimage(this.newgame, 700, 450, w, h));
        this.addplayer.addActionListener(this);
        GraphicsUtil.setBounds(this.addplayer, 437, 413, 115, 31);
        this.cancel = new JButton(this.resb.getString("newgame.cancel"));
        NewGameFrame.sortOutButton(this.cancel, GraphicsUtil.getSubimage(this.newgame, 41, 528, w, h), GraphicsUtil.getSubimage(this.newgame, 700, 233, w, h), GraphicsUtil.getSubimage(this.newgame, 700, 264, w, h));
        this.cancel.addActionListener(this);
        GraphicsUtil.setBounds(this.cancel, 41, 528, 115, 31);
        this.help = new JButton();
        NewGameFrame.sortOutButton(this.help, GraphicsUtil.getSubimage(this.newgame, 781, 526, 30, 30), GraphicsUtil.getSubimage(this.newgame, 794, 171, 30, 30), GraphicsUtil.getSubimage(this.newgame, 794, 202, 30, 30));
        this.help.addActionListener(this);
        GraphicsUtil.setBounds(this.help, 335, 529, 30, 30);
        this.start = new JButton(this.resb.getString("newgame.startgame"));
        NewGameFrame.sortOutButton(this.start, GraphicsUtil.getSubimage(this.newgame, 544, 528, w, h), GraphicsUtil.getSubimage(this.newgame, 700, 295, w, h), GraphicsUtil.getSubimage(this.newgame, 700, 326, w, h));
        this.start.addActionListener(this);
        GraphicsUtil.setBounds(this.start, 544, 528, 115, 31);
        ngp.add(this.mapPic);
        ngp.add(this.chooseMap);
        ngp.add(this.defaultMap);
        ngp.add(this.cardsFile);
        ngp.add(this.chooseCards);
        ngp.add(this.defaultCards);
        ngp.add(this.domination);
        ngp.add(this.capital);
        ngp.add(this.mission);
        ngp.add(this.italianLike);
        ngp.add(this.fixed);
        ngp.add(this.increasing);
        ngp.add(this.PlayersPanel);
        ngp.add(this.playerName);
        ngp.add(this.human);
        ngp.add(this.ai);
        ngp.add(this.aiaverage);
        ngp.add(this.aismart);
        ngp.add(this.playerColor);
        ngp.add(this.resetplayers);
        ngp.add(this.addplayer);
        ngp.add(this.AutoPlaceAll);
        ngp.add(this.recycle);
        ngp.add(this.cancel);
        ngp.add(this.help);
        ngp.add(this.start);
        this.colorChooser = new colorChooserPanel();
        this.colorChooser.setBounds(0, 0, (int)d.getWidth(), (int)d.getHeight());
        this.colorChooser.addMouseListener(this);
        this.colorChooser.setOpaque(false);
        this.colorChooser.setVisible(false);
        this.colorChooser.addKeyListener(this);
        this.playerColor.addKeyListener(this);
        this.nothing = new JPanel();
        this.nothing.setBounds(0, 0, (int)d.getWidth(), (int)d.getHeight());
        this.nothing.addMouseListener(this);
        this.nothing.setOpaque(false);
        this.nothing.setVisible(false);
        layeredPane.add((Component)this.nothing, 0);
        layeredPane.add((Component)this.colorChooser, 1);
        layeredPane.add((Component)ngp, 2);
        this.setContentPane(layeredPane);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                NewGameFrame.this.exitForm();
            }
        });
        this.start.setDefaultCapable(true);
        this.human.setMnemonic('u');
        this.ai.setMnemonic('e');
        this.aismart.setMnemonic('h');
        this.domination.setMnemonic('d');
        this.capital.setMnemonic('c');
        this.mission.setMnemonic('m');
        this.addplayer.setMnemonic('a');
        this.resetplayers.setMnemonic('r');
        this.AutoPlaceAll.setMnemonic('p');
        this.start.setMnemonic('s');
        this.arCycleList = new Component[]{this.chooseMap, this.defaultMap, this.chooseCards, this.defaultCards, this.domination, this.capital, this.mission, this.AutoPlaceAll, null, null, null, null, null, null, this.resetplayers, this.playerName, this.playerColor, this.human, this.ai, this.aiaverage, this.aismart, this.addplayer, this.cancel, this.help, this.start};
        this.nRemoveButtonPos = 8;
    }

    public void setup(boolean localgame) {
        this.localgame = localgame;
        this.start.setEnabled(true);
        if (this.localgame) {
            this.setTitle(this.resb.getString("newgame.title.local"));
            this.resetplayers.setVisible(true);
        } else {
            this.setTitle(this.resb.getString("newgame.title.network"));
            this.resetplayers.setVisible(false);
        }
        Component[] players = this.PlayersPanel.getComponents();
        for (int c = 0; c < players.length; ++c) {
            this.PlayersPanel.remove(players[c]);
        }
        this.nothing.setVisible(false);
        if (this.localgame) {
            RiskSettings.loadPlayers(this.myrisk, this.getClass());
        }
    }

    public void needInput() {
        this.start.setEnabled(true);
        if (this.nothing.isVisible()) {
            this.nothing.setVisible(false);
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void noInput() {
        this.nothing.setVisible(true);
    }

    public void setMap(Icon a) {
        this.mapPic.setIcon(a);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void setCards(String c, boolean m) {
        this.cardsFile.setText(c);
        if (!m && this.mission.isSelected()) {
            this.domination.setSelected(true);
            this.AutoPlaceAll.setEnabled(true);
        }
        this.mission.setEnabled(m);
    }

    public void addPlayer(final int type, final String name, final Color color, final String ip) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                playerPanel player = new playerPanel(type, name, color, ip);
                NewGameFrame.this.PlayersPanel.add(player);
                NewGameFrame.this.PlayersPanel.validate();
                NewGameFrame.this.PlayersPanel.repaint();
                NewGameFrame.this.arCycleList[((NewGameFrame)NewGameFrame.this).nRemoveButtonPos + ((NewGameFrame)NewGameFrame.this).PlayersPanel.getComponents().length - 1] = player.getRemoveButton();
            }
        });
    }

    public void delPlayer(final String name) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Component[] players = NewGameFrame.this.PlayersPanel.getComponents();
                for (int c = 0; c < players.length; ++c) {
                    if (!((playerPanel)players[c]).getName().equals(name)) continue;
                    NewGameFrame.this.PlayersPanel.remove(c);
                    NewGameFrame.this.PlayersPanel.validate();
                    NewGameFrame.this.PlayersPanel.repaint();
                    int nCyclePos = NewGameFrame.this.nRemoveButtonPos + c;
                    NewGameFrame.this.arCycleList[nCyclePos] = null;
                    for (int d = nCyclePos + 1; d < NewGameFrame.this.nRemoveButtonPos + 6; ++d) {
                        NewGameFrame.this.arCycleList[d - 1] = NewGameFrame.this.arCycleList[d];
                    }
                    NewGameFrame.this.arCycleList[((NewGameFrame)NewGameFrame.this).nRemoveButtonPos + 5] = null;
                    break;
                }
            }
        });
    }

    private void exitForm() {
        this.myrisk.parser("closegame");
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancel) {
            GameSound.INSTANCE.playSound("back_button");
        } else if (e.getSource() != this.start) {
            GameSound.INSTANCE.playSound("button");
        }
        if (e.getSource() == this.chooseMap) {
            String name = RiskUIUtil.getNewMap(this);
            if (name != null) {
                this.myrisk.parser("choosemap " + name);
                this.setCursor(Cursor.getPredefinedCursor(3));
            }
        } else if (e.getSource() == this.defaultMap) {
            this.myrisk.parser("choosemap " + RiskGame.getDefaultMap());
        } else if (e.getSource() == this.chooseCards) {
            String name = RiskUIUtil.getNewMapsFile(this, "cards");
            if (name != null) {
                this.myrisk.parser("choosecards " + name);
            }
        } else if (e.getSource() == this.defaultCards) {
            this.myrisk.parser("choosecards " + RiskGame.getDefaultCards());
        } else if (e.getSource() == this.resetplayers) {
            Component[] players = this.PlayersPanel.getComponents();
            for (int c = 0; c < players.length; ++c) {
                this.myrisk.parser("delplayer " + ((playerPanel)players[c]).getName());
            }
            this.resetPlayers();
        } else if (e.getSource() == this.addplayer) {
            String type = "";
            type = this.human.isSelected() ? "human" : (this.ai.isSelected() ? "ai easy" : (this.aismart.isSelected() ? "ai hard" : "ai average"));
            this.myrisk.parser("newplayer " + type + " " + this.color + " " + this.playerName.getText());
        } else if (e.getSource() == this.start) {
            Component[] players = this.PlayersPanel.getComponents();
            if (players.length >= 2 && players.length <= RiskGame.MAX_PLAYERS) {
                if (this.localgame) {
                    RiskSettings.savePlayers(this.myrisk, this.getClass());
                }
                String type = "";
                if (this.domination.isSelected()) {
                    type = "domination";
                } else if (this.capital.isSelected()) {
                    type = "capital";
                } else if (this.mission.isSelected()) {
                    type = "mission";
                }
                if (this.increasing.isSelected()) {
                    type = type + " increasing";
                } else if (this.fixed.isSelected()) {
                    type = type + " fixed";
                } else if (this.italianLike.isSelected()) {
                    type = type + " italianlike";
                }
                this.myrisk.parser("startgame " + type + (this.AutoPlaceAll.isSelected() ? " autoplaceall" : "") + (this.recycle.isSelected() ? " recycle" : ""));
                this.start.setEnabled(false);
            } else {
                JOptionPane.showMessageDialog(this, this.resb.getString("newgame.error.numberofplayers"), this.resb.getString("newgame.error.title"), 0);
            }
        } else if (e.getSource() == this.help) {
            try {
                RiskUtil.openDocs(this.resb.getString("helpfiles.flash"));
            }
            catch (Exception er) {
                JOptionPane.showMessageDialog(this, "Unable to open manual: " + er.getMessage(), "Error", 0);
            }
        } else if (e.getSource() == this.cancel) {
            this.exitForm();
        } else if (e.getSource() == this.playerColor) {
            this.colorChooser.setVisible(this.playerColor.isSelected());
        } else if (e.getSource() == this.mission) {
            this.AutoPlaceAll.setEnabled(false);
        } else if (e.getSource() == this.domination) {
            this.AutoPlaceAll.setEnabled(true);
        } else if (e.getSource() == this.capital) {
            this.AutoPlaceAll.setEnabled(true);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getSource() == this.colorChooser) {
            for (int c = 0; c < this.Colors.length; ++c) {
                if (!GraphicsUtil.insideButton(e.getX(), e.getY(), this.Colors[c].getX(), this.Colors[c].getY(), this.Colors[c].getWidth(), this.Colors[c].getHeight())) continue;
                this.setSelectedPlayerColor(this.Colors[c]);
                break;
            }
            this.colorChooser.setVisible(false);
            this.playerColor.setSelected(false);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    protected void setSelectedPlayerColor(MyColor col) {
        this.color = col.getName();
        this.thecolor = col.getColor();
    }

    public void resetPlayers() {
        this.myrisk.parser("autosetup");
    }

    public static void sortOutButton(AbstractButton button, Image nornal, Image hover, Image pressed) {
        button.setIcon(new ImageIcon(nornal));
        button.setRolloverIcon(new ImageIcon(hover));
        ImageIcon down = new ImageIcon(pressed);
        button.setRolloverSelectedIcon(down);
        button.setSelectedIcon(down);
        button.setPressedIcon(down);
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setBorderPainted(false);
        button.setFocusPainted(false);
        button.setContentAreaFilled(false);
        if (!Color.BLACK.equals(button.getForeground())) {
            button.setForeground(Color.BLACK);
        }
        button.setHorizontalTextPosition(0);
        button.addFocusListener(new ImageButtonFocusListener(button));
        button.setBorder(new EmptyBorder(0, 0, 0, 0));
    }

    public static void sortOutButton(AbstractButton button) {
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setBorderPainted(false);
        button.setContentAreaFilled(false);
        if (!Color.BLACK.equals(button.getForeground())) {
            button.setForeground(Color.BLACK);
        }
        button.addFocusListener(new ImageButtonFocusListener(button));
    }

    public void keyReleased(KeyEvent event) {
        if (event.getSource() != this.colorChooser && event.getSource() != this.playerColor) {
            return;
        }
        for (int nA = 0; nA < this.Colors.length; ++nA) {
            if (this.Colors[nA].getKeyCode() != event.getKeyCode()) continue;
            this.colorChooser.setVisible(true);
            this.setSelectedPlayerColor(this.Colors[nA]);
            this.colorChooser.setVisible(false);
            this.playerColor.setSelected(false);
            break;
        }
    }

    public void keyTyped(KeyEvent event) {
    }

    public void keyPressed(KeyEvent event) {
    }

    class NewGameFrameFocusTraversalPolicy
    extends FocusTraversalPolicy {
        NewGameFrameFocusTraversalPolicy() {
        }

        public Component getComponentAfter(Container container, Component component) {
            int nPos = this.getComponentIndex(component) + 1;
            if (nPos >= NewGameFrame.this.arCycleList.length) {
                nPos = 0;
            }
            while (NewGameFrame.this.arCycleList[nPos] == null && nPos < NewGameFrame.this.arCycleList.length) {
                ++nPos;
            }
            return NewGameFrame.this.arCycleList[nPos];
        }

        public Component getComponentBefore(Container container, Component component) {
            int nPos = this.getComponentIndex(component) - 1;
            if (nPos < 0) {
                nPos = NewGameFrame.this.arCycleList.length - 1;
            }
            while (NewGameFrame.this.arCycleList[nPos] == null && nPos > 0) {
                --nPos;
            }
            return NewGameFrame.this.arCycleList[nPos];
        }

        private int getComponentIndex(Component comp) {
            for (int nA = 0; nA < NewGameFrame.this.arCycleList.length; ++nA) {
                if (NewGameFrame.this.arCycleList[nA] != comp) continue;
                return nA;
            }
            return -1;
        }

        public Component getFirstComponent(Container container) {
            return NewGameFrame.this.arCycleList[0];
        }

        public Component getLastComponent(Container container) {
            return NewGameFrame.this.arCycleList[NewGameFrame.this.arCycleList.length - 1];
        }

        public Component getDefaultComponent(Container container) {
            return NewGameFrame.this.arCycleList[0];
        }
    }

    class MyColor {
        private Color color;
        private String name;
        private int myX;
        private int myY;
        private int myW;
        private int myH;
        private int keyCode;

        public MyColor(Color c, String n, int x, int y, int w, int h, int keyCode) {
            this.color = c;
            this.name = n;
            this.myX = x;
            this.myY = y;
            this.myW = w;
            this.myH = h;
            this.keyCode = keyCode;
        }

        public Color getColor() {
            return this.color;
        }

        public String getName() {
            return this.name;
        }

        public int getX() {
            return this.myX;
        }

        public int getY() {
            return this.myY;
        }

        public int getWidth() {
            return this.myW;
        }

        public int getHeight() {
            return this.myH;
        }

        public int getKeyCode() {
            return this.keyCode;
        }
    }

    class colorChooserPanel
    extends JPanel {
        colorChooserPanel() {
        }

        public void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            AlphaComposite ac = AlphaComposite.getInstance(3, 0.8f);
            g2.setComposite(ac);
            GraphicsUtil.drawImage(g, NewGameFrame.this.newgame, 370, 395, 500, 500, 700, 0, 830, 105, this);
            for (int c = 0; c < NewGameFrame.this.Colors.length; ++c) {
                g.setColor(NewGameFrame.this.Colors[c].getColor());
                GraphicsUtil.fillRect(g, NewGameFrame.this.Colors[c].getX(), NewGameFrame.this.Colors[c].getY(), NewGameFrame.this.Colors[c].getWidth(), NewGameFrame.this.Colors[c].getHeight());
                Image img = RiskUIUtil.getIconForColor(NewGameFrame.this.Colors[c].getColor().getRGB());
                if (img == null) continue;
                GraphicsUtil.drawImageInRect(g2, img, NewGameFrame.this.Colors[c].getX(), NewGameFrame.this.Colors[c].getY(), NewGameFrame.this.Colors[c].getWidth(), NewGameFrame.this.Colors[c].getHeight(), this);
            }
        }
    }

    class NewGamePanel
    extends JPanel {
        NewGamePanel() {
        }

        public void paintComponent(Graphics g) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            GraphicsUtil.drawImage(g, NewGameFrame.this.newgame, 0, 0, 700, 600, 0, 0, 700, 600, this);
            if (NewGameFrame.this.localgame) {
                GraphicsUtil.drawImage(g, NewGameFrame.this.newgame, 432, 262, 557, 305, 700, 482, 825, 525, this);
            }
            g.setColor(Color.black);
            GraphicsUtil.drawString(g, NewGameFrame.this.resb.getString("newgame.label.map"), 55, 40);
            GraphicsUtil.drawString(g, NewGameFrame.this.resb.getString("newgame.label.players"), 350, 40);
            GraphicsUtil.drawString(g, NewGameFrame.this.resb.getString("newgame.label.cards"), 55, 250);
            GraphicsUtil.drawString(g, NewGameFrame.this.resb.getString("newgame.label.gametype"), 60, 365);
            GraphicsUtil.drawString(g, NewGameFrame.this.resb.getString("newgame.label.cardsoptions"), 170, 365);
            GraphicsUtil.drawString(g, NewGameFrame.this.resb.getString("newgame.label.name"), 400, 325);
            GraphicsUtil.drawString(g, NewGameFrame.this.resb.getString("newgame.label.type"), 520, 325);
            g.setColor(NewGameFrame.this.thecolor);
            GraphicsUtil.fillRect(g, 400, 370, 100, 25);
            Image img = RiskUIUtil.getIconForColor(NewGameFrame.this.thecolor.getRGB());
            if (img != null) {
                GraphicsUtil.drawImageInRect(g, img, 450, 370, 25, 25, this);
            }
            g.setColor(RiskUIUtil.getTextColorFor(NewGameFrame.this.thecolor));
            GraphicsUtil.drawString(g, NewGameFrame.this.resb.getString("newgame.label.color"), 405, 387);
        }
    }

    class playerPanel
    extends JPanel {
        private int type;
        private String name;
        private Color color;
        private String ip;
        private JButton remove;

        public playerPanel(int t, String n, Color c, String i) {
            this.type = t;
            this.name = n;
            this.color = c;
            this.ip = i;
            Dimension d = GraphicsUtil.newDimension(309, 30);
            this.setPreferredSize(d);
            this.setMinimumSize(d);
            this.setMaximumSize(d);
            this.setLayout(null);
            int w = 80;
            int h = 25;
            this.remove = new JButton(NewGameFrame.this.resb.getString("newgame.removeplayer"));
            BufferedImage remove1 = new BufferedImage(w, h, 1);
            BufferedImage remove2 = new BufferedImage(w, h, 1);
            BufferedImage remove3 = new BufferedImage(w, h, 1);
            Graphics g1 = remove1.getGraphics();
            g1.drawImage(GraphicsUtil.getSubimage(NewGameFrame.this.newgame, 700, 525, w, h), 0, 0, this);
            g1.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 50));
            g1.fillRect(0, 0, w, h);
            g1.dispose();
            Graphics g2 = remove2.getGraphics();
            g2.drawImage(GraphicsUtil.getSubimage(NewGameFrame.this.newgame, 700, 550, w, h), 0, 0, this);
            g2.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 50));
            g2.fillRect(0, 0, w, h);
            g2.dispose();
            Graphics g3 = remove3.getGraphics();
            g3.drawImage(GraphicsUtil.getSubimage(NewGameFrame.this.newgame, 700, 575, w, h), 0, 0, this);
            g3.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 50));
            g3.fillRect(0, 0, w, h);
            g3.dispose();
            NewGameFrame.sortOutButton(this.remove, remove1, remove2, remove3);
            GraphicsUtil.setBounds(this.remove, 226, 3, 80, 25);
            this.remove.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    NewGameFrame.this.myrisk.parser("delplayer " + playerPanel.this.name);
                }
            });
            this.add(this.remove);
        }

        public void paintComponent(Graphics g) {
            String typeString;
            g.setColor(new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), 125));
            GraphicsUtil.fillRect(g, 0, 0, 309, 30);
            Image img = RiskUIUtil.getIconForColor(this.color.getRGB());
            if (img != null) {
                GraphicsUtil.drawImageInRect(g, img, 98, 5, 20, 20, this);
            }
            g.setColor(RiskUIUtil.getTextColorFor(this.color));
            GraphicsUtil.drawString(g, this.name, 10, 20);
            if (this.type == 0) {
                typeString = NewGameFrame.this.resb.getString("newgame.player.type.human");
            } else {
                String command = NewGameFrame.this.myrisk.getCommandFromType(this.type);
                try {
                    typeString = NewGameFrame.this.resb.getString("newgame.player.type." + command + "ai");
                }
                catch (Exception ex) {
                    typeString = command;
                }
            }
            GraphicsUtil.drawString(g, typeString, 120, 20);
        }

        public String getName() {
            return this.name;
        }

        public int getType() {
            return this.type;
        }

        public JButton getRemoveButton() {
            return this.remove;
        }
    }

    static class LimitedDocument
    extends PlainDocument {
        LimitedDocument() {
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (this.getLength() + str.length() > 15) {
                str = str.substring(0, str.length() - (this.getLength() + str.length() - 15));
                Toolkit.getDefaultToolkit().beep();
            }
            super.insertString(offs, str, a);
        }
    }
}

