/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.ui.swinggui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import net.yura.domination.guishared.ErdeAnsicht;
import net.yura.domination.guishared.PicturePanel;
import net.yura.domination.ui.swinggui.SwingGUITab;
import net.yura.swing.GraphicsUtil;

public class FX3DPanel
extends JPanel
implements ActionListener,
SwingGUITab,
MouseListener,
MouseMotionListener {
    private JToolBar toolbar;
    private PicturePanel pp;
    private ErdeAnsicht fx3d;
    private boolean fxdone;
    private Thread timer;
    private boolean stopflag;
    private int xgedrueckt = 0;
    private int ygedrueckt = 0;

    public FX3DPanel(PicturePanel p) {
        this.pp = p;
        this.setName("3D View");
        this.setLayout(new GridBagLayout());
        this.toolbar = new JToolBar();
        this.toolbar.setRollover(true);
        this.toolbar.setFloatable(false);
        JButton spin = new JButton("Spin/Stop");
        spin.setActionCommand("spin");
        spin.addActionListener(this);
        this.toolbar.add(spin);
        JButton wire = new JButton("Wire On/Off");
        wire.setActionCommand("wire");
        wire.addActionListener(this);
        this.toolbar.add(wire);
        JButton info = new JButton("Info On/Off");
        info.setActionCommand("info");
        info.addActionListener(this);
        this.toolbar.add(info);
        this.fx3d = new ErdeAnsicht();
        Dimension mapSize = GraphicsUtil.newDimension(480, 480);
        this.fx3d.setPreferredSize(mapSize);
        this.fx3d.setMinimumSize(mapSize);
        this.fx3d.setMaximumSize(mapSize);
        this.add(this.fx3d);
        this.fx3d.addMouseListener(this);
        this.fx3d.addMouseMotionListener(this);
        this.setBorder(BorderFactory.createLoweredBevelBorder());
    }

    public void paintComponent(Graphics g) {
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public void setVisible(boolean v) {
        super.setVisible(v);
        if (v) {
            Image img;
            if (!this.fxdone) {
                this.fx3d.init();
                this.fxdone = true;
            }
            if ((img = this.pp.getImage()) != null) {
                this.fx3d.settext(img);
            }
            this.fx3d.zeichnen();
        } else {
            this.stopflag = true;
        }
    }

    public void actionPerformed(ActionEvent a) {
        if (a.getActionCommand().equals("spin")) {
            if (this.timer == null) {
                this.timer = new Thread(){

                    public void run() {
                        while (!FX3DPanel.this.stopflag) {
                            FX3DPanel.this.fx3d.rotate(-3.0, 0.0);
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        FX3DPanel.this.timer = null;
                    }
                };
                this.stopflag = false;
                this.timer.start();
            } else {
                this.stopflag = true;
            }
        } else if (a.getActionCommand().equals("wire")) {
            this.fx3d.toggleWireframe();
        } else if (a.getActionCommand().equals("info")) {
            this.fx3d.toggleInfo();
        }
    }

    public JToolBar getToolBar() {
        return this.toolbar;
    }

    public JMenu getMenu() {
        return null;
    }

    public void mousePressed(MouseEvent e) {
        this.xgedrueckt = e.getX();
        this.ygedrueckt = e.getY();
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        this.stopflag = true;
        this.fx3d.rotate((this.xgedrueckt - e.getX()) / 2, -(this.ygedrueckt - e.getY()) / 2);
        this.xgedrueckt = e.getX();
        this.ygedrueckt = e.getY();
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }
}

