/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.ui.swinggui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.guishared.RiskUIUtil;
import net.yura.domination.ui.swinggui.SwingGUIPanel;
import net.yura.domination.ui.swinggui.SwingGUITab;
import net.yura.util.Service;

public class PLAF {
    private SwingGUIPanel ui;
    private ButtonGroup lookAndFeelRadioGroup;
    private String lookAndFeel;
    Action setLookAndFeelAction = new AbstractAction(){

        public void actionPerformed(ActionEvent ae) {
            ButtonModel model = PLAF.this.lookAndFeelRadioGroup.getSelection();
            String lookAndFeelName = model.getActionCommand();
            try {
                PLAF.this.setLookAndFeel(lookAndFeelName);
            }
            catch (Exception ex) {
                RiskUtil.printStackTrace(ex);
                PLAF.this.ui.showError("unable To Change LookAndFeel to " + lookAndFeelName);
            }
        }
    };

    public PLAF(SwingGUIPanel ui) {
        this.ui = ui;
        ui.getJMenuBar().add(this.createLookAndFeelMenu());
    }

    private JMenu createLookAndFeelMenu() {
        JMenu menu = new JMenu("L&F");
        menu.setName("lookAndFeel");
        UIManager.LookAndFeelInfo[] lookAndFeelInfos = UIManager.getInstalledLookAndFeels();
        this.lookAndFeel = UIManager.getLookAndFeel().getClass().getName();
        this.lookAndFeelRadioGroup = new ButtonGroup();
        for (UIManager.LookAndFeelInfo lafInfo : lookAndFeelInfos) {
            menu.add(this.createLookAndFeelItem(lafInfo.getName(), lafInfo.getClassName()));
        }
        Iterator it = Service.providers(LookAndFeel.class);
        while (it.hasNext()) {
            LookAndFeel laf = (LookAndFeel)it.next();
            menu.add(this.createLookAndFeelItem(laf.toString(), laf.getClass().getName()));
        }
        menu.addSeparator();
        JMenuItem fontUp = new JMenuItem("Font up");
        fontUp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PLAF.this.font(true);
            }
        });
        menu.add(fontUp);
        JMenuItem fontDown = new JMenuItem("Font down");
        fontDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PLAF.this.font(false);
            }
        });
        menu.add(fontDown);
        return menu;
    }

    private JRadioButtonMenuItem createLookAndFeelItem(String lafName, String lafClassName) {
        JRadioButtonMenuItem lafItem = new JRadioButtonMenuItem();
        lafItem.setSelected(lafClassName.equals(this.lookAndFeel));
        try {
            lafItem.setHideActionText(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        lafItem.setAction(this.setLookAndFeelAction);
        lafItem.setText(lafName);
        lafItem.setActionCommand(lafClassName);
        this.lookAndFeelRadioGroup.add(lafItem);
        return lafItem;
    }

    private void setLookAndFeel(String lookAndFeel) throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        String oldLookAndFeel = this.lookAndFeel;
        if (oldLookAndFeel != lookAndFeel) {
            UIManager.setLookAndFeel(lookAndFeel);
            this.lookAndFeel = lookAndFeel;
            this.updateLookAndFeel();
            this.ui.firePropertyChange("lookAndFeel", oldLookAndFeel, lookAndFeel);
        }
    }

    private void updateLookAndFeel() {
        Window[] windows;
        try {
            windows = Window.getWindows();
        }
        catch (Throwable th) {
            windows = Frame.getFrames();
        }
        for (Window window : windows) {
            SwingUtilities.updateComponentTreeUI(window);
        }
        for (Component demoPanel : this.ui.getJTabbedPane().getComponents()) {
            SwingGUITab tab = (SwingGUITab)((Object)demoPanel);
            SwingUtilities.updateComponentTreeUI(tab.getToolBar());
        }
    }

    private void font(boolean up) {
        int szIncr = up ? 1 : -1;
        RiskUIUtil.fontSize(szIncr);
        this.updateLookAndFeel();
    }
}

