/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.ui.swinggui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import net.yura.domination.audio.GameSound;
import net.yura.domination.engine.ColorUtil;
import net.yura.domination.engine.JavaCompatUtil;
import net.yura.domination.engine.OnlineUtil;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.core.Card;
import net.yura.domination.engine.core.Continent;
import net.yura.domination.engine.core.Country;
import net.yura.domination.engine.core.Mission;
import net.yura.domination.engine.core.Player;
import net.yura.domination.engine.core.RiskGame;
import net.yura.domination.guishared.PicturePanel;
import net.yura.domination.guishared.RiskUIUtil;
import net.yura.domination.mapstore.Map;
import net.yura.domination.mapstore.MapPreview;
import net.yura.domination.mapstore.MapServerClient;
import net.yura.domination.mapstore.MapUpdateService;
import net.yura.domination.tools.mapeditor.MapsTools;
import net.yura.domination.ui.flashgui.MainMenu;
import net.yura.domination.ui.swinggui.CardsDialog;
import net.yura.domination.ui.swinggui.SwingGUITab;
import net.yura.mobile.util.Url;
import net.yura.swing.JTable;

public class TestPanel
extends JPanel
implements ActionListener,
SwingGUITab {
    private Risk myrisk;
    private JToolBar toolbar;
    private AbstractTableModel countriesModel;
    private AbstractTableModel continentsModel;
    private AbstractTableModel cardsModel;
    private AbstractTableModel cardsModel2;
    private AbstractTableModel missionsModel;
    private AbstractTableModel playersModel;
    private AbstractTableModel gameInfo;
    private AbstractTableModel commands;
    private PicturePanel pp;

    public TestPanel(Risk r, PicturePanel p) {
        this.myrisk = r;
        this.pp = p;
        this.setName("Testing");
        this.setOpaque(false);
        this.toolbar = new JToolBar();
        this.toolbar.setRollover(true);
        this.toolbar.setFloatable(false);
        JButton refresh = new JButton("\ud83d\udd04 Refresh");
        refresh.setActionCommand("refresh");
        refresh.addActionListener(this);
        this.toolbar.add(refresh);
        JButton allcards = new JButton("All Cards");
        allcards.setActionCommand("allcards");
        allcards.addActionListener(this);
        this.toolbar.add(allcards);
        JButton testSounds = new JButton("All Sounds");
        testSounds.setActionCommand("testSounds");
        testSounds.addActionListener(this);
        this.toolbar.add(testSounds);
        this.toolbar.addSeparator();
        JButton flash = new JButton("Run main GameGUI with current backend");
        flash.setActionCommand("flash");
        flash.addActionListener(this);
        this.toolbar.add(flash);
        this.toolbar.addSeparator();
        JButton mapServerNameChack = new JButton("Check MapServer");
        mapServerNameChack.setActionCommand("checkMapServer");
        mapServerNameChack.addActionListener(this);
        this.toolbar.add(mapServerNameChack);
        this.countriesModel = new AbstractTableModel(){
            private final String[] columnNames = new String[]{"Color/No.", "ID", "Name", "x", "y", "Continent", "Owner", "Armies", "No. Neighbours", "in", "con"};

            public int getColumnCount() {
                return this.columnNames.length;
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return "Armies".equals(this.columnNames[columnIndex]) || "Owner".equals(this.columnNames[columnIndex]);
            }

            public int getRowCount() {
                Country[] countries;
                RiskGame game = TestPanel.this.myrisk.getGame();
                if (game != null && (countries = game.getCountries()) != null) {
                    return countries.length;
                }
                return 0;
            }

            public String getColumnName(int col) {
                return this.columnNames[col];
            }

            public Object getValueAt(int row, int col) {
                Country country = TestPanel.this.myrisk.getGame().getCountries()[row];
                switch (col) {
                    case 0: {
                        return new Integer(country.getColor());
                    }
                    case 1: {
                        return country.getIdString();
                    }
                    case 2: {
                        return country.getName();
                    }
                    case 3: {
                        return new Integer(country.getX());
                    }
                    case 4: {
                        return new Integer(country.getY());
                    }
                    case 5: {
                        return country.getContinent();
                    }
                    case 6: {
                        return country.getOwner();
                    }
                    case 7: {
                        return new Integer(country.getArmies());
                    }
                    case 8: {
                        Vector neighbours = country.getNeighbours();
                        if (neighbours == null) {
                            return null;
                        }
                        return new Integer(neighbours.size());
                    }
                    case 9: {
                        List<Country> neighbours = country.getIncomingNeighbours();
                        if (neighbours == null) {
                            return null;
                        }
                        return new Integer(neighbours.size());
                    }
                    case 10: {
                        List<Country> neighbours = country.getCrossContinentNeighbours();
                        if (neighbours == null) {
                            return null;
                        }
                        return new Integer(neighbours.size());
                    }
                }
                throw new RuntimeException();
            }

            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                Country country = TestPanel.this.myrisk.getGame().getCountries()[rowIndex];
                switch (columnIndex) {
                    case 6: {
                        Player newPlayer = TestPanel.this.myrisk.getGame().getPlayer(String.valueOf(aValue));
                        if (newPlayer == null) break;
                        Player oldPlayer = country.getOwner();
                        if (oldPlayer != null) {
                            oldPlayer.lostCountry(country);
                        } else {
                            country.addArmy();
                        }
                        newPlayer.newCountry(country);
                        country.setOwner(newPlayer);
                        break;
                    }
                    case 7: {
                        int newArmies = Integer.parseInt(aValue.toString());
                        if (newArmies < 0 || country.getOwner() == null) break;
                        int oldArmies = country.getArmies();
                        if (newArmies > oldArmies) {
                            country.addArmies(newArmies - oldArmies);
                        } else {
                            country.removeArmies(oldArmies - newArmies);
                        }
                        if (oldArmies == 0 || newArmies != 0) break;
                        Player player = country.getOwner();
                        player.lostCountry(country);
                        country.setOwner(null);
                    }
                }
            }
        };
        this.continentsModel = new AbstractTableModel(){
            private final String[] columnNames = new String[]{"No.", "ID", "Name", "Army Value", "No. Countries", "Color"};

            public int getColumnCount() {
                return this.columnNames.length;
            }

            public int getRowCount() {
                Continent[] continents;
                RiskGame game = TestPanel.this.myrisk.getGame();
                if (game != null && (continents = game.getContinents()) != null) {
                    return continents.length;
                }
                return 0;
            }

            public String getColumnName(int col) {
                return this.columnNames[col];
            }

            public Object getValueAt(int row, int col) {
                Continent continent = TestPanel.this.myrisk.getGame().getContinents()[row];
                switch (col) {
                    case 0: {
                        return new Integer(row + 1);
                    }
                    case 1: {
                        return continent.getIdString();
                    }
                    case 2: {
                        return continent.getName();
                    }
                    case 3: {
                        return new Integer(continent.getArmyValue());
                    }
                    case 4: {
                        return new Integer(continent.getTerritoriesContained().size());
                    }
                    case 5: {
                        return ColorUtil.getStringForColor(continent.getColor());
                    }
                }
                throw new RuntimeException();
            }
        };
        this.cardsModel = new CardsTableModel(){

            List getCards() {
                RiskGame game = TestPanel.this.myrisk.getGame();
                if (game != null) {
                    Vector l = game.getCards();
                    return l == null ? Collections.EMPTY_LIST : l;
                }
                return Collections.EMPTY_LIST;
            }
        };
        this.cardsModel2 = new CardsTableModel(){

            List getCards() {
                RiskGame game = TestPanel.this.myrisk.getGame();
                if (game != null) {
                    Vector l = game.getUsedCards();
                    return l == null ? Collections.EMPTY_LIST : l;
                }
                return Collections.EMPTY_LIST;
            }
        };
        this.missionsModel = new AbstractTableModel(){
            private final String[] columnNames = new String[]{"i", "Mission"};

            public int getColumnCount() {
                return this.columnNames.length;
            }

            public int getRowCount() {
                List missions;
                RiskGame game = TestPanel.this.myrisk.getGame();
                if (game != null && (missions = game.getMissions()) != null) {
                    return missions.size();
                }
                return 0;
            }

            public String getColumnName(int col) {
                return this.columnNames[col];
            }

            public Object getValueAt(int row, int col) {
                Mission mission = (Mission)TestPanel.this.myrisk.getGame().getMissions().get(row);
                switch (col) {
                    case 0: {
                        return String.valueOf(row);
                    }
                    case 1: {
                        return mission.toString();
                    }
                }
                throw new RuntimeException();
            }
        };
        this.playersModel = new AbstractTableModel(){
            private final String[] columnNames = new String[]{"Name", "Color", "Type", "Extra Armies", "Armies", "No. Cards", "No. Countries", "No. Player Eliminated", "Capital", "Mission", "Address", "autodefend", "autoendgo"};

            public int getColumnCount() {
                return this.columnNames.length;
            }

            public int getRowCount() {
                Vector players;
                RiskGame game = TestPanel.this.myrisk.getGame();
                if (game != null && (players = game.getPlayers()) != null) {
                    return players.size();
                }
                return 0;
            }

            public String getColumnName(int col) {
                return this.columnNames[col];
            }

            public Object getValueAt(int row, int col) {
                Player player = (Player)TestPanel.this.myrisk.getGame().getPlayers().elementAt(row);
                switch (col) {
                    case 0: {
                        return player.getName();
                    }
                    case 1: {
                        return ColorUtil.getStringForColor(player.getColor());
                    }
                    case 2: {
                        return TestPanel.this.myrisk.getType(player.getType());
                    }
                    case 3: {
                        return new Integer(player.getExtraArmies());
                    }
                    case 4: {
                        return new Integer(player.getNoArmies());
                    }
                    case 5: {
                        return new Integer(player.getCards().size());
                    }
                    case 6: {
                        return new Integer(player.getNoTerritoriesOwned());
                    }
                    case 7: {
                        return new Integer(player.getPlayersEliminated().size());
                    }
                    case 8: {
                        return player.getCapital();
                    }
                    case 9: {
                        return player.getMission();
                    }
                    case 10: {
                        return player.getAddress();
                    }
                    case 11: {
                        return new Boolean(player.getAutoDefend());
                    }
                    case 12: {
                        return new Boolean(player.getAutoEndGo());
                    }
                }
                throw new RuntimeException();
            }

            public boolean isCellEditable(int row, int col) {
                switch (col) {
                    case 0: 
                    case 2: 
                    case 3: 
                    case 10: {
                        return true;
                    }
                }
                return false;
            }

            public void setValueAt(Object aValue, int row, int col) {
                Player player = (Player)TestPanel.this.myrisk.getGame().getPlayers().elementAt(row);
                try {
                    if (col == 3) {
                        int newExtraArmiesValue = Integer.parseInt(String.valueOf(aValue));
                        if (newExtraArmiesValue < 0) {
                            throw new IllegalArgumentException("ExtraArmies can not be negative: " + newExtraArmiesValue);
                        }
                        player.addArmies(newExtraArmiesValue - player.getExtraArmies());
                    } else {
                        String address;
                        int type;
                        String name;
                        String string = name = col == 0 ? String.valueOf(aValue) : player.getName();
                        if (name.equals("")) {
                            throw new IllegalArgumentException("no empty name");
                        }
                        int n = type = col == 2 ? TestPanel.this.myrisk.getType(String.valueOf(aValue)) : player.getType();
                        if (type == -1) {
                            throw new IllegalArgumentException("bad type " + aValue);
                        }
                        String string2 = address = col == 10 ? String.valueOf(aValue) : player.getAddress();
                        if (address.equals("")) {
                            throw new IllegalArgumentException("no empty address");
                        }
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("oldName", player.getName());
                        map.put("newName", name);
                        map.put("newType", type);
                        map.put("newAddress", address);
                        TestPanel.this.myrisk.parserFromNetwork("RENAME " + Url.toQueryString((Hashtable)JavaCompatUtil.asHashtable(map)));
                    }
                }
                catch (Exception ex) {
                    System.out.println("error " + ex);
                }
            }
        };
        this.gameInfo = new ObjectTableModel(){

            public Object getObject() {
                return TestPanel.this.myrisk.getGame();
            }
        };
        this.commands = new AbstractTableModel(){
            private final String[] columnNames = new String[]{"No", "Online Player", "Command"};

            public int getColumnCount() {
                return this.columnNames.length;
            }

            public int getRowCount() {
                Vector players;
                RiskGame game = TestPanel.this.myrisk.getGame();
                if (game != null && (players = game.getCommands()) != null) {
                    return players.size();
                }
                return 0;
            }

            public String getColumnName(int col) {
                return this.columnNames[col];
            }

            public Object getValueAt(int row, int col) {
                String command = String.valueOf(TestPanel.this.myrisk.getGame().getCommands().elementAt(row));
                switch (col) {
                    case 0: {
                        return String.valueOf(row);
                    }
                    case 1: {
                        int space = command.indexOf(" ");
                        if (space > 0) {
                            String address = command.substring(0, space);
                            Vector players = TestPanel.this.myrisk.getGame().getPlayers();
                            for (Player player : players) {
                                if (!player.getAddress().equals(address)) continue;
                                return player;
                            }
                        }
                        return null;
                    }
                    case 2: {
                        return command;
                    }
                }
                throw new RuntimeException();
            }

            public boolean isCellEditable(int row, int col) {
                switch (col) {
                    case 2: {
                        return true;
                    }
                }
                return false;
            }

            public void setValueAt(Object aValue, int row, int col) {
                if (col != 2) {
                    throw new RuntimeException();
                }
                TestPanel.this.myrisk.getGame().getCommands().set(row, aValue);
            }
        };
        JTabbedPane views = new JTabbedPane();
        views.add("Countries", new JScrollPane(new JTable(this.countriesModel)));
        views.add("Continents", new JScrollPane(new JTable(this.continentsModel)));
        views.add("Cards", new JScrollPane(new JTable(this.cardsModel)));
        views.add("Spent Cards", new JScrollPane(new JTable(this.cardsModel2)));
        views.add("Players", new JScrollPane(new JTable(this.playersModel)));
        JTable missionTable = new JTable(this.missionsModel);
        missionTable.getColumnModel().getColumn(0).setMaxWidth(missionTable.getFontMetrics(missionTable.getFont()).stringWidth("1000"));
        views.add("Missions", new JScrollPane(missionTable));
        views.add("Game", new JScrollPane(new JTable(this.gameInfo)));
        JTable commandsTable = new JTable(this.commands);
        commandsTable.setCellSelectionEnabled(true);
        views.add("Commands", new JScrollPane(commandsTable));
        this.setLayout(new BorderLayout());
        this.add(views);
    }

    public void actionPerformed(ActionEvent a) {
        String command = a.getActionCommand();
        if ("refresh".equals(command)) {
            this.refresh();
        } else if ("flash".equals(command)) {
            if (this.myrisk.getGame() == null) {
                MainMenu.newMainMenuFrame(this.myrisk, 2);
            } else {
                JOptionPane.showMessageDialog(this, "Please close the current game first.");
            }
        } else if ("allcards".equals(command)) {
            if (this.myrisk.getGame() != null && this.myrisk.getGame().getCards() != null) {
                Frame frame = RiskUIUtil.findParentFrame(this);
                CardsDialog cardsDialog = new CardsDialog(frame, this.pp, false, this.myrisk);
                Dimension frameSize = frame.getSize();
                Dimension aboutSize = cardsDialog.getPreferredSize();
                int x = frame.getLocation().x + (frameSize.width - aboutSize.width) / 2;
                int y = frame.getLocation().y + (frameSize.height - aboutSize.height) / 2;
                if (x < 0) {
                    x = 0;
                }
                if (y < 0) {
                    y = 0;
                }
                cardsDialog.setLocation(x, y);
                cardsDialog.populate(this.myrisk.getGame().getCards(), false);
                cardsDialog.setVisible(true);
            }
        } else if ("checkMapServer".equals(command)) {
            List maps = MapUpdateService.getMaps(MapServerClient.MAP_PAGE, Collections.EMPTY_LIST);
            if (maps.isEmpty()) {
                JOptionPane.showMessageDialog(this, "ERROR: No maps found on server!");
                return;
            }
            HashSet<String> ids = new HashSet<String>();
            HashSet<String> errors = new HashSet<String>();
            String longestMapName = RiskGame.getDefaultMap();
            for (Map map : maps) {
                String filename = MapPreview.getFileUID(map.getMapUrl());
                if (filename.length() > longestMapName.length()) {
                    longestMapName = filename;
                }
                String fileUID = JavaCompatUtil.replaceAll(filename, " ", "").toLowerCase();
                if (!MapsTools.isValidName(filename) || ids.contains(fileUID)) {
                    errors.add(filename);
                    continue;
                }
                ids.add(fileUID);
            }
            String options = OnlineUtil.createGameString(1, 1, 1, 0, 2, true, true, longestMapName);
            String info = "\nLongest map name: \"" + longestMapName + "\" (" + longestMapName.length() + ") max options lenght: " + options.length();
            if (errors.isEmpty()) {
                JOptionPane.showMessageDialog(this, "No errors found." + info);
            } else {
                JOptionPane.showMessageDialog(this, "Error found with map: " + errors + info);
            }
        } else if ("testSounds".equals(command)) {
            GameSound.INSTANCE.playSound("menu_button");
            GameSound.INSTANCE.playSound("button");
            GameSound.INSTANCE.playSound("back_button");
            GameSound.INSTANCE.playSound("button_start_game");
            GameSound.INSTANCE.playSound("cards_receive");
            GameSound.INSTANCE.playSound("cards_trade");
            GameSound.INSTANCE.playSound("place_army");
            GameSound.INSTANCE.playSound("place_armies");
            GameSound.INSTANCE.playSound("attack");
            GameSound.INSTANCE.playSound("battle_retreat");
            GameSound.INSTANCE.playSound("dice_roll");
            GameSound.INSTANCE.playSound("dice_win");
            GameSound.INSTANCE.playSound("dice_lose");
            GameSound.INSTANCE.playSound("dice_draw");
            GameSound.INSTANCE.playSound("battle_win");
            GameSound.INSTANCE.playSound("battle_defeat");
            GameSound.INSTANCE.playSound("battle_defense_win");
            GameSound.INSTANCE.playSound("battle_defense_defeat");
            GameSound.INSTANCE.playSound("move_armies");
            GameSound.INSTANCE.playSound("move_tactical");
            GameSound.INSTANCE.playSound("lobby_start");
            GameSound.INSTANCE.playSound("lobby_join");
            GameSound.INSTANCE.playSound("lobby_leave");
            GameSound.INSTANCE.playSound("lobby_play");
            GameSound.INSTANCE.playSound("lobby_watch");
            GameSound.INSTANCE.playSound("lobby_set_nick");
        } else {
            throw new RuntimeException("TestTab: unknown command found: " + command);
        }
    }

    private void refresh() {
        this.countriesModel.fireTableDataChanged();
        this.continentsModel.fireTableDataChanged();
        this.cardsModel.fireTableDataChanged();
        this.cardsModel2.fireTableDataChanged();
        this.playersModel.fireTableDataChanged();
        this.gameInfo.fireTableDataChanged();
        this.commands.fireTableDataChanged();
        this.missionsModel.fireTableDataChanged();
        this.repaint();
    }

    public JToolBar getToolBar() {
        this.refresh();
        return this.toolbar;
    }

    public JMenu getMenu() {
        return null;
    }

    abstract class CardsTableModel
    extends AbstractTableModel {
        private final String[] columnNames = new String[]{"No.", "Type", "Country"};

        CardsTableModel() {
        }

        abstract List getCards();

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.getCards().size();
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            Card card = (Card)this.getCards().get(row);
            switch (col) {
                case 0: {
                    return new Integer(row + 1);
                }
                case 1: {
                    return card.getName();
                }
                case 2: {
                    return card.getCountry();
                }
            }
            throw new RuntimeException();
        }
    }

    abstract class ObjectTableModel
    extends AbstractTableModel {
        private final String[] columnNames = new String[]{"Name", "Type", "Value"};
        private Field[] fields;

        ObjectTableModel() {
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            Object game = this.getObject();
            if (game != null) {
                if (this.fields == null) {
                    Field[] fs = game.getClass().getDeclaredFields();
                    ArrayList<Field> result = new ArrayList<Field>();
                    for (int c = 0; c < fs.length; ++c) {
                        if (Modifier.isStatic(fs[c].getModifiers())) continue;
                        try {
                            fs[c].setAccessible(true);
                            result.add(fs[c]);
                            continue;
                        }
                        catch (Exception ex) {
                            System.out.println("can not setAccessible " + fs[c] + " " + ex);
                        }
                    }
                    this.fields = result.toArray(new Field[result.size()]);
                }
                return this.fields.length;
            }
            return 0;
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            Object game = this.getObject();
            switch (col) {
                case 0: {
                    return this.fields[row].getName();
                }
                case 1: {
                    return this.fields[row].getType().getName();
                }
                case 2: {
                    try {
                        Object value = this.fields[row].get(game);
                        if (value instanceof Object[]) {
                            return String.valueOf(Arrays.asList((Object[])value));
                        }
                        return String.valueOf(value);
                    }
                    catch (Exception ex) {
                        return ex.toString();
                    }
                }
            }
            throw new IllegalArgumentException("bad col " + col);
        }

        public abstract Object getObject();
    }
}

