/*
 * Decompiled with CFR 0.152.
 */
package net.yura.swingme.core;

import net.yura.mobile.gui.Font;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.components.Button;
import net.yura.mobile.gui.components.TextArea;
import net.yura.mobile.gui.layout.XULLoader;

public class MultilineButton
extends Button {
    private final int maxTextLabelWidth = XULLoader.adjustSizeToDensity((int)110);
    private final int maxNoLines = 2;
    private final int pressedOffset = XULLoader.adjustSizeToDensity((int)2);
    private int[] lineBreaks = null;

    public void setText(String a) {
        this.lineBreaks = null;
        super.setText(a);
    }

    public void setSize(int width, int height) {
        this.lineBreaks = null;
        super.setSize(width, height);
    }

    protected int getTextWidth(String string) {
        this.setupLineBreaks();
        int tw = 0;
        int start = 0;
        int lines = this.getNoLines();
        for (int c = 0; c < lines; ++c) {
            int end = c == lines - 1 ? string.length() : this.lineBreaks[c];
            int w = super.getTextWidth(string.substring(start, end));
            start = end;
            if (w <= tw) continue;
            tw = w;
        }
        return tw;
    }

    protected int getTextHeight(String string) {
        this.setupLineBreaks();
        return this.getNoLines() * super.getTextHeight(string);
    }

    protected void paintText(Graphics2D g, int x, int y, int textWidth, int availableTextWidth) {
        g.setColor(this.getForeground());
        g.setFont(this.getFont());
        if ((this.getCurrentState() & 4) != 0) {
            x += this.pressedOffset;
            y += this.pressedOffset;
        }
        int lineHeight = super.getTextHeight(this.string);
        int start = 0;
        int lines = this.getNoLines();
        for (int c = 0; c < lines; ++c) {
            int end = c == lines - 1 ? this.string.length() : this.lineBreaks[c];
            String line = this.string.substring(start, end).trim();
            int w = super.getTextWidth(line);
            g.drawString(line, x + (availableTextWidth - w) / 2, y + c * lineHeight);
            start = end;
        }
    }

    private int getNoLines() {
        return Math.min(this.lineBreaks.length + 1, 2);
    }

    private void setupLineBreaks() {
        if (this.lineBreaks == null) {
            this.lineBreaks = TextArea.getLines((String)this.string, (Font)this.font, (int)0, (int)this.maxTextLabelWidth, (int)this.maxTextLabelWidth);
        }
    }
}

