/*
 * Decompiled with CFR 0.152.
 */
package org.me4se;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;

public class JadFile {
    private Hashtable values = new Hashtable();
    private String url;

    public String getValue(String name) {
        return (String)this.values.get(name);
    }

    public String getURL() {
        return this.url;
    }

    public void setValue(String name, String value) {
        this.values.put(name, value);
    }

    public Enumeration keys() {
        return this.values.keys();
    }

    public int getMIDletCount() {
        int i = 1;
        while (this.getValue("MIDlet-" + i) != null) {
            ++i;
        }
        return i - 1;
    }

    public MIDletData getMIDlet(int i) {
        String value = this.getValue("MIDlet-" + i);
        if (value == null) {
            return null;
        }
        int p1 = value.indexOf(44);
        String name = null;
        String icon = null;
        String cls = null;
        if (p1 != -1) {
            name = value.substring(0, p1).trim();
            int p2 = value.indexOf(44, p1 + 1);
            if (p2 != -1) {
                icon = value.substring(p1 + 1, p2).trim();
                cls = value.substring(p2 + 1).trim();
            } else {
                icon = value.substring(p1 + 1).trim();
            }
        } else {
            name = value.trim();
        }
        if ("".equals(name)) {
            name = null;
        }
        if ("".equals(cls)) {
            cls = null;
        }
        if ("".equals(icon)) {
            icon = null;
        }
        return new MIDletData(i, name, icon, cls);
    }

    public void load(InputStream is) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        String key = "";
        String s = null;
        while ((s = reader.readLine()) != null) {
            if (s.startsWith(" ")) {
                String val = this.getValue(key) + s.substring(1);
                this.setValue(key, val);
                continue;
            }
            int cut = s.indexOf(58);
            if (cut == -1) continue;
            key = s.substring(0, cut).trim();
            String val = s.substring(cut + 1).trim();
            this.setValue(key, val);
        }
        reader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String url) throws IOException {
        this.url = url;
        int col = url.indexOf(58);
        if (col > 1 && col < 5) {
            this.load(new URL(url).openStream());
        } else if (new File(url).exists()) {
            System.out.println("Loading JAD from file : " + url);
            FileInputStream fin = new FileInputStream(url);
            try {
                this.load(fin);
            }
            finally {
                fin.close();
            }
        } else {
            InputStream in = this.getClass().getResourceAsStream(url);
            if (in != null) {
                System.out.println("Loading JAD from classpath : " + url);
                this.load(in);
            } else {
                throw new IOException("\"" + url + "\" was found in file system or classpath");
            }
        }
    }

    public class MIDletData {
        private int number;
        private String name;
        private String icon;
        private String cls;

        MIDletData(int number, String name, String icon, String cls) {
            this.number = number;
            this.name = name;
            this.icon = icon;
            if (cls != null) {
                this.cls = cls;
            }
        }

        public int getNumber() {
            return this.number;
        }

        public String getName() {
            return this.name;
        }

        public String getClassName() {
            return this.cls;
        }

        public String getIcon() {
            return this.icon;
        }
    }
}

