/*
 * Decompiled with CFR 0.152.
 */
package org.me4se.impl;

import java.util.Vector;
import javax.microedition.media.Control;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.TimeBase;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.midlet.ApplicationManager;
import org.me4se.impl.BasicMMDataSource;
import org.me4se.impl.TimeBaseImpl;

public class BasicMMPlayer
implements Player,
VolumeControl {
    boolean autoNotify;
    protected long desiredTime = -1L;
    protected int loopCount = 1;
    protected long duration = -1L;
    protected BasicMMDataSource dataSource;
    TimeBase timeBase = TimeBaseImpl.defaultInstance;
    private Vector listeners = new Vector();
    protected int state = 100;

    public BasicMMPlayer(boolean autoNotify) {
        this.autoNotify = autoNotify;
    }

    public void setSource(BasicMMDataSource ds) {
        this.dataSource = ds;
    }

    public void addPlayerListener(PlayerListener playerlistener) {
        this.listeners.addElement(playerlistener);
    }

    public int getState() {
        return this.state;
    }

    public void notifyListeners(String event, Object param) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((PlayerListener)this.listeners.elementAt(i)).playerUpdate(this, event, param);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void startListenerNotification(String event, Object param) {
        if (this.listeners.size() != 0) {
            new Thread(new PlayerNotifier(event, param)).start();
        }
    }

    public TimeBase getTimeBase() {
        return this.timeBase;
    }

    public void setTimeBase(TimeBase master) throws MediaException {
        if (this.state == 100 || this.state == 400) {
            throw new IllegalStateException();
        }
        this.timeBase = master;
    }

    public void removePlayerListener(PlayerListener playerlistener) {
        this.listeners.removeElement(playerlistener);
    }

    public void close() {
        if (this.state == 0) {
            return;
        }
        if (this.state == 400) {
            this.deallocate();
        }
        this.closeImpl();
        this.state = 0;
        if (this.autoNotify) {
            this.startListenerNotification("closed", null);
        }
    }

    public void deallocate() {
        if (this.state == 200 || this.state == 100) {
            return;
        }
        if (this.state == 0) {
            throw new IllegalStateException();
        }
        if (this.state == 400) {
            try {
                this.stop();
            }
            catch (MediaException e) {
                e.printStackTrace();
            }
        }
        this.deallocateImpl();
        this.state = 200;
    }

    public void prefetch() throws MediaException {
        if (this.state == 100) {
            this.realize();
        }
        if (this.state == 300 || this.state == 400) {
            return;
        }
        if (this.state == 0) {
            throw new IllegalStateException();
        }
        try {
            this.prefetchImpl();
        }
        catch (Exception e) {
            MediaException mx = new MediaException(e.toString());
            mx.initCause(e);
            throw mx;
        }
        this.state = 300;
    }

    public void realize() throws MediaException {
        if (this.state == 300 || this.state == 400) {
            return;
        }
        if (this.state == 0) {
            throw new IllegalStateException();
        }
        try {
            this.realizeImpl();
        }
        catch (Exception e) {
            MediaException mx = new MediaException(e.toString());
            mx.initCause(e);
            throw mx;
        }
        this.state = 200;
    }

    public void start() throws MediaException {
        if (this.state == 0) {
            throw new IllegalStateException();
        }
        if (this.state == 400) {
            return;
        }
        if (this.state == 100 || this.state == 200) {
            this.prefetch();
        }
        try {
            this.startImpl();
            ApplicationManager.getInstance().activePlayers.addElement(this);
        }
        catch (MediaException e) {
            throw e;
        }
        catch (Exception e) {
            MediaException mx = new MediaException(e.toString());
            mx.initCause(e);
            throw mx;
        }
        this.state = 400;
        if (this.autoNotify) {
            this.startListenerNotification("started", null);
        }
    }

    public void stop() throws MediaException {
        if (this.state == 0) {
            throw new IllegalStateException();
        }
        if (this.state != 400) {
            return;
        }
        try {
            this.stopImpl();
            ApplicationManager.getInstance().activePlayers.removeElement(this);
        }
        catch (Exception e) {
            MediaException mx = new MediaException(e.toString());
            mx.initCause(e);
            throw mx;
        }
        this.state = 300;
        if (this.autoNotify) {
            this.startListenerNotification("stopped", null);
        }
    }

    public void closeImpl() {
    }

    public void deallocateImpl() {
    }

    public void prefetchImpl() throws Exception {
    }

    public void realizeImpl() throws Exception {
    }

    public void stopImpl() throws Exception {
        System.out.println("BasicMMPlayer.stopImpl()");
    }

    public void startImpl() throws Exception {
        System.out.println("BasicMMPlayer.startImpl()");
    }

    public long setMediaTime(long l) throws MediaException {
        this.desiredTime = l;
        return l;
    }

    public long getMediaTime() {
        System.out.println("BasicMMPlayer.getMediaTime()");
        return -1L;
    }

    public long getDuration() {
        return this.duration;
    }

    public String getContentType() {
        if (this.state == 100) {
            throw new IllegalStateException();
        }
        return this.dataSource.getContentType();
    }

    public void setLoopCount(int i) {
        if (this.state == 400 || this.state == 0) {
            throw new IllegalStateException();
        }
        this.loopCount = i;
    }

    public Control[] getControls() {
        return new Control[]{this};
    }

    public Control getControl(String s) {
        return s.endsWith("VolumeControl") ? this : null;
    }

    public void setMute(boolean mute) {
        System.out.println("VolumeControl.setMute(" + mute + ")");
    }

    public boolean isMuted() {
        System.out.println("VolumeControl.getMute()");
        return false;
    }

    public int setLevel(int level) {
        System.out.println("VolumeControl.setLevel(" + level + ")");
        return 100;
    }

    public int getLevel() {
        System.out.println("VolumeControl.getLevel()");
        return 100;
    }

    class PlayerNotifier
    implements Runnable {
        String event;
        Object param;

        PlayerNotifier(String event, Object param) {
            this.event = event;
            this.param = param;
        }

        public void run() {
            BasicMMPlayer.this.notifyListeners(this.event, this.param);
        }
    }
}

