/*
 * Decompiled with CFR 0.152.
 */
package org.me4se.psi.java1.gcf.file;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;
import org.me4se.impl.ConnectionImpl;

public class FileConnectionImpl
extends ConnectionImpl
implements FileConnection {
    File file = null;
    int mode = -1;

    public void initialise(Properties properties) {
    }

    public void open(String url, int mode, boolean timeouts) throws IOException {
        this.mode = mode;
        this.file = FileConnectionImpl.urlToFile(url);
    }

    public static File urlToFile(String url) {
        Enumeration keys = FileSystemRegistry.remap.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!url.startsWith(key)) continue;
            return new File((String)FileSystemRegistry.remap.get(key), url.substring(key.length()));
        }
        try {
            URI fileUrl = new URI(url.replaceAll(" ", "%20"));
            return new File(fileUrl);
        }
        catch (Exception ex) {
            int cut;
            System.out.println("unable to convert using standard java: " + url + " " + ex);
            for (cut = 5; cut < url.length() && url.charAt(cut) == '/'; ++cut) {
            }
            if (cut + 1 >= url.length() || url.charAt(cut + 1) != ':') {
                --cut;
            }
            String path = url.substring(cut);
            return new File(path.replaceAll("\\%20", " "));
        }
    }

    public long availableSize() {
        int free = 20000000;
        System.out.println("Warning: FileConnection.availableSize() not implemented, returning dummy constant free space (" + free + " bytes)");
        return free;
    }

    public boolean canRead() {
        return this.file.canRead();
    }

    public boolean canWrite() {
        return this.file.canWrite();
    }

    public void create() throws IOException {
        FileOutputStream fos = new FileOutputStream(this.file);
        fos.close();
    }

    public void delete() {
        this.file.delete();
    }

    public long directorySize(boolean includeSubDirs) throws IOException {
        if (!this.file.isDirectory()) {
            throw new IOException("FileConnection.directorySize() cannot be invoked on a file: " + this.file);
        }
        if (includeSubDirs) {
            throw new RuntimeException("FileConnection.directorySize(includingSubDirs) not implemented yet.");
        }
        String[] list = this.file.list();
        if (list != null) {
            long size = 0L;
            for (int i = 0; i < list.length; ++i) {
                File f = new File(this.file, list[i]);
                if (!f.isFile()) continue;
                size += f.length();
            }
            return size;
        }
        return 0L;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public long fileSize() throws IOException {
        if (this.file.isDirectory()) {
            throw new IOException("FileConnection.fileSize() cannot be invoked on a directory: " + this.file);
        }
        return this.file.length();
    }

    public String getName() {
        return this.file.isDirectory() ? this.file.getName() + "/" : this.file.getName();
    }

    public String getPath() {
        return this.file.isDirectory() ? this.file.getAbsolutePath() + "/" : this.file.getAbsolutePath();
    }

    public String getURL() {
        return "file:///" + this.getPath();
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public boolean isHidden() {
        return this.file.isHidden();
    }

    public long lastModified() {
        if (this.file.exists()) {
            return this.file.lastModified();
        }
        return 0L;
    }

    public Enumeration list() {
        if (this.file.exists() && this.file.isDirectory()) {
            File[] files = this.file.listFiles();
            String[] names = new String[files == null ? 0 : files.length];
            for (int i = 0; i < names.length; ++i) {
                names[i] = files[i].isDirectory() ? files[i].getName() + '/' : files[i].getName();
            }
            return new ListEnumeration(names);
        }
        return new ListEnumeration(new String[0]);
    }

    public Enumeration list(String filter, boolean includeHidden) throws IOException {
        return this.list();
    }

    public void mkdir() throws IOException {
        if (!this.file.mkdir()) {
            throw new IOException("Failed to create directory " + this.file);
        }
    }

    public void rename(String newName) throws IOException {
        if (!this.file.exists()) {
            throw new IOException("file does not exist " + this.file);
        }
        if (!this.file.renameTo(new File(this.file.getParent(), newName))) {
            throw new IOException("can not rename file " + this.file + " " + newName);
        }
    }

    public void setFileConnection(String fileName) {
        throw new RuntimeException("FileConnection.setFileConnection() is not yet implemented !");
    }

    public void setHidden(boolean tf) throws IOException {
        throw new IOException("FileConnection.setHidden() not implemented.");
    }

    public void setReadable(boolean tf) throws IOException {
        throw new IOException("FileConnection.setReadable() not implemented.");
    }

    public void setWritable(boolean tf) throws IOException {
        throw new IOException("FileConnection.setWritable() not implemented.");
    }

    public long totalSize() {
        throw new RuntimeException("FileConnection.totalSize() not implemented.");
    }

    public void truncate(long byteOffset) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(this.file, "rw");
        int flen = (int)raf.length();
        if ((long)flen >= byteOffset) {
            raf.setLength(byteOffset);
        }
        raf.close();
    }

    public long usedSize() {
        throw new RuntimeException("FileConnection.usedSize() not implemented.");
    }

    public InputStream openInputStream() throws IOException {
        if (this.file.isDirectory()) {
            throw new IOException("FileConnection.openInputStream() cannot be invoked on a directory: " + this.file);
        }
        return new FileInputStream(this.file);
    }

    public DataInputStream openDataInputStream() throws IOException {
        return new DataInputStream(this.openInputStream());
    }

    public OutputStream openOutputStream() throws IOException {
        return this.openOutputStream(0L);
    }

    public OutputStream openOutputStream(long byteOffset) throws IOException {
        if (this.file.isDirectory()) {
            throw new IOException("FileConnection.openOutputStream() cannot be invoked on a directory: " + this.file);
        }
        RandomAccessFile raf = new RandomAccessFile(this.file, "rw");
        raf.seek(byteOffset);
        return new FileOutputStream(raf.getFD());
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        if (this.file.isDirectory()) {
            throw new IOException("FileConnection.openDataOutputStream() cannot be invoked on a directory: " + this.file);
        }
        return new DataOutputStream(this.openOutputStream());
    }

    public void close() throws IOException {
        this.file = null;
        this.mode = -1;
    }

    class ListEnumeration
    implements Enumeration {
        String[] elements = null;
        int index = 0;

        public ListEnumeration(String[] list) {
            this.elements = list;
        }

        public boolean hasMoreElements() {
            return this.index < this.elements.length;
        }

        public Object nextElement() {
            return this.elements[this.index++];
        }

        public String toString() {
            return "ListEnumeration" + Arrays.asList(this.elements);
        }
    }
}

