/*
 * Decompiled with CFR 0.152.
 */
package free.chess;

import free.chess.Chess;
import free.chess.Move;
import free.chess.Piece;
import free.chess.Player;
import free.chess.PositionFormatException;
import free.chess.Square;
import free.chess.WildVariant;
import free.chess.event.MoveEvent;
import free.chess.event.MoveListener;
import free.util.Utilities;
import java.util.StringTokenizer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public final class Position {
    private final WildVariant variant;
    private final Piece[][] pieces = new Piece[8][8];
    private final Modifier modifier;
    private Player currentPlayer;
    private String positionFEN;
    protected transient ChangeEvent changeEvent = null;
    protected EventListenerList listenerList = new EventListenerList();

    public Position() {
        this(Chess.getInstance());
    }

    public Position(WildVariant wildVariant) {
        this.variant = wildVariant;
        this.modifier = new Modifier(this);
        this.init();
    }

    public Position(Position position) {
        this.variant = position.variant;
        this.modifier = new Modifier(this);
        this.copyFrom(position);
    }

    public WildVariant getVariant() {
        return this.variant;
    }

    public Piece getPieceAt(Square square) {
        return this.getPieceAt(square.getFile(), square.getRank());
    }

    public Piece getPieceAt(int n, int n2) {
        return this.pieces[n][n2];
    }

    public Piece getPieceAt(String string) {
        return this.getPieceAt(Square.parseSquare(string));
    }

    public void setPieceAt(Piece piece, Square square) {
        this.setPieceAtImpl(piece, square);
        this.fireStateChanged();
    }

    public void setPieceAt(Piece piece, String string) {
        this.setPieceAt(piece, Square.parseSquare(string));
    }

    public Player getCurrentPlayer() {
        return this.currentPlayer;
    }

    public void setCurrentPlayer(Player player) {
        this.setCurrentPlayerImpl(player);
        this.fireStateChanged();
    }

    public void setLexigraphic(String string) throws PositionFormatException {
        if (string.length() < 64) {
            throw new PositionFormatException("Less than 64 letters in the string: " + string);
        }
        int n = 0;
        try {
            for (int i = 7; i >= 0; --i) {
                for (int j = 0; j < 8; ++j) {
                    this.setPieceAtImpl(this.variant.parsePiece("" + string.charAt(n++)), Square.getInstance(j, i));
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new PositionFormatException(illegalArgumentException);
        }
        this.setCurrentPlayerImpl(Player.WHITE_PLAYER);
        this.fireStateChanged();
    }

    public String getLexigraphic() {
        StringBuffer stringBuffer = new StringBuffer(64);
        for (int i = 7; i >= 0; --i) {
            for (int j = 0; j < 8; ++j) {
                Piece piece = this.getPieceAt(Square.getInstance(j, i));
                if (piece == null) {
                    stringBuffer.append("-");
                    continue;
                }
                stringBuffer.append(piece.toShortColorString());
            }
        }
        return stringBuffer.toString();
    }

    public void setFEN(String string) throws PositionFormatException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (stringTokenizer.countTokens() != 6) {
            throw new PositionFormatException("Wrong amount of fields");
        }
        String string2 = stringTokenizer.nextToken();
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "/");
        if (stringTokenizer2.countTokens() != 8) {
            throw new PositionFormatException("Wrong amount of ranks");
        }
        for (int i = 7; i >= 0; --i) {
            String string3 = stringTokenizer2.nextToken();
            int n = 0;
            for (int j = 0; j < string3.length(); ++j) {
                if (n > 7) {
                    throw new PositionFormatException("Rank " + i + " extends beyond the board");
                }
                char c = string3.charAt(j);
                if (Character.isDigit(c)) {
                    int n2 = Character.digit(c, 10);
                    while (n2-- > 0) {
                        this.setPieceAtImpl(null, Square.getInstance(n, i));
                        ++n;
                    }
                    continue;
                }
                try {
                    this.setPieceAtImpl(this.variant.parsePiece(String.valueOf(c)), Square.getInstance(n, i));
                    ++n;
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new PositionFormatException(illegalArgumentException);
                }
            }
            if (n == 8) continue;
            throw new PositionFormatException("Rank " + i + " is a few files short");
        }
        String string4 = stringTokenizer.nextToken();
        if (string4.length() != 1) {
            throw new PositionFormatException("Wrong amount of characters in active color indicator: " + string4);
        }
        if (string4.equals("w")) {
            this.setCurrentPlayerImpl(Player.WHITE_PLAYER);
        } else if (string4.equals("b")) {
            this.setCurrentPlayerImpl(Player.BLACK_PLAYER);
        } else {
            throw new PositionFormatException("Wrong active color indicator: " + string4);
        }
        this.positionFEN = string;
    }

    public String getFEN() {
        return this.positionFEN;
    }

    public final void init() {
        this.variant.init(this);
    }

    public void clear() {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                this.setPieceAtImpl(null, Square.getInstance(i, j));
            }
        }
        this.setCurrentPlayerImpl(Player.WHITE_PLAYER);
        this.fireStateChanged();
    }

    public void makeMove(Move move) {
        this.variant.makeMove(move, this, this.modifier);
        this.fireMoveMade(move);
        this.fireStateChanged();
    }

    public void copyFrom(Position position) {
        if (!this.variant.equals(position.variant)) {
            throw new IllegalArgumentException("The WildVariants of the positions don't match");
        }
        for (int i = 0; i < this.pieces.length; ++i) {
            for (int j = 0; j < this.pieces[i].length; ++j) {
                this.pieces[i][j] = position.pieces[i][j];
            }
        }
        this.setCurrentPlayerImpl(position.getCurrentPlayer());
        this.positionFEN = position.positionFEN;
        this.fireStateChanged();
    }

    private void setPieceAtImpl(Piece piece, Square square) {
        this.pieces[square.getFile()][square.getRank()] = piece;
        this.positionFEN = null;
    }

    private void setCurrentPlayerImpl(Player player) {
        this.currentPlayer = player;
        this.positionFEN = null;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$ChangeListener == null ? Position.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public void addMoveListener(MoveListener moveListener) {
        this.listenerList.add(MoveListener.class, moveListener);
    }

    public void removeMoveListener(MoveListener moveListener) {
        this.listenerList.remove(MoveListener.class, moveListener);
    }

    protected void fireMoveMade(Move move) {
        MoveEvent moveEvent = new MoveEvent(this, move);
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$free$chess$event$MoveListener == null ? Position.class$("free.chess.event.MoveListener") : class$free$chess$event$MoveListener)) continue;
            ((MoveListener)objectArray[i + 1]).moveMade(moveEvent);
        }
    }

    public String toString() {
        if (this.getCurrentPlayer().isWhite()) {
            return "White to move in " + this.getLexigraphic();
        }
        return "Black to move in " + this.getLexigraphic();
    }

    public boolean equals(Position position) {
        if (!this.variant.equals(position.variant)) {
            return false;
        }
        if (!this.currentPlayer.equals(position.currentPlayer)) {
            return false;
        }
        for (int i = 0; i < this.pieces.length; ++i) {
            for (int j = 0; j < this.pieces[i].length; ++j) {
                if (Utilities.areEqual((Object)this.pieces[i][j], (Object)position.pieces[i][j])) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Position)) {
            return false;
        }
        return this.equals((Position)object);
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.variant.hashCode();
        n = 37 * n + this.currentPlayer.hashCode();
        for (int i = 0; i < this.pieces.length; ++i) {
            for (int j = 0; j < this.pieces[i].length; ++j) {
                Piece piece = this.pieces[i][j];
                int n2 = piece == null ? 0 : piece.hashCode();
                n = 37 * n + n2;
            }
        }
        return n;
    }

    public static final class Modifier {
        private final Position position;

        private Modifier(Position position) {
            this.position = position;
        }

        public void setPieceAt(Piece piece, Square square) {
            this.position.setPieceAtImpl(piece, square);
        }

        public void setCurrentPlayer(Player player) {
            this.position.setCurrentPlayerImpl(player);
        }
    }
}

