/*
 * Decompiled with CFR 0.152.
 */
package free.util;

import free.util.Utilities;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;

public class Localization {
    public static volatile Locale appLocale = Locale.getDefault();
    private final Properties props;
    private final String className;

    private Localization(Properties properties, String string) {
        this.props = properties;
        this.className = string;
    }

    public static void setAppLocale(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("locale may not be null");
        }
        appLocale = locale;
    }

    public static Localization load(Class clazz) {
        return Localization.load(clazz, appLocale);
    }

    public static Localization load(Class clazz, Locale locale) {
        Properties properties = Localization.loadTranslationProperties(clazz, locale);
        return properties == null ? null : new Localization(properties, Utilities.getClassName(clazz));
    }

    private static Properties loadTranslationProperties(Class clazz, Locale locale) {
        String string = "localization";
        String string2 = locale.getLanguage();
        String string3 = locale.getCountry();
        String string4 = locale.getVariant();
        Properties properties = null;
        properties = Localization.loadProps(clazz, properties, string + ".properties");
        if (string2 != null && !"".equals(string2)) {
            properties = Localization.loadProps(clazz, properties, string + "_" + string2 + ".properties");
        }
        if (string3 != null && !"".equals(string3)) {
            properties = Localization.loadProps(clazz, properties, string + "_" + string2 + "_" + string3 + ".properties");
        }
        if (string4 != null && !"".equals(string4)) {
            properties = Localization.loadProps(clazz, properties, string + "_" + string2 + "_" + string3 + "_" + string4 + ".properties");
        }
        return properties;
    }

    private static Properties loadProps(Class clazz, Properties properties, String string) {
        InputStream inputStream = clazz.getResourceAsStream(string);
        if (inputStream != null) {
            properties = new Properties(properties);
            try {
                properties.load(inputStream);
            }
            catch (IOException iOException) {
                throw new MissingResourceException("IOException while loading " + string, clazz.getName(), "");
            }
        }
        return properties;
    }

    public String getString(String string) {
        return this.props.getProperty(this.className + "." + string);
    }

    public Localization getForClass(Class clazz) {
        return new Localization(this.props, Utilities.getClassName(clazz));
    }
}

