/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid;

import com.birosoft.liquid.LiquidLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;

public class LiquidListUI
extends BasicListUI {
    private Color defaultBackground;

    protected void paintCell(Graphics g, int row, Rectangle rowBounds, ListCellRenderer cellRenderer, ListModel dataModel, ListSelectionModel selModel, int leadIndex) {
        Object value = dataModel.getElementAt(row);
        boolean cellHasFocus = this.list.hasFocus() && row == leadIndex;
        boolean isSelected = selModel.isSelectedIndex(row);
        Component rendererComponent = cellRenderer.getListCellRendererComponent(this.list, value, row, isSelected, cellHasFocus);
        if (LiquidLookAndFeel.defaultRowBackgroundMode) {
            if (row % 2 == 0) {
                if (this.defaultBackground.equals(rendererComponent.getBackground())) {
                    rendererComponent.setBackground(LiquidLookAndFeel.getDesktopColor());
                }
            } else if (LiquidLookAndFeel.getDesktopColor().equals(rendererComponent.getBackground())) {
                rendererComponent.setBackground(this.defaultBackground);
            }
        }
        int cx = rowBounds.x;
        int cy = rowBounds.y;
        int cw = rowBounds.width;
        int ch = rowBounds.height;
        this.rendererPane.paintComponent(g, rendererComponent, this.list, cx, cy, cw, ch, true);
    }

    public void paint(Graphics g, JComponent c) {
        if (LiquidLookAndFeel.defaultRowBackgroundMode & this.defaultBackground == null) {
            this.defaultBackground = c.getBackground();
        }
        super.paint(g, c);
    }

    public static ComponentUI createUI(JComponent list) {
        return new LiquidListUI();
    }
}

