#!/usr/bin/python
from distutils.core import setup
from glob import glob
import os
import sys

if sys.hexversion < 0x020400f0:
    sys.stderr.write("python version failed: current version = %s.%s, needed version >= 2.4\n" % (sys.version_info[0],sys.version_info[1]))
    sys.exit(1)
try:
    import libxml2
except ImportError:
    sys.stderr.write("dependencies failed: python libxml2\n") 
    sys.exit(1)
try:
    import libxslt
except ImportError:
    sys.stderr.write("dependencies failed: python libxslt1\n") 
    sys.exit(1)
try:
    import gtk.glade
except ImportError:
    sys.stderr.write("dependencies failed: python glade\n") 
    sys.exit(1)

# make sure that the mo files are generated and up-to-date
os.system("cd po; make update-po")

I18NFILES = []
for filepath in glob("po/mo/*/LC_MESSAGES/*.mo"):
    lang = filepath[len("po/mo/"):]
    targetpath = os.path.dirname(os.path.join("share/locale",lang))
    I18NFILES.append((targetpath, [filepath]))

LONG_DESC="""A friendly frontend for game emulators.
Features:
 * Game emulation with xmame, sdlmame, snes9 and zsnes is supported.
 * Game browsing using dynamic list. This allows tracking in a parcial list 
   generated with several categories.
 * Fast game finding. Specific filtering tool speeds up your search.
 * Localization support.
"""

setup(name='loemu',
      version='0.3.1',
      description='A user friendly frontend for game emulators',
      author='Bernat Pegueroles Forcadell',
      author_email='bernat@pegueroles.cat',
      url='http://loemu.pegueroles.com',
      long_description=LONG_DESC,
      license='GNU GPL',
      platforms=['posix'],
      packages=['loemu'],
      scripts=glob("scripts/*"),
      data_files=[
                  ('share/loemu/config',glob("config/*")),
                  ('share/loemu/glade',glob("glade/*")),
                  ('share/loemu/images',glob("images/*")),
                  ('share/loemu/roms',''),
                  ('share/loemu/flyers',''),
                  ('share/loemu/snaps',''),
                  ] + I18NFILES 
      )
