#pragma once
#include "stdafx.h"
#include "MMC3_215.h"

class Unl158B : public MMC3_215
{
private:
	const uint8_t _protectionLut[8][8] = {
		{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00 },
		{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x04, 0x00, 0x00 },
		{ 0x00, 0x00, 0x00, 0x01, 0x00, 0x04, 0x05, 0x00 },
		{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		{ 0x00, 0x00, 0x00, 0x01, 0x02, 0x04, 0x0F, 0x00 }
	};

	uint8_t _reg;

protected:
	bool AllowRegisterRead() override { return true; }

	void InitMapper() override
	{
		_reg = 7;
		MMC3_215::InitMapper();
		AddRegisterRange(0x5000, 0x5FFF, MemoryOperation::Any);
		RemoveRegisterRange(0x8000, 0xFFFF, MemoryOperation::Read);
	}

	void StreamState(bool saving) override
	{
		MMC3_215::StreamState(saving);
		Stream(_reg);
	}

	uint8_t ReadRegister(uint16_t addr) override
	{
		return (_console->GetMemoryManager()->GetOpenBus() & 0xF0) | _protectionLut[_reg][addr & 0x07];
	}

	void WriteRegister(uint16_t addr, uint8_t value) override
	{
		if((addr <= 0x5FFF) && ((addr & 0xF007) == 0x5002)) {
			_reg = value & 0x07;
		}
		MMC3_215::WriteRegister(addr, value);
	}
};