------------------------------------------------------------------------
--  Name Generator
------------------------------------------------------------------------
--
--  Oblige Level Maker
--
--  Copyright (C) 2008-2017 Andrew Apted
--  Copyright (C) 2008-2009 Jon Vail
--  Copyright (C)      2009 Enhas
--  Copyright (C) 2010-2011 Chris Pisarczyk
--
--  This program is free software; you can redistribute it and/or
--  modify it under the terms of the GNU General Public License
--  as published by the Free Software Foundation; either version 2
--  of the License, or (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--
------------------------------------------------------------------------
--
--  Thanks to Jon Vail (a.k.a JohnnyRancid/40oz) who contributed
--  many of the complete level names and lots of cool words.
--
--  Thanks to Enhas and Chris for their additions.
--
------------------------------------------------------------------------

namelib = {}


namelib.NAMES =
{
  COMMON =
  {
    -- these words and patterns are shared by all themes

    -- FIXME...

    lexicon =
    {
      v =
      {
        ["Curse of the"]=10

        -- these from flyingdeath
        ["Enter the"]=10
        ["Welcome to the"]=10
        ["Escape the"]=10
        ["Flight from the"]=5 
        ["Journey to the"]=10
        ["Assault on the"]=15
        ["Death Awaits in the"]=5
        ["Oh God not another"]=5
        ["Yet Another"]=5
        ["Just Another"]=5
        ["Hell in the"]=5

        -- these by Chris
        ["Fear the"]=10
        ["Beware the"]=10
        ["Bane of the"]=10
        ["Scourge of the"]=10
        ["Ordeal of the"]=10
        ["Calamity in the"]=10
        ["Misdeed by the"]=10
        ["Dread the"]=10
        ["Shun the"]=10
        ["Plague of the"]=10
        ["Pain from the"]=10

        -- command-like prefixes, some by Dante
--[[
        ["Attack the"]=20
        ["Destroy the"]=20
        ["Shut Down the"]=15
        ["Patrol the"]=15
        ["Secure the"]=15
        ["Clear this"]=5
        ["Defend this"]=10
--]]
      }
    }

    divisors =
    {
      a = 10   --\
      b = 10   -- adjectives
      h = 10   --/

      n = 50   -- noun: Base, Station, City (etc)
      m = 3    -- monster name: Demon, Imp, Mummy (etc)
      e = 3    -- evil being: Satan (etc)

      t = 1    -- article: The XX
      v = 20   -- phrase before a noun: Curse of the XX
      r = 40

      s = 1000  -- single complete names
    }
  }
  -- end of 'COMMON' theme


  --------------------------------------------------

  TECH =
  {
    patterns =
    {
      ["%a %n"]    = 65
      ["%b %n"]    = 65
      ["%a %b %n"] = 33

      ["%t %a %n"]    = 17
      ["%t %b %n"]    = 17
      ["%t %a %b %n"] = 5

      ["%v %n"]    = 24
      ["%v %a %n"] = 24
      ["%v %b %n"] = 24

--[[
      ["%r the %n"] = 12
      ["%r the %a %n"] = 12
      ["%r the %b %n"] = 12
--]]

      ["%s"] = 16
    }

    lexicon =
    {
      t =
      {
        The=50
      }

      r =
      {
        Find = 10
        Activate = 10
        Reactivate = 20
        Deactivate = 20
        ["Turn on"] = 5
        ["Turn off"] = 5
      }

      a =
      {
        -- size
        Universal=20, Colossal=20, Prodigious=3,
        Secluded=10, Confined=5, Restricted=3,
        Vast=10, Cramped=5,

        -- location
        Subterrestrial=10, Sub_terra=5,
        Aethereal=10, Hypogean=5,
        Mars=10, Saturn=10, Jupiter=10,
        Europa=5, Ganymede=5, Dione=5, Io=5,
        Callisto=5, Hyperion=5, Vesta=5, Titan=3,

        Covert=20, Occult=10, Preliminary=3, Experimental=3,
        Northern=3, Southern=3, Eastern=3, Western=3,
        Upper=10, Lower=10, Central=15, Secondary=7,
        Inner=10, Outer=10, Innermost=3, Outermost=3,
        Auxiliary=10, Primary=20, Prime=5, Tertiary=7,
        Exterior=10, Subsidiary=3, Ultimate=3,

        -- condition
        Inactive=10, Unsound=10, Eternal=5,
        Advanced=10, Interlock=5, Symbiotic=3,
        Fantastic=3, Incredible=3, Amazing=3,
        Wondrous=3, Inert=4, Dormant=10,

        Destructive=20, Unstable=10, Devastated=3,
        Lost=20, Defective=10, Haggard=15, Failed=10,
        Ravished=10, Inanimate=3, Ruptured=3,
        Polluted=10, Putrid=5, Faulty=5, Troublesome=10,
        Obsolete=15, Abandoned=15,

        -- infestation
        Monstrous=10, Fatal=10, Invaded=3, Overtaken=3,
        Abberant=10, Internecine=10, Noxious=10, Subnormal=10,
        Infested=20, Anomalous=5, Ghostly=10, Lurid=3,
        Subverted=15, Corrupted=7, Contaminated=5, Degraded=7,
        Congested=10, Swarming=10, Pestilential=5, Nefarious=10,

        -- descriptive
        Extreme=20, Depraved=10, Unnatural=10, Messianic=3,
        Dark=20, Treacherous=10, Frigid=3,
        Deconditioned=10, Dismal=5, Dreaded=5, Cold=10,
        Perverted=5, Doomed=10,
      }

      b =
      {
        -- purpose
        Control=10, Research=10,
        Military=10, Security=5, Defense=5,
        Processing=10, Refueling=5, Supply=15,
        Manufacturing=3, Maintenance=3,
        Industrial=3, Engineering=5,
        Construction=5, Assembly=5, Management=5,
        Development=5, Foundation=5,
        Aegis=3, Stockade=3, Refuge=5,

        Munitions=5, Armament=5, Drainage=5,
        Support=5, Counteraction=3, Holding=5,
        Testing=5, Quarantine=5, Authorization=5,
        Synthesis=5, Unification=3, Loading=5,
        Disposal=5, Dumping=3, Pumping=4, 
        Transfer=3, Mobilization=3, Irrigation=3,
        Communications=5, Operations=5,
        Training=5, Treatment=5, Shipment=5,
        Cooling=5, Coolant=5, Administration=5,
        Distribution=5, Trafficking=5, Singularity=3,
        Programming=5, Security=5, Staging=5, Comms=5,

        -- descriptive
        Main=20, Entrance=10, Provisional=3,
        Planetary=3, Interstellar=7, Lunar=10,
        Atlas=3, Promethus=2, Cronus=3, 
        Hyperion=2, Icarus=2, Echo=2,
        Morpheus=2, Eos=2, Orion=2,
        Tiephron=2, Psion=3,

        Alpha=10, Beta=5, Gamma=10,
        Delta=10, Omega=5, Sigma=5,
        Epsilon=3, Zeta=5, Lambda=3,
        Theta=5, Omicron=3, Tau=3,

        -- materials / substances
        Power=20, Energy=15, Cargo=10,
        Fuel=5, Rocket=3, Missile=5,
        Blast=15, Oil=3, Nuclear=15,
        Nukage=10, Plutonium=10, Toxin=10,
        Chemical=15, Slige=10, Waste=10, Stibine=3,
        Mining=15, Fusion=15, Thermal=10,
        Infrared=10, Radiation=5, Hydro=3,

        Parallax=5, Ultraviolet=5, Slime=7,
        Steel=5, Fluid=3, Iron=3, Combustion=5,
        Steam=5, Carbon=5, Pressure=5, Pyrolosis=3,
        Radioactivity=5, Sludge=3, Particle=3,
        Cadmium=3, Halogen=3, Toxicity=3, Mercury=3,
        Data=10, CPU=5, Freight=5, Wares=3, Phosphine=3,
        Petrochemical=3, Tesla=5, Bromine=3, Quantum=5,

        Computer=10, Composite=15, Synthetic=5,
        Electronics=5, Electrical=5, Diffusion=3,
        Worm_hole=5, Black_hole=5, Teleport=3,
        Hybrid=5, Cryogenic=5, Cryo_=2,
        Robotic=1, Laser=1, Photonic=1, Bio_=2,

        ["I/O"]=5,
      }

      n =
      {
        -- specific places
        Generator=12, Plant=15, Base=30,
        Warehouse=10, Depot=10, Storage=5,
        Lab=15, Laboratory=5, Depositry=3,
        Station=20, Reactor=10, Tower=5,
        Refinery=15, Factory=10, Storehouse=5,
        Gateway=10, Hangar=5, Outpost=10,
        Tunnels=10, Bunker=7, Facility=10, Workshop=7,
        Gateway=5, Point=2, Turbine=3,

        Beacon=3, Satellite=10, Pillbox=1,
        Colony=15, Compound=15, Foundry=3,
        Headquarters=2, Observatory=3,
        Shaft=3, Silos=7, Substation=10,

        -- general places
        Complex=20, Center=20,
        Facility=10, Works=2,
        Area=15, Site=10, Zone=10,
        Quadrant=5, Sector=5, Adjunct=3, 
        Platform=5, Port=3, Grid=5,
        Hub=10, Nexus=3, Core=5, 
        Terminal=10, Installation=5,
        Project=5, Experiment=3,
        Infrastructure=5, Annex=5,
        Dock=3, Bay=3, Tributary=5,
        Channel=5, Chamber=5, Quarters=5,
        Relay=5, Section=3, Post=3, Dilemma=3,
        Situation=2, Crisis=2, Emergency=2,

        -- weird ones
        Device=5, Machine=5, Network=5,
        Anomaly=10, Portal=7, Apparatus=10,
        System=15, Project=2, Forge=10,
        Dimension=3, Paradox=3, Vortex=5,
        Enigma=5, Artifact=1, Quagmire=1,
      }

      s =
      {
        -- single complete level names

        ["A Losing Battle"]=10
        ["A Stray Marine"]=10
        ["Advance Guard Delta"]=10
        ["Alien Carnage"]=10
        ["Alpha Labs"]=10
        ["Assault"]=10
        ["Backbone Breakage"]=10
        ["Baryogenesis"]=10
        ["Battlezone"]=10
        ["Beleaguered Unit"]=10
        ["Blackbody Radiation"]=10
        ["Blackdamp"]=10
        ["Black Sky"]=10
        ["Blast Chamber"]=10
        ["Blood Red Aurora"]=10
        ["Bombardment"]=10
        ["Bombing Sessions"]=10
        ["Breakdown"]=10
        ["Burnout"]=10
        ["Butt End of Space"]=10
        ["Call to Arms"]=10
        ["Capture and Kill"]=10
        ["Carnage Command"]=10
        ["Catch The Bullet"]=10
        ["Cathode Ray Sunshine"]=10
        ["Clawhammer"]=10
        ["Close Quarters"]=10
        ["Close Call"]=10
        ["Code Blue"]=10
        ["Code Yellow"]=10
        ["Code Orange"]=10
        ["Collapsys"]=10
        ["Cold Science"]=10
        ["Cold Reception"]=10
        ["Congestion Collapse"]=10
        ["Dachronix"]=10
        ["Dead Sun Aeon"]=10
        ["Debris of Aircraft"]=10
        ["Deconstruction Site"]=10
        ["Deep Into The Code"]=10
        ["Defcon Six"]=10
        ["Defragmentation factor"]=10
        ["Deja Vu"]=10
        ["Delta Labs"]=10
        ["Denial Measures"]=10
        ["Dissolution Factor Red"]=10
        ["Domino Effect"]=10
        ["Don't Give Up Yet"]=10
        ["Downfall"]=10
        ["Eclipse"]=10
        ["Ectopia"]=10
        ["Electrical Overload"]=10
        ["Emergency Situation"]=10
        ["Evacuation Step One"]=10
        ["Excessive Force"]=10
        ["Eye for an Eye"]=10
        ["Fallback of Humanity"]=10
        ["Fear of the Dark"]=10
        ["Final Resistance"]=10
        ["Fire Vat"]=10
        ["Genocidal Genesis"]=10
        ["Graveyard Orbit"]=10
        ["Heavy Armed Assault"]=10
        ["Hellclone"]=10
        ["Hellspawn Spectrum"]=10
        ["Helix"]=10
        ["Horrific Signal"]=10
        ["Hypernova"]=10
        ["Ignition!"]=10
        ["In Extremis"]=10
        ["Insanity's Crescendo"]=10
        ["Interstellar Overdrive"]=10
        ["Judgement Day"]=10
        ["Know No Boundries"]=10
        ["Launchpad"]=10
        ["Lockdown"]=10
        ["Losing Ground"]=10
        ["Mayday"]=10
        ["Motornerve"]=10
        ["Negative Reinforcement"]=10
        ["Natas Legenda"]=10
        ["Neon Rapture"]=10
        ["Nether Novas"]=10
        ["Network Collapse"]=10
        ["Neural Butchery"]=10
        ["Nuclear Imperator"]=10
        ["One Shot, One Kill"]=10
        ["Oscillator"]=10
        ["Outnumbered"]=10
        ["Out of Control"]=10
        ["Panic Attack"]=10
        ["Paying Ohmage"]=10
        ["Point Blank"]=10
        ["Power Surge"]=10
        ["Power Pulse"]=10
        ["Pressure Point"]=10
        ["Price of Warfare"]=10
        ["Propulsion"]=10
        ["Revolution"]=10
        ["Shock-Drop"]=10
        ["Shotguns and Rockets"]=10
        ["Sickbay"]=10
        ["Skylab"]=10
        ["Solar Plexus"]=10
        ["Space Debris"]=10
        ["Steel Forgery"]=10
        ["Strike Zone"]=10
        ["Supernova"]=10
        ["Systemic Purge"]=10
        ["Tactical Retreat"]=10
        ["Terminal Velocity"]=10
        ["Terminus"]=10
        ["The Disruption"]=10
        ["The Supercharger"]=10
        ["This Is Not a Drill"]=10
        ["Too Close For Comfort"]=10
        ["Turboshaft"]=10
        ["Unwanted Attention"]=10
        ["Waste Management"]=10
        ["Wires and Bloodcells"]=10

        ["Atomic Fortress"]=10
        ["Artificial Apathy"]=10
        ["Blast Radius"]=10
        ["Celestial Crimes"]=10
        ["Excessive Exposure"]=10
        ["False Discharge"]=10
        ["Galaxy on Fire"]=10
        ["Gravity Well"]=10
        ["Higher Voltage"]=10
        ["Hello Dynamo"]=10
        ["Hunger for Weapons"]=10
        ["In a Future World"]=10
        ["Input-Output"]=10
        ["Interstellar Starport"]=10
        ["Nebula Checkpoint"]=10
        ["No Escape!"]=10
        ["No Solutions"]=10
        ["No Time To Waste"]=10
        ["No Way Through"]=10
        ["Nothing Works"]=10
        ["Quantum Distortion"]=10
        ["System Overload"]=10
        ["Tech Center"]=10
        ["The Delusion Machine"]=10
        ["The Emerald Parallax"]=10
        ["The Mental Abyss"]=10
        ["The Muon Collective"]=10
        ["Transportation H.Q."]=10
        ["Warp Factor 666"]=10
      }
    }

  }
  -- end of 'TECH' theme


  --------------------------------------------------

  GOTHIC =
  {
    patterns =
    {
         ["%a %n"] = 60
      ["%t %a %n"] = 20

         ["%n of %h"] = 26
      ["%a %n of %h"] = 14

      ["%e's %n"]       = 10
      ["%e's %a %n"]    = 8
      ["%e's %n of %h"] = 6

      ["%v %n"]    = 25
      ["%v %a %n"] = 25

      ["%s"] = 14
    }

    lexicon =
    {
      t =
      {
        The=50
      }

      e =
      {
        Satan=10, ["The Devil"]=7, Lucifer=7, Helgor=3, 
        Ceren=2, Mephisto=3, Vuradi=2, Oltion=2, Ktulu=2,
        Dozod=2, Draco=2, Kalrac=2, Minotaur=5, Pandora=1,
        Minos=2, Orgel=2, Nurgle=2, Odin=2, Balrok=2, Mammon=3,
        Orcus=3, Lolth=3, Quenna=3, Saleos=3, Rusalka=3, Haborym=3,
        Erishkigal=3, Jubilex=3, Utukku=3, Vucub=3, Zagan=3,
        Deccal=3, Ipos=3, Xezbeth=3, Yeenoghlu=3, Caasimolar=3,
        Baal=3, Malthus=3, Beelzebub=3, Moloch=3, Dante=5,
        Nybbas=2, Namtar=2, Lamashtu=2,
        Linguica=1, Bloodshedder=1,
      }

      a =
      {
        -- size
        Monumental=5, Colossal=10, Sprawling=5, Massive=5,
        Small=3, Endless=10, Gigantic=5, Mighty=5, Enormous=5,
        Giant=3, Great=3, Elephantine=3,

        -- location
        Underground=10, Subterranean=5,
        Cloaked=3, Hermetic=3,
        Occult=10, Surreptious=15,
        Inner=15, Abysmal=10, Deepest=15,
        Concealed=7, Clandestine=5, Outer=5,

        -- condition
        Elder=15, Ancient=15, Eternal=5,
        Decrepid=3, Desolate=10, Foul=10,
        Defiled=10, Ruined=5, Forgotten=10,
        Ravished=5, Barren=5, Deadly=3,
        Begrimed=5, Filthy=5, Sloven=5,
        Stagnant=7, Rancid=10, Rotten=15,
        Burning=20, Burnt=5, Scorching=5,
        Melting=5, Red_Hot=5, Fractured=5,
        Vile=15, Revolting=10, Putrid=5,
        Vulgar=5, Wretched=3, Caustic=5,
        Fallen=10, Stinking=1, Grungy=3,
        Smoky=5, Flagrant=20,

        -- contents
        Blood=20, Bloody=5, Blood_filled=3,
        Blood_stained=2, Blood_soaked=3,
        Lava=5, Lava_filled=3, Bleeding=3, Acrid=5,
        Monstrous=15, Monster=5, Zombie=10,
        Demonic=15, Demon=5, Ghoulish=5,
        Wizard=5, Warlock=2, Wiccan=3,
        Haunted=10, Ghostly=15, Ghastly=5,
        Heathen=3, Rat_infested=5, Necromancers=5,
        Baron=5, Cyberdemon=5, Slime=5, Knights=7,
        Kings=5, Royal=5, Magma=5,

        -- descriptive
        Evil=30, Unholy=20, Wicked=15, Cruel=10,
        Godless=5, God_forsaken=7, Ungodly=3, Vexatious=5,
        Perverse=5, Hallowed=5, Oppressive=5, Painful=5,
        Uncivilised=2, Unsanctified=2, Profane=5, Despoiled=3,
        Brutal=20, Grisly=15, Gothic=7, Ungodly=10,
        Mystic=7, Mystical=2, Magical=2, Magic=2, Tortuous=10,
        Poignant=3, Sinful=5, Unblessed=3, Bitter=7,

        Ominous=20, Terrifying=5, Gruesome=10,
        Gloomy=5, Awful=10, Execrable=10, Uncanny=15,
        Horrible=10, Horrendous=10,
        Dismal=10, Dank=5, Frightful=5,
        Dreaded=15, Nightmare=5, Dolor=5,
        Screaming=3, Silent=5, Sullen=10,

        Abhorrent=3, Abominable=5, Bestial=5,
        Detested=5, Direful=2, Disastrous=2,
        Execrated=2, Ill_fated=10, Maximum=5,
        Fatal=10, Final=5, Frail=3, Terminal=2,
        Immoral=5, Immortal=3, Impure=5, Utmost=5,
        Loathsome=5, Merciless=7, Sovereign=7,
        Morbid=10, Pestilent=5, Profane=5, Triumph=2,
        Raw=2, Vicious=10, Violent=10, Sheer=10,
        Ceremonial=5, Liturgical=5, Solemn=5, Deistic=5,
        Divine=5, Devout=5, Sacerdotal=5, Desecrated=5,
        Sacred=5, Clerical=5, Accursed=5, Malodorous=5,
        Despicable=2, Heinous=5, Mephitic=2, Peccant=5,
        Sordid=2, Sacreligious=5, Grievous=2, Fetid=2, 
        Ferine=2, Unspiritual=2, Cruel=5, Crass=2,
      }

      n =
      {
        -- places
        Crypt=20, Grotto=15, Tomb=15,
        Chapel=10, Church=7, Mosque=5,
        Graveyard=10, Cloister=5,
        Pit=10, Cavern=10, Cave=5,
        Wasteland=15, Sepulcher=7, Town=5,
        Ghetto=2, City=5, Well=5, Realm=10,
        Lair=15, Den=7, Domain=10, Hive=5, Abode=15,
        Valley=10, River=5, Catacombs=10,
        Palace=5, Cathedral=5, Chamber=10, Citadel=5,
        Hall=7, Rooms=3, Hecatomb=3, Tabernacle=3,

        Labyrinth=5, Dungeon=10, Shores=5, Cenotaph=5,
        Temple=20, Shrine=10, Vault=10, Sanctum=10,
        Spire=10, Arena=3, Swaths=2, Monastery=10,
        Gate=3, Circle=10, Altar=7, Chapel=10, Village=3,
        Tower=3, Mountains=2, Prison=3, Narthex=5,
        Sanctuary=3, Basillica=3, Morgue=5, Ring=5,

        -- weird ones
        Communion=5, Monolith=5, Crucible=5,
        Excruciation=1, Abnormality=1,
        Hallucination=1, Teracculus=2,
        Ceremony=3, Threshold=1,
        Ache=2, Apocalypse=1, Resurrection=5,
        Absolution=5, Crux=5, Culmination=5,
        Sacrament=5, Plight=5, Liturgy=5,
      }

      h =
      {
        Hell=10, Fire=10, Flames=10,
        Horror=10, Terror=10, Death=15,
        Pain=15, Fear=5, Hate=10, Misery=10,
        Limbo=3, Souls=10, Doom=15, Tragedy=10,
        Carnage=10, Gore=5, Shadows=10, Rapine=10,
        Darkness=10, Destruction=5, Famine=10,
        Suffering=5, Torment=10, Torture=10, Heresy=10,
        Iconoclasm=10, Fallacy=10, Defection=10, 
        Blasphemy=10, Infidelity=10, Paganism=10,
        Schism=10, Secularism=10, Sin=10, Mayhem=10,
        Sorrow=10, Trauma=10, Agony=10, Anguish=10,
        Strain=5, Supplication=5, Witchcraft=5,

        Flesh=10, Corpses=10, Bones=10, Chaos=15,
        Skulls=10, Whispers=5, Tears=3, Viscera=5,
        Dread=5, Fate=5, Locusts=2, Erebus=5, Lethe=2,
        Treachery=5, Lunacy=5, Woe=5,
        Reckoning=5, Minos=3, Hades=7, Acheron=5,
        Leviathan=5, Baphomet=5, Devils=10,

        ["the Acolyte"]=10
        ["the Ancient"]=10
        ["the Apostates"]=10
        ["the Beast"]=10
        ["the Behemoth"]=10
        ["the Baneful"]=10
        ["the Betrayers"]=10
        ["the Bleeding"]=10
        ["the Corrupt"]=10
        ["the Damned"]=10
        ["the Decayed"]=10
        ["the Dead"]=10
        ["the Defiled"]=10
        ["the Denizens"]=10
        ["the Destroyer"]=10
        ["the Dishonored"]=10
        ["the Disobedient"]=10
        ["the Dissolute"]=10
        ["the Emissary"]=10
        ["the Forgotten"]=10
        ["the Foul"]=10
        ["the Forsaken"]=10
        ["the Knavish"]=10
        ["the Minions"]=10
        ["the Missionary"]=10
        ["the Necromancer"]=10
        ["the Nefarious"]=10
        ["the Neophyte"]=10
        ["the Oracle"]=10
        ["the Possessed"]=10
        ["the Priest"]=10
        ["the Prophets"]=10
        ["the Putrid"]=10
        ["the Rotten"]=10
        ["the Saints"]=10
        ["the Seer"]=10
        ["the Sick"]=10
        ["the Sinner"]=10
        ["the Tainted"]=10
        ["the Undead"]=10
        ["the Unheard"]=10
        ["the Unknown"]=10
        ["the Unmaker"]=10
        ["the Vicar"]=10
        ["the Witches"]=10
        ["the Zealots"]=10
      }

      s =
      {
        -- single complete level names

        ["Absent Savior"]=10
        ["Absolution Neglect"]=10
        ["Addicted to Sin"]=10
        ["All is Lost"]=10
        ["Alone Walking"]=10
        ["Ankle Deep in Blood"]=10
        ["Angelus Mortis"]=10
        ["Ashes to Ashes"]=10
        ["Architect of Troubled Sleep"]=10
        ["Atrocitic Hunt"]=10
        ["Atrophy of the Soul"]=10
        ["A Dream of Death"]=10
        ["A Putrid Serenity"]=10
        ["Aura of Filth"]=10
        ["A Vile Peace"]=10
        ["Awaiting Evil"]=10
        ["Bad Blood"]=10
        ["Baptised in Parasites"]=10
        ["Bathed in Viscera"]=10
        ["Bearer of Pain"]=10
        ["Beyond Death"]=10
        ["Beyond Fate"]=10
        ["Beyond the Apocalypse"]=10
        ["Black Moon"]=10
        ["Blazing Flames of War"]=10
        ["Bled Dry"]=10
        ["Blinded by Fear"]=10
        ["Blood Clot"]=10
        ["Bloodless Unreality"]=10
        ["Bloodstains"]=10
        ["Blood for Blood"]=10
        ["Blood Throne"]=10
        ["Blood Vanity"]=10
        ["Bloody Mist"]=10
        ["Body and Soul"]=10
        ["Bonded by Blood"]=10
        ["Born/Dead"]=10
        ["Born in the Flames"]=10
        ["Birthplace of Fate"]=10
        ["Brotherhood of Ruin"]=10
        ["Buried Alive"]=10
        ["Burning Sea"]=10
        ["Cato's Escort"]=10
        ["Centromere"]=10
        ["Charred Flesh"]=10
        ["Cocoon of Filth"]=10
        ["Cold Comfort"]=10
        ["Collection of Corpses"]=10
        ["Compelled to Kill"]=10
        ["Cocytus"]=10
        ["Corpsehaven"]=10
        ["Cries of Pain"]=10
        ["Crimson Tears"]=10
        ["Crown of Snakes"]=10
        ["Crucifix of the Damned"] = 10
        ["Cynicism of Vitality"]=10
        ["Dare to Dream"]=10
        ["Dark Citadel"]=10
        ["Dark Crusade"]=10
        ["Dark Light"]=10
        ["Darkness Ensues"]=10
        ["Dead Inside"]=10
        ["Dead Traditions"]=10
        ["Dead Words Speak"]=10
        ["Deadly Intentions"]=10
        ["Death Cycle"]=10
        ["Death Grate"]=10
        ["Death Spawn"]=10
        ["Death's Gratification"]=10
        ["Deathstay"]=10
        ["Defective Decay"]=10
        ["Demon's Gate"]=10
        ["Depths of Hatred"]=10
        ["Desquamation"]=10
        ["Destroyer of Worlds"]=10
        ["Diamortal"]=10
        ["Disdain and Anguish"]=10
        ["Disease"]=10
        ["Dissidence Volta"]=10
        ["Dithyamb of Sadism"]=10
        ["Dogma Destroyed"]=10
        ["Dreaming in Red"]=10
        ["Drowning the Light"]=10
        ["Durance of Hate"]=10
        ["Echos of the Dead"]=10
        ["Elderworld"]=10
        ["Embraced by Lucifer"]=10
        ["Emissary of Pain"]=10
        ["Empty Life"]=10
        ["End of Everything"]=10
        ["End of the Line"]=10
        ["Essence of Black"]=10
        ["Etherworld"]=10
        ["Evil Oath"]=10
        ["Extinction of Mankind"]=10
        ["Exuviated Offscouring"]=10
        ["Ezra's Influence"]=10
        ["Falling Sky"]=10
        ["False Promises"]=10
        ["Feed of Decay"]=10
        ["Feign Sympathy"]=10
        ["Fenchurch"]=10
        ["Fields of Gluttony"]=10
        ["Final Revelation"]=10
        ["Food for the Demons"]=10
        ["Freeze Mentality"]=10
        ["From the Deeps"]=10
        ["Frost and Fire"]=10
        ["Funeral of the Gods"]=10
        ["Ghost Trail"]=10
        ["Gore Galore"]=10
        ["Gottesmord"]=10
        ["Guttural Breath"]=10
        ["Half Light"]=10
        ["Hell Arrives"]=10
        ["Helpless"]=10
        ["Herald of Demons"]=10
        ["Hope is Dead"]=10
        ["Human Compost"]=10
        ["Human Insecticide"]=10
        ["Human Landfill"]=10
        ["Human Trafficking"]=10
        ["Hunted"]=10
        ["Incinerated Cross"]=10
        ["Infected Grave"]=10
        ["Iniquity Inferior"]=10
        ["Insolent Terror"]=10
        ["Internal Darkness"]=10
        ["I Stand Defiant"]=10
        ["Lava Love"]=10
        ["Left Hand Path"]=10
        ["Legion"]=10
        ["Lifecode Sin"]=10
        ["Locust Hide"]=10
        ["Lord of Destruction"]=10
        ["Lost in Oblivion"]=10
        ["Lychgate"]=10
        ["Made in Hell"]=10
        ["Mandatory Suicide"]=10
        ["Manifest Destination"]=10
        ["Marbellum"]=10
        ["Meltdown"]=10
        ["Menzobarranzen"]=10
        ["Misery"]=10
        ["Myth of Progress"]=10
        ["Necessary Death"]=10
        ["Necromancide"]=10
        ["Necropolis"]=10
        ["Necrosis"]=10
        ["Nihilist Nexus"]=10
        ["Nomen Luni"]=10
        ["Nothing Lasts Forever"]=10
        ["Obsidian Fragments"]=10
        ["Octarena"]=10
        ["Opus Satani"]=10
        ["Origin of Nausea"]=10
        ["Pain Eternal"]=10
        ["Panzer Pentagram"]=10
        ["Paranoia"]=10
        ["Parasitic Skies"]=10
        ["Path of a Fallen Angel"]=10
        ["Pazuzu's Run"]=10
        ["Pentadrome"]=10
        ["Perdition's Massacre"]=10
        ["Perished in Pain"]=10
        ["Perversitas Sancta"]=10
        ["Portal of No Return"]=10
        ["Post Combustion"]=10
        ["Punishment Defined"]=10
        ["Purgation in Molten Metal"]=10
        ["Purgatorio"]=10
        ["Realm of Souls"]=10
        ["Red Dream"]=10
        ["Reduced to Dust"]=10
        ["Return to Hell"]=10
        ["Ripped Intestines"]=10
        ["Running Scared"]=10
        ["Sado-Masochistic"]=10
        ["Saint Scream"]=10
        ["Sacred Utopia"]=10
        ["Scourge of Humanity"]=10
        ["Sphacelus"]=10
        ["Satan's Disgust"]=10
        ["Satanic Propaganda"]=10
        ["Satanic Supremacy"]=10
        ["Sawn in Half"]=10
        ["Seven Deadly Sins"]=10
        ["Severe Burns"]=10
        ["Shambled Dimension"]=10
        ["Shannara"]=10
        ["Sheol"]=10
        ["Sign of Evil"]=10
        ["Sinners Bleed"]=10
        ["Sins of Allegiance"]=10
        ["Sins of the Fallen"]=10
        ["Shadow Keep"]=10
        ["Skinfeast"]=10
        ["Skin Graft"]=10
        ["Skullbog"]=10
        ["Slow Death"]=10
        ["Soulburn"]=10
        ["Soul Scars"]=10
        ["Spheres of Madness"]=10
        ["Spiritual Madness"]=10
        ["Stained Tombs"]=10
        ["Stripped of Flesh"]=10
        ["Stygiophobia"]=10
        ["Sympathy Denied"]=10
        ["The Bleeding"]=10
        ["The Heretic's Touch"]=10
        ["Time and Dust"]=10
        ["Terminal Filth"]=10
        ["The Ecomium of Terror"]=10
        ["The Sun Never Rises"]=10
        ["Thinning the Horde"]=10
        ["Tomb of Souls"]=10
        ["Trialed in Flames"]=10
        ["Trivial Anguish"]=10
        ["Tyranny"]=10
        ["Unhealing Wounds"]=10
        ["Vertigone"]=10
        ["Vomitorium"]=10
        ["Weaving Darkness"]=10
        ["Well of Souls"]=10
        ["What Color is Death?"]=10
        ["Where No Light Is"]=10
        ["Where Shadows Live"]=10
        ["Wrapped in Barbwire"]=10
        ["Ziggurat"]=10
        ["Zoweseandek"]=10

        ["Divine Intoxication"]=10
        ["Dying for It"]=10
        ["Infernal Directorate"]=10
        ["Glutton for Punishment"]=10
        ["Gore Soup"]=10
        ["Kill Thy Neighbor"]=10
        ["Murderous Intent"]=10
        ["No Sanctuary"]=10
        ["Out for Revenge"]=10
        ["Rampage!"]=10
        ["Rip in Reality"]=10
        ["Reaper Unleashed"]=10
        ["Searching for Sanity"]=10
        ["Slice 'em Twice!"]=10
        ["Sorrowful Faction"]=10
        ["Taste the Blade"]=10
        ["Traces of Evil"]=10
        ["Twists and Turns"]=10
        ["Welcome to the Coalface"]=10
        ["You Can't Handle the Noose"]=10
      }
    }
  }
  -- end of 'GOTHIC' theme


  --------------------------------------------------

  URBAN =
  {
    patterns =
    {
         ["%a %n"] = 60
      ["%t %a %n"] = 15

      [   "%n of %h"] = 20
      ["%t %n of %h"] = 12
      ["%a %n of %h"] = 7

      ["%v %n"]    = 25
      ["%v %a %n"] = 25

      ["%s"] = 12
    }

    lexicon =
    {
      t =
      {
        The=50
      }

      a =
      {
        -- size
        Plethoric=7, Sprawling=10, Unending=7,
        Serpentine=10, Hulking=3, Giant=2, Vast=7,

        -- location
        Arcane=5, Hidden=5, Ethereal=5, Nether_=5,
        Northern=10, Southern=10, Eastern=10, Western=10,
        Upper=5, Lower=10, Central=5,
        Inner=5, Innermost=3,
        Outer=5, Outermost=3,
        Furthest=5, Isolated=10,

        -- condition
        Old=10, Ancient=20, Eternal=7,
        Decrepid=20, Lost=10, Forgotten=10,
        Ravished=10, Barren=20, Deadly=5,
        Stagnant=10, Rancid=5, Rotten=3,
        Flooded=5, Sunken=3, Occult=5,
        Misty=10, Foggy=5, Toxic=2,
        Windy=10, Hazy=3, Distraught=5, Charred=10,
        Urban=10, Bombarded=2, Corrosive=2,

        -- descriptive
        Monstrous=3, Monster=15, Wild=5,
        Demonic=3, Demon=15, Polluted=10,
        Invaded=5, Overtaken=5, Stolen=3,
        Haunted=20, Infected=10, Infested=10,
        Corrupted=15, Corrupt=15, Fateful=5,
        Besieged=10, Contaminated=10, Malevolent=5,

        Savage=10, Menacing=15, Frightening=10, Creepy=5,
        Dark=30, Darkest=7, Horrible=10, Exotic=5,
        Dismal=10, Dreadful=10, Cold=7, Ugly=2,
        Vacant=15, Empty=7, Lonely=2, Desperate=2,
        Unknown=5, Unexplored=7, Lupine=2,
        Crowded=3, Untamed=3,

        Bleak=30, Abandoned=15, Forsaken=10,
        Cursed=20, Wretched=15, Bewitched=5, 
        Forbidden=20, Sinister=10, Hostile=10,
        Mysterious=10, Obscure=10, Living=3,
        Ominous=15, Perilous=15,
        Slaughter=5, Murder=5, Killing=5,
        Catastrophic=5, Whispering=10,
      }

      n =
      {
        City=30, Town=20, Village=10,
        Condominium=10, Condo=5, Citadel=10,
        Plaza=10, Square=5, Kingdom=15,
        Fortress=20, Fort=5, Stronghold=5,
        Palace=20, Courtyard=10, Court=10,
        Hallways=20, Halls=5, Corridors=7,

        Castle=20, Mineshaft=5, Embassy=5,
        House=20, Mansion=10, Manor=10,
        Refuge=5, Sanctuary=5, Asylum=10,
        Dwelling=3, Estate=2, Sewers=2,
        Outpost=5, Keep=3, Slough=3, Temple=3,
        Gate=10, Prison=15, Dens=5, Slums=5,
        Coliseum=2, Chateau=2,

        World=5, Country=10, Zone=10,
        District=10, Precinct=10,
        Dominion=10, Domain=3, Trail=10,
        Region=10, Territory=5, Path=5,
        Neighborhood=3, Environs=2,
        Bypass=2, Barrio=2, Crossing=5,
        Promenade=5, Trek=5, Venture=5,
        Voyage=7, Course=5, 

        Camp=3, Campus=2, Compound=3, Venue=1,
        Harbor=10, Reserve=3, Ward=3,
        Junction=2, Seabed=5, Embankment=3,
        Oasis=2, Odyssey=2, Habitat=2, Soil=10, 
        Scum=5, Remnants=10, Remains=5, Debris=5,
        Refuse=5, Dust=5, 

        Siege=5, Assault=5, Attack=5, Ambush=5,
        Onslaught=5, Stampede=5, Encounter=5,
        Conflict=5,

        -- plurals
        Lands=20, Fields=20, Footprints=5,
        Alleys=10, Docks=10,
        Towers=10, Streets=10, Roads=5,
        Gardens=15, Warrens=5, Quarry=5,
        Crossroads=5, Outskirts=10,
        Suburbs=10, Quarters=10,
        Mines=20, Barracks=5,

        -- weird ones
        Echo=1,
      }

      h =
      {
        Doom=20, Gloom=15, Despair=10, Sorrow=15,
        Horror=20, Terror=10, Death=10, Dolor=5,
        Danger=10, Pain=15, Fear=7, Hate=5,
        Desolation=3, Reparation=3, Solace=10,

        Ruin=10, Flames=3, Destruction=5,
        Twilight=5, Midnight=5, Dreams=2,
        Tears=10, Helplessness=2, Misfortune=5,
        Misery=10, Turmoil=5, Decay=5,
        Blood=10, Insanity=5, Delirium=2,
        Sabotage=5, 

        -- residents
        Ghosts=15, Gods=10, Spirits=5,
        Spectres=5, Banshees=5, Phantoms=5,
        Menace=15, Evil=5, Ghouls=5, Demons=5,
        Ogres=5, Denizens=7, Souls=5,
        Murderers=3, Vultures=5, Pirates=3,
        Spiders=2, Snakes=5, Vermin=5,
        Madmen=2, Mortals=10, Martyrs=5,
        Prophets=5, Prey=5, Crows=5, 
        Fools=1, Creeps=3, Demigods=3,

        ["the Bizarre"]=5
        ["the Diseased"]=5
        ["the Mad"]=7
        ["the Night"]=10
        ["the Phantasm"]=10
        ["the Poltergeist"]=10
        ["the Sick"]=5
        ["the Stray"]=5
        ["the Untamed"]=5
        ["the Vermin"]=5
        ["the Wraith"]=10
      }

      s =
      {
        -- single complete level names

        ["Abandonment"]=10
        ["Afterhours"]=10
        ["Aftermath"]=10
        ["All is Lost"]=10
        ["Archipelago"]=10
        ["Armed to the Teeth"]=10
        ["Arson Anthem"]=10
        ["Atomized"]=10
        ["Awaiting Death"]=10
        ["A Monster Too Many"]=10
        ["Bad Company"]=10
        ["Behind Enemy Lines"]=10
        ["Black and Grey"]=10
        ["Bleak"]=10
        ["Blind Salvation"]=10
        ["Blizzard of Glass"]=10
        ["Bullets and Fireballs"]=10
        ["Burndown"]=10
        ["Burnout"]=10
        ["Business District"]=10
        ["Cacophobia"]=10
        ["Carnival Bizarre"]=10
        ["Chaos and Confusion"]=10
        ["Cisterne"]=10
        ["Cloak of Midnight"]=10
        ["Cold Comfort"]=10
        ["Cold Sweat"]=10
        ["Countdown to Death"]=10
        ["Course of Decadence"]=10
        ["Cross Attack"]=10
        ["Crumbled Nations"]=10
        ["Darkness at Noon"]=10
        ["Dark Apparition"]=10
        ["Dark City"]=10
        ["Dark Horizon"]=10
        ["Darkened Waters"]=10
        ["Dead End"]=10
        ["Deadfall"]=10
        ["Deadlock"]=10
        ["Deadly Visions"]=10
        ["Dead Silent"]=10
        ["Dead Zone"]=10
        ["Demons On The Prey"]=10
        ["Destroy All Humans"]=10
        ["Devil's Rejects"]=10
        ["Doomed Society"]=10
        ["Dropoff"]=10
        ["Earth Scum"]=10
        ["Eight Floors Above"]=10
        ["Endoomed"]=10
        ["Enter Combat"]=10
        ["Evil or Dead"]=10
        ["Fading to Black"]=10
        ["Fallen into Shadows"]=10
        ["Famine"]=10
        ["Fatal Doom"]=10
        ["Fight to the End"]=10
        ["Fimbul Winter"]=10
        ["Forebearer of Grievance"]=10
        ["Forgotten"]=10
        ["Foul Ruin"]=10
        ["God's Little Acre"]=10
        ["Graveflower"]=10
        ["Graveyard Shift"]=10
        ["Gray Skies"]=10
        ["Greek Fire"]=10
        ["Hellbrigade"]=10
        ["Hell's Triumph"]=10
        ["Hidden Screams"]=10
        ["Hiding the Secrets"]=10
        ["House of a Thousand Deaths"]=10
        ["Human Debris"]=10
        ["In Remembrance"]=10
        ["In Solitary Ruin"]=10
        ["In the Final Hour"]=10
        ["Irradiated"]=10
        ["Jailbird"]=10
        ["Judgement Day"]=10
        ["Kitchen Ace"]=10
        ["Left in the Cold"]=10
        ["Library of the Lost"]=10
        ["Lights Out!"]=10
        ["Long Gone"]=10
        ["Lucid Illusion"]=10
        ["Lucifer in Starlight"]=10
        ["Lunatic Fringe"]=10
        ["Mayhem"]=10
        ["March of the Zombies"]=10
        ["Nightfall"]=10
        ["Night Stalkers"]=10
        ["Night Terrors"]=10
        ["No Guts No Glory"]=10
        ["No Rest No Peace"]=10
        ["Nothing's There"]=10
        ["On the Hunt"]=10
        ["One Too Many"]=10
        ["Open Wound"]=10
        ["Organized Chaos"]=10
        ["Overtime"]=10
        ["Patron of Antipathy"]=10
        ["Population One"]=10
        ["Poison Society"]=10
        ["Polygraph"]=10
        ["Pinciple of War"]=10
        ["Pitch Black"]=10
        ["Primetime Killing"]=10
        ["Punctured"]=10
        ["Quietus"]=10
        ["Riddled by Gunfire"]=10
        ["R.I.P Humanity"]=10
        ["Red Valhalla"]=10
        ["Realm of Chaos"]=10
        ["Remains of Humanity"]=10
        ["Retribution"]=10
        ["Roadkill"]=10
        ["Roctagon"]=10
        ["Rotten Roots"]=10
        ["Running of the Bulls"]=10
        ["Sanctuary"]=10
        ["Set the World on Fire"]=10
        ["Shellshock"]=10
        ["Shadowland"]=10
        ["Silent Might"]=10
        ["Sin City"]=10
        ["Solitude"]=10
        ["Stakeout"]=10
        ["Stille Nacht"]=10
        ["Stonegate"]=10
        ["Subjugated"]=10
        ["Suspense"]=10
        ["Terminal Fear"]=10
        ["Ten Degrees of Fate"]=10
        ["Terrorville"]=10
        ["The Blackest Day"]=10
        ["The Bones of Many"]=10
        ["The Fading Light"]=10
        ["The Fire Still Burns"]=10
        ["The Guns Fall Silent"]=10
        ["The Hook"]=10
        ["The Silenced Lamasery"]=10
        ["The Sun No Longer Rises"]=10
        ["The Trial"]=10
        ["The Winds Speak None"]=10
        ["This is The End"]=10
        ["Tombstone"]=10
        ["Under Ruins"]=10
        ["Unleashed Aggression"]=10
        ["Urban Horror"]=10
        ["Valley of the Dead"]=10
        ["Viscera"]=10
        ["Voice of the Voiceless"]=10
        ["Walk of Faith"]=10
        ["Warzone"]=10
        ["Watch it Burn"]=10
        ["Watch your Step"]=10
        ["When the Candle Fades"]=10
        ["Where Marines Dare"]=10
        ["Witch Parade"]=10
        ["Xenophobia"]=10

        ["Ambushed!"]=10
        ["Bullet Hole"]=10
        ["Civil Disobedience"]=10
        ["Disestablishment"]=10
        ["Eaten by the Furniture"]=10
        ["Escape is Futile"]=10
        ["Fight That!"]=10
        ["Forboding Signs"]=10
        ["Mindless Architecture"]=10
        ["Mow 'em Down!"]=10
        ["Nobody's Home"]=10
        ["No Comfort"]=10
        ["Out of Luck"]=10
        ["Passing Away"]=10
        ["Route to Death"]=10
        ["Stream of Unconsciousness"]=10
        ["Struggle No More"]=10
        ["Today You Die!"]=10
        ["Ups and Downs"]=10
        ["You Don't Belong Here"]=10
      }
    }
  }
  -- end of 'URBAN' theme


  --------------------------------------------------

  BOSS =
  {
    patterns =
    {
      ["%s"] = 10
    }

    lexicon =
    {
      s =
      {
        ["Angelic Exodus"]=10
        ["Arena of Terror"]=10
        ["Bad Neighbors"]=10
        ["Barrier"]=10
        ["Barons' Rhapsody"]=10
        ["Battle Royale"]=10
        ["Blast Through"]=10
        ["Bleed on Me"]=10
        ["Blessed Are the Quick"]=10
        ["Bloodbath"]=10
        ["Border Crossing"]=10
        ["Boss Cage"]=10
        ["Captured"]=10
        ["Caughtyard"]=10
        ["Checkmate"]=10
        ["Close Combat"]=10
        ["Coliseum"]=10
        ["Coronary Bypass"]=10
        ["Creepshow"]=10
        ["Cyberstomp"]=10
        ["Death Sentence"]=10
        ["Deicide Ultra"]=10
        ["Deliverance"]=10
        ["Die Hard"]=10
        ["Dog Eat Dog"]=10
        ["Do or Die"]=10
        ["End of Days"]=10
        ["Execution"]=10
        ["Eye for an Eye"]=10
        ["Fatality"]=10
        ["Fate"]=10
        ["Final Fight"]=10
        ["Fire Amok"]=10
        ["Gateway"]=10
        ["Gladiator"]=10
        ["Ground Zero"]=10
        ["Guardian"]=10
        ["Hail of Bullets"]=10
        ["Hard Attack"]=10
        ["Hardball"]=10
        ["Hellmouth"]=10
        ["Into The Ground"]=10
        ["I Expect You to Die"]=10
        ["Kill Frenzy"]=10
        ["Killswitch"]=10
        ["Kingdom Come"]=10
        ["Knockout"]=10
        ["Lion's Den"]=10
        ["Lucid"]=10
        ["Melee!"]=10
        ["Mission Improbable"]=10
        ["Moving Target"]=10
        ["Murderplay"]=10
        ["Nightmare Without End"]=10
        ["Nemesis"]=10
        ["No Exit!"]=10
        ["No Sweat"]=10
        ["Nowhere to Go"]=10
        ["Not So Simple"]=10
        ["Nucleus"]=10
        ["Open Fire"]=10
        ["Panic Room"]=10
        ["Perfect Conflict"]=10
        ["Playground"]=10
        ["Proving Grounds"]=10
        ["Punchline"]=10
        ["Razor's Edge"]=10
        ["Recess"]=10
        ["Rip and Tear"]=10
        ["Roadblock"]=10
        ["Screamin' Marines"]=10
        ["Showdown"]=10
        ["Showtime!"]=10
        ["Shoot First Ask Later"]=10
        ["Sinister"]=10
        ["Sink or Swim"]=10
        ["Six Feet Under"]=10
        ["Slaughterfest"]=10
        ["SNAFU"]=10
        ["Soul Trap"]=10
        ["Sudden Death"]=10
        ["The Hunt"]=10
        ["The New Fury"]=10
        ["The Purge"]=10
        ["The Second Coming"]=10
        ["The Trap"]=10
        ["There Can Be No Victory"]=10
        ["Total Doom"]=10
        ["Trapped"]=10
        ["Trial by Fire"]=10
        ["Trial of Mankind"]=10
        ["Trouble in Paradise"]=10
        ["Unmaker"]=10
        ["Unwelcome"]=10
        ["Victory Zero"]=10
        ["Welcome to Thy Doom"]=10
        ["What Color is Death?"]=10
        ["You May Not Pass!"]=10
      }
    }
  }
  -- end of 'BOSS' theme


  --------------------------------------------------

  EPISODE =
  {
    patterns =
    {
      -- places
      ["%p of %j"] = 30
      ["The %p of %j"] = 30
      ["The %a %p"] = 40
      ["A %a %p/s"] = 40
      ["%j %q"] = 20
      ["Gateway to %j"] = 5
      ["%p/s of No Return"] = 5

      -- homages to Episode 1
      ["%k-Deep in %j"] = 10
      ["%k-Deep in the %j"] = 5
      ["%k-High in %j"] = 5
      ["Drowning in %j"] = 10
      ["Wading through the %j"] = 5
      ["Endless %j"] = 10

      -- complete names
      ["%s"] = 100
    }

    lexicon =
    {
      p =
      {
        Citadel = 15
        City = 15
        Ghetto = 15
        Towers = 15
        Kingdom = 7

        World = 10
        Planet = 5
        Realm = 10
        Shores = 30
        Land = 10
        Fields = 15

        Crypt = 5
        Dungeons = 10
        Underworld = 10
        Dimension = 20

        Facility = 5
        Complex = 10
        Quarters = 5
        Domain = 10
        House = 5
      }

      q =
      {
        Town = 20
        City = 5
        Zone = 20
        Central = 20

        ["All Around"] = 10
        ["Awaits Thee"] = 5
        ["Galore"] = 10
      }

      a =
      {
        Creepy = 10
        Lonely = 20
        Dark = 20
        Menacing = 20
        Cold = 20
        Savage = 20
        Deathly = 20
        Corrupted = 10
        Unholy = 10
        Strange = 10

        Monstrous = 10
        Demonic = 10
        Infested = 10
        Haunted = 5
        Doomed = 5
        Hateful = 5
        Forsaken = 15
        Evil = 10
      }

      k =
      {
        Knee = 30
        Neck = 20
        Waist = 10
        Chest = 3
        Thigh = 3
      }

      j =
      {
        Gore = 30
        Dead = 5
        Corpses = 20
        Bodies = 20
        Bones = 10
        Death = 15
        Carnage = 20
        Slaughter = 10

        Blood = 20
        Slime = 10
        Nukage = 10
        Mush = 5
        Ash = 5
        Filth = 10
        Viscera = 10

        Destruction = 10
        Horror = 20
        Monsters = 10
        Zombies = 10
        Demons = 10

        Pain = 10
        Agony = 10
        Terror = 10
        Fear = 10
        Flames = 10
        Despair = 10
        Doom = 5
      }

      s =
      {
        ["A Price To Pay"] = 10
        ["Aftershock"] = 10
        ["Bad Dream"] = 10
        ["Defenders of Hell"] = 10
        ["Entombed"] = 10
        ["Halloween"] = 10
        ["Limbo"] = 10
        ["Origin of Venom"] = 10
        ["Sealed Fate"] = 10
        ["Warbringer"] = 10

        ["A Storm Cometh"] = 10
        ["Battlefield"] = 10
        ["Bestial Experiment"] = 10
        ["Beyond Earth"] = 10
        ["Breeding Chambers"] = 10
        ["Code Red"] = 10
        ["Hell Breaks Loose"] = 10
        ["The Treason Well"] = 10
        ["Under an Alien Sky"] = 10

        ["As The World Burns"] = 10
        ["Deadly Harvest"] = 10
        ["Desperate Measures"] = 10
        ["Everlasting Night"] = 10
        ["Left for Dead"] = 10
        ["New Beginning"] = 10
        ["Oblivion Upon Us"] = 10
        ["The Healer Stalks"] = 10
        ["When Ashes Rise"] = 10

        ["Abandon all Hope"] = 10
        ["Chaos Rising"] = 10
        ["Ex Nihilo"] = 10
        ["Genesis of Genocide"] = 10
        ["The Devil's Emissary"] = 10
        ["The Howling Void"] = 10
        ["Torturous Existence"] = 10
        ["Pulse of Depravity"] = 10
        ["Say Thy Prayers!"] = 10
        ["Vengeance Denied"] = 10

        ["The Lost Base"] = 10
        ["Hell's Playground"] = 10
        ["Crimson Reprieve"] = 10
        ["Souls of the Damned"] = 10
        ["In the Face of Armageddon"] = 10
        ["Highway to Hell"] = 10
        ["Time to Bleed"] = 10

        ["Into the Shadows"] = 10
        ["And Now You Die"] = 10
        ["Halls of Lamentation"] = 10
        ["Intruder Alert"] = 10
        ["Security Breach"] = 10
        ["Arena From Hell"] = 10

        -- these by Chris (mostly)
        ["Radio Silence"] = 10
        ["Liquidation"] = 10
        ["Return to Hell"] = 10
        ["A Chilling Discovery"] = 10
        ["Human Stagnation"] = 10
        ["Thou Art Doomed"] = 10
        ["Fathomless Abyss"] = 10
        ["Insecurity"] = 10
        ["Pathos 666"] = 10
        ["Toxic Grievance"] = 10
        ["Hell's Injustice"] = 10
        ["Gate to Nowhere"] = 10
        ["Of Horns And Blood"] = 10
        ["Disadvantaged"] = 10
        ["Silent Hell"] = 10
        ["Ghosts of Tei Tenga"] = 10
        ["End of Everything"] = 10
        ["Ashes And Plasma"] = 10
        ["A New Kind of Army"] = 10
        ["Post-Human Paradox"] = 10
        ["Neverending Twilight"] = 10
        ["Tower of Limbs"] = 10
        ["Burial in Space"] = 10
        ["The Sons of Mars"] = 10
        ["Parallel Absolution"] = 10
        ["A Clockwork Death"] = 10
        ["Dolor Extremus"] = 10
        ["Spiritus Malus"] = 10

        -- homages to DOOM 1 Episodes
        ["Explosion"] = 3
        ["Enter the Flames"] = 3
        ["Burning in Hell"] = 3
        ["Blazing Shores"] = 3
        ["Lakes of Fire"] = 3
        ["Hellfires"] = 3

        ["Thy Soul Devoured"] = 5
        ["Thy Shrivelled Mind"] = 5
        ["Thou Shalt Die"] = 5
        ["Consumed by Flames"] = 3
      }
    }
  }
  -- end of 'EPISODE' theme


  --------------------------------------------------

  TITLE =
  {
    patterns =
    {
      -- <adj> <place>  e.g. dark dimension
      ["%a %p"] = 20
      ["The %a %p"] = 30

      -- <adj> <thing>  e.g. eternal gore
      ["%a %d"] = 40

      ["%d Forever"]  = 5
      ["%d Revealed"] = 2

      -- <place> of <desc>  e.g. city of souls
      ["%p of %d"] = 40
      ["%d in the %p"] = 6

      ["The %e of %d"] = 3
      ["%e in the %p"] = 3

      -- <place> of the <entity>  e.g. realm of the devil
      ["%p of the %e"] = 60

      -- miscellaneous
      ["Beyond the %p"] = 2
      ["Journey to the %p"] = 2

      ["The %e Cometh"] = 2
      ["The %e will Rise"] = 2
      ["The %e must Die"] = 2
      ["Fight the %e"] = 2
      ["Age of the %e"] = 2
    }

    lexicon =
    {
      a =
      {
        Dark = 20
        Menacing = 20
        Cold = 10
        Fiery = 10
        Blazing = 15
        Savage = 30
        Deathly = 20
        Strange = 10
        Burning = 10
        Frozen  = 10

        Evil = 50
        Monstrous = 15
        Sinful  = 15
        Demonic = 15
        Infested = 10
        Doomed = 10
        Malicious = 10
        Forsaken = 10
        Filthy   = 5

        Morbid = 20
        Lonely = 10
        Weird = 10
        Endless = 20
        Infinite = 10
        Gory = 10
        Visceral = 15
        Corrupt = 15
        Wicked  = 10
        Vile    = 5

        Fatal = 10
        Lost  = 10
        Fetid = 5
        Foul  = 5
        Cursed = 10
        Haunted = 10
        Cruel = 10

        Hallowed = 10
        Unholy = 10
        Profane = 15
        Tortured = 10
        Forgotten = 10
        Abandoned = 10
        Ghoulish  = 10

        Hidden = 10
        Wretched = 15
        Nefarious = 15
        Extreme = 10
        Wrecked = 10
      }

      p =
      {
        City = 15
        Citadel = 15
        Ghetto = 15
        Towers = 15
        Kingdom = 10
        Temple = 15

        World = 15
        Planet = 15
        Realm = 15
        Dimension = 10

        Shores = 20
        Valley = 20
        Land = 10
        Fields = 10
        River = 10

        Crypt = 10
        Dungeons = 10
        Underworld = 10
        Catacombs = 10

        Base = 10
        Facility = 10
        Complex = 10
        Domain = 10
        House = 10

        Island = 15
        Mazes = 10
        Cult = 10
        Ruins = 10
        Caverns = 15
        Garden = 10

        Night = 30
        Knowledge = 10
        Twilight = 10
        Gateway = 10
        Prison = 10
        Tomb = 15
      }

      -- these are quite abstract
      d =
      {
        Death = 20
        Blood = 20
        Hell = 10
        Fury = 10
        Horror = 10
        Slime = 5

        Pain = 10
        Agony = 20
        Terror = 20
        Fear = 20
        Flames = 20
        Doom = 10

        Dreams = 20
        Souls = 10
        Hate = 10
        Magic = 15
        Rage = 10

        Heroes = 10
        Insanity = 10
        Silence = 20
        Vengeance = 20
        Shadows = 10
        Wrath = 10
      }

      e =
      {
        Devil = 20
        Gods  = 20
        Overlord = 20
        Ancients = 20
        Infidel = 20

        Antichrist = 10
        Necromancer = 20
        Oracle = 10
        Wicked = 20
        Titans = 20

        Beast = 20
        Demons = 20
        Hellspawn = 20
        Undead = 20
        Vampire = 20
        Zombies = 10
        Trolls = 10
        Aliens = 10

        Dead = 20
        Doomed = 30
        Fearless = 20
        Tormented = 20
        Wretched = 20
        Destroyer = 10
      }
    }
  }


  SUB_TITLE =
  {
    patterns =
    {
      ["%s"] = 50
    }

    lexicon =
    {
      s =
      {
        -- sequels
        ["II"]  = 80
        ["III"] = 80
        ["IV"]  = 40
        ["VI"]  = 10
        ["XII"] = 10

        ["R E D U X"] = 10
        ["Revisited"] = 10
        ["Reloaded"] = 10
        ["Special Edition"] = 10

        ["A New Generation"] = 40
        ["The Resurrection"] = 30
        ["The Reckoning"] = 40
        ["Evil Is Reborn"] = 20

        ["The Struggle Continues..."] = 20
        ["The Endless Fight"] = 20
        ["The Demons Are Back"] = 20
        ["Battle Everlasting"] = 20

        -- prequels
        ["G E N E S I S"] = 40
        ["The Awakening"] = 40
        ["Evil Unleashed"] = 20
        ["The Dead Shall Rise"] = 20
        ["Where It All Began"] = 20
        ["Dawn Of Eternity"] = 20
        ["The Invasion Begins"] = 20
        ["The Prophecy Unfolds"] = 20

        -- describe the place
        ["The Evil Within"] = 20
        ["What Lurks Beneath"] = 20
        ["A God-forsaken Place"] = 20
        ["A Land In Turmoil"] = 20
        ["Point Of No Return"] = 20
        ["Gateway to Hell"] = 20
        ["Where Devils Spawn"] = 20

        -- miscellaneous
        ["A Dreaded Obligation"] = 30
        ["Your Dire Obligation"] = 30

        ["The Final Hour"] = 20
        ["Out Of Time"] = 20
        ["Days Of Rage"] = 20
        ["No Salvation"] = 20
        ["A Fight for Survival"] = 20
        ["Thirst for Vengeance"] = 20

        ["The Brink of Disaster"] = 20
        ["The Apocalypse Has Come"] = 20
        ["Nobody Is Safe"] = 10
        ["Nowhere Is Safe"] = 10
        ["The Seeds of War"] = 20
        ["The Will To Survive"] = 20
      }
    }
  }
  -- end of 'TITLE' and 'SUB_TITLE' themes


  --------------------------------------------------

  -- name of the mastermind behind all the evil
  NAME_BOSS =
  {
    patterns =
    {
      ["The Spider Mastermind"] = 40

      ["The Leader of Hell"] = 20
      ["The Necromancer"] = 20
      ["The Demon Queen"] = 20
      ["The Cyber-Devil"] = 20
      ["The Shadow Council"] = 20
      ["The Witch-King"] = 20
      ["The Alien Faction"] = 20
      ["The Cruel One"] = 20

      ["Satan"] = 10
      ["Beelzebub"] = 10
      ["Baal"] = 10
      ["Moloch"] = 10
    }

    lexicon = {}
  }


  -- name of lesser bosses, minions of the mastermind
  NAME_MINION =
  {
    patterns =
    {
      ["The Arch-Vile"] = 40
      ["The Baron of Hell"] = 40

      ["The Demon Prince"] = 20
      ["The Gatekeeper"] = 20
      ["The Guardian"] = 20
      ["The Wicked Acolyte"] = 20
      ["The Dark Archon"] = 20
      ["The Evil Beast"] = 20
      ["The Zombie Lord"] = 20

      ["Doctor Kruger"] = 10
    }

    lexicon = {}
  }


  -- name of a powerful thing needed to defeat the big boss
  NAME_ARTIFACT =
  {
    patterns =
    {
      ["Khronos Device"] = 10
      ["Soul-X Agitator"] = 10
      ["Quantum Disrupter"] = 10
      ["Gravitronic Amplifier"] = 10
      ["Ectoplasmic Deflector"] = 10

      ["Sphere of Invincibility"] = 10
      ["Ring of Power"] = 10
      ["Crystal Sceptre"] = 10
      ["Diamond Skull"] = 10

      ["Sword of the Infidel"] = 10
      ["Staff of Ulysses"] = 10
      ["Hand of Charon"] = 10
    }

    lexicon = {}
  }


  -- name of the player's friend, for capture/rescue sub-plots
  NAME_FRIEND =
  {
    patterns =
    {
      ["Professor Braun"] = 20
      ["Doctor Stine"] = 20
      ["Major Halderman"] = 20
      ["Sergeant Kelly"] = 20
      ["Private Swann"] = 20

      ["Christopher"] = 10
      ["Michael"] = 10
      ["Jonathon"] = 10

      ["Arlene"] = 40
      ["Cassandra"] = 20
      ["Samantha"] = 20
    }

    lexicon = {}
  }


  -- location for the early action, neutral-ish places
  NAME_PLACE1 =
  {
    patterns =
    {
      ["Phobos"] = 20
      ["Demios Base"] = 20
      ["UAC Complex"] = 20

      ["Lunar Base"] = 20
      ["Martian Complex"] = 20
      ["Jupiter Station"] = 20
      ["Orbital Station"] = 20

      ["Terran Starport"] = 20
      ["Egyptian Portal"] = 20
      ["Mayan Temple"] = 20
    }

    lexicon = {}
  }


  -- locations for later battles or the finale, hell-ish places
  NAME_PLACE2 =
  {
    patterns =
    {
      ["Shores of Hell"] = 20
      ["Land of the Undead"] = 20
      ["Crimson Underworld"] = 20
      ["Dimension of Evil"] = 20
      ["Kingdom of Fire"] = 20
      ["Nether-Sphere"] = 20
      ["Ghostly Realm"] = 20
    }

    lexicon = {}
  }
  -- end of all the 'NAME_XXX' themes


  --------------------------------------------------

  TEXT_FACE_MINION =
  {
    patterns =
    {
      ["Now you must find <minion>, who holds the key "..
       "to this infernal mystery."
      ] = 10
    }

    lexicon = {}
  }

  TEXT_DEFEAT_MINION =
  {
    patterns =
    {
      ["With one last blow you finish off <minion>, " ..
       "its hideous body laying at your feet."
      ] = 10
    }

    lexicon = {}
  }


  TEXT_FACE_BOSS =
  {
    patterns =
    {
      ["Ahead lies the dominion of <boss>, "..
       "an evil place where even fools fear to tread. "..
       "Daunted, yet determined, you emerge from the "..
       "inter-dimensional portal and begin to explore "..
       "this alien world...."
      ] = 10
    }

    lexicon = {}
  }

  TEXT_DEFEAT_BOSS =
  {
    patterns =
    {
      ["Your skillful use of the <artifact> was glorious, " ..
       "defeating <boss> once and for all time."
       -- FIXME : more stuff...
      ] = 10
    }

    lexicon = {}
  }


  TEXT_LEARN_ARTIFACT =
  {
    patterns =
    {
      ["You have learned of a powerful artifact, "..
       "the <artifact>.  "..
       "But is it real, or only a myth or legend? "..
       "Somehow, you know you are going to find out."
      ] = 10
    }

    lexicon = {}
  }

  TEXT_FOUND_ARTIFACT =
  {
    patterns =
    {
      ["The <artifact> is yours! "..
       "But your jubilation soon turns into a grim "..
       "realization of what this means: it shall be "..
       "your fate to use it against the "..
       "most evil entity in the universe."
       -- to save the entire human race
      ] = 10
    }

    lexicon = {}
  }


  TEXT_LEARN_FRIEND =
  {
    patterns =
    {
      ["You receive communication that your dear friend, "..
       "<friend>, has been abducted by the army of <minion>!"
      ] = 10
    }

    lexicon = {}
  }

  TEXT_RESCUE_FRIEND =
  {
    patterns =
    {
      ["In a nearby dungeon cell you discover your friend, "..
       "<friend>, who is still alive!"..
       "|Quickly you remove their shackles and free them. "..
       "Almost too weak to talk, a barely audible \"Thank you\" "..
       "is followed by some surprising information: "..
       "the location of the <artifact>!" ..
       "|Relieved that <friend> is now safe, you set forth to "..
       "retreive the <artifact> from its secret location."
      ] = 10
    }

    lexicon = {}
  }

  -- gosh, this will cause some tears
  TEXT_LOSE_FRIEND =
  {
    patterns =
    {
      ["In the distance you recognize your friend "..
       "<friend>, waiting for you. "..
       "You hurry toward them, but all too soon your "..
       "joy turns to repulsion as you discover they have "..
       "been turned into a demon!"..
       "|\"Noooo!\" you scream, "..
       "and shudder as you realize what you must now do... "..
       "|Your soul feels ripped apart, the only consolation "..
       "is that <friend> can finally rest in piece. "..
       "<boss> will pay for this!"
      ] = 10
    }

    lexicon = {}
  }


  TEXT_SECRET =
  {
    patterns =
    {
      ["%c %f |%p |%m %e"] = 50

      ["%s"] = 10
    }

    lexicon =
    {
      c =
      {
        ["Congratulations,"] = 50
        ["Well done!"] = 50
        ["Oh yes!"] = 50
        ["Woohoo!"] = 50
      }

      f =
      {
        ["You found the secret level!"] = 50
      }

      p =
      {
        ["This place looks very weird..."] = 50
      }

      m =
      {
        ["The monsters will kill you!"] = 50
      }

      e =
      {
        ["So, better not stay too long..."] = 50
      }

      -- complete replacements
      s =
      {
        ["Welcome . . . . . . |. . . . . to the Twilight Zone"] = 10
      }
    }
  }


  TEXT_SECRET2 =
  {
    patterns =
    {
      ["%c %f |%e"] = 50

      ["%s"] = 10
    }

    lexicon =
    {
      c =
      {
        ["Congratulations!"] = 20
        ["Very well done!"] = 50
        ["Holy shit,"] = 50
        ["Woah,"] = 50
        ["This is incredible,"] = 40
        ["This is almost unbelievable, because"] = 20
      }

      f =
      {
        ["You found the super secret level!"] = 50
      }

      e =
      {
        ["Are you ready for what is ahead?"] = 50
      }

      -- complete replacements
      s =
      {
        ["Human! |You will be punished for entering our " ..
         "secret chambers!"] = 10
      }
    }
  }
  -- end of all the 'TEXT_XXX' themes
}


----------------------------------------------------------------


namelib.IGNORE_WORDS =
{
  ["the"]=1, ["a"]=1,  ["an"]=1, ["of"]=1, ["s"]=1,
  ["for"]=1, ["in"]=1, ["on"]=1, ["to"]=1,
}


function namelib.fix_up(name)
  -- convert "_" to "-"
  name = string.gsub(name, "_ ", "-")
  name = string.gsub(name, "_",  "-")

  -- convert "A" to "AN" where necessary
  name = string.gsub(name, "^[aA] ([aAeEiIoOuU])", "An %1")

  -- the "+s" means to add "S" to a word (pluralize it)
  name = string.gsub(name, "s%+s", "s")
  name = string.gsub(name, "x%+s", "xes")
  name = string.gsub(name, "z%+s", "zes")
  name = string.gsub(name, "ay%+s", "ays")
  name = string.gsub(name, "oy%+s", "ays")
  name = string.gsub(name, "y%+s", "ies")
  name = string.gsub(name, "%+s", "s")

  -- the "/s" means to remove a trailing "S" from a word
  name = string.gsub(name, "ies/s", "y")
  name = string.gsub(name, "s/s", "")
  name = string.gsub(name, "/s", "")

  return name
end


function namelib.split_word(tab, word)
  for w in string.gmatch(word, "%a+") do
    local low = string.lower(w)

    if not namelib.IGNORE_WORDS[low] then
      -- truncate to 4 letters
      if #low > 4 then
        low = string.sub(low, 1, 4)
      end

      tab[low] = (tab[low] or 0) + 1
    end
  end
end


function namelib.match_parts(word, parts)
  each p,_ in parts do
    for w in string.gmatch(word, "%a+") do
      local low = string.lower(w)

      -- truncate to 4 letters
      if #low > 4 then
        low = string.sub(low, 1, 4)
      end

      if p == low then
        return true
      end
    end
  end

  return false
end


function namelib.one_from_pattern(DEF)
  local name = ""
  local words = {}

  local pattern = rand.key_by_probs(DEF.patterns)
  local pos = 1

  while pos <= #pattern do
    
    local c = string.sub(pattern, pos, pos)
    pos = pos + 1

    if c != '%' then
      name = name .. c
    else
      assert(pos <= #pattern)
      c = string.sub(pattern, pos, pos)
      pos = pos + 1

      if not string.match(c, "%a") then
        error("Bad naming pattern: expected letter after %")
      end

      local lex = DEF.lexicon[c]
      if not lex then
        error("Naming theme is missing letter: " .. c)
      end

      local w = rand.key_by_probs(lex)
      name = name .. w

      namelib.split_word(words, w)
    end
  end

  return name, words
end


function namelib.choose_one(DEF, max_len)
  local name, parts

  repeat
    name, parts = namelib.one_from_pattern(DEF)
  until #name <= max_len

  -- adjust probabilities
  each c,word_tab in DEF.lexicon do
    local divisor = DEF.divisors[c] or 10

    each w,prob in word_tab do
      if namelib.match_parts(w, parts) then
        DEF.lexicon[c][w] = prob / divisor
      end
    end
  end

  return namelib.fix_up(name)
end


function namelib.merge_theme(theme_name)
  -- verify the theme name
  if not namelib.NAMES[theme_name] then
    error("namelib.generate: unknown theme: " .. tostring(theme_name))
  end

  local theme = {}

  local sources = { namelib.NAMES, GAME.NAMES or {} }

  -- always merge in the "COMMON" theme before the main one
  each S in sources do
    if S["COMMON"] then
      table.deep_merge(theme, S["COMMON"])
    end
  end

  -- now merge in the actual specific theme
  each S in sources do
    if S[theme_name] then
      table.deep_merge(theme, S[theme_name])
    end
  end

  return theme
end


function namelib.generate(theme_name, count, max_len)
  local DEF = namelib.merge_theme(theme_name)

  local list = {}

  for i = 1, count do
    local name = namelib.choose_one(DEF, max_len)

    table.insert(list, name)
  end

  return list
end


function namelib.test()
  local function test_theme(T)
    for set = 1,30 do
      gui.rand_seed(set)
      local list = namelib.generate(T, 12, 28)

      each name in list do
        gui.debugf("%s Set %d Name %2d: %s\n", T, set, _index, name)
      end

      gui.debugf("\n");
    end
  end

  test_theme("TECH")
  test_theme("GOTHIC")
  test_theme("URBAN")

  test_theme("BOSS")
  test_theme("EPISODE")
  test_theme("TITLE")
end


function Naming_init()
  namelib.cache = {}
end


function Naming_grab_one(theme)
  local cache = namelib.cache
  assert(cache)

  if not cache[theme] or table.empty(cache[theme]) then
    cache[theme] = namelib.generate(theme, 30, PARAM.max_name_length or 28)
  end

  return table.remove(namelib.cache[theme], 1)
end

