/*****************************************************************************
 * Copyright (c) 2014-2024 OpenRCT2 developers
 *
 * For a complete list of all authors, please refer to contributors.md
 * Interested in contributing? Visit https://github.com/OpenRCT2/OpenRCT2
 *
 * OpenRCT2 is licensed under the GNU General Public License version 3.
 *****************************************************************************/

#pragma once

#include "../localisation/StringIdType.h"

enum : StringId
{
    // Coasters
    STR_RIDE_NAME_38 = 58,
    STR_RIDE_NAME_3A = 60,
    STR_RIDE_NAME_40 = 66,
    STR_RIDE_NAME_AIR_POWERED_VERTICAL_COASTER = 77,
    STR_RIDE_NAME_ALPINE_COASTER = 95,
    STR_RIDE_NAME_BOBSLEIGH_COASTER = 15,
    STR_RIDE_NAME_CLASSIC_MINI_ROLLER_COASTER = 6111,
    STR_RIDE_NAME_CLASSIC_STAND_UP_ROLLER_COASTER = 97,
    STR_RIDE_NAME_CLASSIC_WOODEN_ROLLER_COASTER = 96,
    STR_RIDE_NAME_COMPACT_INVERTED_COASTER = 75,
    STR_RIDE_NAME_CORKSCREW_ROLLER_COASTER = 21,
    STR_RIDE_NAME_FLYING_ROLLER_COASTER = 59,
    STR_RIDE_NAME_GIGA_COASTER = 70,
    STR_RIDE_NAME_HEARTLINE_TWISTER_COASTER = 68,
    STR_RIDE_NAME_HYBRID_COASTER = 93,
    STR_RIDE_NAME_HYPERCOASTER = 6105,
    STR_RIDE_NAME_HYPER_TWISTER = 6109,
    STR_RIDE_NAME_INVERTED_HAIRPIN_COASTER = 78,
    STR_RIDE_NAME_INVERTED_IMPULSE_COASTER = 88,
    STR_RIDE_NAME_INVERTED_ROLLER_COASTER = 5,
    STR_RIDE_NAME_JUNIOR_ROLLER_COASTER = 6,
    STR_RIDE_NAME_LAY_DOWN_ROLLER_COASTER = 64,
    STR_RIDE_NAME_LIM_LAUNCHED_ROLLER_COASTER = 92,
    STR_RIDE_NAME_LOOPING_ROLLER_COASTER = 17,
    STR_RIDE_NAME_MINE_RIDE = 90,
    STR_RIDE_NAME_MINE_TRAIN_COASTER = 19,
    STR_RIDE_NAME_MINI_ROLLER_COASTER = 89,
    STR_RIDE_NAME_MINI_SUSPENDED_COASTER = 9,
    STR_RIDE_NAME_MULTI_DIMENSION_ROLLER_COASTER = 57,
    STR_RIDE_NAME_REVERSER_ROLLER_COASTER = 67,
    STR_RIDE_NAME_REVERSE_FREEFALL_COASTER = 44,
    STR_RIDE_NAME_SIDE_FRICTION_ROLLER_COASTER = 55,
    STR_RIDE_NAME_SINGLE_RAIL_ROLLER_COASTER = 94,
    STR_RIDE_NAME_SPINNING_WILD_MOUSE = 6162,
    STR_RIDE_NAME_SPIRAL_ROLLER_COASTER = 2,
    STR_RIDE_NAME_STAND_UP_ROLLER_COASTER = 3,
    STR_RIDE_NAME_STEEPLECHASE = 12,
    STR_RIDE_NAME_SUSPENDED_SWINGING_COASTER = 4,
    STR_RIDE_NAME_TWISTER_ROLLER_COASTER = 53,
    STR_RIDE_NAME_VERTICAL_DROP_ROLLER_COASTER = 46,
    STR_RIDE_NAME_VIRGINIA_REEL = 61,
    STR_RIDE_NAME_WATER_COASTER = 76,
    STR_RIDE_NAME_WILD_MOUSE = 56,
    STR_RIDE_NAME_WOODEN_ROLLER_COASTER = 54,
    STR_RIDE_NAME_WOODEN_WILD_MOUSE = 11,
    STR_RIDE_DESCRIPTION_AIR_POWERED_VERTICAL_COASTER = 587,
    STR_RIDE_DESCRIPTION_ALPINE_COASTER = 605,
    STR_RIDE_DESCRIPTION_BOBSLEIGH_COASTER = 525,
    STR_RIDE_DESCRIPTION_CLASSIC_MINI_COASTER = 6119,
    STR_RIDE_DESCRIPTION_CLASSIC_STAND_UP_ROLLER_COASTER = 607,
    STR_RIDE_DESCRIPTION_CLASSIC_WOODEN_ROLLER_COASTER = 606,
    STR_RIDE_DESCRIPTION_COMPACT_INVERTED_COASTER = 585,
    STR_RIDE_DESCRIPTION_CORKSCREW_ROLLER_COASTER = 531,
    STR_RIDE_DESCRIPTION_FLYING_ROLLER_COASTER = 569,
    STR_RIDE_DESCRIPTION_GIGA_COASTER = 580,
    STR_RIDE_DESCRIPTION_HEARTLINE_TWISTER_COASTER = 578,
    STR_RIDE_DESCRIPTION_HYBRID_COASTER = 603,
    STR_RIDE_DESCRIPTION_HYPERCOASTER = 6113,
    STR_RIDE_DESCRIPTION_HYPER_TWISTER = 563,
    STR_RIDE_DESCRIPTION_INVERTED_HAIRPIN_COASTER = 588,
    STR_RIDE_DESCRIPTION_INVERTED_IMPULSE_COASTER = 598,
    STR_RIDE_DESCRIPTION_INVERTED_ROLLER_COASTER = 515,
    STR_RIDE_DESCRIPTION_JUNIOR_ROLLER_COASTER = 516,
    STR_RIDE_DESCRIPTION_LAY_DOWN_ROLLER_COASTER = 574,
    STR_RIDE_DESCRIPTION_LIM_LAUNCHED_ROLLER_COASTER = 602,
    STR_RIDE_DESCRIPTION_LOOPING_ROLLER_COASTER = 527,
    STR_RIDE_DESCRIPTION_MINE_RIDE = 600,
    STR_RIDE_DESCRIPTION_MINE_TRAIN_COASTER = 529,
    STR_RIDE_DESCRIPTION_MINI_ROLLER_COASTER = 599,
    STR_RIDE_DESCRIPTION_MINI_SUSPENDED_COASTER = 519,
    STR_RIDE_DESCRIPTION_MULTI_DIMENSION_ROLLER_COASTER = 567,
    STR_RIDE_DESCRIPTION_REVERSER_ROLLER_COASTER = 577,
    STR_RIDE_DESCRIPTION_REVERSE_FREEFALL_COASTER = 554,
    STR_RIDE_DESCRIPTION_SIDE_FRICTION_ROLLER_COASTER = 565,
    STR_RIDE_DESCRIPTION_SINGLE_RAIL_ROLLER_COASTER = 604,
    STR_RIDE_DESCRIPTION_SPINNING_WILD_MOUSE = 6163,
    STR_RIDE_DESCRIPTION_SPIRAL_ROLLER_COASTER = 512,
    STR_RIDE_DESCRIPTION_STAND_UP_ROLLER_COASTER = 513,
    STR_RIDE_DESCRIPTION_STEEPLECHASE = 522,
    STR_RIDE_DESCRIPTION_SUSPENDED_SWINGING_COASTER = 514,
    STR_RIDE_DESCRIPTION_TWISTER_ROLLER_COASTER = 6116,
    STR_RIDE_DESCRIPTION_VERTICAL_DROP_ROLLER_COASTER = 556,
    STR_RIDE_DESCRIPTION_VIRGINIA_REEL = 571,
    STR_RIDE_DESCRIPTION_WATER_COASTER = 586,
    STR_RIDE_DESCRIPTION_WILD_MOUSE = 566,
    STR_RIDE_DESCRIPTION_WOODEN_ROLLER_COASTER = 564,
    STR_RIDE_DESCRIPTION_WOODEN_WILD_MOUSE = 521,

    // Gentle rides
    STR_RIDE_NAME_CAR_RIDE = 13,
    STR_RIDE_NAME_CIRCUS = 51,
    STR_RIDE_NAME_CROOKED_HOUSE = 73,
    STR_RIDE_NAME_DODGEMS = 27,
    STR_RIDE_NAME_FERRIS_WHEEL = 39,
    STR_RIDE_NAME_FLYING_SAUCERS = 72,
    STR_RIDE_NAME_GHOST_TRAIN = 52,
    STR_RIDE_NAME_HAUNTED_HOUSE = 49,
    STR_RIDE_NAME_MAZE = 22,
    STR_RIDE_NAME_MERRY_GO_ROUND = 35,
    STR_RIDE_NAME_MINI_GOLF = 69,
    STR_RIDE_NAME_MINI_HELICOPTERS = 63,
    STR_RIDE_NAME_MONORAIL_CYCLES = 74,
    STR_RIDE_NAME_MONSTER_TRUCKS = 6107,
    STR_RIDE_NAME_OBSERVATION_TOWER = 16,
    STR_RIDE_NAME_SPACE_RINGS = 43,
    STR_RIDE_NAME_SPIRAL_SLIDE = 23,
    STR_RIDE_DESCRIPTION_CAR_RIDE = 523,
    STR_RIDE_DESCRIPTION_CIRCUS = 561,
    STR_RIDE_DESCRIPTION_CROOKED_HOUSE = 583,
    STR_RIDE_DESCRIPTION_DODGEMS = 537,
    STR_RIDE_DESCRIPTION_FERRIS_WHEEL = 549,
    STR_RIDE_DESCRIPTION_FLYING_SAUCERS = 582,
    STR_RIDE_DESCRIPTION_GHOST_TRAIN = 562,
    STR_RIDE_DESCRIPTION_HAUNTED_HOUSE = 559,
    STR_RIDE_DESCRIPTION_MAZE = 532,
    STR_RIDE_DESCRIPTION_MERRY_GO_ROUND = 545,
    STR_RIDE_DESCRIPTION_MINI_GOLF = 579,
    STR_RIDE_DESCRIPTION_MINI_HELICOPTERS = 573,
    STR_RIDE_DESCRIPTION_MONORAIL_CYCLES = 584,
    STR_RIDE_DESCRIPTION_MONSTER_TRUCKS = 6115,
    STR_RIDE_DESCRIPTION_OBSERVATION_TOWER = 526,
    STR_RIDE_DESCRIPTION_SPACE_RINGS = 553,
    STR_RIDE_DESCRIPTION_SPIRAL_SLIDE = 533,

    // Shops
    STR_RIDE_NAME_CASH_MACHINE = 47,
    STR_RIDE_NAME_DRINK_STALL = 32,
    STR_RIDE_NAME_FIRST_AID = 50,
    STR_RIDE_NAME_FOOD_STALL = 30,
    STR_RIDE_NAME_INFORMATION_KIOSK = 37,
    STR_RIDE_NAME_SHOP = 34,
    STR_RIDE_NAME_TOILETS = 38,
    STR_RIDE_DESCRIPTION_CASH_MACHINE = 557,
    STR_RIDE_DESCRIPTION_DRINK_STALL = 542,
    STR_RIDE_DESCRIPTION_FIRST_AID = 560,
    STR_RIDE_DESCRIPTION_FOOD_STALL = 540,
    STR_RIDE_DESCRIPTION_INFORMATION_KIOSK = 547,
    STR_RIDE_DESCRIPTION_SHOP = 544,
    STR_RIDE_DESCRIPTION_TOILETS = 548,

    // Thrill rides
    STR_RIDE_NAME_3D_CINEMA = 41,
    STR_RIDE_NAME_ENTERPRISE = 83,
    STR_RIDE_NAME_GO_KARTS = 24,
    STR_RIDE_NAME_LAUNCHED_FREEFALL = 14,
    STR_RIDE_NAME_MAGIC_CARPET = 79,
    STR_RIDE_NAME_MOTION_SIMULATOR = 40,
    STR_RIDE_NAME_ROTO_DROP = 71,
    STR_RIDE_NAME_SWINGING_INVERTER_SHIP = 29,
    STR_RIDE_NAME_SWINGING_SHIP = 28,
    STR_RIDE_NAME_TOP_SPIN = 42,
    STR_RIDE_NAME_TWIST = 48,
    STR_RIDE_DESCRIPTION_3D_CINEMA = 551,
    STR_RIDE_DESCRIPTION_ENTERPRISE = 593,
    STR_RIDE_DESCRIPTION_GO_KARTS = 534,
    STR_RIDE_DESCRIPTION_LAUNCHED_FREEFALL = 524,
    STR_RIDE_DESCRIPTION_MAGIC_CARPET = 589,
    STR_RIDE_DESCRIPTION_MOTION_SIMULATOR = 550,
    STR_RIDE_DESCRIPTION_ROTO_DROP = 581,
    STR_RIDE_DESCRIPTION_SWINGING_INVERTER_SHIP = 539,
    STR_RIDE_DESCRIPTION_SWINGING_SHIP = 538,
    STR_RIDE_DESCRIPTION_TOP_SPIN = 552,
    STR_RIDE_DESCRIPTION_TWIST = 558,

    // Transport rides
    STR_RIDE_NAME_CHAIRLIFT = 20,
    STR_RIDE_NAME_LIFT = 45,
    STR_RIDE_NAME_MINIATURE_RAILWAY = 7,
    STR_RIDE_NAME_MONORAIL = 8,
    STR_RIDE_NAME_SUSPENDED_MONORAIL = 65,
    STR_RIDE_DESCRIPTION_CHAIRLIFT = 530,
    STR_RIDE_DESCRIPTION_LIFT = 555,
    STR_RIDE_DESCRIPTION_MINIATURE_RAILWAY = 517,
    STR_RIDE_DESCRIPTION_MONORAIL = 518,
    STR_RIDE_DESCRIPTION_SUSPENDED_MONORAIL = 575,

    // Water rides
    STR_RIDE_NAME_BOAT_HIRE = 10,
    STR_RIDE_NAME_DINGHY_SLIDE = 18,
    STR_RIDE_NAME_LOG_FLUME = 25,
    STR_RIDE_NAME_RIVER_RAFTS = 81,
    STR_RIDE_NAME_RIVER_RAPIDS = 26,
    STR_RIDE_NAME_SPLASH_BOATS = 62,
    STR_RIDE_NAME_SUBMARINE_RIDE = 80,
    STR_RIDE_DESCRIPTION_BOAT_HIRE = 520,
    STR_RIDE_DESCRIPTION_DINGHY_SLIDE = 528,
    STR_RIDE_DESCRIPTION_LOG_FLUME = 535,
    STR_RIDE_DESCRIPTION_RIVER_RAFTS = 591,
    STR_RIDE_DESCRIPTION_RIVER_RAPIDS = 536,
    STR_RIDE_DESCRIPTION_SPLASH_BOATS = 572,
    STR_RIDE_DESCRIPTION_SUBMARINE_RIDE = 590,

    // Other strings, used in RTDs
    STR_RIDE_CONSTRUCTION_O_SHAPED_ENCLOSED_TRACK_TIP = 1461,
    STR_RIDE_CONSTRUCTION_STANDARD_RC_TRACK_TIP = 3062,
    STR_RIDE_CONSTRUCTION_U_SHAPED_OPEN_TRACK_TIP = 1460,
    STR_RIDE_CONSTRUCTION_WATER_CHANNEL_TIP = 3063,
};
