@value = {}
@vowels = {}
@syn = {}

def vc(vows, blanks)
	vows += blanks * (42.0 / 98.0)
	ipart = vows.to_i
	fpart = vows - ipart
	
	return @vowels[7] if ipart == 7
	return @vowels[ipart] * (1 - fpart) + @vowels[ipart + 1] * fpart
end
	
def calc(rack)
	sum = 0
	vows = 0
	blanks = 0
	dupes = 0
	dpenalty = 0
	synergy = 0

	for i in 0..(rack.split(//).size - 2) do
		if rack.split(//)[i] == rack.split(//)[i + 1] then
			dupes += 1
			#puts "tile: " + rack.split(//)[i]
			dpenalty += @syn[rack.split(//)[i] + rack.split(//)[i]]
		end  
	end

	uniqtiles = rack.split(//).uniq
	for i in 0..(uniqtiles.size - 2) do
		for j in (i + 1)..(uniqtiles.size - 1) do
			pair = uniqtiles[i] + uniqtiles[j]
			synergy += @syn[pair]
		end
	end

	for tile in rack.split(//) do
		vows += 1 unless ("AEIOU".split(//) & [tile]) == []
		blanks += 1 if tile == "?"
		sum += @value[tile]
	end
	
	sum += vc(vows, blanks)

	#puts "rack: " + rack + " estimate: " + sum.to_s + " dupes: " + dupes.to_s

	return [sum, dupes, synergy, dpenalty]
end

for line in open("syn2") do
	tokens = line.strip.split(/ /)
	pair = tokens[0].split(//).sort.join
	equity = tokens[1].to_f
	puts "pair: " + pair + " equity: " + equity.to_s
	@syn[pair] = equity
end

for line in open("newaverages") do
	tokens = line.strip.split(/ /)
	tile = tokens[0]
	equity = tokens[1].to_f
	@value[tile] = equity
end

for line in open("vowelcon") do
	tokens = line.strip.split(/ /)
	vcount = tokens[0].to_i
	heuristic = tokens[1].to_f
	@vowels[vcount] = heuristic
end

for line in open("lame") do
 	tokens = line.strip.split(/ /)
	rack = tokens[0]
	equity = tokens[1]
	estimate = calc(rack)	
	puts rack + " " + equity.to_s + " " + estimate[0].to_s + " " + estimate[1].to_s + " " + estimate[2].to_s + " " + estimate[3].to_s
end
