/* This file is automatically generated by `parse-configuration'.
 * Do not modify it, edit `gtk-configuration.list' instead.
 */


#include "gtk-configuration.h"
#include "gtk-games.h"
#include "gui-back-end.h"
#include "utils.h"


static void	gtp_engine_defaults_init (void *section_structure);

#define		game_tree_view_defaults_init			NULL
#define		sgf_configuration_defaults_init			NULL

static void	go_board_appearance_defaults_init (void *section_structure);
static void	amazons_board_appearance_defaults_init (void *section_structure);
static void	reversi_board_appearance_defaults_init (void *section_structure);

#define		gtk_ui_defaults_init				NULL

static void	new_game_defaults_init (void *section_structure);

#define		new_go_game_defaults_init			NULL
#define		new_amazons_game_defaults_init			NULL
#define		new_reversi_game_defaults_init			NULL

static void	new_game_record_defaults_init (void *section_structure);

#define		new_go_game_record_defaults_init		NULL
#define		new_amazons_game_record_defaults_init		NULL
#define		new_reversi_game_record_defaults_init		NULL
#define		find_dialog_defaults_init			NULL


#define		game_tree_view_dispose				NULL
#define		sgf_configuration_dispose			NULL

static void	board_appearance_dispose (void *section_structure);
static void	amazons_board_appearance_dispose (void *section_structure);

#define		gtk_ui_configuration_dispose			NULL

static void	new_game_configuration_dispose (void *section_structure);

#define		time_control_configuration_dispose		NULL
#define		new_go_game_configuration_dispose		NULL
#define		new_amazons_game_configuration_dispose		NULL
#define		new_reversi_game_configuration_dispose		NULL

static void	new_game_record_configuration_dispose (void *section_structure);

#define		new_go_game_record_configuration_dispose	NULL
#define		new_amazons_game_record_configuration_dispose	NULL
#define		new_reversi_game_record_configuration_dispose	NULL

static void	find_dialog_configuration_dispose (void *section_structure);


GtpEngineList gtp_engines = STATIC_GTP_ENGINE_LIST;


GameTreeView game_tree_view = {
  1,
  SHOW_GAME_TREE_AUTOMATICALLY,
  TRACK_CURRENT_NODE_AUTOMATICALLY,
  0
};


SgfConfiguration sgf_configuration = {
  1
};


BoardAppearance go_board_appearance = {
  1,
  NULL,
  { 219, 182, 101 },
  { 0, 0, 0 },
  NULL,
  1,
  0.65,
  1,
  0.8,
  {
    { 24, 96, 16 },
    { 230, 216, 198 },
    { 80, 80, 80 }
  }
};


AmazonsBoardAppearance amazons_board_appearance = {
  {
    1,
    NULL,
    { 219, 182, 101 },
    { 0, 0, 0 },
    NULL,
    1,
    0.65,
    1,
    0.8,
    {
      { 34, 34, 34 },
      { 230, 216, 198 },
      { 80, 80, 80 }
    }
  },
  { 96, 64, 0 },
  0.4
};


BoardAppearance reversi_board_appearance = {
  0,
  NULL,
  { 8, 120, 52 },
  { 204, 238, 187 },
  NULL,
  1,
  0.65,
  1,
  0.8,
  {
    { 204, 238, 187 },
    { 230, 216, 198 },
    { 80, 80, 80 }
  }
};


GtkUIConfiguration gtk_ui_configuration = {
  1,
  1,
  TOOLBAR_STYLE_DEFAULT,
  1,
  TOOLBAR_STYLE_DEFAULT,
  1,
  TOOLBAR_STYLE_DEFAULT,
  1
};


NewGameConfiguration new_game_configuration = {
  NULL,
  {
    NULL,
    NULL
  },
  {
    0,
    0
  },
  {
    NULL,
    NULL
  }
};


NewGoGameConfiguration new_go_game_configuration = {
  19,
  1,
  0,
  0,
  6.5,
  {
    0,
    0,
    1800,
    30,
    600,
    600,
    25
  }
};


NewAmazonsGameConfiguration new_amazons_game_configuration = {
  10,
  {
    0,
    0,
    900,
    20,
    0,
    300,
    10
  }
};


NewReversiGameConfiguration new_reversi_game_configuration = {
  8,
  {
    0,
    0,
    600,
    15,
    0,
    300,
    10
  }
};


NewGameRecordConfiguration new_game_record_configuration = {
  NULL,
  {
    NULL,
    NULL
  },
  NULL
};


NewGoGameRecordConfiguration new_go_game_record_configuration = {
  19,
  1, 0,
  1,
  0, 6.5
};


NewAmazonsGameRecordConfiguration new_amazons_game_record_configuration = {
  10
};


NewReversiGameRecordConfiguration new_reversi_game_record_configuration = {
  8
};


FindDialogConfiguration find_dialog_configuration = {
  STATIC_STRING_LIST,
  0,
  0,
  1,
  1,
  SEARCH_EVERYWHERE,
  0
};


static const ConfigurationValue gtp_engine_section_values[] = {
  { "Screen name format", VALUE_TYPE_STRING,
    STRUCTURE_FIELD_OFFSET (GtpEngineListItem, screen_name_format),
    NULL },
  { "Name", VALUE_TYPE_STRING,
    STRUCTURE_FIELD_OFFSET (GtpEngineListItem, name),
    NULL },
  { "Version", VALUE_TYPE_STRING,
    STRUCTURE_FIELD_OFFSET (GtpEngineListItem, version),
    NULL },
  { "Site configuration name", VALUE_TYPE_STRING,
    STRUCTURE_FIELD_OFFSET (GtpEngineListItem, site_configuration_name),
    NULL },
  { "Hidden by user", VALUE_TYPE_BOOLEAN_WRITE_TRUE_ONLY,
    STRUCTURE_FIELD_OFFSET (GtpEngineListItem, is_hidden),
    NULL },
  { "Command line", VALUE_TYPE_STRING,
    STRUCTURE_FIELD_OFFSET (GtpEngineListItem, command_line),
    NULL },
  { "Supported games", VALUE_TYPE_STRING_LIST,
    STRUCTURE_FIELD_OFFSET (GtpEngineListItem, supported_games),
    NULL }
};


static const ConfigurationValue game_tree_view_values[] = {
  { "Show tooltips", VALUE_TYPE_BOOLEAN,
    STRUCTURE_FIELD_OFFSET (GameTreeView, show_tooltips),
    NULL },
  { "Show game tree", VALUE_TYPE_ENUMERATION,
    STRUCTURE_FIELD_OFFSET (GameTreeView, show_game_tree),
    "Always\000\0"
    "Auto\000Automatically\000\0"
    "Never\000\0" },
  { "Track current node", VALUE_TYPE_ENUMERATION,
    STRUCTURE_FIELD_OFFSET (GameTreeView, track_current_node),
    "Always\000\0"
    "Auto\000Automatically\000\0"
    "Never\000\0" },
  { "Center on current node", VALUE_TYPE_BOOLEAN,
    STRUCTURE_FIELD_OFFSET (GameTreeView, center_on_current_node),
    NULL }
};


static const ConfigurationValue sgf_configuration_values[] = {
  { "Force UTF-8", VALUE_TYPE_BOOLEAN,
    STRUCTURE_FIELD_OFFSET (SgfConfiguration, force_utf8),
    NULL }
};


static const ConfigurationValue board_appearance_values[] = {
  { "Use background texture", VALUE_TYPE_BOOLEAN,
    STRUCTURE_FIELD_OFFSET (BoardAppearance, use_background_texture),
    NULL },
  { "Background texture", VALUE_TYPE_STRING,
    STRUCTURE_FIELD_OFFSET (BoardAppearance, background_texture),
    NULL },
  { "Background color", VALUE_TYPE_COLOR,
    STRUCTURE_FIELD_OFFSET (BoardAppearance, background_color),
    NULL },
  { "Grid and labels color", VALUE_TYPE_COLOR,
    STRUCTURE_FIELD_OFFSET (BoardAppearance, grid_and_labels_color),
    NULL },
  { "Markup theme", VALUE_TYPE_STRING,
    STRUCTURE_FIELD_OFFSET (BoardAppearance, markup_theme),
    NULL },
  { "Use theme defaults", VALUE_TYPE_BOOLEAN,
    STRUCTURE_FIELD_OFFSET (BoardAppearance, use_theme_defaults),
    NULL },
  { "Markup size", VALUE_TYPE_REAL,
    STRUCTURE_FIELD_OFFSET (BoardAppearance, markup_size),
    NULL },
  { "Markup size is relative", VALUE_TYPE_BOOLEAN,
    STRUCTURE_FIELD_OFFSET (BoardAppearance, markup_size_is_relative),
    NULL },
  { "Markup opacity", VALUE_TYPE_REAL,
    STRUCTURE_FIELD_OFFSET (BoardAppearance, markup_opacity),
    NULL },
  { "Markup color on white", VALUE_TYPE_COLOR,
    STRUCTURE_FIELD_OFFSET (BoardAppearance, markup_colors[2]),
    NULL },
  { "Markup color on black", VALUE_TYPE_COLOR,
    STRUCTURE_FIELD_OFFSET (BoardAppearance, markup_colors[1]),
    NULL },
  { "Markup color on other", VALUE_TYPE_COLOR,
    STRUCTURE_FIELD_OFFSET (BoardAppearance, markup_colors[0]),
    NULL }
};


static const ConfigurationValue amazons_board_appearance_values[] = {
  { "Use background texture", VALUE_TYPE_BOOLEAN,
    STRUCTURE_FIELD_OFFSET (AmazonsBoardAppearance, board_appearance.use_background_texture),
    NULL },
  { "Background texture", VALUE_TYPE_STRING,
    STRUCTURE_FIELD_OFFSET (AmazonsBoardAppearance, board_appearance.background_texture),
    NULL },
  { "Background color", VALUE_TYPE_COLOR,
    STRUCTURE_FIELD_OFFSET (AmazonsBoardAppearance, board_appearance.background_color),
    NULL },
  { "Checkerboard pattern color", VALUE_TYPE_COLOR,
    STRUCTURE_FIELD_OFFSET (AmazonsBoardAppearance, checkerboard_pattern_color),
    NULL },
  { "Checkerboard pattern opacity", VALUE_TYPE_REAL,
    STRUCTURE_FIELD_OFFSET (AmazonsBoardAppearance, checkerboard_pattern_opacity),
    NULL },
  { "Grid and labels color", VALUE_TYPE_COLOR,
    STRUCTURE_FIELD_OFFSET (AmazonsBoardAppearance, board_appearance.grid_and_labels_color),
    NULL },
  { "Markup theme", VALUE_TYPE_STRING,
    STRUCTURE_FIELD_OFFSET (AmazonsBoardAppearance, board_appearance.markup_theme),
    NULL },
  { "Use theme defaults", VALUE_TYPE_BOOLEAN,
    STRUCTURE_FIELD_OFFSET (AmazonsBoardAppearance, board_appearance.use_theme_defaults),
    NULL },
  { "Markup size", VALUE_TYPE_REAL,
    STRUCTURE_FIELD_OFFSET (AmazonsBoardAppearance, board_appearance.markup_size),
    NULL },
  { "Markup size is relative", VALUE_TYPE_BOOLEAN,
    STRUCTURE_FIELD_OFFSET (AmazonsBoardAppearance, board_appearance.markup_size_is_relative),
    NULL },
  { "Markup opacity", VALUE_TYPE_REAL,
    STRUCTURE_FIELD_OFFSET (AmazonsBoardAppearance, board_appearance.markup_opacity),
    NULL },
  { "Markup color on white", VALUE_TYPE_COLOR,
    STRUCTURE_FIELD_OFFSET (AmazonsBoardAppearance, board_appearance.markup_colors[2]),
    NULL },
  { "Markup color on black", VALUE_TYPE_COLOR,
    STRUCTURE_FIELD_OFFSET (AmazonsBoardAppearance, board_appearance.markup_colors[1]),
    NULL },
  { "Markup color on other", VALUE_TYPE_COLOR,
    STRUCTURE_FIELD_OFFSET (AmazonsBoardAppearance, board_appearance.markup_colors[0]),
    NULL }
};


static const ConfigurationValue gtk_ui_section_values[] = {
  { "Use GtkFileChooser if possible", VALUE_TYPE_BOOLEAN,
    STRUCTURE_FIELD_OFFSET (GtkUIConfiguration, use_gtk_file_chooser),
    NULL },
  { "Show main toolbar", VALUE_TYPE_BOOLEAN,
    STRUCTURE_FIELD_OFFSET (GtkUIConfiguration, show_main_toolbar),
    NULL },
  { "Main toolbar style", VALUE_TYPE_ENUMERATION,
    STRUCTURE_FIELD_OFFSET (GtkUIConfiguration, main_toolbar_style),
    "Default\000Desktop\000Desktop default\000System\000System default\000\0"
    "Both\000Both vertically\000Vertically\000Text below icons\000\0"
    "Both horizontally\000Horizontally\000Text beside icons\000Text beside important icons\000\0"
    "Icons only\000Icons\000\0"
    "Text only\000Text\000\0" },
  { "Show editing toolbar", VALUE_TYPE_BOOLEAN,
    STRUCTURE_FIELD_OFFSET (GtkUIConfiguration, show_editing_toolbar),
    NULL },
  { "Editing toolbar style", VALUE_TYPE_ENUMERATION,
    STRUCTURE_FIELD_OFFSET (GtkUIConfiguration, editing_toolbar_style),
    "Default\000Desktop\000Desktop default\000System\000System default\000\0"
    "Both\000Both vertically\000Vertically\000Text below icons\000\0"
    "Both horizontally\000Horizontally\000Text beside icons\000Text beside important icons\000\0"
    "Icons only\000Icons\000\0"
    "Text only\000Text\000\0" },
  { "Show navigation toolbar", VALUE_TYPE_BOOLEAN,
    STRUCTURE_FIELD_OFFSET (GtkUIConfiguration, show_navigation_toolbar),
    NULL },
  { "Navigation toolbar style", VALUE_TYPE_ENUMERATION,
    STRUCTURE_FIELD_OFFSET (GtkUIConfiguration, navigation_toolbar_style),
    "Default\000Desktop\000Desktop default\000System\000System default\000\0"
    "Both\000Both vertically\000Vertically\000Text below icons\000\0"
    "Both horizontally\000Horizontally\000Text beside icons\000Text beside important icons\000\0"
    "Icons only\000Icons\000\0"
    "Text only\000Text\000\0" },
  { "Show game action buttons", VALUE_TYPE_BOOLEAN,
    STRUCTURE_FIELD_OFFSET (GtkUIConfiguration, show_game_action_buttons),
    NULL }
};


static const ConfigurationValue new_game_section_values[] = {
  { "Game", VALUE_TYPE_STRING,
    STRUCTURE_FIELD_OFFSET (NewGameConfiguration, game_name),
    NULL },
  { "White player name", VALUE_TYPE_STRING,
    STRUCTURE_FIELD_OFFSET (NewGameConfiguration, player_names[WHITE_INDEX]),
    NULL },
  { "White is computer", VALUE_TYPE_BOOLEAN,
    STRUCTURE_FIELD_OFFSET (NewGameConfiguration, player_is_computer[WHITE_INDEX]),
    NULL },
  { "Engine playing white", VALUE_TYPE_STRING,
    STRUCTURE_FIELD_OFFSET (NewGameConfiguration, engine_names[WHITE_INDEX]),
    NULL },
  { "Black player name", VALUE_TYPE_STRING,
    STRUCTURE_FIELD_OFFSET (NewGameConfiguration, player_names[BLACK_INDEX]),
    NULL },
  { "Black is computer", VALUE_TYPE_BOOLEAN,
    STRUCTURE_FIELD_OFFSET (NewGameConfiguration, player_is_computer[BLACK_INDEX]),
    NULL },
  { "Engine playing black", VALUE_TYPE_STRING,
    STRUCTURE_FIELD_OFFSET (NewGameConfiguration, engine_names[BLACK_INDEX]),
    NULL }
};


static const ConfigurationValue new_go_game_section_values[] = {
  { "Board size", VALUE_TYPE_INT,
    STRUCTURE_FIELD_OFFSET (NewGoGameConfiguration, board_size),
    NULL },
  { "Handicap is fixed", VALUE_TYPE_BOOLEAN,
    STRUCTURE_FIELD_OFFSET (NewGoGameConfiguration, handicap_is_fixed),
    NULL },
  { "Fixed handicap", VALUE_TYPE_INT,
    STRUCTURE_FIELD_OFFSET (NewGoGameConfiguration, fixed_handicap),
    NULL },
  { "Free handicap", VALUE_TYPE_INT,
    STRUCTURE_FIELD_OFFSET (NewGoGameConfiguration, free_handicap),
    NULL },
  { "Komi", VALUE_TYPE_REAL,
    STRUCTURE_FIELD_OFFSET (NewGoGameConfiguration, komi),
    NULL },
  { "Time control type", VALUE_TYPE_INT,
    STRUCTURE_FIELD_OFFSET (NewGoGameConfiguration, time_control.type),
    NULL },
  { "Keep track of total time", VALUE_TYPE_INT,
    STRUCTURE_FIELD_OFFSET (NewGoGameConfiguration, time_control.track_total_time),
    NULL },
  { "Time limit for game", VALUE_TYPE_TIME,
    STRUCTURE_FIELD_OFFSET (NewGoGameConfiguration, time_control.game_time_limit),
    NULL },
  { "Time limit for move", VALUE_TYPE_TIME,
    STRUCTURE_FIELD_OFFSET (NewGoGameConfiguration, time_control.move_time_limit),
    NULL },
  { "Main time", VALUE_TYPE_TIME,
    STRUCTURE_FIELD_OFFSET (NewGoGameConfiguration, time_control.main_time),
    NULL },
  { "Overtime period length", VALUE_TYPE_TIME,
    STRUCTURE_FIELD_OFFSET (NewGoGameConfiguration, time_control.overtime_period_length),
    NULL },
  { "Moves per overtime", VALUE_TYPE_INT,
    STRUCTURE_FIELD_OFFSET (NewGoGameConfiguration, time_control.moves_per_overtime),
    NULL }
};


static const ConfigurationValue new_amazons_game_section_values[] = {
  { "Board size", VALUE_TYPE_INT,
    STRUCTURE_FIELD_OFFSET (NewAmazonsGameConfiguration, board_size),
    NULL },
  { "Time control type", VALUE_TYPE_INT,
    STRUCTURE_FIELD_OFFSET (NewAmazonsGameConfiguration, time_control.type),
    NULL },
  { "Keep track of total time", VALUE_TYPE_INT,
    STRUCTURE_FIELD_OFFSET (NewAmazonsGameConfiguration, time_control.track_total_time),
    NULL },
  { "Time limit for game", VALUE_TYPE_TIME,
    STRUCTURE_FIELD_OFFSET (NewAmazonsGameConfiguration, time_control.game_time_limit),
    NULL },
  { "Time limit for move", VALUE_TYPE_TIME,
    STRUCTURE_FIELD_OFFSET (NewAmazonsGameConfiguration, time_control.move_time_limit),
    NULL },
  { "Main time", VALUE_TYPE_TIME,
    STRUCTURE_FIELD_OFFSET (NewAmazonsGameConfiguration, time_control.main_time),
    NULL },
  { "Overtime period length", VALUE_TYPE_TIME,
    STRUCTURE_FIELD_OFFSET (NewAmazonsGameConfiguration, time_control.overtime_period_length),
    NULL },
  { "Moves per overtime", VALUE_TYPE_INT,
    STRUCTURE_FIELD_OFFSET (NewAmazonsGameConfiguration, time_control.moves_per_overtime),
    NULL }
};


static const ConfigurationValue new_reversi_game_section_values[] = {
  { "Board size", VALUE_TYPE_INT,
    STRUCTURE_FIELD_OFFSET (NewReversiGameConfiguration, board_size),
    NULL },
  { "Time control type", VALUE_TYPE_INT,
    STRUCTURE_FIELD_OFFSET (NewReversiGameConfiguration, time_control.type),
    NULL },
  { "Keep track of total time", VALUE_TYPE_INT,
    STRUCTURE_FIELD_OFFSET (NewReversiGameConfiguration, time_control.track_total_time),
    NULL },
  { "Time limit for game", VALUE_TYPE_TIME,
    STRUCTURE_FIELD_OFFSET (NewReversiGameConfiguration, time_control.game_time_limit),
    NULL },
  { "Time limit for move", VALUE_TYPE_TIME,
    STRUCTURE_FIELD_OFFSET (NewReversiGameConfiguration, time_control.move_time_limit),
    NULL },
  { "Main time", VALUE_TYPE_TIME,
    STRUCTURE_FIELD_OFFSET (NewReversiGameConfiguration, time_control.main_time),
    NULL },
  { "Overtime period length", VALUE_TYPE_TIME,
    STRUCTURE_FIELD_OFFSET (NewReversiGameConfiguration, time_control.overtime_period_length),
    NULL },
  { "Moves per overtime", VALUE_TYPE_INT,
    STRUCTURE_FIELD_OFFSET (NewReversiGameConfiguration, time_control.moves_per_overtime),
    NULL }
};


static const ConfigurationValue new_game_record_section_values[] = {
  { "Game", VALUE_TYPE_STRING,
    STRUCTURE_FIELD_OFFSET (NewGameRecordConfiguration, game_name),
    NULL },
  { "White player name", VALUE_TYPE_STRING,
    STRUCTURE_FIELD_OFFSET (NewGameRecordConfiguration, player_names[WHITE_INDEX]),
    NULL },
  { "Black player name", VALUE_TYPE_STRING,
    STRUCTURE_FIELD_OFFSET (NewGameRecordConfiguration, player_names[BLACK_INDEX]),
    NULL },
  { "Game name", VALUE_TYPE_STRING,
    STRUCTURE_FIELD_OFFSET (NewGameRecordConfiguration, game_record_name),
    NULL }
};


static const ConfigurationValue new_go_game_record_section_values[] = {
  { "Board size", VALUE_TYPE_INT,
    STRUCTURE_FIELD_OFFSET (NewGoGameRecordConfiguration, board_size),
    NULL },
  { "Handicap", VALUE_TYPE_INT | VALUE_TYPE_IS_NULLABLE,
    STRUCTURE_FIELD_OFFSET (NewGoGameRecordConfiguration, handicap),
    NULL },
  { "Place handicap stones", VALUE_TYPE_BOOLEAN,
    STRUCTURE_FIELD_OFFSET (NewGoGameRecordConfiguration, place_handicap_stones),
    NULL },
  { "Komi", VALUE_TYPE_REAL | VALUE_TYPE_IS_NULLABLE,
    STRUCTURE_FIELD_OFFSET (NewGoGameRecordConfiguration, komi),
    NULL }
};


static const ConfigurationValue new_amazons_game_record_section_values[] = {
  { "Board size", VALUE_TYPE_INT,
    STRUCTURE_FIELD_OFFSET (NewAmazonsGameRecordConfiguration, board_size),
    NULL }
};


static const ConfigurationValue new_reversi_game_record_section_values[] = {
  { "Board size", VALUE_TYPE_INT,
    STRUCTURE_FIELD_OFFSET (NewReversiGameRecordConfiguration, board_size),
    NULL }
};


static const ConfigurationValue find_dialog_section_values[] = {
  { "Latest search strings", VALUE_TYPE_STRING_LIST,
    STRUCTURE_FIELD_OFFSET (FindDialogConfiguration, latest_search_strings),
    NULL },
  { "Case sensitive", VALUE_TYPE_BOOLEAN,
    STRUCTURE_FIELD_OFFSET (FindDialogConfiguration, case_sensitive),
    NULL },
  { "Whole words only", VALUE_TYPE_BOOLEAN,
    STRUCTURE_FIELD_OFFSET (FindDialogConfiguration, whole_words_only),
    NULL },
  { "Wrap around", VALUE_TYPE_BOOLEAN,
    STRUCTURE_FIELD_OFFSET (FindDialogConfiguration, wrap_around),
    NULL },
  { "Search whole game tree", VALUE_TYPE_BOOLEAN,
    STRUCTURE_FIELD_OFFSET (FindDialogConfiguration, search_whole_game_tree),
    NULL },
  { "Search in", VALUE_TYPE_ENUMERATION,
    STRUCTURE_FIELD_OFFSET (FindDialogConfiguration, search_in),
    "Nodes and comments\000Everywhere\000Both\000\0"
    "Comments\000Comments only\000\0"
    "Node names\000Node names only\000\0" },
  { "Auto-close search dialog", VALUE_TYPE_BOOLEAN,
    STRUCTURE_FIELD_OFFSET (FindDialogConfiguration, close_automatically),
    NULL }
};


const ConfigurationSection gtk_configuration_sections[] = {
  { "GTP Engine", 1,
    &gtp_engines,
    gtp_engine_defaults_init, string_list_empty,
    gtp_engine_section_values,
    sizeof gtp_engine_section_values / sizeof (ConfigurationValue) },
  { "Game Tree View", 0,
    &game_tree_view,
    game_tree_view_defaults_init, game_tree_view_dispose,
    game_tree_view_values,
    sizeof game_tree_view_values / sizeof (ConfigurationValue) },
  { "SGF", 0,
    &sgf_configuration,
    sgf_configuration_defaults_init, sgf_configuration_dispose,
    sgf_configuration_values,
    sizeof sgf_configuration_values / sizeof (ConfigurationValue) },
  { "Go Board Appearance", 0,
    &go_board_appearance,
    go_board_appearance_defaults_init, board_appearance_dispose,
    board_appearance_values,
    sizeof board_appearance_values / sizeof (ConfigurationValue) },
  { "Amazons Board Appearance", 0,
    &amazons_board_appearance,
    amazons_board_appearance_defaults_init, amazons_board_appearance_dispose,
    amazons_board_appearance_values,
    sizeof amazons_board_appearance_values / sizeof (ConfigurationValue) },
  { "Reversi Board Appearance", 0,
    &reversi_board_appearance,
    reversi_board_appearance_defaults_init, board_appearance_dispose,
    board_appearance_values,
    sizeof board_appearance_values / sizeof (ConfigurationValue) },
  { "GTK+ User Interface", 0,
    &gtk_ui_configuration,
    gtk_ui_defaults_init, gtk_ui_configuration_dispose,
    gtk_ui_section_values,
    sizeof gtk_ui_section_values / sizeof (ConfigurationValue) },
  { "New Game Parameters", 0,
    &new_game_configuration,
    new_game_defaults_init, new_game_configuration_dispose,
    new_game_section_values,
    sizeof new_game_section_values / sizeof (ConfigurationValue) },
  { "New Go Game Parameters", 0,
    &new_go_game_configuration,
    new_go_game_defaults_init, new_go_game_configuration_dispose,
    new_go_game_section_values,
    sizeof new_go_game_section_values / sizeof (ConfigurationValue) },
  { "New Amazons Game Parameters", 0,
    &new_amazons_game_configuration,
    new_amazons_game_defaults_init, new_amazons_game_configuration_dispose,
    new_amazons_game_section_values,
    sizeof new_amazons_game_section_values / sizeof (ConfigurationValue) },
  { "New Reversi Game Parameters", 0,
    &new_reversi_game_configuration,
    new_reversi_game_defaults_init, new_reversi_game_configuration_dispose,
    new_reversi_game_section_values,
    sizeof new_reversi_game_section_values / sizeof (ConfigurationValue) },
  { "New Game Record Parameters", 0,
    &new_game_record_configuration,
    new_game_record_defaults_init, new_game_record_configuration_dispose,
    new_game_record_section_values,
    sizeof new_game_record_section_values / sizeof (ConfigurationValue) },
  { "New Go Game Record Parameters", 0,
    &new_go_game_record_configuration,
    new_go_game_record_defaults_init, new_go_game_record_configuration_dispose,
    new_go_game_record_section_values,
    sizeof new_go_game_record_section_values / sizeof (ConfigurationValue) },
  { "New Amazons Game Record Parameters", 0,
    &new_amazons_game_record_configuration,
    new_amazons_game_record_defaults_init, new_amazons_game_record_configuration_dispose,
    new_amazons_game_record_section_values,
    sizeof new_amazons_game_record_section_values / sizeof (ConfigurationValue) },
  { "New Reversi Game Record Parameters", 0,
    &new_reversi_game_record_configuration,
    new_reversi_game_record_defaults_init, new_reversi_game_record_configuration_dispose,
    new_reversi_game_record_section_values,
    sizeof new_reversi_game_record_section_values / sizeof (ConfigurationValue) },
  { "Find Dialog Parameters", 0,
    &find_dialog_configuration,
    find_dialog_defaults_init, find_dialog_configuration_dispose,
    find_dialog_section_values,
    sizeof find_dialog_section_values / sizeof (ConfigurationValue) }
};


static void
gtp_engine_defaults_init (void *section_structure)
{
  GtpEngineListItem *structure = (GtpEngineListItem *) section_structure;

  structure->screen_name_format	= utils_duplicate_string ("%n %v");
  structure->name		= NULL;
  structure->version		= NULL;
  structure->site_configuration_name
    = NULL;
  structure->is_hidden		= 0;
  structure->command_line	= NULL;
  string_list_init (&structure->supported_games);
}


static void
go_board_appearance_defaults_init (void *section_structure)
{
  BoardAppearance *structure = (BoardAppearance *) section_structure;

  structure->background_texture	= utils_duplicate_string ("/usr/local/share/quarry/textures/wood1.jpg");
  structure->markup_theme	= utils_duplicate_string ("Default");
}


static void
amazons_board_appearance_defaults_init (void *section_structure)
{
  AmazonsBoardAppearance *structure = (AmazonsBoardAppearance *) section_structure;

  structure->board_appearance.background_texture
    = utils_duplicate_string ("/usr/local/share/quarry/textures/wood1.jpg");
  structure->board_appearance.markup_theme
    = utils_duplicate_string ("Default");
}


static void
reversi_board_appearance_defaults_init (void *section_structure)
{
  BoardAppearance *structure = (BoardAppearance *) section_structure;

  structure->markup_theme	= utils_duplicate_string ("Default");
}


static void
new_game_defaults_init (void *section_structure)
{
  NewGameConfiguration *structure = (NewGameConfiguration *) section_structure;

  structure->game_name		= utils_duplicate_string ("Go");
  structure->player_names[BLACK_INDEX]
    = utils_duplicate_string (user_real_name);
  structure->player_names[WHITE_INDEX]
    = utils_duplicate_string (user_real_name);
}


static void
new_game_record_defaults_init (void *section_structure)
{
  NewGameRecordConfiguration *structure = (NewGameRecordConfiguration *) section_structure;

  structure->game_name		= utils_duplicate_string ("Go");
  structure->player_names[BLACK_INDEX]
    = utils_duplicate_string ("Black");
  structure->player_names[WHITE_INDEX]
    = utils_duplicate_string ("White");
}


void
gtp_engine_list_item_dispose (GtpEngineListItem *item)
{
  utils_free (item->screen_name_format);
  utils_free (item->name);
  utils_free (item->version);
  utils_free (item->site_configuration_name);
  utils_free (item->command_line);
  string_list_empty (&item->supported_games);
}


static void
board_appearance_dispose (void *section_structure)
{
  BoardAppearance *structure = (BoardAppearance *) section_structure;

  utils_free (structure->background_texture);
  utils_free (structure->markup_theme);
}


static void
amazons_board_appearance_dispose (void *section_structure)
{
  AmazonsBoardAppearance *structure = (AmazonsBoardAppearance *) section_structure;

  board_appearance_dispose (&structure->board_appearance);
}


static void
new_game_configuration_dispose (void *section_structure)
{
  NewGameConfiguration *structure = (NewGameConfiguration *) section_structure;

  utils_free (structure->game_name);
  utils_free (structure->player_names[BLACK_INDEX]);
  utils_free (structure->player_names[WHITE_INDEX]);
  utils_free (structure->engine_names[BLACK_INDEX]);
  utils_free (structure->engine_names[WHITE_INDEX]);
}


static void
new_game_record_configuration_dispose (void *section_structure)
{
  NewGameRecordConfiguration *structure = (NewGameRecordConfiguration *) section_structure;

  utils_free (structure->game_name);
  utils_free (structure->player_names[BLACK_INDEX]);
  utils_free (structure->player_names[WHITE_INDEX]);
  utils_free (structure->game_record_name);
}


static void
find_dialog_configuration_dispose (void *section_structure)
{
  FindDialogConfiguration *structure = (FindDialogConfiguration *) section_structure;

  string_list_empty (&structure->latest_search_strings);
}
