/* This file is automatically generated by `parse-configuration'.
 * Do not modify it, edit `gtk-configuration.list' instead.
 */


#ifndef QUARRY_GTK_CONFIGURATION_H
#define QUARRY_GTK_CONFIGURATION_H


#include "configuration.h"
#include "board.h"
#include "utils.h"


typedef struct _GtpEngineListItem	GtpEngineListItem;
typedef struct _GtpEngineList		GtpEngineList;

struct _GtpEngineListItem {
  GtpEngineListItem		*next;
  char				*screen_name;

  char				*screen_name_format;
  char				*name;
  char				*version;
  char				*site_configuration_name;
  int				 is_hidden;
  char				*command_line;
  StringList			 supported_games;
};

struct _GtpEngineList {
  GtpEngineListItem		*first;
  GtpEngineListItem		*last;

  int				 item_size;
  StringListItemDispose		 item_dispose;
};


#define gtp_engine_list_new()						\
  string_list_new_derived (sizeof (GtpEngineListItem),			\
			  ((StringListItemDispose)			\
			   gtp_engine_list_item_dispose))

#define gtp_engine_list_init(list)					\
  string_list_init_derived ((list), sizeof (GtpEngineListItem),		\
			   ((StringListItemDispose)			\
			    gtp_engine_list_item_dispose))

#define STATIC_GTP_ENGINE_LIST						\
  STATIC_STRING_LIST_DERIVED (GtpEngineListItem,				\
			     gtp_engine_list_item_dispose)

void		gtp_engine_list_item_dispose (GtpEngineListItem *item);


#define gtp_engine_list_get_item(list, item_index)			\
  ((GtpEngineListItem *)						\
   string_list_get_item ((list), (item_index)))

#define gtp_engine_list_find(list, screen_name)				\
  ((GtpEngineListItem *) string_list_find ((list), (screen_name)))

#define gtp_engine_list_find_after_notch(list, screen_name, notch)	\
  ((GtpEngineListItem *)						\
   string_list_find_after_notch ((list), (screen_name), (notch)))


typedef struct _GameTreeView		GameTreeView;

struct _GameTreeView {
  int				 show_tooltips;
  int				 show_game_tree;
  int				 track_current_node;
  int				 center_on_current_node;
};


typedef struct _SgfConfiguration	SgfConfiguration;

struct _SgfConfiguration {
  int				 force_utf8;
};


typedef struct _BoardAppearance		BoardAppearance;

struct _BoardAppearance {
  int				 use_background_texture;
  char				*background_texture;
  QuarryColor			 background_color;
  QuarryColor			 grid_and_labels_color;
  char				*markup_theme;
  int				 use_theme_defaults;
  double			 markup_size;
  int				 markup_size_is_relative;
  double			 markup_opacity;
  QuarryColor			 markup_colors[3];
};


typedef struct _AmazonsBoardAppearance	AmazonsBoardAppearance;

struct _AmazonsBoardAppearance {
  BoardAppearance		 board_appearance;
  QuarryColor			 checkerboard_pattern_color;
  double			 checkerboard_pattern_opacity;
};


typedef struct _GtkUIConfiguration	GtkUIConfiguration;

struct _GtkUIConfiguration {
  int				 use_gtk_file_chooser;
  int				 show_main_toolbar;
  int				 main_toolbar_style;
  int				 show_editing_toolbar;
  int				 editing_toolbar_style;
  int				 show_navigation_toolbar;
  int				 navigation_toolbar_style;
  int				 show_game_action_buttons;
};


typedef struct _NewGameConfiguration	NewGameConfiguration;

struct _NewGameConfiguration {
  char				*game_name;
  char				*player_names[NUM_COLORS];
  int				 player_is_computer[NUM_COLORS];
  char				*engine_names[NUM_COLORS];
};


typedef struct _TimeControlConfiguration TimeControlConfiguration;

struct _TimeControlConfiguration {
  int				 type;
  int				 track_total_time;
  int				 game_time_limit;
  int				 move_time_limit;
  int				 main_time;
  int				 overtime_period_length;
  int				 moves_per_overtime;
};


typedef struct _NewGoGameConfiguration	NewGoGameConfiguration;

struct _NewGoGameConfiguration {
  int				 board_size;
  int				 handicap_is_fixed;
  int				 fixed_handicap;
  int				 free_handicap;
  double			 komi;
  TimeControlConfiguration	 time_control;
};


typedef struct _NewAmazonsGameConfiguration NewAmazonsGameConfiguration;

struct _NewAmazonsGameConfiguration {
  int				 board_size;
  TimeControlConfiguration	 time_control;
};


typedef struct _NewReversiGameConfiguration NewReversiGameConfiguration;

struct _NewReversiGameConfiguration {
  int				 board_size;
  TimeControlConfiguration	 time_control;
};


typedef struct _NewGameRecordConfiguration NewGameRecordConfiguration;

struct _NewGameRecordConfiguration {
  char				*game_name;
  char				*player_names[NUM_COLORS];
  char				*game_record_name;
};


typedef struct _NewGoGameRecordConfiguration NewGoGameRecordConfiguration;

struct _NewGoGameRecordConfiguration {
  int				 board_size;
  int				 handicap_is_null;
  int				 handicap;
  int				 place_handicap_stones;
  int				 komi_is_null;
  double			 komi;
};


typedef struct _NewAmazonsGameRecordConfiguration NewAmazonsGameRecordConfiguration;

struct _NewAmazonsGameRecordConfiguration {
  int				 board_size;
};


typedef struct _NewReversiGameRecordConfiguration NewReversiGameRecordConfiguration;

struct _NewReversiGameRecordConfiguration {
  int				 board_size;
};


typedef struct _FindDialogConfiguration	FindDialogConfiguration;

struct _FindDialogConfiguration {
  StringList			 latest_search_strings;
  int				 case_sensitive;
  int				 whole_words_only;
  int				 wrap_around;
  int				 search_whole_game_tree;
  int				 search_in;
  int				 close_automatically;
};


enum {
  SECTION_GTP_ENGINES,
  SECTION_GAME_TREE_VIEW,
  SECTION_SGF,
  SECTION_GO_BOARD_APPEARANCE,
  SECTION_AMAZONS_BOARD_APPEARANCE,
  SECTION_REVERSI_BOARD_APPEARANCE,
  SECTION_GTK_UI,
  SECTION_NEW_GAME_DIALOG,
  SECTION_NEW_GO_GAME,
  SECTION_NEW_AMAZONS_GAME,
  SECTION_NEW_REVERSI_GAME,
  SECTION_NEW_GAME_RECORD_DIALOG,
  SECTION_NEW_GO_GAME_RECORD,
  SECTION_NEW_AMAZONS_GAME_RECORD,
  SECTION_NEW_REVERSI_GAME_RECORD,
  SECTION_FIND_DIALOG,
  NUM_GTK_CONFIGURATION_SECTIONS
};


enum {
  SHOW_GAME_TREE_ALWAYS,
  SHOW_GAME_TREE_AUTOMATICALLY,
  SHOW_GAME_TREE_NEVER
};


enum {
  TRACK_CURRENT_NODE_ALWAYS,
  TRACK_CURRENT_NODE_AUTOMATICALLY,
  TRACK_CURRENT_NODE_NEVER
};


enum {
  TOOLBAR_STYLE_DEFAULT,
  TOOLBAR_STYLE_BOTH,
  TOOLBAR_STYLE_BOTH_HORIZONTALLY,
  TOOLBAR_STYLE_ICONS_ONLY,
  TOOLBAR_STYLE_TEXT_ONLY
};


enum {
  SEARCH_EVERYWHERE,
  SEARCH_IN_COMMENTS,
  SEARCH_IN_NODE_NAMES
};


extern const ConfigurationSection	gtk_configuration_sections[];


extern GtpEngineList			gtp_engines;

extern GameTreeView			game_tree_view;

extern SgfConfiguration			sgf_configuration;

extern BoardAppearance			go_board_appearance;

extern AmazonsBoardAppearance		amazons_board_appearance;

extern BoardAppearance			reversi_board_appearance;

extern GtkUIConfiguration		gtk_ui_configuration;

extern NewGameConfiguration		new_game_configuration;

extern NewGoGameConfiguration		new_go_game_configuration;

extern NewAmazonsGameConfiguration	new_amazons_game_configuration;

extern NewReversiGameConfiguration	new_reversi_game_configuration;

extern NewGameRecordConfiguration	new_game_record_configuration;

extern NewGoGameRecordConfiguration	new_go_game_record_configuration;

extern NewAmazonsGameRecordConfiguration new_amazons_game_record_configuration;

extern NewReversiGameRecordConfiguration new_reversi_game_record_configuration;

extern FindDialogConfiguration		find_dialog_configuration;


#endif /* QUARRY_GTK_CONFIGURATION_H */
