/*
 * Copyright (c) 2007, Zhang Wei.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice,
 *   this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 * - Neither the name of the author nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER  CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS  SERVICES; LOSS OF USE, DATA,  PROFITS;  BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY,  TORT (INCLUDING NEGLIGENCE  OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */


#include "game.h"


/*
 * Function declarations.
 */
static void print_help(const char *);
static void print_version(void);


/*
 * Entry.
 */
int
main(int argc, char *argv[])
{
	int i;
	int j;
	int def;
	int fullscreen;
	int height;
	int width;
	int verbose;

	def = 0;
	fullscreen = 0;
	height = 0;
	width = 0;
	verbose = 0;
	for (i = 1; i < argc; ++i) {
		if (argv[i][0] == '-') {
			if (argv[i][1] == '-') {
				if (strcmp(argv[i], "--default") == 0)
					def = 1;
				else if (strcmp(argv[i], "--fullscreen") == 0)
					fullscreen = 1;
				else if (strcmp(argv[i], "--resolution") == 0) {
					if (i + 2 < argc) {
						width = strtol(argv[++i], (char **)NULL, 10);
						height = strtol(argv[++i], (char **)NULL, 10);
					}
				}
				else if (strcmp(argv[i], "--verbose") == 0)
					verbose = 1;
				else if (strcmp(argv[i], "--help") == 0) {
					print_help(argv[0]);
					return -1;
				} else if (strcmp(argv[i], "--version") == 0) {
					print_version();
					return -1;
				}
			} else {
				for (j = 1; (j > 0) && (argv[i][j]); ++j) {
					switch (argv[i][j]) {
					case 'd':
						def = 1;
						break;
					case 'f':
						fullscreen = 1;
						break;
					case 'r':
						if (i + 2 < argc) {
							width = strtol(argv[++i], (char **)NULL, 10);
							height = strtol(argv[++i], (char **)NULL, 10);
							j = -1;
						}
						break;
					case 'v':
						verbose = 1;
						break;
					case 'h':
					case '?':
						print_help(argv[0]);
						return -1;
					case 'V':
						print_version();
						return -1;
					}
				}
			}
		}
	}

	if (initialize_game(def, fullscreen, verbose, height, width) == 1)
		return -1;

	update_game();
	return 0;
}

/*
 * Print help message.
 */
static void
print_help(const char *name)
{
	printf("usage: %s [options]\n", name);
	printf("options:\n");
	printf("  -d, --default                        Do not use configuration file\n");
	printf("  -f, --fullscreen                     Switch to fullscreen mode\n");
	printf("  -h, --help                           Print this help message and exit\n");
	printf("  -r, --resolution <width> <height>    Set screen resolution\n");
	printf("  -V, --version                        Print version information and exit\n");
	printf("  -v, --verbose                        Enable verbose output\n");
}

/*
 * Print version information.
 */
static void
print_version()
{
	printf(GAME_NAME" version " GAME_VERSION"\n");
	printf("Copyright (c) 2007 Zhang Wei\n");
	printf("This is free software, and you are welcome to modify\n");
	printf("and redistribute it under the terms of the BSD license.\n");
}
