#!/bin/sh
path="."
if [ x"$1" != x ]; then
	path="$1"
fi

version() {
	cat <<EOF > "$path/comptime.h"

// Do not edit!  This file was autogenerated
// by the $0 script with git
//
const char* compbranch = "$1";
const char* comprevision = "$2";
const char* compnote = "$3";
EOF
}

versiongit() {
	gitbranch="$(git rev-parse --abbrev-ref HEAD)"
	gitversion="$(git rev-parse HEAD | cut -c -8)"
	gitsubject="$(git log -1 --format=%f)"
	version "$gitbranch" "$gitversion" "$gitsubject";
	exit 0
}

versionsvn() {
	svnrevision="$(svnversion -n "$1")"
	version "Subversion" "r$svnrevision" "dummy";
	exit 0
}

versionfake() {
	version "Unknown" "illegal" "dummy";
}

compversion() {
	touch "$path/comptime.c"
	versionfake
	[ -d "$path/.svn" ] && versionsvn "$@"
	[ -d "$path/../.git" ] && versiongit
	exit 1
}

[ -f "$path/comptime.c" ] && compversion "$@"
exit 2
