proc random {args} {
	global RNG_seed RandFileName

	set max 259200
	set argcnt [llength $args]
	if {$argcnt < 1 || $argcnt > 2} {
		error "wrong # args: random limit | seed ?seedval?"
	}
	if {![string compare [lindex $args 0] seed]} {
		if {$argcnt == 2} {
			set RNG_seed [lindex $args 1]
		} else {
			set RNG_seed [expr ([pid] + [file atime $RandFileName]) % $max]
		}
		return
	}
	if {![info exists RNG_seed]} {
		set RNG_seed [expr ([pid] + [file atime $RandFileName]) % $max]
	}
	set RNG_seed [expr ($RNG_seed * 7141 + 54773) % $max]
	return [expr int([lindex $args 0] * ($RNG_seed / double($max)))]
}
