/*
 * raster-snapshot.c
 *
 * Written by
 *  David Hogan <david.q.hogan@gmail.com>
 *
 * This file is part of VICE, the Versatile Commodore Emulator.
 * See README for copyright notice.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307  USA.
 *
 */

#ifndef VICE_RASTER_SNAPSHOT_H
#define VICE_RASTER_SNAPSHOT_H

#ifdef __LIBRETRO__
#ifndef VICE_RASTER_H
typedef struct raster_s raster_t;
#endif
#ifndef SNAPSHOT_STREAM_H
typedef struct snapshot_module_s snapshot_module_t;
#endif
#else
typedef struct raster_s raster_t;
typedef struct snapshot_module_s snapshot_module_t;
#endif

int raster_snapshot_write(snapshot_module_t *m, raster_t *raster);
int raster_snapshot_read(snapshot_module_t *m, raster_t *raster);

#endif
