/*
Copyright (C) 1996-2001 Id Software, Inc.
Copyright (C) 2002-2009 John Fitzgibbons and others

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
/* crc.c */

#include "quakedef.h"
#include "palette.h"

// clang-format off
palette_octree_node_t palette_octree_nodes[NUM_PALETTE_OCTREE_NODES] =
{
	{ {0x1, 0x59, 0x75, 0x7f, 0x8e, 0x9a, 0xa5, 0xab} },
	{ {0x2, 0x20, 0x30, 0x36, 0x41, 0x43, 0x4b, 0x51} },
	{ {0x3, 0xa, 0x11, 0x12, 0x80002c28, 0x1a, 0x1c, 0x1d} },
	{ {0x4, 0x5, 0x80000608, 0x7, 0x80000905, 0x8, 0x80000b47, 0x9} },
	{ {0x80000004, 0x80000046, 0x800000a3, 0x800000d6, 0x80000135, 0x80000184, 0x800001c3, 0x800001f6} },
	{ {0x80000255, 0x800002a4, 0x6, 0x800004a5, 0x800004f4, 0x80000533, 0x80000566, 0x800005c4} },
	{ {0x800002e4, 0x80000325, 0x80000373, 0x800003a3, 0x800003d2, 0x800003f4, 0x80000432, 0x80000455} },
	{ {0x80000685, 0x800006d6, 0x80000734, 0x80000772, 0x80000797, 0x80000804, 0x80000848, 0x800008c4} },
	{ {0x80000954, 0x80000992, 0x800009b6, 0x80000a15, 0x80000a64, 0x80000aa4, 0x80000ae3, 0x80000b13} },
	{ {0x80000bb5, 0x80000c04, 0x80000c44, 0x80000c88, 0x80000d02, 0x80000d24, 0x80000d65, 0x80000db5} },
	{ {0xb, 0x80001057, 0xc, 0xd, 0xe, 0xf, 0x10, 0x80001a56} },
	{ {0x80000e02, 0x80000e23, 0x80000e55, 0x80000ea5, 0x80000ef5, 0x80000f46, 0x80000fa5, 0x80000ff6} },
	{ {0x800010c6, 0x80001123, 0x80001156, 0x800011b4, 0x800011f5, 0x80001244, 0x80001284, 0x800012c6} },
	{ {0x80001322, 0x80001346, 0x800013a3, 0x800013d4, 0x80001411, 0x80001423, 0x80001454, 0x80001492} },
	{ {0x800014b4, 0x800014f6, 0x80001552, 0x80001574, 0x800015b3, 0x800015e3, 0x80001612, 0x80001633} },
	{ {0x80001665, 0x800016b5, 0x80001702, 0x80001726, 0x80001782, 0x800017a4, 0x800017e1, 0x800017f2} },
	{ {0x80001814, 0x80001855, 0x800018a5, 0x800018f7, 0x80001963, 0x80001993, 0x800019c4, 0x80001a05} },
	{ {0x80001ab5, 0x80001b08, 0x80001b86, 0x80001be5, 0x80001c33, 0x80001c68, 0x80001ce4, 0x80001d25} },
	{ {0x13, 0x14, 0x800021d5, 0x15, 0x16, 0x17, 0x18, 0x19} },
	{ {0x80001d73, 0x80001da4, 0x80001de3, 0x80001e14, 0x80001e55, 0x80001ea3, 0x80001ed3, 0x80001f04} },
	{ {0x80001f47, 0x80001fb2, 0x80001fd5, 0x80002022, 0x80002048, 0x800020c3, 0x800020f7, 0x80002167} },
	{ {0x80002224, 0x80002264, 0x800022a1, 0x800022b3, 0x800022e3, 0x80002314, 0x80002351, 0x80002362} },
	{ {0x80002385, 0x800023d3, 0x80002405, 0x80002458, 0x800024d3, 0x80002507, 0x80002572, 0x80002596} },
	{ {0x800025f4, 0x80002634, 0x80002673, 0x800026a3, 0x800026d5, 0x80002726, 0x80002783, 0x800027b3} },
	{ {0x800027e3, 0x80002817, 0x80002884, 0x800028c5, 0x80002912, 0x80002934, 0x80002972, 0x80002995} },
	{ {0x800029e5, 0x80002a34, 0x80002a73, 0x80002aa5, 0x80002af3, 0x80002b25, 0x80002b76, 0x80002bd5} },
	{ {0x80002ca7, 0x80002d13, 0x1b, 0x80002f66, 0x80002fc5, 0x80003017, 0x80003084, 0x800030c7} },
	{ {0x80002d44, 0x80002d83, 0x80002db3, 0x80002de5, 0x80002e33, 0x80002e66, 0x80002ec4, 0x80002f06} },
	{ {0x80003137, 0x800031a7, 0x80003214, 0x80003253, 0x80003283, 0x800032b4, 0x800032f4, 0x80003336} },
	{ {0x1e, 0x1f, 0x800037b5, 0x80003805, 0x80003856, 0x800038b7, 0x80003927, 0x80003998} },
	{ {0x80003394, 0x800033d8, 0x80003452, 0x80003475, 0x800034c5, 0x80003514, 0x80003554, 0x80003593} },
	{ {0x800035c3, 0x800035f4, 0x80003632, 0x80003655, 0x800036a4, 0x800036e4, 0x80003723, 0x80003756} },
	{ {0x21, 0x22, 0x23, 0x28, 0x2a, 0x2b, 0x2d, 0x2f} },
	{ {0x80003a15, 0x80003a65, 0x80003ab4, 0x80003af5, 0x80003b48, 0x80003bc7, 0x80003c36, 0x80003c94} },
	{ {0x80003cd5, 0x80003d25, 0x80003d74, 0x80003db2, 0x80003dd8, 0x80003e55, 0x80003ea5, 0x80003ef4} },
	{ {0x24, 0x800040f6, 0x25, 0x800042e7, 0x26, 0x80004535, 0x80004587, 0x27} },
	{ {0x80003f33, 0x80003f63, 0x80003f93, 0x80003fc3, 0x80003ff3, 0x80004021, 0x80004037, 0x800040a5} },
	{ {0x80004153, 0x80004182, 0x800041a3, 0x800041d2, 0x800041f6, 0x80004255, 0x800042a3, 0x800042d1} },
	{ {0x80004353, 0x80004381, 0x80004393, 0x800043c4, 0x80004407, 0x80004474, 0x800044b4, 0x800044f4} },
	{ {0x800045f4, 0x80004633, 0x80004663, 0x80004695, 0x800046e4, 0x80004724, 0x80004763, 0x80004794} },
	{ {0x800047d7, 0x80004844, 0x80004888, 0x80004907, 0x80004974, 0x800049b3, 0x29, 0x80004b85} },
	{ {0x800049e2, 0x80004a02, 0x80004a26, 0x80004a85, 0x80004ad1, 0x80004ae2, 0x80004b03, 0x80004b35} },
	{ {0x80004bd7, 0x80004c48, 0x80004cc4, 0x80004d05, 0x80004d54, 0x80004d92, 0x80004db5, 0x80004e02} },
	{ {0x2c, 0x80005056, 0x800050b6, 0x80005114, 0x80005156, 0x800051b8, 0x80005233, 0x80005267} },
	{ {0x80004e24, 0x80004e63, 0x80004e96, 0x80004ef4, 0x80004f36, 0x80004f95, 0x80004fe3, 0x80005014} },
	{ {0x2e, 0x800054f7, 0x80005567, 0x800055d8, 0x80005654, 0x80005695, 0x800056e6, 0x80005748} },
	{ {0x800052d3, 0x80005303, 0x80005337, 0x800053a5, 0x800053f3, 0x80005423, 0x80005454, 0x80005496} },
	{ {0x800057c3, 0x800057f3, 0x80005825, 0x80005873, 0x800058a5, 0x800058f5, 0x80005947, 0x800059b6} },
	{ {0x31, 0x32, 0x34, 0x80006318, 0x80006395, 0x35, 0x800065e5, 0x80006638} },
	{ {0x80005a16, 0x80005a77, 0x80005ae6, 0x80005b45, 0x80005b93, 0x80005bc5, 0x80005c13, 0x80005c45} },
	{ {0x80005c93, 0x80005cc4, 0x80005d04, 0x80005d43, 0x80005d76, 0x33, 0x80005fc7, 0x80006035} },
	{ {0x80005dd2, 0x80005df3, 0x80005e22, 0x80005e43, 0x80005e75, 0x80005ec7, 0x80005f34, 0x80005f75} },
	{ {0x80006086, 0x800060e6, 0x80006146, 0x800061a5, 0x800061f3, 0x80006226, 0x80006283, 0x800062b6} },
	{ {0x800063e3, 0x80006417, 0x80006483, 0x800064b5, 0x80006503, 0x80006535, 0x80006583, 0x800065b3} },
	{ {0x37, 0x38, 0x80006f15, 0x3b, 0x3c, 0x3e, 0x3f, 0x40} },
	{ {0x800066b6, 0x80006717, 0x80006783, 0x800067b5, 0x80006807, 0x80006878, 0x800068f3, 0x80006925} },
	{ {0x80006974, 0x800069b3, 0x39, 0x80006bb6, 0x80006c17, 0x80006c88, 0x3a, 0x80006ea7} },
	{ {0x800069e5, 0x80006a32, 0x80006a53, 0x80006a83, 0x80006ab4, 0x80006af3, 0x80006b23, 0x80006b56} },
	{ {0x80006d05, 0x80006d54, 0x80006d93, 0x80006dc5, 0x80006e12, 0x80006e32, 0x80006e53, 0x80006e82} },
	{ {0x80006f64, 0x80006fa3, 0x80006fd2, 0x80006ff3, 0x80007025, 0x80007078, 0x800070f1, 0x80007105} },
	{ {0x3d, 0x80007377, 0x800073e8, 0x80007467, 0x800074d7, 0x80007545, 0x80007596, 0x800075f5} },
	{ {0x80007153, 0x80007186, 0x800071e8, 0x80007264, 0x800072a3, 0x800072d3, 0x80007305, 0x80007352} },
	{ {0x80007647, 0x800076b8, 0x80007736, 0x80007795, 0x800077e5, 0x80007834, 0x80007876, 0x800078d5} },
	{ {0x80007927, 0x80007997, 0x80007a05, 0x80007a53, 0x80007a84, 0x80007ac6, 0x80007b24, 0x80007b67} },
	{ {0x80007bd4, 0x80007c14, 0x80007c53, 0x80007c84, 0x80007cc5, 0x80007d16, 0x80007d76, 0x80007dd6} },
	{ {0x80007e34, 0x80007e78, 0x80007ef8, 0x42, 0x80008195, 0x800081e4, 0x80008224, 0x80008265} },
	{ {0x80007f73, 0x80007fa6, 0x80008005, 0x80008056, 0x800080b2, 0x800080d4, 0x80008114, 0x80008154} },
	{ {0x44, 0x800084e5, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a} },
	{ {0x800082b5, 0x80008302, 0x80008327, 0x80008393, 0x800083c4, 0x80008404, 0x80008445, 0x80008495} },
	{ {0x80008537, 0x800085a5, 0x800085f6, 0x80008654, 0x80008697, 0x80008705, 0x80008755, 0x800087a6} },
	{ {0x80008803, 0x80008834, 0x80008874, 0x800088b5, 0x80008904, 0x80008942, 0x80008964, 0x800089a3} },
	{ {0x800089d2, 0x800089f6, 0x80008a52, 0x80008a78, 0x80008af2, 0x80008b12, 0x80008b32, 0x80008b54} },
	{ {0x80008b93, 0x80008bc2, 0x80008be3, 0x80008c13, 0x80008c44, 0x80008c83, 0x80008cb7, 0x80008d24} },
	{ {0x80008d64, 0x80008da7, 0x80008e14, 0x80008e55, 0x80008ea3, 0x80008ed4, 0x80008f14, 0x80008f53} },
	{ {0x80008f85, 0x80008fd3, 0x80009008, 0x80009084, 0x800090c7, 0x80009133, 0x80009167, 0x800091d6} },
	{ {0x4c, 0x4d, 0x800096b5, 0x80009705, 0x80009757, 0x4e, 0x4f, 0x50} },
	{ {0x80009235, 0x80009285, 0x800092d2, 0x800092f3, 0x80009323, 0x80009356, 0x800093b5, 0x80009405} },
	{ {0x80009455, 0x800094a7, 0x80009513, 0x80009543, 0x80009576, 0x800095d5, 0x80009624, 0x80009665} },
	{ {0x800097c4, 0x80009804, 0x80009846, 0x800098a5, 0x800098f3, 0x80009924, 0x80009964, 0x800099a3} },
	{ {0x800099d6, 0x80009a35, 0x80009a83, 0x80009ab3, 0x80009ae5, 0x80009b36, 0x80009b97, 0x80009c06} },
	{ {0x80009c65, 0x80009cb5, 0x80009d03, 0x80009d33, 0x80009d65, 0x80009db5, 0x80009e05, 0x80009e55} },
	{ {0x52, 0x53, 0x8000a487, 0x54, 0x55, 0x56, 0x57, 0x58} },
	{ {0x80009ea7, 0x80009f17, 0x80009f84, 0x80009fc8, 0x8000a045, 0x8000a096, 0x8000a0f6, 0x8000a156} },
	{ {0x8000a1b7, 0x8000a227, 0x8000a294, 0x8000a2d6, 0x8000a336, 0x8000a394, 0x8000a3d5, 0x8000a426} },
	{ {0x8000a4f4, 0x8000a534, 0x8000a574, 0x8000a5b3, 0x8000a5e7, 0x8000a654, 0x8000a695, 0x8000a6e5} },
	{ {0x8000a733, 0x8000a764, 0x8000a7a6, 0x8000a807, 0x8000a873, 0x8000a8a3, 0x8000a8d3, 0x8000a902} },
	{ {0x8000a925, 0x8000a976, 0x8000a9d7, 0x8000aa45, 0x8000aa95, 0x8000aae5, 0x8000ab36, 0x8000ab96} },
	{ {0x8000abf4, 0x8000ac37, 0x8000aca3, 0x8000acd3, 0x8000ad04, 0x8000ad47, 0x8000adb4, 0x8000adf5} },
	{ {0x8000ae45, 0x8000ae97, 0x8000af03, 0x8000af35, 0x8000af86, 0x8000afe5, 0x8000b036, 0x8000b094} },
	{ {0x5a, 0x8000b736, 0x5d, 0x66, 0x67, 0x6b, 0x6c, 0x73} },
	{ {0x8000b0d5, 0x8000b124, 0x5b, 0x8000b3a5, 0x5c, 0x8000b625, 0x8000b677, 0x8000b6e5} },
	{ {0x8000b163, 0x8000b192, 0x8000b1b8, 0x8000b233, 0x8000b264, 0x8000b2a3, 0x8000b2d6, 0x8000b337} },
	{ {0x8000b3f4, 0x8000b434, 0x8000b474, 0x8000b4b4, 0x8000b4f5, 0x8000b546, 0x8000b5a4, 0x8000b5e4} },
	{ {0x5e, 0x8000b9d8, 0x5f, 0x60, 0x61, 0x8000c2c8, 0x63, 0x65} },
	{ {0x8000b793, 0x8000b7c5, 0x8000b814, 0x8000b852, 0x8000b876, 0x8000b8d8, 0x8000b955, 0x8000b9a3} },
	{ {0x8000ba54, 0x8000ba95, 0x8000bae2, 0x8000bb03, 0x8000bb38, 0x8000bbb5, 0x8000bc04, 0x8000bc45} },
	{ {0x8000bc95, 0x8000bce4, 0x8000bd23, 0x8000bd54, 0x8000bd93, 0x8000bdc4, 0x8000be05, 0x8000be54} },
	{ {0x8000be98, 0x8000bf14, 0x62, 0x8000c156, 0x8000c1b3, 0x8000c1e2, 0x8000c206, 0x8000c266} },
	{ {0x8000bf54, 0x8000bf95, 0x8000bfe3, 0x8000c014, 0x8000c053, 0x8000c086, 0x8000c0e2, 0x8000c105} },
	{ {0x8000c344, 0x8000c387, 0x8000c3f2, 0x8000c413, 0x8000c445, 0x64, 0x8000c694, 0x8000c6d3} },
	{ {0x8000c494, 0x8000c4d5, 0x8000c523, 0x8000c555, 0x8000c5a1, 0x8000c5b6, 0x8000c614, 0x8000c654} },
	{ {0x8000c704, 0x8000c744, 0x8000c786, 0x8000c7e4, 0x8000c825, 0x8000c873, 0x8000c8a2, 0x8000c8c3} },
	{ {0x8000c8f4, 0x8000c933, 0x8000c968, 0x8000c9e4, 0x8000ca25, 0x8000ca73, 0x8000caa6, 0x8000cb03} },
	{ {0x68, 0x69, 0x6a, 0x8000d0e6, 0x8000d144, 0x8000d186, 0x8000d1e4, 0x8000d224} },
	{ {0x8000cb34, 0x8000cb77, 0x8000cbe4, 0x8000cc23, 0x8000cc52, 0x8000cc74, 0x8000ccb3, 0x8000cce5} },
	{ {0x8000cd33, 0x8000cd64, 0x8000cda2, 0x8000cdc4, 0x8000ce04, 0x8000ce45, 0x8000ce93, 0x8000cec5} },
	{ {0x8000cf14, 0x8000cf51, 0x8000cf66, 0x8000cfc4, 0x8000d003, 0x8000d034, 0x8000d072, 0x8000d095} },
	{ {0x8000d267, 0x8000d2d4, 0x8000d315, 0x8000d363, 0x8000d398, 0x8000d418, 0x8000d496, 0x8000d4f7} },
	{ {0x6d, 0x8000d944, 0x6f, 0x8000db97, 0x70, 0x8000dde6, 0x71, 0x72} },
	{ {0x8000d565, 0x8000d5b6, 0x8000d613, 0x8000d644, 0x8000d685, 0x8000d6d4, 0x6e, 0x8000d8f5} },
	{ {0x8000d714, 0x8000d753, 0x8000d782, 0x8000d7a3, 0x8000d7d2, 0x8000d7f4, 0x8000d836, 0x8000d896} },
	{ {0x8000d985, 0x8000d9d4, 0x8000da15, 0x8000da64, 0x8000daa4, 0x8000dae4, 0x8000db23, 0x8000db54} },
	{ {0x8000dc02, 0x8000dc23, 0x8000dc58, 0x8000dcd4, 0x8000dd13, 0x8000dd42, 0x8000dd64, 0x8000dda4} },
	{ {0x8000de47, 0x8000deb8, 0x8000df34, 0x8000df74, 0x8000dfb4, 0x8000dff5, 0x8000e044, 0x8000e084} },
	{ {0x8000e0c6, 0x8000e124, 0x8000e164, 0x8000e1a2, 0x8000e1c6, 0x8000e224, 0x8000e267, 0x8000e2d6} },
	{ {0x8000e338, 0x8000e3b2, 0x8000e3d8, 0x8000e453, 0x8000e488, 0x8000e508, 0x74, 0x8000e718} },
	{ {0x8000e585, 0x8000e5d2, 0x8000e5f1, 0x8000e604, 0x8000e643, 0x8000e674, 0x8000e6b3, 0x8000e6e3} },
	{ {0x76, 0x79, 0x7c, 0x7d, 0x8000f858, 0x7e, 0x8000fb35, 0x8000fb88} },
	{ {0x77, 0x8000e9a6, 0x8000ea08, 0x8000ea83, 0x8000eab5, 0x78, 0x8000ed26, 0x8000ed87} },
	{ {0x8000e795, 0x8000e7e4, 0x8000e824, 0x8000e862, 0x8000e883, 0x8000e8b5, 0x8000e905, 0x8000e955} },
	{ {0x8000eb05, 0x8000eb56, 0x8000ebb6, 0x8000ec15, 0x8000ec63, 0x8000ec93, 0x8000ecc3, 0x8000ecf3} },
	{ {0x8000edf2, 0x8000ee15, 0x8000ee62, 0x8000ee84, 0x8000eec7, 0x7a, 0x8000f175, 0x7b} },
	{ {0x8000ef32, 0x8000ef53, 0x8000ef83, 0x8000efb4, 0x8000eff6, 0x8000f055, 0x8000f0a7, 0x8000f116} },
	{ {0x8000f1c3, 0x8000f1f5, 0x8000f244, 0x8000f284, 0x8000f2c5, 0x8000f315, 0x8000f365, 0x8000f3b4} },
	{ {0x8000f3f5, 0x8000f441, 0x8000f453, 0x8000f483, 0x8000f4b6, 0x8000f515, 0x8000f565, 0x8000f5b7} },
	{ {0x8000f623, 0x8000f655, 0x8000f6a4, 0x8000f6e4, 0x8000f726, 0x8000f786, 0x8000f7e5, 0x8000f832} },
	{ {0x8000f8d4, 0x8000f917, 0x8000f984, 0x8000f9c6, 0x8000fa24, 0x8000fa66, 0x8000fac3, 0x8000faf4} },
	{ {0x80, 0x82, 0x800102d8, 0x80010358, 0x83, 0x89, 0x8b, 0x8d} },
	{ {0x8000fc04, 0x8000fc47, 0x8000fcb3, 0x8000fce3, 0x8000fd17, 0x81, 0x8000ff57, 0x8000ffc5} },
	{ {0x8000fd87, 0x8000fdf5, 0x8000fe44, 0x8000fe84, 0x8000fec2, 0x8000fee4, 0x8000ff22, 0x8000ff41} },
	{ {0x80010016, 0x80010075, 0x800100c5, 0x80010114, 0x80010157, 0x800101c4, 0x80010208, 0x80010285} },
	{ {0x84, 0x800105e5, 0x85, 0x80010816, 0x86, 0x80010a96, 0x87, 0x88} },
	{ {0x800103d6, 0x80010434, 0x80010474, 0x800104b3, 0x800104e3, 0x80010514, 0x80010554, 0x80010595} },
	{ {0x80010636, 0x80010691, 0x800106a1, 0x800106b2, 0x800106d6, 0x80010735, 0x80010785, 0x800107d4} },
	{ {0x80010873, 0x800108a3, 0x800108d6, 0x80010934, 0x80010975, 0x800109c4, 0x80010a05, 0x80010a54} },
	{ {0x80010af4, 0x80010b35, 0x80010b85, 0x80010bd6, 0x80010c34, 0x80010c74, 0x80010cb2, 0x80010cd4} },
	{ {0x80010d14, 0x80010d52, 0x80010d76, 0x80010dd6, 0x80010e34, 0x80010e73, 0x80010ea1, 0x80010eb4} },
	{ {0x8a, 0x800110d3, 0x80011107, 0x80011176, 0x800111d5, 0x80011225, 0x80011276, 0x800112d3} },
	{ {0x80010ef8, 0x80010f72, 0x80010f94, 0x80010fd3, 0x80011004, 0x80011043, 0x80011074, 0x800110b2} },
	{ {0x80011305, 0x80011352, 0x80011372, 0x80011392, 0x800113b7, 0x8c, 0x80011674, 0x800116b4} },
	{ {0x80011423, 0x80011457, 0x800114c3, 0x800114f2, 0x80011513, 0x80011547, 0x800115b6, 0x80011616} },
	{ {0x800116f3, 0x80011726, 0x80011782, 0x800117a2, 0x800117c6, 0x80011824, 0x80011863, 0x80011893} },
	{ {0x800118c6, 0x8f, 0x92, 0x94, 0x800129c6, 0x97, 0x98, 0x99} },
	{ {0x80011923, 0x90, 0x80011b76, 0x91, 0x80011e43, 0x80011e76, 0x80011ed4, 0x80011f17} },
	{ {0x80011954, 0x80011996, 0x800119f6, 0x80011a55, 0x80011aa2, 0x80011ac3, 0x80011af3, 0x80011b25} },
	{ {0x80011bd5, 0x80011c24, 0x80011c64, 0x80011ca6, 0x80011d05, 0x80011d56, 0x80011db4, 0x80011df5} },
	{ {0x80011f83, 0x80011fb6, 0x80012018, 0x93, 0x80012283, 0x800122b4, 0x800122f4, 0x80012335} },
	{ {0x80012094, 0x800120d2, 0x800120f4, 0x80012135, 0x80012185, 0x800121d4, 0x80012214, 0x80012253} },
	{ {0x80012387, 0x95, 0x800125e8, 0x96, 0x80012895, 0x800128e5, 0x80012935, 0x80012984} },
	{ {0x800123f3, 0x80012426, 0x80012482, 0x800124a5, 0x800124f3, 0x80012526, 0x80012582, 0x800125a4} },
	{ {0x80012664, 0x800126a6, 0x80012705, 0x80012755, 0x800127a3, 0x800127d2, 0x800127f3, 0x80012827} },
	{ {0x80012a23, 0x80012a53, 0x80012a83, 0x80012ab5, 0x80012b04, 0x80012b43, 0x80012b73, 0x80012ba6} },
	{ {0x80012c03, 0x80012c33, 0x80012c63, 0x80012c95, 0x80012ce4, 0x80012d23, 0x80012d53, 0x80012d87} },
	{ {0x80012df5, 0x80012e46, 0x80012ea6, 0x80012f04, 0x80012f46, 0x80012fa6, 0x80013007, 0x80013072} },
	{ {0x9b, 0x80013465, 0x9d, 0x80013ff7, 0xa3, 0x800144d3, 0x80014507, 0x80014576} },
	{ {0x80013095, 0x800130e3, 0x80013115, 0x80013164, 0x800131a7, 0x80013213, 0x9c, 0x80013424} },
	{ {0x80013245, 0x80013292, 0x800132b5, 0x80013302, 0x80013325, 0x80013373, 0x800133a4, 0x800133e4} },
	{ {0x9e, 0x800136b4, 0x9f, 0xa0, 0xa1, 0x80013d44, 0xa2, 0x80013f96} },
	{ {0x800134b4, 0x800134f2, 0x80013515, 0x80013564, 0x800135a5, 0x800135f2, 0x80013616, 0x80013674} },
	{ {0x800136f4, 0x80013735, 0x80013784, 0x800137c4, 0x80013805, 0x80013854, 0x80013896, 0x800138f3} },
	{ {0x80013923, 0x80013952, 0x80013975, 0x800139c6, 0x80013a24, 0x80013a62, 0x80013a84, 0x80013ac4} },
	{ {0x80013b04, 0x80013b43, 0x80013b75, 0x80013bc6, 0x80013c24, 0x80013c65, 0x80013cb2, 0x80013cd7} },
	{ {0x80013d84, 0x80013dc6, 0x80013e24, 0x80013e64, 0x80013ea3, 0x80013ed5, 0x80013f22, 0x80013f45} },
	{ {0x80014068, 0x800140e2, 0xa4, 0x80014305, 0x80014358, 0x800143d6, 0x80014437, 0x800144a3} },
	{ {0x80014105, 0x80014154, 0x80014192, 0x800141b6, 0x80014213, 0x80014245, 0x80014293, 0x800142c4} },
	{ {0xa6, 0xa8, 0x80014de8, 0xa9, 0xaa, 0x800152f6, 0x80015352, 0x80015375} },
	{ {0xa7, 0x80014867, 0x800148d5, 0x80014923, 0x80014956, 0x800149b6, 0x80014a18, 0x80014a96} },
	{ {0x800145d6, 0x80014635, 0x80014684, 0x800146c3, 0x800146f5, 0x80014745, 0x80014797, 0x80014806} },
	{ {0x80014af7, 0x80014b67, 0x80014bd3, 0x80014c04, 0x80014c45, 0x80014c96, 0x80014cf8, 0x80014d77} },
	{ {0x80014e62, 0x80014e84, 0x80014ec4, 0x80014f04, 0x80014f47, 0x80014fb6, 0x80015014, 0x80015055} },
	{ {0x800150a6, 0x80015107, 0x80015175, 0x800151c4, 0x80015205, 0x80015257, 0x800152c2, 0x800152e1} },
	{ {0xac, 0xaf, 0xb1, 0xb3, 0xb5, 0xb6, 0x80016ab8, 0xb7} },
	{ {0xad, 0xae, 0x80015794, 0x800157d7, 0x80015848, 0x800158c8, 0x80015945, 0x80015995} },
	{ {0x800153c3, 0x800153f6, 0x80015452, 0x80015474, 0x800154b5, 0x80015504, 0x80015542, 0x80015562} },
	{ {0x80015583, 0x800155b7, 0x80015623, 0x80015653, 0x80015684, 0x800156c5, 0x80015715, 0x80015763} },
	{ {0x800159e7, 0x80015a56, 0x80015ab6, 0x80015b14, 0xb0, 0x80015d26, 0x80015d87, 0x80015df4} },
	{ {0x80015b53, 0x80015b84, 0x80015bc3, 0x80015bf4, 0x80015c34, 0x80015c73, 0x80015ca5, 0x80015cf3} },
	{ {0x80015e34, 0xb2, 0x80016054, 0x80016098, 0x80016113, 0x80016144, 0x80016184, 0x800161c4} },
	{ {0x80015e75, 0x80015ec4, 0x80015f04, 0x80015f45, 0x80015f92, 0x80015fb4, 0x80015ff3, 0x80016023} },
	{ {0xb4, 0x80016404, 0x80016447, 0x800164b2, 0x800164d7, 0x80016546, 0x800165a8, 0x80016625} },
	{ {0x80016205, 0x80016254, 0x80016295, 0x800162e3, 0x80016312, 0x80016334, 0x80016375, 0x800163c4} },
	{ {0x80016673, 0x800166a5, 0x800166f4, 0x80016734, 0x80016772, 0x80016794, 0x800167d2, 0x800167f5} },
	{ {0x80016848, 0x800168c4, 0x80016905, 0x80016953, 0x80016986, 0x800169e4, 0x80016a25, 0x80016a74} },
	{ {0x80016b34, 0x80016b75, 0x80016bc5, 0x80016c13, 0x80016c45, 0x80016c92, 0x80016cb4, 0x80016cf5} }
};

uint32_t palette_octree_colors[NUM_PALETTE_OCTREE_COLORS] =
{
	0xff000000, 0xff000007, 0xff000707, 0xff070b07, 0xff000007, 0xff00000f, 0xff00070b, 0xff000707, 
	0xff07070f, 0xff070b07, 0xff000707, 0xff000b0b, 0xff070b07, 0xff000707, 0xff00070b, 0xff000b0b, 
	0xff07070f, 0xff070b0f, 0xff070b07, 0xff000000, 0xff000007, 0xff070b07, 0xff07070f, 0xff0f0b0b, 
	0xff000007, 0xff07070f, 0xff070b07, 0xff0f0b0b, 0xff070b07, 0xff0b130b, 0xff0f0b0b, 0xff070b07, 
	0xff07070f, 0xff070b0f, 0xff0b130b, 0xff0f0f0f, 0xff0f0b0b, 0xff00000f, 0xff000017, 0xff00070b, 
	0xff07070f, 0xff0b0b17, 0xff000017, 0xff00001f, 0xff000f1b, 0xff0b0b17, 0xff00070b, 0xff000b0b, 
	0xff07070f, 0xff070b0f, 0xff000017, 0xff070b0f, 0xff000f1b, 0xff001313, 0xff07070f, 0xff000b0b, 
	0xff001313, 0xff070b0f, 0xff001313, 0xff000f1b, 0xff070b0f, 0xff07070f, 0xff070b0f, 0xff07070f, 
	0xff0b0b17, 0xff070b0f, 0xff000f1b, 0xff070b0f, 0xff001313, 0xff070b0f, 0xff000f1b, 0xff001313, 
	0xff0b0b17, 0xff0b0f17, 0xff000f1b, 0xff00001f, 0xff0b0b17, 0xff071323, 0xff0b0f17, 0xff07070f, 
	0xff000017, 0xff0b0b17, 0xff0f0b0b, 0xff000017, 0xff00001f, 0xff0b0b17, 0xff07070f, 0xff0b0b17, 
	0xff070b0f, 0xff0b0f17, 0xff0f0f0f, 0xff0f0b0b, 0xff0b0b17, 0xff071323, 0xff0b0f17, 0xff0f131b, 
	0xff070b07, 0xff000b0b, 0xff001313, 0xff0b130b, 0xff070b0f, 0xff131b0f, 0xff0f0f0f, 0xff0f0b0b, 
	0xff001313, 0xff000f1b, 0xff070b0f, 0xff0b0f17, 0xff0b130b, 0xff000f1b, 0xff00131b, 0xff001b1b, 
	0xff071323, 0xff0b171f, 0xff0b0f17, 0xff001313, 0xff001b1b, 0xff0b130b, 0xff131b0f, 0xff001b1b, 
	0xff0b171f, 0xff070b0f, 0xff0b0f17, 0xff0b130b, 0xff001313, 0xff0f0f0f, 0xff0f131b, 0xff131b0f, 
	0xff0b0f17, 0xff071323, 0xff0b171f, 0xff0f131b, 0xff0b130b, 0xff001313, 0xff0b0f17, 0xff0b171f, 
	0xff001b1b, 0xff131b0f, 0xff0f131b, 0xff172317, 0xff0b171f, 0xff001b1b, 0xff0f131b, 0xff172317, 
	0xff0f0b0b, 0xff07070f, 0xff0f0f0f, 0xff1b1313, 0xff1f1313, 0xff07070f, 0xff0b0b17, 0xff0f0b0b, 
	0xff0f0f0f, 0xff0b0b17, 0xff131323, 0xff0f0b0b, 0xff0f0f0f, 0xff0b0b17, 0xff0b0f17, 0xff0f131b, 
	0xff1b1313, 0xff0b0b17, 0xff0f131b, 0xff0b0f17, 0xff131323, 0xff1b1313, 0xff0f0b0b, 0xff0b0b17, 
	0xff1b1313, 0xff1f1313, 0xff0b0b17, 0xff131323, 0xff1b1313, 0xff1f1313, 0xff0f0b0b, 0xff1b1313, 
	0xff1f1313, 0xff1b1313, 0xff131323, 0xff1f1313, 0xff0f0b0b, 0xff0f0f0f, 0xff0b130b, 0xff131b0f, 
	0xff1b1313, 0xff172317, 0xff1f1313, 0xff0f0f0f, 0xff0b0f17, 0xff0f131b, 0xff131b0f, 0xff1b1313, 
	0xff0f131b, 0xff0b171f, 0xff131323, 0xff1b1313, 0xff131b0f, 0xff0f131b, 0xff172317, 0xff1b1313, 
	0xff0f131b, 0xff0b171f, 0xff172317, 0xff0f1b27, 0xff131323, 0xff171f27, 0xff1b1313, 0xff1f1f1f, 
	0xff1b1313, 0xff1f1313, 0xff1b1313, 0xff131323, 0xff1f1f1f, 0xff1f1313, 0xff131b0f, 0xff1b1313, 
	0xff172317, 0xff1f1f1f, 0xff1f1313, 0xff1b1313, 0xff131323, 0xff1f1f1f, 0xff172317, 0xff1f1313, 
	0xff00001f, 0xff000027, 0xff000027, 0xff00002b, 0xff00002f, 0xff00001f, 0xff000027, 0xff000f1b, 
	0xff071323, 0xff0b0b17, 0xff000027, 0xff00002b, 0xff00002f, 0xff071323, 0xff0b172f, 0xff00001f, 
	0xff000027, 0xff0b0b17, 0xff071323, 0xff131323, 0xff000027, 0xff00002b, 0xff00002f, 0xff071323, 
	0xff131323, 0xff0b172f, 0xff0b0b17, 0xff071323, 0xff000027, 0xff0f131b, 0xff131323, 0xff000027, 
	0xff00002b, 0xff00002f, 0xff071323, 0xff0b172f, 0xff131323, 0xff00002f, 0xff000037, 0xff00003b, 
	0xff00003f, 0xff00074b, 0xff0b172f, 0xff0f1f3b, 0xff000f1b, 0xff071323, 0xff00131b, 0xff001b1b, 
	0xff001f2b, 0xff0b171f, 0xff071323, 0xff0b172f, 0xff001f2b, 0xff001b1b, 0xff071323, 0xff001f2b, 
	0xff002323, 0xff0b171f, 0xff0f1b27, 0xff001f2b, 0xff071323, 0xff0b172f, 0xff0f1b27, 0xff071323, 
	0xff0b171f, 0xff0f1b27, 0xff0f131b, 0xff131323, 0xff071323, 0xff0b172f, 0xff0f1b27, 0xff131323, 
	0xff0b171f, 0xff071323, 0xff0f1b27, 0xff002323, 0xff071323, 0xff0b172f, 0xff0f1b27, 0xff001f2b, 
	0xff0f232b, 0xff13232f, 0xff0b172f, 0xff001f2b, 0xff0b172f, 0xff000037, 0xff00003b, 0xff00003f, 
	0xff00074b, 0xff0f1f3b, 0xff001f2b, 0xff0b172f, 0xff0f1f3b, 0xff0b172f, 0xff0f1f3b, 0xff001f2b, 
	0xff002b3b, 0xff0b172f, 0xff0b172f, 0xff00074b, 0xff0f1f3b, 0xff0b172f, 0xff0f1f3b, 0xff0f232b, 
	0xff13232f, 0xff0b172f, 0xff0f1f3b, 0xff0b0b17, 0xff00001f, 0xff000027, 0xff131323, 0xff000027, 
	0xff00002b, 0xff00002f, 0xff131323, 0xff0b172f, 0xff1b172f, 0xff0b0b17, 0xff131323, 0xff131323, 
	0xff0b172f, 0xff1b172f, 0xff1b172b, 0xff0b0b17, 0xff131323, 0xff1b172b, 0xff131323, 0xff1b172f, 
	0xff1b172b, 0xff131323, 0xff1b172b, 0xff131323, 0xff1b172b, 0xff1b172f, 0xff00002f, 0xff000037, 
	0xff0b172f, 0xff131323, 0xff1b172f, 0xff000037, 0xff00003b, 0xff00003f, 0xff0b172f, 0xff1b172f, 
	0xff0b172f, 0xff1b172f, 0xff000037, 0xff00003b, 0xff00003f, 0xff0b172f, 0xff0f1f3b, 0xff1b172f, 
	0xff1b172f, 0xff000037, 0xff000037, 0xff00003b, 0xff00003f, 0xff1b172f, 0xff1b172f, 0xff1b172f, 
	0xff231f3b, 0xff131323, 0xff0b171f, 0xff0f1b27, 0xff1b172b, 0xff131323, 0xff0b172f, 0xff0f1b27, 
	0xff1b172b, 0xff1b172f, 0xff0b171f, 0xff0f1b27, 0xff131323, 0xff171f27, 0xff1b172b, 0xff0f1b27, 
	0xff0b172f, 0xff13232f, 0xff0f232b, 0xff171f27, 0xff1b172b, 0xff1b172f, 0xff131323, 0xff1b172b, 
	0xff1f1f1f, 0xff131323, 0xff1b172b, 0xff1b172f, 0xff131323, 0xff1b172b, 0xff171f27, 0xff1f1f1f, 
	0xff1b172b, 0xff1b172f, 0xff171f27, 0xff13232f, 0xff231f37, 0xff0b172f, 0xff0f1f3b, 0xff13232f, 
	0xff1b172f, 0xff231f37, 0xff231f3b, 0xff0b130b, 0xff001313, 0xff001b1b, 0xff131b0f, 0xff172317, 
	0xff001b1b, 0xff002323, 0xff072b2b, 0xff172317, 0xff131b0f, 0xff0b171f, 0xff0f1b27, 0xff0f232b, 
	0xff131b0f, 0xff001b1b, 0xff002323, 0xff172317, 0xff072b2b, 0xff1f2b1f, 0xff002323, 0xff072b2b, 
	0xff072f2f, 0xff172317, 0xff1f2b1f, 0xff131b0f, 0xff172317, 0xff1f2b1f, 0xff131b0f, 0xff172317, 
	0xff0b171f, 0xff0f1b27, 0xff072b2b, 0xff1f2b1f, 0xff171f27, 0xff1f1f1f, 0xff131b0f, 0xff172317, 
	0xff1f2b1f, 0xff273323, 0xff172317, 0xff1f2b1f, 0xff072b2b, 0xff072f2f, 0xff273323, 0xff002323, 
	0xff001f2b, 0xff072b2b, 0xff001f2b, 0xff002323, 0xff002b2f, 0xff072b2b, 0xff002323, 0xff002b2f, 
	0xff072b2b, 0xff002323, 0xff002b2f, 0xff072b2b, 0xff072f2f, 0xff002323, 0xff0f1b27, 0xff0f232b, 
	0xff072b2b, 0xff0b171f, 0xff0f232b, 0xff072b2b, 0xff13232f, 0xff002323, 0xff072b2b, 0xff0f232b, 
	0xff072b2b, 0xff072f2f, 0xff0f232b, 0xff13232f, 0xff001f2b, 0xff002b3b, 0xff002b2f, 0xff0f1f3b, 
	0xff072b2b, 0xff0b172f, 0xff072f2f, 0xff002b3b, 0xff0f1f3b, 0xff002b2f, 0xff002b3b, 0xff002f37, 
	0xff072f2f, 0xff072b2b, 0xff002b3b, 0xff002f37, 0xff0f232b, 0xff0b172f, 0xff0f1f3b, 0xff072b2b, 
	0xff072f2f, 0xff002b3b, 0xff13232f, 0xff132b37, 0xff0f1f3b, 0xff002b3b, 0xff132b37, 0xff072b2b, 
	0xff072f2f, 0xff002b3b, 0xff002f37, 0xff132b37, 0xff13232f, 0xff0f232b, 0xff002b3b, 0xff002f37, 
	0xff073737, 0xff132b37, 0xff0f1f3b, 0xff072f2f, 0xff172f3f, 0xff002323, 0xff072b2b, 0xff002b2f, 
	0xff072f2f, 0xff073737, 0xff002b2f, 0xff002f37, 0xff073737, 0xff072f2f, 0xff002f37, 0xff002b3b, 
	0xff003743, 0xff073737, 0xff073737, 0xff073737, 0xff003743, 0xff073f3f, 0xff072f2f, 0xff073737, 
	0xff132b37, 0xff073737, 0xff002b3b, 0xff172f3f, 0xff132b37, 0xff073737, 0xff073737, 0xff073f3f, 
	0xff0f1b27, 0xff0f232b, 0xff171f27, 0xff172317, 0xff1f2b1f, 0xff0f232b, 0xff13232f, 0xff171f27, 
	0xff0f232b, 0xff072b2b, 0xff172317, 0xff1f2b1f, 0xff171f27, 0xff0f232b, 0xff13232f, 0xff072b2b, 
	0xff132b37, 0xff072f2f, 0xff172b37, 0xff1f2b1f, 0xff171f27, 0xff1f1f1f, 0xff171f27, 0xff1f2b1f, 
	0xff171f27, 0xff13232f, 0xff1b172f, 0xff1f2b37, 0xff231f37, 0xff1f2b1f, 0xff1b172b, 0xff1f2b1f, 
	0xff171f27, 0xff171f27, 0xff13232f, 0xff172b37, 0xff1f2b1f, 0xff1f2b37, 0xff273323, 0xff13232f, 
	0xff0f1f3b, 0xff132b37, 0xff172b37, 0xff0f1f3b, 0xff132b37, 0xff172f3f, 0xff172b37, 0xff13232f, 
	0xff132b37, 0xff172b37, 0xff132b37, 0xff172f3f, 0xff172b37, 0xff13232f, 0xff172b37, 0xff231f37, 
	0xff1b172f, 0xff1f2b37, 0xff0f1f3b, 0xff172b37, 0xff172f3f, 0xff231f37, 0xff231f3b, 0xff1f2b37, 
	0xff13232f, 0xff172b37, 0xff1f2b37, 0xff172b37, 0xff172f3f, 0xff1f2b37, 0xff072b2b, 0xff072f2f, 
	0xff1f2b1f, 0xff072b2b, 0xff072f2f, 0xff132b37, 0xff13232f, 0xff1f2b1f, 0xff172b37, 0xff273323, 
	0xff072b2b, 0xff072f2f, 0xff1f2b1f, 0xff273323, 0xff072f2f, 0xff073737, 0xff172b37, 0xff1f2b1f, 
	0xff273323, 0xff1f2b1f, 0xff273323, 0xff1f2b1f, 0xff172b37, 0xff273323, 0xff1f2b37, 0xff1f2b1f, 
	0xff273323, 0xff273323, 0xff172b37, 0xff073737, 0xff2f3b2b, 0xff1f2b37, 0xff072f2f, 0xff132b37, 
	0xff073737, 0xff172f3f, 0xff172b37, 0xff132b37, 0xff172f3f, 0xff073737, 0xff172b37, 0xff073737, 
	0xff172f3f, 0xff172b37, 0xff073737, 0xff172f3f, 0xff073f3f, 0xff1b3347, 0xff1b374b, 0xff172b37, 
	0xff172f3f, 0xff1f2b37, 0xff172b37, 0xff172f3f, 0xff1f2b37, 0xff1b3347, 0xff273343, 0xff172b37, 
	0xff172f3f, 0xff073737, 0xff2f3b2b, 0xff1f2b37, 0xff273343, 0xff172f3f, 0xff1b3347, 0xff1b374b, 
	0xff1f2b37, 0xff273343, 0xff0f0b0b, 0xff1f1313, 0xff271b1b, 0xff1f1f1f, 0xff131b0f, 0xff172317, 
	0xff2f1b1b, 0xff3f2323, 0xff1f1313, 0xff131323, 0xff1b172b, 0xff1b172f, 0xff271b1b, 0xff2f1b1b, 
	0xff231f37, 0xff1b172f, 0xff231f3b, 0xff231f37, 0xff1f1313, 0xff1b172b, 0xff271b1b, 0xff1f1f1f, 
	0xff1b172b, 0xff1b172f, 0xff231f37, 0xff1f1f1f, 0xff1b172b, 0xff271b1b, 0xff1b172b, 0xff1b172f, 
	0xff1f1f1f, 0xff231f37, 0xff171f27, 0xff271b1b, 0xff1b172b, 0xff2f1b1b, 0xff1b172b, 0xff1b172f, 
	0xff231f37, 0xff271b1b, 0xff2f1b1b, 0xff332727, 0xff271b1b, 0xff1f1f1f, 0xff332727, 0xff2f1b1b, 
	0xff271b1b, 0xff1b172b, 0xff231f37, 0xff1f1f1f, 0xff332727, 0xff2f1b1b, 0xff1b172f, 0xff231f3b, 
	0xff231f37, 0xff2b2347, 0xff2f2743, 0xff332727, 0xff2f1b1b, 0xff1b172b, 0xff1b172f, 0xff231f37, 
	0xff3f2323, 0xff1b172f, 0xff231f3b, 0xff231f37, 0xff2b2347, 0xff2f1b1b, 0xff3f2323, 0xff2f2743, 
	0xff2f1b1b, 0xff231f37, 0xff332727, 0xff3f2323, 0xff231f37, 0xff231f3b, 0xff2b2347, 0xff332727, 
	0xff2f2743, 0xff3f2323, 0xff3f2f2f, 0xff131b0f, 0xff172317, 0xff1f2b1f, 0xff1f1313, 0xff271b1b, 
	0xff2f1b1b, 0xff273323, 0xff172317, 0xff1f1f1f, 0xff1f2b1f, 0xff271b1b, 0xff273323, 0xff332727, 
	0xff2f1b1b, 0xff172317, 0xff1f2b1f, 0xff273323, 0xff2f1b1b, 0xff1f2b1f, 0xff273323, 0xff2f3b2b, 
	0xff2f1b1b, 0xff273323, 0xff3f2323, 0xff2f1b1b, 0xff332727, 0xff273323, 0xff3f2323, 0xff2f1b1b, 
	0xff273323, 0xff3f2323, 0xff2f3b2b, 0xff273323, 0xff2f3b2b, 0xff332727, 0xff3f2323, 0xff37432f, 
	0xff3f2f2f, 0xff1f1f1f, 0xff1f2b1f, 0xff271b1b, 0xff332727, 0xff1f1f1f, 0xff171f27, 0xff1b172b, 
	0xff231f37, 0xff1f2b37, 0xff1f2b1f, 0xff2f2f2f, 0xff332727, 0xff1f2b1f, 0xff273323, 0xff1f2b1f, 
	0xff1f2b37, 0xff273323, 0xff2f2f2f, 0xff332727, 0xff271b1b, 0xff1f1f1f, 0xff332727, 0xff1f2b1f, 
	0xff2f1b1b, 0xff1f1f1f, 0xff332727, 0xff231f37, 0xff2f2f2f, 0xff1f2b1f, 0xff332727, 0xff273323, 
	0xff2f2f2f, 0xff332727, 0xff2f2f2f, 0xff273323, 0xff231f37, 0xff1f2b37, 0xff2f2f2f, 0xff231f37, 
	0xff231f3b, 0xff1f2b37, 0xff2f2743, 0xff1f2b37, 0xff2f2f2f, 0xff1f2b37, 0xff172f3f, 0xff273343, 
	0xff231f3b, 0xff2f2743, 0xff231f37, 0xff2f2f2f, 0xff332727, 0xff2f2743, 0xff231f37, 0xff231f3b, 
	0xff2f2743, 0xff2b2347, 0xff2f2f2f, 0xff1f2b37, 0xff231f37, 0xff1f2b37, 0xff231f3b, 0xff2f2743, 
	0xff273343, 0xff2f2f2f, 0xff231f37, 0xff1f2b1f, 0xff273323, 0xff1f2b37, 0xff2f3b2b, 0xff2f2f2f, 
	0xff1f2b37, 0xff273343, 0xff2f3b2b, 0xff2f2f2f, 0xff37432f, 0xff2f1b1b, 0xff332727, 0xff2f2f2f, 
	0xff273323, 0xff3f2323, 0xff3f2f2f, 0xff332727, 0xff231f37, 0xff2f2743, 0xff2f2f2f, 0xff372f4b, 
	0xff3f2f2f, 0xff3f2323, 0xff273323, 0xff332727, 0xff2f2f2f, 0xff2f3b2b, 0xff37432f, 0xff3f2f2f, 
	0xff3f2323, 0xff2f2f2f, 0xff2f2743, 0xff273343, 0xff2f3b2b, 0xff37432f, 0xff3f3f3f, 0xff372f4b, 
	0xff3f2f2f, 0xff00003f, 0xff000047, 0xff00004f, 0xff00074b, 0xff0f1f3b, 0xff00004f, 0xff000057, 
	0xff00005f, 0xff00075f, 0xff00074b, 0xff00074b, 0xff0f1f3b, 0xff002b3b, 0xff13234b, 0xff00074b, 
	0xff00075f, 0xff13234b, 0xff000f6f, 0xff172b57, 0xff00003f, 0xff000047, 0xff00004f, 0xff00074b, 
	0xff0f1f3b, 0xff13234b, 0xff1b172f, 0xff231f3b, 0xff00004f, 0xff000057, 0xff00005f, 0xff00075f, 
	0xff00074b, 0xff13234b, 0xff172b57, 0xff0f1f3b, 0xff00074b, 0xff13234b, 0xff1b172f, 0xff231f3b, 
	0xff2b2347, 0xff00074b, 0xff00075f, 0xff13234b, 0xff172b57, 0xff00005f, 0xff000067, 0xff00006f, 
	0xff00075f, 0xff000f6f, 0xff00006f, 0xff000077, 0xff00007f, 0xff000f6f, 0xff07177f, 0xff00075f, 
	0xff000f6f, 0xff172b57, 0xff07177f, 0xff000f6f, 0xff07177f, 0xff00005f, 0xff000067, 0xff00006f, 
	0xff00075f, 0xff000f6f, 0xff07177f, 0xff172b57, 0xff1f2f63, 0xff00006f, 0xff000077, 0xff00007f, 
	0xff000f6f, 0xff07177f, 0xff00075f, 0xff000f6f, 0xff172b57, 0xff07177f, 0xff1f2f63, 0xff000f6f, 
	0xff07177f, 0xff1f2f63, 0xff233773, 0xff002b3b, 0xff0f1f3b, 0xff13234b, 0xff002b3b, 0xff13234b, 
	0xff00374b, 0xff002b3b, 0xff003743, 0xff13234b, 0xff002b3b, 0xff00374b, 0xff13234b, 0xff0f1f3b, 
	0xff13234b, 0xff002b3b, 0xff13234b, 0xff002b3b, 0xff13234b, 0xff003743, 0xff0f1f3b, 0xff073b4b, 
	0xff132b37, 0xff172f3f, 0xff13234b, 0xff00374b, 0xff073b4b, 0xff172f3f, 0xff172b57, 0xff13234b, 
	0xff00075f, 0xff000f6f, 0xff172b57, 0xff00374b, 0xff073b4b, 0xff002b3b, 0xff003743, 0xff073b4b, 
	0xff00374b, 0xff073b4b, 0xff003743, 0xff073f3f, 0xff073b4b, 0xff00374b, 0xff073b4b, 0xff002b3b, 
	0xff003743, 0xff073b4b, 0xff073f3f, 0xff073737, 0xff172f3f, 0xff00374b, 0xff073b4b, 0xff172f3f, 
	0xff172b57, 0xff1b3347, 0xff073f3f, 0xff003743, 0xff073b4b, 0xff073b4b, 0xff00374b, 0xff074357, 
	0xff00475b, 0xff073b4b, 0xff07475f, 0xff172b57, 0xff1b3b53, 0xff0f1f3b, 0xff13234b, 0xff172f3f, 
	0xff13234b, 0xff172f3f, 0xff13234b, 0xff1b3347, 0xff13234b, 0xff172b57, 0xff172f3f, 0xff1b3347, 
	0xff0f1f3b, 0xff13234b, 0xff172f3f, 0xff231f3b, 0xff1f2b37, 0xff1b3347, 0xff2b2347, 0xff13234b, 
	0xff172b57, 0xff2b2347, 0xff1b3347, 0xff172f3f, 0xff13234b, 0xff1b3347, 0xff1f2b37, 0xff13234b, 
	0xff172b57, 0xff1b3347, 0xff1b374b, 0xff13234b, 0xff172b57, 0xff1f2f63, 0xff1b374b, 0xff233753, 
	0xff172f3f, 0xff1b3347, 0xff172b57, 0xff1b374b, 0xff073b4b, 0xff073f3f, 0xff1b3b53, 0xff172b57, 
	0xff1b374b, 0xff073b4b, 0xff1b3b53, 0xff172b57, 0xff1b3b53, 0xff1f2f63, 0xff073b4b, 0xff1b3b53, 
	0xff074357, 0xff1b3b53, 0xff074357, 0xff07475f, 0xff1f435b, 0xff1f2f63, 0xff172b57, 0xff1b374b, 
	0xff1b3b53, 0xff233753, 0xff172b57, 0xff1f2f63, 0xff1b3b53, 0xff233753, 0xff1b3b53, 0xff1f435b, 
	0xff233753, 0xff1b3b53, 0xff1f2f63, 0xff1f435b, 0xff233753, 0xff000f6f, 0xff172b57, 0xff07177f, 
	0xff00374b, 0xff074357, 0xff07475f, 0xff1f2f63, 0xff000f6f, 0xff07177f, 0xff1f2f63, 0xff233773, 
	0xff00374b, 0xff074357, 0xff07475f, 0xff00475b, 0xff0b4b6b, 0xff172b57, 0xff1f2f63, 0xff233773, 
	0xff07475f, 0xff07177f, 0xff0b4b6b, 0xff071f93, 0xff0f5377, 0xff1f2f63, 0xff233773, 0xff172b57, 
	0xff1f2f63, 0xff07177f, 0xff233773, 0xff07177f, 0xff1f2f63, 0xff233773, 0xff172b57, 0xff1f2f63, 
	0xff1f2f63, 0xff233773, 0xff074357, 0xff1f2f63, 0xff07475f, 0xff0b4b6b, 0xff1b3b53, 0xff1f435b, 
	0xff1f2f63, 0xff0b4b6b, 0xff233773, 0xff1f435b, 0xff1f4b63, 0xff1f2f63, 0xff1f2f63, 0xff233773, 
	0xff1f2f63, 0xff1f435b, 0xff2b3f63, 0xff1f2f63, 0xff233773, 0xff1f435b, 0xff1f4b63, 0xff2b3f63, 
	0xff1f2f63, 0xff233773, 0xff0b4b6b, 0xff0f5377, 0xff2b3b7f, 0xff1b172f, 0xff000047, 0xff00004f, 
	0xff231f3b, 0xff00074b, 0xff13234b, 0xff2b2347, 0xff00004f, 0xff000057, 0xff00005f, 0xff00075f, 
	0xff13234b, 0xff172b57, 0xff2b2347, 0xff372b53, 0xff231f3b, 0xff2b2347, 0xff13234b, 0xff2f2743, 
	0xff13234b, 0xff172b57, 0xff1f2f63, 0xff2b2347, 0xff372b53, 0xff231f3b, 0xff2b2347, 0xff2f2743, 
	0xff372b53, 0xff2b2347, 0xff372b53, 0xff231f3b, 0xff2b2347, 0xff2f2743, 0xff372b53, 0xff372f4b, 
	0xff2b2347, 0xff372b53, 0xff00005f, 0xff000067, 0xff00075f, 0xff2b2347, 0xff000067, 0xff00006f, 
	0xff07177f, 0xff00075f, 0xff000067, 0xff000f6f, 0xff172b57, 0xff1f2f63, 0xff2b2347, 0xff000067, 
	0xff000f6f, 0xff07177f, 0xff1f2f63, 0xff00005f, 0xff000067, 0xff2b2347, 0xff00075f, 0xff1f2f63, 
	0xff372b53, 0xff000067, 0xff00006f, 0xff07177f, 0xff1f2f63, 0xff372b53, 0xff2b2347, 0xff1f2f63, 
	0xff372b53, 0xff1f2f63, 0xff000f6f, 0xff07177f, 0xff372b53, 0xff00006f, 0xff000077, 0xff00007f, 
	0xff07177f, 0xff000f6f, 0xff1f2f63, 0xff172b57, 0xff1f2f63, 0xff000f6f, 0xff07177f, 0xff2b2347, 
	0xff372b53, 0xff07177f, 0xff1f2f63, 0xff233773, 0xff2b3b7f, 0xff2b2347, 0xff000067, 0xff00006f, 
	0xff372b53, 0xff1f2f63, 0xff3f335f, 0xff00006f, 0xff000077, 0xff07177f, 0xff1f2f63, 0xff233773, 
	0xff372b53, 0xff2b3b7f, 0xff3f335f, 0xff372b53, 0xff1f2f63, 0xff3f335f, 0xff1f2f63, 0xff233773, 
	0xff07177f, 0xff2b3b7f, 0xff3f335f, 0xff372b53, 0xff4b3b6b, 0xff231f3b, 0xff2b2347, 0xff2f2743, 
	0xff2b2347, 0xff13234b, 0xff172b57, 0xff1f2b37, 0xff172f3f, 0xff1b3347, 0xff273343, 0xff231f3b, 
	0xff2b2347, 0xff2f2743, 0xff1b3347, 0xff172b57, 0xff233753, 0xff2b2347, 0xff273343, 0xff231f3b, 
	0xff2b2347, 0xff2f2743, 0xff2b2347, 0xff2f2743, 0xff372b53, 0xff2f2743, 0xff2b2347, 0xff273343, 
	0xff372f4b, 0xff2b2347, 0xff273343, 0xff233753, 0xff2f2743, 0xff372f4b, 0xff372b53, 0xff13234b, 
	0xff172b57, 0xff1f2f63, 0xff233753, 0xff2b2347, 0xff372b53, 0xff372f4b, 0xff273343, 0xff1b3347, 
	0xff1b374b, 0xff233753, 0xff1b3b53, 0xff333f53, 0xff372f4b, 0xff233753, 0xff1f2f63, 0xff1f435b, 
	0xff1b3b53, 0xff2b3f63, 0xff333f53, 0xff372f4b, 0xff372b53, 0xff2f2743, 0xff2b2347, 0xff372b53, 
	0xff372f4b, 0xff2b2347, 0xff372b53, 0xff372f4b, 0xff3f335f, 0xff433757, 0xff2f2743, 0xff372f4b, 
	0xff273343, 0xff333f53, 0xff3f3f3f, 0xff433757, 0xff372f4b, 0xff372b53, 0xff3f335f, 0xff2b3f63, 
	0xff333f53, 0xff433757, 0xff3b4b5f, 0xff4b3f5f, 0xff1f2f63, 0xff233773, 0xff372b53, 0xff1f2f63, 
	0xff233773, 0xff2b3b7f, 0xff1f2f63, 0xff233773, 0xff1f435b, 0xff2b3f63, 0xff33476f, 0xff233773, 
	0xff2b3b7f, 0xff33476f, 0xff372b53, 0xff1f2f63, 0xff233773, 0xff3f335f, 0xff2b3f63, 0xff1f2f63, 
	0xff233773, 0xff2b3b7f, 0xff3f335f, 0xff4b3b6b, 0xff3f335f, 0xff2b3f63, 0xff233773, 0xff33476f, 
	0xff3b4b5f, 0xff4b3b6b, 0xff4b3f5f, 0xff233773, 0xff2b3b7f, 0xff33476f, 0xff3f335f, 0xff4b3b6b, 
	0xff3f537f, 0xff172317, 0xff002323, 0xff072b2b, 0xff072f2f, 0xff1f2b1f, 0xff273323, 0xff002323, 
	0xff072b2b, 0xff072f2f, 0xff073737, 0xff172317, 0xff1f2b1f, 0xff273323, 0xff172317, 0xff072b2b, 
	0xff072f2f, 0xff073737, 0xff1f2b1f, 0xff273323, 0xff072f2f, 0xff073737, 0xff073f3f, 0xff1f2b1f, 
	0xff273323, 0xff172317, 0xff1f2b1f, 0xff273323, 0xff1f2b1f, 0xff072f2f, 0xff273323, 0xff073737, 
	0xff2f3b2b, 0xff1f2b1f, 0xff273323, 0xff2f3b2b, 0xff273323, 0xff073737, 0xff073f3f, 0xff2f3b2b, 
	0xff37432f, 0xff072f2f, 0xff073737, 0xff073f3f, 0xff073737, 0xff073f3f, 0xff074747, 0xff0b4b4b, 
	0xff073737, 0xff073f3f, 0xff074747, 0xff0b4b4b, 0xff073f3f, 0xff074747, 0xff0b4b4b, 0xff072f2f, 
	0xff073737, 0xff073f3f, 0xff1f2b1f, 0xff273323, 0xff2f3b2b, 0xff073737, 0xff073f3f, 0xff073f3f, 
	0xff0b4b4b, 0xff1b374b, 0xff073f3f, 0xff0b4b4b, 0xff073f3f, 0xff074747, 0xff0b4b4b, 0xff073737, 
	0xff172f3f, 0xff073f3f, 0xff2f3b2b, 0xff273343, 0xff172f3f, 0xff1b3347, 0xff1b374b, 0xff073f3f, 
	0xff0b4b4b, 0xff273343, 0xff2f3b2b, 0xff073f3f, 0xff0b4b4b, 0xff2f3b2b, 0xff37432f, 0xff073f3f, 
	0xff0b4b4b, 0xff1b374b, 0xff2f3b2b, 0xff273343, 0xff073737, 0xff073f3f, 0xff074747, 0xff0b4b4b, 
	0xff273323, 0xff2f3b2b, 0xff37432f, 0xff073f3f, 0xff074747, 0xff0b4b4b, 0xff2f3b2b, 0xff37432f, 
	0xff072f2f, 0xff073737, 0xff073f3f, 0xff1f2b1f, 0xff273323, 0xff2f3b2b, 0xff073737, 0xff073f3f, 
	0xff074747, 0xff273323, 0xff2f3b2b, 0xff0b4b4b, 0xff073737, 0xff073f3f, 0xff074747, 0xff273323, 
	0xff2f3b2b, 0xff37432f, 0xff073f3f, 0xff074747, 0xff0b4b4b, 0xff2f3b2b, 0xff37432f, 0xff273323, 
	0xff2f3b2b, 0xff37432f, 0xff273323, 0xff073f3f, 0xff2f3b2b, 0xff074747, 0xff0b4b4b, 0xff37432f, 
	0xff273323, 0xff2f3b2b, 0xff37432f, 0xff2f3b2b, 0xff37432f, 0xff073f3f, 0xff074747, 0xff0b4b4b, 
	0xff3f4b37, 0xff073f3f, 0xff074747, 0xff0b4b4b, 0xff0b5353, 0xff0b5b5b, 0xff2f3b2b, 0xff37432f, 
	0xff3f4b37, 0xff1f2b1f, 0xff273323, 0xff2f3b2b, 0xff37432f, 0xff3f4b37, 0xff273323, 0xff2f3b2b, 
	0xff37432f, 0xff2f3b2b, 0xff273343, 0xff1b374b, 0xff37432f, 0xff0b4b4b, 0xff3f4b37, 0xff3f3f3f, 
	0xff2f3b2b, 0xff37432f, 0xff3f4b37, 0xff2f3b2b, 0xff37432f, 0xff0b4b4b, 0xff3f4b37, 0xff47533f, 
	0xff2f3b2b, 0xff37432f, 0xff3f4b37, 0xff2f3b2b, 0xff37432f, 0xff3f3f3f, 0xff3f4b37, 0xff47533f, 
	0xff37432f, 0xff3f4b37, 0xff47533f, 0xff37432f, 0xff3f4b37, 0xff47533f, 0xff273323, 0xff2f3b2b, 
	0xff37432f, 0xff3f4b37, 0xff47533f, 0xff37432f, 0xff0b4b4b, 0xff0b5353, 0xff3f4b37, 0xff0b5b5b, 
	0xff47533f, 0xff4f5b47, 0xff57634f, 0xff073f3f, 0xff003743, 0xff073b4b, 0xff074747, 0xff074357, 
	0xff0b4b4b, 0xff073b4b, 0xff074357, 0xff00475b, 0xff0b4b4b, 0xff0b5353, 0xff074747, 0xff07475f, 
	0xff074747, 0xff0b4b4b, 0xff0b5353, 0xff0b5353, 0xff00475b, 0xff00536b, 0xff0b5b5b, 0xff07475f, 
	0xff073f3f, 0xff073b4b, 0xff074747, 0xff0b4b4b, 0xff1b3b53, 0xff1b374b, 0xff1f435b, 0xff073b4b, 
	0xff074357, 0xff07475f, 0xff0b4b4b, 0xff0b5353, 0xff1b3b53, 0xff1f435b, 0xff1f4b63, 0xff0b4b4b, 
	0xff0b5353, 0xff1f435b, 0xff0b5353, 0xff0b5b5b, 0xff1f4b63, 0xff1f536b, 0xff1f435b, 0xff00475b, 
	0xff07475f, 0xff0b4b6b, 0xff00536b, 0xff0b4b6b, 0xff0f5377, 0xff00536b, 0xff00475b, 0xff00536b, 
	0xff07475f, 0xff0b5b5b, 0xff0b4b6b, 0xff00536b, 0xff0b4b6b, 0xff00536b, 0xff0b5b5b, 0xff0b6363, 
	0xff00536b, 0xff0b6363, 0xff07637b, 0xff07475f, 0xff0b4b6b, 0xff0b5b5b, 0xff00536b, 0xff0b4b6b, 
	0xff00536b, 0xff0f5377, 0xff0b5b5b, 0xff00536b, 0xff0b6363, 0xff00536b, 0xff0b6363, 0xff07637b, 
	0xff0f5377, 0xff0b4b6b, 0xff0f6b6b, 0xff00536b, 0xff0f5377, 0xff07637b, 0xff0b4b6b, 0xff135783, 
	0xff0f6b6b, 0xff07475f, 0xff0b4b6b, 0xff1f435b, 0xff1f4b63, 0xff0f5377, 0xff1f536b, 0xff233773, 
	0xff0b4b6b, 0xff0f5377, 0xff135783, 0xff233773, 0xff1f536b, 0xff1f5773, 0xff1f4b63, 0xff2b3b7f, 
	0xff07475f, 0xff0b4b6b, 0xff0b5b5b, 0xff1f536b, 0xff1f4b63, 0xff0b4b6b, 0xff0f5377, 0xff1f536b, 
	0xff1f5773, 0xff0b5b5b, 0xff0b6363, 0xff1f536b, 0xff0b6363, 0xff0f5377, 0xff0f6b6b, 0xff1f536b, 
	0xff1f5773, 0xff1f4b63, 0xff1f536b, 0xff1f536b, 0xff1f5773, 0xff1f536b, 0xff0b5b5b, 0xff0b6363, 
	0xff1f536b, 0xff1f5773, 0xff0f5377, 0xff135783, 0xff07637b, 0xff0f6b6b, 0xff1f5773, 0xff235f7b, 
	0xff1f536b, 0xff0b5353, 0xff0b5b5b, 0xff0b6363, 0xff0f6b6b, 0xff1f536b, 0xff0b6363, 0xff00536b, 
	0xff07637b, 0xff0f6b6b, 0xff07637b, 0xff0f6b6b, 0xff07738b, 0xff0b6363, 0xff0f6b6b, 0xff0f6b6b, 
	0xff07637b, 0xff07738b, 0xff0b6363, 0xff0f6b6b, 0xff1f5773, 0xff1f536b, 0xff235f7b, 0xff0f6b6b, 
	0xff07637b, 0xff135783, 0xff07738b, 0xff0f5377, 0xff1f5773, 0xff236783, 0xff235f7b, 0xff0f6b6b, 
	0xff0f6b6b, 0xff07637b, 0xff07738b, 0xff236783, 0xff236f8f, 0xff1b374b, 0xff273343, 0xff333f53, 
	0xff1b374b, 0xff1b3b53, 0xff1f435b, 0xff233753, 0xff273343, 0xff333f53, 0xff1b374b, 0xff1b3b53, 
	0xff0b4b4b, 0xff1f435b, 0xff273343, 0xff333f53, 0xff37432f, 0xff3f4b37, 0xff1b3b53, 0xff1f435b, 
	0xff0b4b4b, 0xff333f53, 0xff273343, 0xff333f53, 0xff3f3f3f, 0xff273343, 0xff233753, 0xff333f53, 
	0xff273343, 0xff333f53, 0xff37432f, 0xff3f4b37, 0xff3f3f3f, 0xff333f53, 0xff1f435b, 0xff1b3b53, 
	0xff1f435b, 0xff1f4b63, 0xff233753, 0xff2b3f63, 0xff333f53, 0xff3b4b5f, 0xff0b4b4b, 0xff1f435b, 
	0xff0b5353, 0xff1f4b63, 0xff3f4b37, 0xff333f53, 0xff47533f, 0xff3b4b5f, 0xff1f435b, 0xff1f4b63, 
	0xff0b5353, 0xff1f536b, 0xff0b5b5b, 0xff333f53, 0xff3b4b5f, 0xff3f3f3f, 0xff333f53, 0xff3f4b37, 
	0xff47533f, 0xff3b4b5f, 0xff4b4b4b, 0xff433757, 0xff333f53, 0xff2b3f63, 0xff3b4b5f, 0xff433757, 
	0xff4b4b4b, 0xff3f4b37, 0xff333f53, 0xff3b4b5f, 0xff47533f, 0xff4f5b47, 0xff4b4b4b, 0xff333f53, 
	0xff3b4b5f, 0xff4f5b47, 0xff47576b, 0xff4b4b4b, 0xff1f435b, 0xff1f4b63, 0xff233773, 0xff1f536b, 
	0xff2b3f63, 0xff33476f, 0xff3b4b5f, 0xff233773, 0xff2b3b7f, 0xff1f4b63, 0xff1f536b, 0xff1f5773, 
	0xff33476f, 0xff235f7b, 0xff3f537f, 0xff1f4b63, 0xff1f536b, 0xff1f5773, 0xff235f7b, 0xff33476f, 
	0xff3b4b5f, 0xff1f536b, 0xff1f5773, 0xff235f7b, 0xff33476f, 0xff3f537f, 0xff2b3f63, 0xff33476f, 
	0xff3b4b5f, 0xff47576b, 0xff4b3b6b, 0xff33476f, 0xff2b3b7f, 0xff3f537f, 0xff47576b, 0xff3b4b5f, 
	0xff33476f, 0xff1f536b, 0xff1f5773, 0xff235f7b, 0xff47576b, 0xff33476f, 0xff3f537f, 0xff235f7b, 
	0xff1f5773, 0xff47576b, 0xff0b5353, 0xff0b5b5b, 0xff3f4b37, 0xff1f4b63, 0xff47533f, 0xff3b4b5f, 
	0xff4f5b47, 0xff0b5b5b, 0xff1f536b, 0xff0b6363, 0xff0f6b6b, 0xff1f4b63, 0xff3b4b5f, 0xff4f5b47, 
	0xff0b5b5b, 0xff0b6363, 0xff0f6b6b, 0xff47533f, 0xff4f5b47, 0xff0b6363, 0xff0f6b6b, 0xff4f5b47, 
	0xff47533f, 0xff3b4b5f, 0xff4f5b47, 0xff57634f, 0xff3b4b5f, 0xff1f536b, 0xff4f5b47, 0xff235f7b, 
	0xff47576b, 0xff57634f, 0xff47533f, 0xff4f5b47, 0xff0f6b6b, 0xff57634f, 0xff4f5b47, 0xff3b4b5f, 
	0xff0f6b6b, 0xff235f7b, 0xff47576b, 0xff57634f, 0xff5f6b57, 0xff1f536b, 0xff1f5773, 0xff235f7b, 
	0xff0f6b6b, 0xff1f5773, 0xff235f7b, 0xff236783, 0xff0f6b6b, 0xff0f6b6b, 0xff235f7b, 0xff236783, 
	0xff0f6b6b, 0xff236783, 0xff236f8f, 0xff235f7b, 0xff3b4b5f, 0xff1f536b, 0xff1f5773, 0xff235f7b, 
	0xff47576b, 0xff235f7b, 0xff236783, 0xff3f537f, 0xff47576b, 0xff475f8b, 0xff53637b, 0xff235f7b, 
	0xff0f6b6b, 0xff236783, 0xff47576b, 0xff53637b, 0xff5f6b57, 0xff235f7b, 0xff236783, 0xff236f8f, 
	0xff47576b, 0xff53637b, 0xff475f8b, 0xff2f1b1b, 0xff3f2323, 0xff4f2b2b, 0xff5f2f2f, 0xff2f1b1b, 
	0xff3f2323, 0xff231f3b, 0xff2b2347, 0xff2f2743, 0xff3f2f2f, 0xff4f2b2b, 0xff5f2f2f, 0xff2f1b1b, 
	0xff3f2323, 0xff3f2f2f, 0xff2f3b2b, 0xff37432f, 0xff273323, 0xff4f2b2b, 0xff5f2f2f, 0xff3f2323, 
	0xff3f2f2f, 0xff4f2b2b, 0xff3f2323, 0xff3f2f2f, 0xff2f2743, 0xff372f4b, 0xff4b3737, 0xff4f2b2b, 
	0xff3f2323, 0xff3f2f2f, 0xff37432f, 0xff4b3737, 0xff4f2b2b, 0xff3f2f2f, 0xff4b3737, 0xff3f3f3f, 
	0xff37432f, 0xff4f2b2b, 0xff573f3f, 0xff4f2b2b, 0xff5f2f2f, 0xff4f2b2b, 0xff4b3737, 0xff5f2f2f, 
	0xff573f3f, 0xff4f2b2b, 0xff4b3737, 0xff5f2f2f, 0xff573f3f, 0xff4f2b2b, 0xff4b3737, 0xff573f3f, 
	0xff5f2f2f, 0xff3f2323, 0xff4f2b2b, 0xff5f2f2f, 0xff6f2f2f, 0xff7f2f2f, 0xff4f2b2b, 0xff5f2f2f, 
	0xff6f2f2f, 0xff7f2f2f, 0xff4f2b2b, 0xff5f2f2f, 0xff6f2f2f, 0xff7f2f2f, 0xff5f2f2f, 0xff573f3f, 
	0xff674747, 0xff6f2f2f, 0xff7f2f2f, 0xff2b2347, 0xff2f2743, 0xff372b53, 0xff3f2323, 0xff4f2b2b, 
	0xff2b2347, 0xff372b53, 0xff2f2743, 0xff2b2347, 0xff372b53, 0xff372f4b, 0xff3f2f2f, 0xff4f2b2b, 
	0xff4b3737, 0xff372b53, 0xff3f335f, 0xff433757, 0xff4f2b2b, 0xff2b2347, 0xff372b53, 0xff5f2f2f, 
	0xff372b53, 0xff3f335f, 0xff5f2f2f, 0xff433757, 0xff4f2b2b, 0xff372b53, 0xff4b3737, 0xff433757, 
	0xff5f2f2f, 0xff372b53, 0xff3f335f, 0xff433757, 0xff4b3b6b, 0xff5f2f2f, 0xff372b53, 0xff3f335f, 
	0xff2b3b7f, 0xff4b3b6b, 0xff534373, 0xff2f2743, 0xff372f4b, 0xff372b53, 0xff4b3737, 0xff433757, 
	0xff3f2f2f, 0xff4f2b2b, 0xff372b53, 0xff3f335f, 0xff433757, 0xff372f4b, 0xff4b3f5f, 0xff372f4b, 
	0xff3f3f3f, 0xff433757, 0xff4b3737, 0xff4b4b4b, 0xff573f3f, 0xff433757, 0xff3f335f, 0xff4b3f5f, 
	0xff4b4b4b, 0xff4f2b2b, 0xff4b3737, 0xff372b53, 0xff433757, 0xff372f4b, 0xff573f3f, 0xff5f2f2f, 
	0xff433757, 0xff3f335f, 0xff4b3f5f, 0xff4b3b6b, 0xff573f3f, 0xff4b3737, 0xff573f3f, 0xff433757, 
	0xff4b4b4b, 0xff674747, 0xff433757, 0xff4b3f5f, 0xff4b4b4b, 0xff573f3f, 0xff674747, 0xff574b6b, 
	0xff3f335f, 0xff4b3b6b, 0xff4b3f5f, 0xff3f335f, 0xff4b3b6b, 0xff2b3b7f, 0xff534373, 0xff3f335f, 
	0xff4b3b6b, 0xff4b3f5f, 0xff534373, 0xff4b3b6b, 0xff2b3b7f, 0xff33476f, 0xff3f537f, 0xff534373, 
	0xff3f335f, 0xff4b3b6b, 0xff4b3f5f, 0xff534373, 0xff4b3b6b, 0xff534373, 0xff4b3f5f, 0xff4b3b6b, 
	0xff534373, 0xff574b6b, 0xff4b3b6b, 0xff534373, 0xff5f4b7f, 0xff5f2f2f, 0xff6f2f2f, 0xff5f2f2f, 
	0xff372b53, 0xff3f335f, 0xff433757, 0xff4b3b6b, 0xff6f2f2f, 0xff5f2f2f, 0xff6f2f2f, 0xff5f2f2f, 
	0xff433757, 0xff3f335f, 0xff4b3b6b, 0xff573f3f, 0xff4b3f5f, 0xff6f2f2f, 0xff674747, 0xff6f2f2f, 
	0xff7f2f2f, 0xff6f2f2f, 0xff7f2f2f, 0xff6f2f2f, 0xff7f2f2f, 0xff6f2f2f, 0xff4b3b6b, 0xff674747, 
	0xff7f2f2f, 0xff3f335f, 0xff4b3b6b, 0xff6f2f2f, 0xff4b3b6b, 0xff534373, 0xff3f335f, 0xff4b3b6b, 
	0xff534373, 0xff4b3b6b, 0xff534373, 0xff5f4b7f, 0xff6f2f2f, 0xff4b3b6b, 0xff7f2f2f, 0xff534373, 
	0xff4b3b6b, 0xff534373, 0xff5f4b7f, 0xff4b3b6b, 0xff534373, 0xff6f2f2f, 0xff674747, 0xff7f2f2f, 
	0xff734f4f, 0xff5f4b7f, 0xff4b3b6b, 0xff534373, 0xff5f4b7f, 0xff6b4f8b, 0xff5f2f2f, 0xff573f3f, 
	0xff674747, 0xff6f2f2f, 0xff5f2f2f, 0xff573f3f, 0xff433757, 0xff4b3b6b, 0xff4b3f5f, 0xff674747, 
	0xff6f2f2f, 0xff5f2f2f, 0xff573f3f, 0xff674747, 0xff6f2f2f, 0xff573f3f, 0xff4b3f5f, 0xff674747, 
	0xff574b6b, 0xff734f4f, 0xff6f2f2f, 0xff674747, 0xff7f2f2f, 0xff6f2f2f, 0xff674747, 0xff734f4f, 
	0xff7f2f2f, 0xff6f2f2f, 0xff674747, 0xff734f4f, 0xff7f2f2f, 0xff674747, 0xff734f4f, 0xff7f2f2f, 
	0xff4b3b6b, 0xff4b3f5f, 0xff534373, 0xff674747, 0xff574b6b, 0xff4b3b6b, 0xff534373, 0xff5f4b7f, 
	0xff4b3f5f, 0xff4b3b6b, 0xff534373, 0xff574b6b, 0xff674747, 0xff734f4f, 0xff635377, 0xff5f4b7f, 
	0xff534373, 0xff5f4b7f, 0xff574b6b, 0xff635377, 0xff4b3b6b, 0xff534373, 0xff674747, 0xff734f4f, 
	0xff574b6b, 0xff5f4b7f, 0xff7f2f2f, 0xff534373, 0xff5f4b7f, 0xff6b4f8b, 0xff674747, 0xff734f4f, 
	0xff574b6b, 0xff534373, 0xff5f4b7f, 0xff635377, 0xff7f5b5b, 0xff534373, 0xff5f4b7f, 0xff635377, 
	0xff6b4f8b, 0xff6f5b7f, 0xff7f5b5b, 0xff273323, 0xff2f3b2b, 0xff37432f, 0xff3f2323, 0xff4f2b2b, 
	0xff2f3b2b, 0xff37432f, 0xff3f4b37, 0xff4f2b2b, 0xff4b3737, 0xff37432f, 0xff3f4b37, 0xff37432f, 
	0xff3f4b37, 0xff47533f, 0xff4f2b2b, 0xff37432f, 0xff5f2f2f, 0xff4f2b2b, 0xff4b3737, 0xff37432f, 
	0xff3f4b37, 0xff5f2f2f, 0xff573f3f, 0xff37432f, 0xff3f4b37, 0xff4f2b2b, 0xff5f2f2f, 0xff47533f, 
	0xff37432f, 0xff3f4b37, 0xff47533f, 0xff5f2f2f, 0xff573f3f, 0xff37432f, 0xff3f4b37, 0xff4b3737, 
	0xff4f2b2b, 0xff47533f, 0xff37432f, 0xff3f3f3f, 0xff3f4b37, 0xff47533f, 0xff4b3737, 0xff4b4b4b, 
	0xff573f3f, 0xff37432f, 0xff3f4b37, 0xff47533f, 0xff3f4b37, 0xff47533f, 0xff4f5b47, 0xff4f2b2b, 
	0xff4b3737, 0xff3f4b37, 0xff47533f, 0xff573f3f, 0xff5f2f2f, 0xff4b3737, 0xff573f3f, 0xff3f4b37, 
	0xff47533f, 0xff674747, 0xff3f4b37, 0xff47533f, 0xff4f5b47, 0xff573f3f, 0xff47533f, 0xff4f5b47, 
	0xff573f3f, 0xff674747, 0xff57634f, 0xff37432f, 0xff3f4b37, 0xff47533f, 0xff4f5b47, 0xff57634f, 
	0xff3f4b37, 0xff47533f, 0xff4f5b47, 0xff57634f, 0xff5f6b57, 0xff5f2f2f, 0xff573f3f, 0xff47533f, 
	0xff3f4b37, 0xff674747, 0xff6f2f2f, 0xff7f2f2f, 0xff5f2f2f, 0xff573f3f, 0xff674747, 0xff6f2f2f, 
	0xff5f2f2f, 0xff573f3f, 0xff674747, 0xff6f2f2f, 0xff5f2f2f, 0xff573f3f, 0xff674747, 0xff47533f, 
	0xff4f5b47, 0xff6f2f2f, 0xff573f3f, 0xff674747, 0xff4f5b47, 0xff57634f, 0xff734f4f, 0xff6f2f2f, 
	0xff674747, 0xff7f2f2f, 0xff6f2f2f, 0xff674747, 0xff734f4f, 0xff7f2f2f, 0xff6f2f2f, 0xff674747, 
	0xff734f4f, 0xff7f2f2f, 0xff674747, 0xff734f4f, 0xff7f2f2f, 0xff3f4b37, 0xff47533f, 0xff5f2f2f, 
	0xff6f2f2f, 0xff4f5b47, 0xff674747, 0xff47533f, 0xff4f5b47, 0xff6f2f2f, 0xff674747, 0xff57634f, 
	0xff47533f, 0xff4f5b47, 0xff57634f, 0xff47533f, 0xff4f5b47, 0xff57634f, 0xff6f2f2f, 0xff674747, 
	0xff4f5b47, 0xff47533f, 0xff7f2f2f, 0xff6f2f2f, 0xff674747, 0xff4f5b47, 0xff57634f, 0xff734f4f, 
	0xff7f2f2f, 0xff6f2f2f, 0xff47533f, 0xff4f5b47, 0xff57634f, 0xff674747, 0xff7f2f2f, 0xff734f4f, 
	0xff4f5b47, 0xff57634f, 0xff674747, 0xff734f4f, 0xff5f6b57, 0xff7f2f2f, 0xff47533f, 0xff4f5b47, 
	0xff57634f, 0xff674747, 0xff734f4f, 0xff4f5b47, 0xff57634f, 0xff5f6b57, 0xff674747, 0xff734f4f, 
	0xff4f5b47, 0xff57634f, 0xff5f6b57, 0xff57634f, 0xff5f6b57, 0xff67735f, 0xff674747, 0xff734f4f, 
	0xff57634f, 0xff4f5b47, 0xff7f2f2f, 0xff674747, 0xff734f4f, 0xff5f6b57, 0xff57634f, 0xff7f5b5b, 
	0xff57634f, 0xff5f6b57, 0xff734f4f, 0xff7f5b5b, 0xff67735f, 0xff57634f, 0xff5f6b57, 0xff67735f, 
	0xff734f4f, 0xff7f5b5b, 0xff3f3f3f, 0xff433757, 0xff333f53, 0xff4b4b4b, 0xff3f4b37, 0xff47533f, 
	0xff573f3f, 0xff433757, 0xff4b3f5f, 0xff3b4b5f, 0xff333f53, 0xff4b4b4b, 0xff47576b, 0xff574b6b, 
	0xff47533f, 0xff4b4b4b, 0xff4f5b47, 0xff57634f, 0xff4b4b4b, 0xff3b4b5f, 0xff47576b, 0xff4f5b47, 
	0xff57634f, 0xff5b5b5b, 0xff4b3f5f, 0xff574b6b, 0xff573f3f, 0xff4b4b4b, 0xff47533f, 0xff4f5b47, 
	0xff674747, 0xff4b4b4b, 0xff4b3f5f, 0xff574b6b, 0xff5b5b5b, 0xff573f3f, 0xff674747, 0xff47533f, 
	0xff4b4b4b, 0xff4f5b47, 0xff57634f, 0xff5b5b5b, 0xff674747, 0xff4b4b4b, 0xff5b5b5b, 0xff574b6b, 
	0xff4f5b47, 0xff57634f, 0xff674747, 0xff4b3f5f, 0xff4b3b6b, 0xff3b4b5f, 0xff33476f, 0xff47576b, 
	0xff534373, 0xff574b6b, 0xff4b3b6b, 0xff33476f, 0xff3f537f, 0xff47576b, 0xff534373, 0xff574b6b, 
	0xff5f4b7f, 0xff3b4b5f, 0xff47576b, 0xff5b5b5b, 0xff574b6b, 0xff47576b, 0xff3f537f, 0xff475f8b, 
	0xff53637b, 0xff534373, 0xff574b6b, 0xff4b3f5f, 0xff4b3b6b, 0xff534373, 0xff574b6b, 0xff5b5b5b, 
	0xff635377, 0xff534373, 0xff574b6b, 0xff5f4b7f, 0xff635377, 0xff574b6b, 0xff5b5b5b, 0xff47576b, 
	0xff53637b, 0xff635377, 0xff574b6b, 0xff534373, 0xff5f4b7f, 0xff47576b, 0xff53637b, 0xff635377, 
	0xff47533f, 0xff4f5b47, 0xff47576b, 0xff57634f, 0xff5f6b57, 0xff5b5b5b, 0xff67735f, 0xff47576b, 
	0xff53637b, 0xff5f6b57, 0xff5b5b5b, 0xff47576b, 0xff3f537f, 0xff475f8b, 0xff53637b, 0xff47576b, 
	0xff53637b, 0xff5f6b57, 0xff67735f, 0xff53637b, 0xff475f8b, 0xff5f6f87, 0xff5b5b5b, 0xff47576b, 
	0xff53637b, 0xff5f6b57, 0xff67735f, 0xff6b6b6b, 0xff635377, 0xff53637b, 0xff5f6f87, 0xff6b6b6b, 
	0xff635377, 0xff5f6b57, 0xff53637b, 0xff67735f, 0xff6f7b67, 0xff6b6b6b, 0xff53637b, 0xff5f6f87, 
	0xff67735f, 0xff6f7b67, 0xff6b6b6b, 0xff573f3f, 0xff674747, 0xff734f4f, 0xff674747, 0xff574b6b, 
	0xff5b5b5b, 0xff734f4f, 0xff674747, 0xff5b5b5b, 0xff57634f, 0xff4f5b47, 0xff734f4f, 0xff5f6b57, 
	0xff674747, 0xff5b5b5b, 0xff57634f, 0xff734f4f, 0xff5f6b57, 0xff6b6b6b, 0xff7f5b5b, 0xff674747, 
	0xff734f4f, 0xff7f2f2f, 0xff674747, 0xff734f4f, 0xff7f5b5b, 0xff674747, 0xff734f4f, 0xff7f5b5b, 
	0xff734f4f, 0xff7f5b5b, 0xff574b6b, 0xff534373, 0xff635377, 0xff5b5b5b, 0xff734f4f, 0xff534373, 
	0xff5f4b7f, 0xff574b6b, 0xff635377, 0xff6b4f8b, 0xff6f5b7f, 0xff5b5b5b, 0xff574b6b, 0xff635377, 
	0xff6b6b6b, 0xff734f4f, 0xff7f5b5b, 0xff6f5b7f, 0xff635377, 0xff5f4b7f, 0xff53637b, 0xff6f5b7f, 
	0xff6b6b6b, 0xff734f4f, 0xff574b6b, 0xff635377, 0xff7f5b5b, 0xff6f5b7f, 0xff635377, 0xff5f4b7f, 
	0xff6b4f8b, 0xff6f5b7f, 0xff7f5b5b, 0xff734f4f, 0xff7f5b5b, 0xff635377, 0xff6b6b6b, 0xff6f5b7f, 
	0xff8b6363, 0xff635377, 0xff6f5b7f, 0xff6b6b6b, 0xff8b6363, 0xff7b678b, 0xff7f5b5b, 0xff57634f, 
	0xff5f6b57, 0xff734f4f, 0xff67735f, 0xff57634f, 0xff5b5b5b, 0xff5f6b57, 0xff67735f, 0xff6b6b6b, 
	0xff734f4f, 0xff7f5b5b, 0xff57634f, 0xff5f6b57, 0xff67735f, 0xff5f6b57, 0xff67735f, 0xff6f7b67, 
	0xff734f4f, 0xff5f6b57, 0xff67735f, 0xff7f5b5b, 0xff734f4f, 0xff7f5b5b, 0xff6b6b6b, 0xff5f6b57, 
	0xff67735f, 0xff6f7b67, 0xff8b6363, 0xff5f6b57, 0xff67735f, 0xff6f7b67, 0xff7f5b5b, 0xff67735f, 
	0xff6f7b67, 0xff7f5b5b, 0xff8b6363, 0xff7b836f, 0xff5b5b5b, 0xff6b6b6b, 0xff635377, 0xff5f6b57, 
	0xff67735f, 0xff635377, 0xff53637b, 0xff6b6b6b, 0xff5f6f87, 0xff6f5b7f, 0xff7b7b7b, 0xff7b678b, 
	0xff67735f, 0xff6b6b6b, 0xff6f7b67, 0xff6b6b6b, 0xff5f6f87, 0xff6f7b67, 0xff7b7b7b, 0xff7b836f, 
	0xff6b6b6b, 0xff67735f, 0xff7f5b5b, 0xff6f7b67, 0xff8b6363, 0xff7b7b7b, 0xff6b6b6b, 0xff6f5b7f, 
	0xff7b678b, 0xff7b7b7b, 0xff8b6363, 0xff67735f, 0xff6b6b6b, 0xff6f7b67, 0xff7b836f, 0xff7b7b7b, 
	0xff8b6363, 0xff6b6b6b, 0xff7b7b7b, 0xff6f7b67, 0xff7b836f, 0xff00007f, 0xff00008b, 0xff07177f, 
	0xff071f93, 0xff0b27a3, 0xff0000b3, 0xff071f93, 0xff0b27a3, 0xff0f33b7, 0xff07177f, 0xff071f93, 
	0xff233773, 0xff071f93, 0xff0b27a3, 0xff07177f, 0xff071f93, 0xff0b4b6b, 0xff0f5377, 0xff135783, 
	0xff0b27a3, 0xff233773, 0xff2b3b7f, 0xff071f93, 0xff0b27a3, 0xff135783, 0xff07177f, 0xff071f93, 
	0xff233773, 0xff2b3b7f, 0xff071f93, 0xff0b27a3, 0xff2b3b7f, 0xff233773, 0xff071f93, 0xff0b27a3, 
	0xff2b3b7f, 0xff135783, 0xff0f5377, 0xff071f93, 0xff0b27a3, 0xff135783, 0xff2b3b7f, 0xff135b8b, 
	0xff33438f, 0xff334f9f, 0xff0b27a3, 0xff0f33b7, 0xff1b4bc3, 0xff334f9f, 0xff33438f, 0xff00007f, 
	0xff00008b, 0xff07177f, 0xff071f93, 0xff00008b, 0xff071f93, 0xff07177f, 0xff0b27a3, 0xff07177f, 
	0xff071f93, 0xff233773, 0xff2b3b7f, 0xff071f93, 0xff0b27a3, 0xff2b3b7f, 0xff33438f, 0xff07177f, 
	0xff00008b, 0xff071f93, 0xff2b3b7f, 0xff3f335f, 0xff00008b, 0xff071f93, 0xff07177f, 0xff0b27a3, 
	0xff2b3b7f, 0xff33438f, 0xff07177f, 0xff071f93, 0xff233773, 0xff2b3b7f, 0xff071f93, 0xff0b27a3, 
	0xff2b3b7f, 0xff33438f, 0xff0000b3, 0xff071f93, 0xff0b27a3, 0xff0f33b7, 0xff33438f, 0xff233773, 
	0xff07177f, 0xff071f93, 0xff0b27a3, 0xff2b3b7f, 0xff33438f, 0xff334f9f, 0xff0b27a3, 0xff0f33b7, 
	0xff33438f, 0xff1b4bc3, 0xff334f9f, 0xff0000b3, 0xff0000d7, 0xff0000ff, 0xff0f33b7, 0xff1b4bc3, 
	0xff2b63cf, 0xff0f5377, 0xff135783, 0xff135b8b, 0xff135783, 0xff0b27a3, 0xff135b8b, 0xff1b5f97, 
	0xff0f33b7, 0xff0f5377, 0xff135783, 0xff135b8b, 0xff07637b, 0xff135b8b, 0xff1b5f97, 0xff0f5377, 
	0xff135783, 0xff135b8b, 0xff233773, 0xff2b3b7f, 0xff33438f, 0xff135783, 0xff135b8b, 0xff0b27a3, 
	0xff0f33b7, 0xff1b5f97, 0xff33438f, 0xff2b3b7f, 0xff334f9f, 0xff135783, 0xff135b8b, 0xff235f7b, 
	0xff1b5f97, 0xff236783, 0xff135b8b, 0xff1b5f97, 0xff1f63a3, 0xff0b27a3, 0xff0f33b7, 0xff135b8b, 
	0xff1b4bc3, 0xff1b5f97, 0xff1f63a3, 0xff2367af, 0xff334f9f, 0xff07637b, 0xff135b8b, 0xff07738b, 
	0xff135783, 0xff135b8b, 0xff07738b, 0xff07839b, 0xff1b5f97, 0xff1f63a3, 0xff07738b, 0xff07839b, 
	0xff07738b, 0xff07839b, 0xff1f63a3, 0xff135783, 0xff135b8b, 0xff07637b, 0xff07738b, 0xff236783, 
	0xff1b5f97, 0xff236f8f, 0xff235f7b, 0xff135b8b, 0xff1b5f97, 0xff07738b, 0xff1f63a3, 0xff236f8f, 
	0xff07738b, 0xff07839b, 0xff236783, 0xff236f8f, 0xff07738b, 0xff1f63a3, 0xff07839b, 0xff1b5f97, 
	0xff236f8f, 0xff1b5f97, 0xff1f63a3, 0xff07738b, 0xff07839b, 0xff2367af, 0xff1f63a3, 0xff2367af, 
	0xff1b4bc3, 0xff07839b, 0xff07839b, 0xff2367af, 0xff1f63a3, 0xff07839b, 0xff2367af, 0xff0b97ab, 
	0xff2f77bf, 0xff1b5f97, 0xff1f63a3, 0xff2367af, 0xff1f63a3, 0xff2367af, 0xff1b4bc3, 0xff2f77bf, 
	0xff1f63a3, 0xff2367af, 0xff07839b, 0xff236f8f, 0xff2f77bf, 0xff2367af, 0xff07839b, 0xff2f77bf, 
	0xff0b97ab, 0xff2b3b7f, 0xff33438f, 0xff135783, 0xff1f5773, 0xff135b8b, 0xff1b5f97, 0xff235f7b, 
	0xff3f537f, 0xff33438f, 0xff334f9f, 0xff1b5f97, 0xff135b8b, 0xff1f5773, 0xff135783, 0xff235f7b, 
	0xff33438f, 0xff135783, 0xff135b8b, 0xff1b5f97, 0xff235f7b, 0xff33438f, 0xff235f7b, 0xff135783, 
	0xff236783, 0xff135b8b, 0xff1b5f97, 0xff236783, 0xff235f7b, 0xff235f7b, 0xff33438f, 0xff3f537f, 
	0xff33438f, 0xff235f7b, 0xff1b5f97, 0xff236783, 0xff334f9f, 0xff3f537f, 0xff235f7b, 0xff236783, 
	0xff235f7b, 0xff236783, 0xff1b5f97, 0xff334f9f, 0xff3f537f, 0xff1b5f97, 0xff1f63a3, 0xff334f9f, 
	0xff33438f, 0xff236783, 0xff236f8f, 0xff2b3b7f, 0xff33438f, 0xff3f537f, 0xff33438f, 0xff334f9f, 
	0xff3f537f, 0xff33438f, 0xff334f9f, 0xff235f7b, 0xff236783, 0xff475f8b, 0xff33438f, 0xff334f9f, 
	0xff236783, 0xff236f8f, 0xff475f8b, 0xff3f537f, 0xff334f9f, 0xff0f33b7, 0xff1b4bc3, 0xff1f63a3, 
	0xff1b5f97, 0xff2367af, 0xff2f63af, 0xff2b63cf, 0xff235f7b, 0xff236783, 0xff1b5f97, 0xff236f8f, 
	0xff1b5f97, 0xff1f63a3, 0xff236f8f, 0xff236783, 0xff334f9f, 0xff2f63af, 0xff3b7ba7, 0xff236783, 
	0xff236f8f, 0xff236f8f, 0xff1f63a3, 0xff3b7ba7, 0xff235f7b, 0xff236783, 0xff236f8f, 0xff475f8b, 
	0xff3f537f, 0xff236783, 0xff236f8f, 0xff334f9f, 0xff475f8b, 0xff334f9f, 0xff2f63af, 0xff1f63a3, 
	0xff236f8f, 0xff475f8b, 0xff236f8f, 0xff475f8b, 0xff3b7ba7, 0xff236f8f, 0xff1f63a3, 0xff2f63af, 
	0xff3b7ba7, 0xff475f8b, 0xff475f8b, 0xff334f9f, 0xff2f63af, 0xff475f8b, 0xff3b7ba7, 0xff536b9b, 
	0x535b9f, 0xff475f8b, 0xff236f8f, 0xff3b7ba7, 0xff536b9b, 0xff475f8b, 0xff2f63af, 0xff3b7ba7, 
	0xff536b9b, 0xff236783, 0xff236f8f, 0xff3b7ba7, 0xff475f8b, 0xff236f8f, 0xff3b7ba7, 0xff475f8b, 
	0xff1f63a3, 0xff2367af, 0xff2f63af, 0xff3b7ba7, 0xff2367af, 0xff2f77bf, 0xff2b63cf, 0xff2f63af, 
	0xff1f63a3, 0xff2367af, 0xff236f8f, 0xff2f77bf, 0xff3b7ba7, 0xff2f63af, 0xff2367af, 0xff2f77bf, 
	0xff2f63af, 0xff3b7ba7, 0xff2f63af, 0xff3b7ba7, 0xff334f9f, 0x535b9f, 0xff536b9b, 0xff2f63af, 
	0xff2f77bf, 0xff3b7ba7, 0xff3b7ba7, 0xff2f63af, 0xff2f63af, 0xff2f77bf, 0xff3b7ba7, 0xff0f33b7, 
	0xff1b4bc3, 0xff2b63cf, 0xff2367af, 0xff1b4bc3, 0xff0000ff, 0xff2b63cf, 0xff1b4bc3, 0xff2b63cf, 
	0xff2367af, 0xff07839b, 0xff0b97ab, 0xff2b8fcf, 0xff2f77bf, 0xff3b7fdb, 0xff1b4bc3, 0xff2b63cf, 
	0xff2b8fcf, 0xff3b7fdb, 0xff1b4bc3, 0xff2b63cf, 0xff2367af, 0xff2f63af, 0xff334f9f, 0xff1b4bc3, 
	0xff2b63cf, 0xff3b7fdb, 0xff2367af, 0xff2b63cf, 0xff2f77bf, 0xff3b7fdb, 0xff2b8fcf, 0xff2f63af, 
	0xff2b63cf, 0xff3b7fdb, 0xff2b8fcf, 0xff3f335f, 0xff07177f, 0xff2b3b7f, 0xff4b3b6b, 0xff07177f, 
	0xff00008b, 0xff071f93, 0xff0b27a3, 0xff2b3b7f, 0xff33438f, 0xff4b3b6b, 0xff2b3b7f, 0xff33438f, 
	0xff3f335f, 0xff4b3b6b, 0xff2b3b7f, 0xff33438f, 0xff4b3b6b, 0xff4b3b6b, 0xff534373, 0xff4b3b6b, 
	0xff33438f, 0xff534373, 0xff5f4b7f, 0xff4b3b6b, 0xff534373, 0xff5f4b7f, 0xff4b3b6b, 0xff33438f, 
	0xff534373, 0xff5f4b7f, 0xff6b4f8b, 0xff0b27a3, 0xff0000b3, 0xff33438f, 0xff0000b3, 0xff0b27a3, 
	0xff0f33b7, 0xff33438f, 0xff33438f, 0xff0b27a3, 0xff0b27a3, 0xff0f33b7, 0xff33438f, 0xff334f9f, 
	0xff33438f, 0xff5f4b7f, 0xff6b4f8b, 0xff534373, 0xff0000b3, 0xff33438f, 0xff0b27a3, 0xff0f33b7, 
	0xff6b4f8b, 0xff33438f, 0xff5f4b7f, 0xff6b4f8b, 0xff33438f, 0xff0f33b7, 0xff334f9f, 0x535b9f, 
	0xff6b4f8b, 0xff2b3b7f, 0xff33438f, 0xff4b3b6b, 0xff534373, 0xff33438f, 0xff2b3b7f, 0xff33438f, 
	0xff3f537f, 0xff4b3b6b, 0xff534373, 0xff5f4b7f, 0xff33438f, 0xff334f9f, 0x535b9f, 0xff5f4b7f, 
	0xff4b3b6b, 0xff534373, 0xff5f4b7f, 0xff33438f, 0xff534373, 0xff5f4b7f, 0xff6b4f8b, 0xff534373, 
	0xff5f4b7f, 0xff33438f, 0xff5f4b7f, 0x535b9f, 0xff534373, 0xff6b4f8b, 0xff33438f, 0xff0f33b7, 
	0xff334f9f, 0xff1b4bc3, 0x535b9f, 0xff6b4f8b, 0xff4b3b6b, 0xff534373, 0xff5f4b7f, 0xff6b4f8b, 
	0xff534373, 0xff5f4b7f, 0xff33438f, 0xff6b4f8b, 0x535b9f, 0xff775797, 0xff534373, 0xff5f4b7f, 
	0xff6b4f8b, 0xff775797, 0xff6b4f8b, 0x535b9f, 0xff775797, 0xff835fa3, 0xff0000b3, 0xff0000d7, 
	0xff0f33b7, 0xff1b4bc3, 0xff334f9f, 0xff33438f, 0x535b9f, 0xff0000d7, 0xff0000ff, 0xff1b4bc3, 
	0xff2b63cf, 0xff0f33b7, 0xff1b4bc3, 0xff2b63cf, 0xff334f9f, 0x535b9f, 0xff1b4bc3, 0xff0000ff, 
	0xff2b63cf, 0xff33438f, 0xff0f33b7, 0xff0000d7, 0x535b9f, 0xff6b4f8b, 0xff1b4bc3, 0xff775797, 
	0xff835fa3, 0xff0000d7, 0xff0000ff, 0xff1b4bc3, 0xff2b63cf, 0x535b9f, 0xff835fa3, 0xff775797, 
	0xff8f6baf, 0x535b9f, 0xff1b4bc3, 0xff2b63cf, 0xff775797, 0xff835fa3, 0xff8f6baf, 0xff1b4bc3, 
	0xff2b63cf, 0x535b9f, 0xff835fa3, 0xff3b7fdb, 0xff8f6baf, 0xff9f73bb, 0xff3f537f, 0xff33438f, 
	0xff475f8b, 0xff534373, 0xff5f4b7f, 0xff33438f, 0xff334f9f, 0xff3f537f, 0xff475f8b, 0x535b9f, 
	0xff5f4b7f, 0xff3f537f, 0xff475f8b, 0xff53637b, 0xff3f537f, 0xff475f8b, 0xff334f9f, 0x535b9f, 
	0xff534373, 0xff5f4b7f, 0xff475f8b, 0x535b9f, 0xff6b4f8b, 0xff5f4b7f, 0x535b9f, 0xff475f8b, 
	0xff6b4f8b, 0xff5f4b7f, 0xff475f8b, 0xff3f537f, 0xff53637b, 0xff475f8b, 0xff5f4b7f, 0x535b9f, 
	0xff53637b, 0xff475f8b, 0xff475f8b, 0xff53637b, 0x535b9f, 0xff5f4b7f, 0xff635377, 0xff5f4b7f, 
	0x535b9f, 0xff475f8b, 0xff6b4f8b, 0xff53637b, 0xff5f4b7f, 0xff635377, 0xff5f6f87, 0xff6b4f8b, 
	0xff6f5b7f, 0xff5f4b7f, 0xff475f8b, 0x535b9f, 0xff53637b, 0xff5f6f87, 0xff6b4f8b, 0xff475f8b, 
	0x535b9f, 0xff5f4b7f, 0xff6b4f8b, 0xff5f6f87, 0xff334f9f, 0xff2f63af, 0x535b9f, 0xff6b4f8b, 
	0xff3f537f, 0xff475f8b, 0xff53637b, 0xff536b9b, 0xff5f6f87, 0xff475f8b, 0x535b9f, 0xff536b9b, 
	0xff3b7ba7, 0xff475f8b, 0xff3b7ba7, 0xff53637b, 0xff536b9b, 0xff5f6f87, 0xff475f8b, 0xff536b9b, 
	0xff3b7ba7, 0xff5f7ba7, 0xff53637b, 0xff475f8b, 0xff536b9b, 0xff5f6f87, 0xff475f8b, 0x535b9f, 
	0xff536b9b, 0xff5f6f87, 0xff53637b, 0xff5f6f87, 0xff536b9b, 0xff536b9b, 0xff5f7ba7, 0xff5f6f87, 
	0xff6f7b97, 0x535b9f, 0xff2f63af, 0xff536b9b, 0xff2f77bf, 0xff3b7ba7, 0xff5f7ba7, 0xff6b87b7, 
	0xff5f4b7f, 0xff6b4f8b, 0xff6b4f8b, 0x535b9f, 0xff775797, 0xff5f4b7f, 0xff6b4f8b, 0xff635377, 
	0xff6f5b7f, 0xff5f6f87, 0xff53637b, 0xff775797, 0xff7b678b, 0xff6b4f8b, 0x535b9f, 0xff5f6f87, 
	0xff775797, 0xff6b4f8b, 0xff6f5b7f, 0xff775797, 0xff6b4f8b, 0xff775797, 0xff6f5b7f, 0xff6b4f8b, 
	0xff775797, 0xff7b678b, 0xff6b4f8b, 0xff775797, 0xff7b678b, 0xff835fa3, 0xff6b4f8b, 0x535b9f, 
	0xff775797, 0xff5f7ba7, 0xff835fa3, 0xff8f6baf, 0xff53637b, 0xff5f6f87, 0xff6f5b7f, 0xff6b4f8b, 
	0xff7b678b, 0xff775797, 0xff6f7b97, 0xff5f6f87, 0x535b9f, 0xff536b9b, 0xff5f7ba7, 0xff6b4f8b, 
	0xff6f7b97, 0xff775797, 0xff7b678b, 0xff5f6f87, 0xff6f7b97, 0xff7b7b7b, 0xff7b678b, 0xff5f6f87, 
	0xff536b9b, 0xff5f7ba7, 0xff6f7b97, 0xff6f5b7f, 0xff7b678b, 0xff7b7b7b, 0xff877393, 0xff775797, 
	0xff7b678b, 0xff6f7b97, 0xff835fa3, 0xff877393, 0xff7b7b7b, 0xff7b678b, 0xff6f7b97, 0xff877393, 
	0xff6f7b97, 0xff7b678b, 0xff7b87a3, 0xff877393, 0x535b9f, 0xff536b9b, 0xff5f7ba7, 0xff775797, 
	0xff6f7b97, 0xff835fa3, 0x535b9f, 0xff5f7ba7, 0xff6b87b7, 0xff835fa3, 0xff5f7ba7, 0xff6b87b7, 
	0xff6f7b97, 0xff7b87a3, 0xff5f7ba7, 0xff6b87b7, 0xff775797, 0xff835fa3, 0xff6f7b97, 0xff5f7ba7, 
	0xff8f6baf, 0xff877393, 0xff835fa3, 0xff6b87b7, 0xff5f7ba7, 0xff8f6baf, 0xff6f7b97, 0xff5f7ba7, 
	0xff6b87b7, 0xff7b87a3, 0xff835fa3, 0xff8f6baf, 0xff877393, 0xff5f7ba7, 0xff6b87b7, 0xff835fa3, 
	0xff8f6baf, 0xff7b87a3, 0xff7b93c3, 0xff334f9f, 0xff1b4bc3, 0xff2b63cf, 0xff2f63af, 0x535b9f, 
	0xff3b7fdb, 0xff5f7ba7, 0xff6b87b7, 0xff2b63cf, 0xff3b7fdb, 0xff2f63af, 0xff2b63cf, 0xff2f77bf, 
	0xff3b7fdb, 0x535b9f, 0xff5f7ba7, 0xff6b87b7, 0xff4f97e3, 0xff2b63cf, 0xff3b7fdb, 0xff4f97e3, 
	0x535b9f, 0xff2b63cf, 0xff3b7fdb, 0xff6b87b7, 0xff5f7ba7, 0xff835fa3, 0xff8f6baf, 0xff775797, 
	0xff2b63cf, 0xff3b7fdb, 0xff835fa3, 0xff8f6baf, 0xff6b87b7, 0xff4f97e3, 0xff7b93c3, 0xff9f73bb, 
	0x535b9f, 0xff5f7ba7, 0xff6b87b7, 0xff835fa3, 0xff8f6baf, 0xff6b87b7, 0xff3b7fdb, 0xff6b87b7, 
	0xff6b87b7, 0xff3b7fdb, 0xff4f97e3, 0xff7b93c3, 0xff835fa3, 0xff8f6baf, 0xff6b87b7, 0xff6b87b7, 
	0xff8f6baf, 0xff7b93c3, 0xff9f73bb, 0xff6b87b7, 0xff7b93c3, 0xff8f6baf, 0xff6b87b7, 0xff7b93c3, 
	0xff8f6baf, 0xff3b7fdb, 0xff4f97e3, 0xff6b87b7, 0xff7b93c3, 0xff8f6baf, 0xff9f73bb, 0xff8ba3d3, 
	0xff5fabe7, 0xff073f3f, 0xff074747, 0xff0b4b4b, 0xff273323, 0xff37432f, 0xff074747, 0xff0b4b4b, 
	0xff0b5353, 0xff37432f, 0xff074747, 0xff0b4b4b, 0xff0b5353, 0xff37432f, 0xff0b5353, 0xff0b5b5b, 
	0xff37432f, 0xff0b4b4b, 0xff3f4b37, 0xff37432f, 0xff0b4b4b, 0xff0b5353, 0xff3f4b37, 0xff47533f, 
	0xff37432f, 0xff0b4b4b, 0xff0b5353, 0xff3f4b37, 0xff47533f, 0xff0b5353, 0xff0b5b5b, 0xff37432f, 
	0xff3f4b37, 0xff47533f, 0xff0b5353, 0xff0b5b5b, 0xff0b6363, 0xff0f6b6b, 0xff3f4b37, 0xff47533f, 
	0xff0b5353, 0xff0b5b5b, 0xff0b6363, 0xff0f6b6b, 0xff37432f, 0xff3f4b37, 0xff47533f, 0xff4f5b47, 
	0xff0b6363, 0xff0f6b6b, 0xff47533f, 0xff37432f, 0xff3f4b37, 0xff47533f, 0xff4f5b47, 0xff57634f, 
	0xff3f4b37, 0xff47533f, 0xff0b5353, 0xff0b5b5b, 0xff4f5b47, 0xff0b5b5b, 0xff0b6363, 0xff0f6b6b, 
	0xff47533f, 0xff4f5b47, 0xff57634f, 0xff47533f, 0xff0b5b5b, 0xff0b6363, 0xff0f6b6b, 0xff4f5b47, 
	0xff57634f, 0xff0b6363, 0xff0f6b6b, 0xff47533f, 0xff4f5b47, 0xff57634f, 0xff47533f, 0xff4f5b47, 
	0xff57634f, 0xff47533f, 0xff4f5b47, 0xff57634f, 0xff47533f, 0xff4f5b47, 0xff57634f, 0xff4f5b47, 
	0xff57634f, 0xff5f6b57, 0xff3f4b37, 0xff47533f, 0xff4f5b47, 0xff0f6b6b, 0xff57634f, 0xff5f6b57, 
	0xff47533f, 0xff0b6363, 0xff0f6b6b, 0xff4f5b47, 0xff57634f, 0xff5f6b57, 0xff67735f, 0xff0b6363, 
	0xff0f6b6b, 0xff0f6b6b, 0xff07738b, 0xff07839b, 0xff236783, 0xff236f8f, 0xff0f6b6b, 0xff07839b, 
	0xff0f6b6b, 0xff07738b, 0xff07839b, 0xff0b97ab, 0xff0b6363, 0xff0f6b6b, 0xff4f5b47, 0xff57634f, 
	0xff5f6b57, 0xff67735f, 0xff47576b, 0xff0f6b6b, 0xff236783, 0xff0f6b6b, 0xff236783, 0xff236f8f, 
	0xff0f6b6b, 0xff236f8f, 0xff236783, 0xff0f6b6b, 0xff236f8f, 0xff07839b, 0xff236783, 0xff0f6b6b, 
	0xff236783, 0xff47576b, 0xff5f6b57, 0xff67735f, 0xff53637b, 0xff236783, 0xff236f8f, 0xff53637b, 
	0xff5f6f87, 0xff3b7ba7, 0xff0f6b6b, 0xff236783, 0xff236f8f, 0xff67735f, 0xff5f6b57, 0xff6f7b67, 
	0xff53637b, 0xff236783, 0xff236f8f, 0xff3b7ba7, 0xff53637b, 0xff6f7b67, 0xff5f6f87, 0xff0f6b6b, 
	0xff57634f, 0xff5f6b57, 0xff67735f, 0xff6f7b67, 0xff0f6b6b, 0xff07839b, 0xff236f8f, 0xff0f6b6b, 
	0xff07839b, 0xff0b97ab, 0xff236f8f, 0xff379bb7, 0xff0f6b6b, 0xff07839b, 0xff0b97ab, 0xff236f8f, 
	0xff07839b, 0xff0b97ab, 0xff379bb7, 0xff236f8f, 0xff0f6b6b, 0xff236f8f, 0xff67735f, 0xff6f7b67, 
	0xff379bb7, 0xff236f8f, 0xff379bb7, 0xff3b7ba7, 0xff6f7b67, 0xff5f6f87, 0xff0f6b6b, 0xff236f8f, 
	0xff0b97ab, 0xff379bb7, 0xff6f7b67, 0xff236f8f, 0xff379bb7, 0xff0b97ab, 0xff6f7b67, 0xff0b6363, 
	0xff0f6b6b, 0xff47533f, 0xff4f5b47, 0xff57634f, 0xff0f6b6b, 0xff0f6b6b, 0xff57634f, 0xff5f6b57, 
	0xff0f6b6b, 0xff0b97ab, 0xff37c3c7, 0xff47533f, 0xff4f5b47, 0xff0f6b6b, 0xff57634f, 0xff5f6b57, 
	0xff67735f, 0xff0f6b6b, 0xff57634f, 0xff5f6b57, 0xff67735f, 0xff6f7b67, 0xff57634f, 0xff0f6b6b, 
	0xff5f6b57, 0xff67735f, 0xff6f7b67, 0xff0f6b6b, 0xff0b97ab, 0xff37c3c7, 0xff67735f, 0xff6f7b67, 
	0xff5f6b57, 0xff7b836f, 0xff0f6b6b, 0xff07839b, 0xff0b97ab, 0xff07839b, 0xff0b97ab, 0xff0fa7bb, 
	0xff0f6b6b, 0xff37c3c7, 0xff0f6b6b, 0xff0b97ab, 0xff0fa7bb, 0xff37c3c7, 0xff0b97ab, 0xff0fa7bb, 
	0xff0fb7cb, 0xff37c3c7, 0xff0f6b6b, 0xff0b97ab, 0xff37c3c7, 0xff6f7b67, 0xff67735f, 0xff379bb7, 
	0xff0f6b6b, 0xff0b97ab, 0xff0fa7bb, 0xff37c3c7, 0xff379bb7, 0xff6f7b67, 0xff0f6b6b, 0xff0b97ab, 
	0xff37c3c7, 0xff6f7b67, 0xff7b836f, 0xff0b97ab, 0xff37c3c7, 0xff3f4b37, 0xff47533f, 0xff4f5b47, 
	0xff57634f, 0xff5f6b57, 0xff67735f, 0xff6f7b67, 0xff7b836f, 0xff57634f, 0xff5f6b57, 0xff67735f, 
	0xff6f7b67, 0xff5f6b57, 0xff53637b, 0xff5f6f87, 0xff67735f, 0xff3b7ba7, 0xff6f7b67, 0xff7b836f, 
	0xff5f6b57, 0xff67735f, 0xff6f7b67, 0xff7b836f, 0xff67735f, 0xff6f7b67, 0xff5f6f87, 0xff3b7ba7, 
	0xff379bb7, 0xff7b836f, 0xff5f6b57, 0xff67735f, 0xff6f7b67, 0xff7b836f, 0xff67735f, 0xff6f7b67, 
	0xff5f6f87, 0xff7b836f, 0xff7b7b7b, 0xff8b8b8b, 0xff67735f, 0xff6f7b67, 0xff7b836f, 0xff6f7b67, 
	0xff7b836f, 0xff8b8b8b, 0xff9b9b9b, 0xff57634f, 0xff5f6b57, 0xff67735f, 0xff6f7b67, 0xff7b836f, 
	0xff67735f, 0xff6f7b67, 0xff379bb7, 0xff37c3c7, 0xff7b836f, 0xff8b8b8b, 0xff9b9b9b, 0xffababab, 
	0xff07738b, 0xff07839b, 0xff0b97ab, 0xff236f8f, 0xff07839b, 0xff0b97ab, 0xff0fa7bb, 0xff2f77bf, 
	0xff2b8fcf, 0xff2367af, 0xff236f8f, 0xff07839b, 0xff0b97ab, 0xff0fa7bb, 0xff0b97ab, 0xff0fa7bb, 
	0xff0fb7cb, 0xff236f8f, 0xff07839b, 0xff0b97ab, 0xff3b7ba7, 0xff379bb7, 0xff53637b, 0xff475f8b, 
	0xff236f8f, 0xff07839b, 0xff2367af, 0xff2f77bf, 0xff3b7ba7, 0xff0b97ab, 0xff379bb7, 0xff2f77bf, 
	0xff2b8fcf, 0xff0b97ab, 0xff379bb7, 0xff3b7ba7, 0xff0b97ab, 0xff0fa7bb, 0xff379bb7, 0xff3b7ba7, 
	0xff0b97ab, 0xff2b8fcf, 0xff379bb7, 0xff0fa7bb, 0xff3b7ba7, 0xff379bb7, 0xff3b7ba7, 0xff2f77bf, 
	0xff379bb7, 0xff2b8fcf, 0xff3b7ba7, 0xff379bb7, 0xff379bb7, 0xff07839b, 0xff0b97ab, 0xff0fa7bb, 
	0xff379bb7, 0xff37c3c7, 0xff236f8f, 0xff3b7ba7, 0xff0b97ab, 0xff0fa7bb, 0xff0fb7cb, 0xff37c3c7, 
	0xff379bb7, 0xff0b97ab, 0xff2b8fcf, 0xff0fa7bb, 0xff0fb7cb, 0xff27abdf, 0xff2f77bf, 0xff2b8fcf, 
	0xff27abdf, 0xff0fa7bb, 0xff0fb7cb, 0xff3b7fdb, 0xff0fa7bb, 0xff0fb7cb, 0xff13cbdb, 0xff27abdf, 
	0xff2b8fcf, 0xff0fb7cb, 0xff27abdf, 0xff1fcbef, 0xff13cbdb, 0xff2f77bf, 0xff2b8fcf, 0xff27abdf, 
	0xff0fa7bb, 0xff379bb7, 0xff3b7fdb, 0xff4f97e3, 0xff2b8fcf, 0xff3b7fdb, 0xff27abdf, 0xff4f97e3, 
	0xff0fa7bb, 0xff2b8fcf, 0xff27abdf, 0xff0fb7cb, 0xff13cbdb, 0xff37c3c7, 0xff379bb7, 0xff4f97e3, 
	0xff27abdf, 0xff1fcbef, 0xff13cbdb, 0xff37c3c7, 0xff4f97e3, 0xff0b97ab, 0xff0fa7bb, 0xff0fb7cb, 
	0xff13cbdb, 0xff17dfef, 0xff37c3c7, 0xff379bb7, 0xff57e3e7, 0xff0fb7cb, 0xff13cbdb, 0xff1fcbef, 
	0xff17dfef, 0xff1bf3ff, 0xff37c3c7, 0xff27abdf, 0xff57e3e7, 0xff53637b, 0xff475f8b, 0xff3b7ba7, 
	0xff5f6f87, 0xff536b9b, 0xff5f7ba7, 0xff3b7ba7, 0xff536b9b, 0xff5f7ba7, 0xff5f6f87, 0xff3b7ba7, 
	0xff379bb7, 0xff5f6f87, 0xff5f7ba7, 0xff3b7ba7, 0xff379bb7, 0xff5f7ba7, 0xff5f6f87, 0xff5f7ba7, 
	0xff6f7b97, 0xff536b9b, 0xff5f7ba7, 0xff5f6f87, 0xff6f7b97, 0xff5f6f87, 0xff5f7ba7, 0xff6f7b97, 
	0xff7b836f, 0xff5f7ba7, 0xff379bb7, 0xff6f7b97, 0xff6b87b7, 0xff7b87a3, 0xff3b7ba7, 0xff2f77bf, 
	0xff379bb7, 0xff5f7ba7, 0xff6b87b7, 0xff3b7ba7, 0xff379bb7, 0xff5f6f87, 0xff5f7ba7, 0xff6f7b97, 
	0xff7b836f, 0xff379bb7, 0xff379bb7, 0xff379bb7, 0xff37c3c7, 0xff5f6f87, 0xff6f7b97, 0xff5f7ba7, 
	0xff379bb7, 0xff7b836f, 0xff7b87a3, 0xff5f7ba7, 0xff379bb7, 0xff6f7b97, 0xff6b87b7, 0xff7b87a3, 
	0xff379bb7, 0xff7b836f, 0xff6f7b97, 0xff7b87a3, 0xff8b8b8b, 0xff379bb7, 0xff37c3c7, 0xff7b87a3, 
	0xff6b87b7, 0xff379bb7, 0xff37c3c7, 0xff5f7ba7, 0xff6b87b7, 0xff5fabe7, 0xff7b93c3, 0xff5f6f87, 
	0xff6f7b97, 0xff7b7b7b, 0xff6f7b97, 0xff5f7ba7, 0xff7b87a3, 0xff5f6f87, 0xff6f7b97, 0xff7b836f, 
	0xff7b7b7b, 0xff7b87a3, 0xff8b8b8b, 0xff6f7b97, 0xff5f7ba7, 0xff7b87a3, 0xff6b87b7, 0xff7b7b7b, 
	0xff6f7b97, 0xff8b8b8b, 0xff7b87a3, 0xff877393, 0xff6f7b97, 0xff7b87a3, 0xff8b8b8b, 0xff877393, 
	0xff7b836f, 0xff7b7b7b, 0xff6f7b97, 0xff8b8b8b, 0xff7b87a3, 0xff6f7b97, 0xff7b87a3, 0xff8b8b8b, 
	0xff8b97af, 0xff5f7ba7, 0xff6b87b7, 0xff7b87a3, 0xff7b93c3, 0xff6f7b97, 0xff8b97af, 0xff7b836f, 
	0xff6f7b97, 0xff7b87a3, 0xff8b8b8b, 0xff6f7b97, 0xff7b87a3, 0xff6b87b7, 0xff8b97af, 0xff8b8b8b, 
	0xff7b836f, 0xff8b8b8b, 0xff7b87a3, 0xff8b97af, 0xff9b9b9b, 0xff7b87a3, 0xff6b87b7, 0xff379bb7, 
	0xff37c3c7, 0xff8b97af, 0xff8b8b8b, 0xff7b836f, 0xff8b8b8b, 0xff7b87a3, 0xff9b9b9b, 0xff7b87a3, 
	0xff8b97af, 0xff8b8b8b, 0xff9b9b9b, 0xff8b8b8b, 0xff9b9b9b, 0xff8b8b8b, 0xff7b87a3, 0xff8b97af, 
	0xff9b9b9b, 0xff6b87b7, 0xff7b87a3, 0xff7b93c3, 0xff8b97af, 0xff6b87b7, 0xff7b93c3, 0xff6b87b7, 
	0xff7b93c3, 0xff37c3c7, 0xff379bb7, 0xff8b97af, 0xff7b87a3, 0xff6b87b7, 0xff7b93c3, 0xff5fabe7, 
	0xff37c3c7, 0xff8ba3d3, 0xff8b97af, 0xff7b87a3, 0xff6b87b7, 0xff7b93c3, 0xff8b97af, 0xff7b93c3, 
	0xff8b97af, 0xff8ba3d3, 0xff8b97af, 0xff7b93c3, 0xff8b97af, 0xff8ba3d3, 0xff9ba3bf, 0xff2f77bf, 
	0xff3b7fdb, 0xff379bb7, 0xff2b8fcf, 0xff4f97e3, 0xff3b7ba7, 0xff5f7ba7, 0xff6b87b7, 0xff3b7fdb, 
	0xff4f97e3, 0xff379bb7, 0xff2b8fcf, 0xff3b7fdb, 0xff4f97e3, 0xff3b7fdb, 0xff4f97e3, 0xff2b8fcf, 
	0xff6b87b7, 0xff3b7fdb, 0xff4f97e3, 0xff379bb7, 0xff3b7fdb, 0xff4f97e3, 0xff6b87b7, 0xff379bb7, 
	0xff4f97e3, 0xff6b87b7, 0xff7b93c3, 0xff4f97e3, 0xff5fabe7, 0xff3b7fdb, 0xff4f97e3, 0xff5fabe7, 
	0xff379bb7, 0xff4f97e3, 0xff27abdf, 0xff37c3c7, 0xff5fabe7, 0xff6b87b7, 0xff7b93c3, 0xff4f97e3, 
	0xff27abdf, 0xff5fabe7, 0xff1fcbef, 0xff37c3c7, 0xff77bfef, 0xff6b87b7, 0xff4f97e3, 0xff7b93c3, 
	0xff5fabe7, 0xff8ba3d3, 0xff4f97e3, 0xff5fabe7, 0xff7b93c3, 0xff8ba3d3, 0xff77bfef, 0xff6b87b7, 
	0xff7b93c3, 0xff5fabe7, 0xff37c3c7, 0xff77bfef, 0xff8ba3d3, 0xff5fabe7, 0xff77bfef, 0xff8ba3d3, 
	0xff379bb7, 0xff37c3c7, 0xff7b836f, 0xff8b8b8b, 0xff7b87a3, 0xff37c3c7, 0xff57e3e7, 0xff37c3c7, 
	0xff57e3e7, 0xff37c3c7, 0xff57e3e7, 0xff7b836f, 0xff8b8b8b, 0xff7b87a3, 0xff37c3c7, 0xff8b97af, 
	0xff9b9b9b, 0xffababab, 0xff37c3c7, 0xff8b97af, 0xff7b93c3, 0xff37c3c7, 0xff5fabe7, 0xff57e3e7, 
	0xff7b93c3, 0xff77bfef, 0xff8ba3d3, 0xff8b97af, 0xff37c3c7, 0xff57e3e7, 0xff8b97af, 0xff37c3c7, 
	0xff57e3e7, 0xff8b97af, 0xff9ba3bf, 0xffababab, 0xff8b97af, 0xff7b93c3, 0xff8ba3d3, 0xff77bfef, 
	0xff57e3e7, 0xff9ba3bf, 0xffa7b3cb, 0xff8b97af, 0xff37c3c7, 0xff57e3e7, 0xff9ba3bf, 0xffababab, 
	0xffa7b3cb, 0xff37c3c7, 0xff57e3e7, 0xff8ba3d3, 0xff77bfef, 0xff9ba3bf, 0xffa7b3cb, 0xff37c3c7, 
	0xff57e3e7, 0xff9b9b9b, 0xffababab, 0xff37c3c7, 0xff57e3e7, 0xffababab, 0xffa7b3cb, 0xff37c3c7, 
	0xff57e3e7, 0xff5fabe7, 0xff37c3c7, 0xff27abdf, 0xff1fcbef, 0xff57e3e7, 0xff5fabe7, 0xff77bfef, 
	0xff37c3c7, 0xff57e3e7, 0xff57e3e7, 0xff1bf3ff, 0xff37c3c7, 0xff5fabe7, 0xff57e3e7, 0xff77bfef, 
	0xff8ba3d3, 0xff8bd3f7, 0xff5fabe7, 0xff77bfef, 0xff57e3e7, 0xff8bd3f7, 0xff57e3e7, 0xff8bd3f7, 
	0xff93f3ff, 0xff57e3e7, 0xff93f3ff, 0xff8bd3f7, 0xff7f2f2f, 0xff8f2f2f, 0xffbf2323, 0xffaf2b2b, 
	0xff9f2f2f, 0xffcf1b1b, 0xff7f2f2f, 0xff8f2f2f, 0xff9f2f2f, 0xff7f2f2f, 0xff4b3b6b, 0xff534373, 
	0xff8f2f2f, 0xff4b3b6b, 0xff534373, 0xff5f4b7f, 0xff6b4f8b, 0xff7f2f2f, 0xff8f2f2f, 0xff7f2f2f, 
	0xff4b3b6b, 0xff534373, 0xff734f4f, 0xff5f4b7f, 0xff8f2f2f, 0xff534373, 0xff5f4b7f, 0xff6b4f8b, 
	0xff8f2f2f, 0xff734f4f, 0xff8f2f2f, 0xff9f2f2f, 0xff8f2f2f, 0xff6b4f8b, 0xff9f2f2f, 0xff8f2f2f, 
	0xff734f4f, 0xff9f2f2f, 0xff8f2f2f, 0xff6b4f8b, 0xff734f4f, 0xff7f5b5b, 0xff9f2f2f, 0xff7f2f2f, 
	0xff734f4f, 0xff7f5b5b, 0xff8f2f2f, 0xff9f2f2f, 0xff8b6363, 0xff7f2f2f, 0xff734f4f, 0xff5f4b7f, 
	0xff7f5b5b, 0xff8f2f2f, 0xff5f4b7f, 0xff6b4f8b, 0xff7f5b5b, 0xff734f4f, 0xff734f4f, 0xff5f4b7f, 
	0xff635377, 0xff7f5b5b, 0xff5f4b7f, 0xff6b4f8b, 0xff635377, 0xff7f5b5b, 0xff6f5b7f, 0xff8b6363, 
	0xff8f2f2f, 0xff734f4f, 0xff7f5b5b, 0xff9f2f2f, 0xff8b6363, 0xff734f4f, 0xff6b4f8b, 0xff7f5b5b, 
	0xff8b6363, 0xff9f2f2f, 0xff775797, 0xff734f4f, 0xff7f5b5b, 0xff8b6363, 0xff9f2f2f, 0xff7f5b5b, 
	0xff6b4f8b, 0xff8b6363, 0xff775797, 0xff976b6b, 0xff9f2f2f, 0xffaf2b2b, 0xffbf2323, 0xff9f2f2f, 
	0xff6b4f8b, 0xff8b6363, 0xff775797, 0xffaf2b2b, 0xff976b6b, 0xff9f2f2f, 0xff8b6363, 0xffaf2b2b, 
	0xff976b6b, 0xff9f2f2f, 0xff8b6363, 0xff6b4f8b, 0xff775797, 0xff976b6b, 0xffaf2b2b, 0xffa37373, 
	0xff7f2f2f, 0xff8f2f2f, 0xff9f2f2f, 0xff7f2f2f, 0xff734f4f, 0xff7f5b5b, 0xff8f2f2f, 0xff9f2f2f, 
	0xff8b6363, 0xff7f2f2f, 0xff734f4f, 0xff5f6b57, 0xff57634f, 0xff7f5b5b, 0xff8f2f2f, 0xff9f2f2f, 
	0xff8b6363, 0xff7f2f2f, 0xff734f4f, 0xff7f5b5b, 0xff8f2f2f, 0xff734f4f, 0xff7f5b5b, 0xff734f4f, 
	0xff7f5b5b, 0xff5f6b57, 0xff67735f, 0xff734f4f, 0xff7f5b5b, 0xff67735f, 0xff5f6b57, 0xff8b6363, 
	0xff8f2f2f, 0xff734f4f, 0xff7f5b5b, 0xff9f2f2f, 0xff8b6363, 0xff734f4f, 0xff7f5b5b, 0xff8b6363, 
	0xff9f2f2f, 0xff734f4f, 0xff7f5b5b, 0xff8b6363, 0xff9f2f2f, 0xff7f5b5b, 0xff8b6363, 0xff976b6b, 
	0xff9f2f2f, 0xffaf2b2b, 0xffbf2323, 0xff9f2f2f, 0xff8b6363, 0xffaf2b2b, 0xff976b6b, 0xff9f2f2f, 
	0xff8b6363, 0xffaf2b2b, 0xff976b6b, 0xff9f2f2f, 0xff8b6363, 0xff976b6b, 0xffaf2b2b, 0xffa37373, 
	0xff7f2f2f, 0xff734f4f, 0xff7f5b5b, 0xff8b6363, 0xff8f2f2f, 0xff9f2f2f, 0xff976b6b, 0xff734f4f, 
	0xff7f5b5b, 0xff8b6363, 0xff7f5b5b, 0xff6f5b7f, 0xff6b4f8b, 0xff8b6363, 0xff775797, 0xff7b678b, 
	0xff7f5b5b, 0xff8b6363, 0xff7f5b5b, 0xff6f5b7f, 0xff8b6363, 0xff7b678b, 0xff976b6b, 0xff7f5b5b, 
	0xff8b6363, 0xff976b6b, 0xff8b6363, 0xff6b4f8b, 0xff775797, 0xff6f5b7f, 0xff7b678b, 0xff976b6b, 
	0xff8b6363, 0xff976b6b, 0xff8b6363, 0xff7b678b, 0xff976b6b, 0xffa37373, 0xff734f4f, 0xff7f5b5b, 
	0xff8b6363, 0xff6f7b67, 0xff67735f, 0xff7b836f, 0xff976b6b, 0xffa37373, 0xff7f5b5b, 0xff8b6363, 
	0xff7b7b7b, 0xff976b6b, 0xff8b6363, 0xff6f5b7f, 0xff7b678b, 0xff7b7b7b, 0xff976b6b, 0xff877393, 
	0xff8b6363, 0xff7b7b7b, 0xff7b836f, 0xff6f7b67, 0xff976b6b, 0xff7b7b7b, 0xff7b836f, 0xff976b6b, 
	0xff8b8b8b, 0xff877393, 0xff8b6363, 0xff976b6b, 0xffa37373, 0xff976b6b, 0xffa37373, 0xff976b6b, 
	0xff7b836f, 0xffa37373, 0xff976b6b, 0xff877393, 0xffa37373, 0xff7b7b7b, 0xff8b8b8b, 0xff7b836f, 
	0xffaf7b7b, 0xff9f2f2f, 0xff8b6363, 0xff976b6b, 0xffaf2b2b, 0xffa37373, 0xff8b6363, 0xff976b6b, 
	0xffa37373, 0xffaf7b7b, 0xffaf2b2b, 0xff8b6363, 0xff976b6b, 0xffa37373, 0xffaf7b7b, 0xffaf2b2b, 
	0xff976b6b, 0xffa37373, 0xffaf7b7b, 0xffbb8383, 0xffdf1313, 0xffcf1b1b, 0xffbf2323, 0xffaf2b2b, 
	0xffef0b0b, 0xffff0000, 0xffbf2323, 0xffaf2b2b, 0xffcf1b1b, 0xffbf2323, 0xffaf2b2b, 0xffcf1b1b, 
	0xffbf2323, 0xffaf2b2b, 0xffcf1b1b, 0xffaf2b2b, 0xff976b6b, 0xffa37373, 0xffaf7b7b, 0xffbf2323, 
	0xffdf1313, 0xffcf1b1b, 0xffbf2323, 0xffef0b0b, 0xffcf1b1b, 0xffbf2323, 0xffdf1313, 0xffcf1b1b, 
	0xffbf2323, 0xffdf1313, 0xffbf2323, 0xffaf2b2b, 0xffaf7b7b, 0xffbb8383, 0xffcf1b1b, 0xffcb8b8b, 
	0xffbf2323, 0xffaf2b2b, 0xffcf1b1b, 0xffbf2323, 0xffaf2b2b, 0xffcf1b1b, 0xffbf2323, 0xffaf2b2b, 
	0xffcf1b1b, 0xffaf2b2b, 0xff976b6b, 0xffa37373, 0xffaf7b7b, 0xffbf2323, 0xffdf1313, 0xffcf1b1b, 
	0xffbf2323, 0xffef0b0b, 0xffcf1b1b, 0xffbf2323, 0xffdf1313, 0xffcf1b1b, 0xffbf2323, 0xffdf1313, 
	0xffbf2323, 0xffaf2b2b, 0xffaf7b7b, 0xffbb8383, 0xffcf1b1b, 0xffcb8b8b, 0xffffbf7f, 0xffaf2b2b, 
	0xff976b6b, 0xffa37373, 0xffaf7b7b, 0xffbf2323, 0xffaf2b2b, 0xff976b6b, 0xffa37373, 0xffaf7b7b, 
	0xffbb8383, 0xffcb8b8b, 0xffaf2b2b, 0xff976b6b, 0xffa37373, 0xffaf7b7b, 0xffbb8383, 0xffcb8b8b, 
	0xffa37373, 0xffaf7b7b, 0xffbb8383, 0xffcb8b8b, 0xffbf2323, 0xffaf2b2b, 0xffaf7b7b, 0xffbb8383, 
	0xffcf1b1b, 0xffcb8b8b, 0xffbf2323, 0xffaf2b2b, 0xffaf7b7b, 0xffbb8383, 0xffcb8b8b, 0xffcf1b1b, 
	0xffbf2323, 0xffaf2b2b, 0xffaf7b7b, 0xffbb8383, 0xffcb8b8b, 0xffcf1b1b, 0xffffbf7f, 0xffbb8383, 
	0xffcb8b8b, 0xff534373, 0xff5f4b7f, 0xff6b4f8b, 0xff775797, 0xff9f2f2f, 0xff6b4f8b, 0xff775797, 
	0xff835fa3, 0xff6b4f8b, 0xff775797, 0xff835fa3, 0xff8b6363, 0xff976b6b, 0xff6b4f8b, 0xff775797, 
	0xff835fa3, 0xff8f6baf, 0xff9f2f2f, 0xff6b4f8b, 0xff775797, 0xff835fa3, 0xff8b6363, 0xffaf2b2b, 
	0xff976b6b, 0xff775797, 0xff835fa3, 0xff9f73bb, 0xff6b4f8b, 0xff775797, 0xff8b6363, 0xff976b6b, 
	0xff835fa3, 0xff775797, 0xff835fa3, 0xff775797, 0xff8b6363, 0xff976b6b, 0xff835fa3, 0xffa37373, 
	0xff775797, 0xff835fa3, 0xff976b6b, 0xff775797, 0xff835fa3, 0xffa37373, 0xffaf2b2b, 0xff775797, 
	0xff835fa3, 0xffa37373, 0xff976b6b, 0xff835fa3, 0xffa37373, 0xffaf7b7b, 0xff835fa3, 0xffa37373, 
	0xff8f6baf, 0xffaf7b7b, 0xff775797, 0xff835fa3, 0xff8f6baf, 0xff9f73bb, 0xff775797, 0xff835fa3, 
	0xff0000ff, 0xff8f6baf, 0xff9f73bb, 0xff6b4f8b, 0xff775797, 0xff6f5b7f, 0xff7b678b, 0xff775797, 
	0xff835fa3, 0xff6f5b7f, 0xff775797, 0xff7b678b, 0xff835fa3, 0xff877393, 0xff775797, 0xff835fa3, 
	0xff7b678b, 0xff877393, 0xff775797, 0xff7b678b, 0xff976b6b, 0xff835fa3, 0xff8b6363, 0xff775797, 
	0xff835fa3, 0xff7b678b, 0xff775797, 0xff835fa3, 0xff877393, 0xff976b6b, 0xffa37373, 0xff775797, 
	0xff835fa3, 0xff877393, 0xff8f6baf, 0xff775797, 0xff835fa3, 0xff8f6baf, 0xff9f73bb, 0xff7b678b, 
	0xff877393, 0xff7b7b7b, 0xff976b6b, 0xff7b678b, 0xff775797, 0xff835fa3, 0xff877393, 0xff8f6baf, 
	0xff7b7b7b, 0xff7b678b, 0xff877393, 0xff8b8b8b, 0xff877393, 0xff7b87a3, 0xff977f9f, 0xff8b8b8b, 
	0xff976b6b, 0xff7b678b, 0xff877393, 0xffa37373, 0xff977f9f, 0xff877393, 0xff835fa3, 0xff8f6baf, 
	0xff977f9f, 0xff877393, 0xff7b7b7b, 0xff8b8b8b, 0xffa37373, 0xff977f9f, 0xffaf7b7b, 0xff877393, 
	0xff977f9f, 0xff8b8b8b, 0xff835fa3, 0xff8f6baf, 0xff877393, 0xff835fa3, 0xff8f6baf, 0xff877393, 
	0xff835fa3, 0xff8f6baf, 0xff7b87a3, 0xff977f9f, 0xff8f6baf, 0xff7b87a3, 0xff6b87b7, 0xff7b93c3, 
	0xff9f73bb, 0xff977f9f, 0xff835fa3, 0xff8f6baf, 0xff977f9f, 0xff9f73bb, 0xff8f6baf, 0xff9f73bb, 
	0xff8f6baf, 0xff977f9f, 0xff9f73bb, 0xffa38bab, 0xff8f6baf, 0xff9f73bb, 0xff977f9f, 0xffa38bab, 
	0xff976b6b, 0xff775797, 0xff835fa3, 0xffa37373, 0xff835fa3, 0xff8f6baf, 0xffa37373, 0xff976b6b, 
	0xff835fa3, 0xffa37373, 0xff877393, 0xffaf7b7b, 0xff835fa3, 0xff8f6baf, 0xff877393, 0xffa37373, 
	0xff977f9f, 0xffaf7b7b, 0xff976b6b, 0xffa37373, 0xff835fa3, 0xffaf7b7b, 0xff835fa3, 0xffa37373, 
	0xff8f6baf, 0xffaf7b7b, 0xff9f73bb, 0xffa37373, 0xffaf7b7b, 0xffa37373, 0xffaf7b7b, 0xff835fa3, 
	0xff8f6baf, 0xff9f73bb, 0xff977f9f, 0xffbb8383, 0xff835fa3, 0xff8f6baf, 0xff9f73bb, 0xffbb8383, 
	0xffa37373, 0xff877393, 0xff977f9f, 0xffaf7b7b, 0xff877393, 0xff8f6baf, 0xff977f9f, 0xffa37373, 
	0xffaf7b7b, 0xff9f73bb, 0xffa37373, 0xffaf7b7b, 0xff977f9f, 0xffbb8383, 0xff977f9f, 0xffaf7b7b, 
	0xffa38bab, 0xffbb8383, 0xffa37373, 0xffaf7b7b, 0xffbb8383, 0xffaf7b7b, 0xff977f9f, 0xff8f6baf, 
	0xff9f73bb, 0xffbb8383, 0xffaf7b7b, 0xffbb8383, 0xffaf7b7b, 0xffbb8383, 0xff977f9f, 0xffa38bab, 
	0xffcb8b8b, 0xff8f6baf, 0xff9f73bb, 0xff977f9f, 0xffa38bab, 0xffbb8383, 0xffcb8b8b, 0xff835fa3, 
	0xff8f6baf, 0xff9f73bb, 0xff4f97e3, 0xff7b93c3, 0xff8ba3d3, 0xff97b3e3, 0xffaf2b2b, 0xff775797, 
	0xff835fa3, 0xff976b6b, 0xffa37373, 0xffbf2323, 0xffaf7b7b, 0xff9f73bb, 0xff835fa3, 0xff9f73bb, 
	0xffaf2b2b, 0xff976b6b, 0xffa37373, 0xff835fa3, 0xffaf7b7b, 0xff835fa3, 0xffa37373, 0xffaf7b7b, 
	0xff9f73bb, 0xffa37373, 0xffaf7b7b, 0xffa37373, 0xff835fa3, 0xffaf7b7b, 0xff8f6baf, 0xff9f73bb, 
	0xffbb8383, 0xffaf2b2b, 0xffa37373, 0xffaf7b7b, 0xffa37373, 0xffaf7b7b, 0xff835fa3, 0xff9f73bb, 
	0xffbb8383, 0xffa37373, 0xffaf7b7b, 0xffbb8383, 0xffaf7b7b, 0xff9f73bb, 0xffbb8383, 0xffcb8b8b, 
	0xff835fa3, 0xff9f73bb, 0xff8f6baf, 0xffbb8383, 0xffcb8b8b, 0xffbf2323, 0xff835fa3, 0xffaf2b2b, 
	0xffaf7b7b, 0xff9f73bb, 0xffbb8383, 0xffcf1b1b, 0xffcb8b8b, 0xff835fa3, 0xff9f73bb, 0xffbf2323, 
	0xffbb8383, 0xffcb8b8b, 0xffcf1b1b, 0xffbf2323, 0xffaf2b2b, 0xffaf7b7b, 0xffbb8383, 0xff9f73bb, 
	0xffcb8b8b, 0xffcf1b1b, 0xff9f73bb, 0xffbb8383, 0xffcb8b8b, 0xff835fa3, 0xff9f73bb, 0xffcb8b8b, 
	0xffa37373, 0xffaf7b7b, 0xff8f6baf, 0xff9f73bb, 0xffbb8383, 0xffcb8b8b, 0xffa38bab, 0xff9f73bb, 
	0xff97b3e3, 0xffbbc3db, 0xffcb8b8b, 0xffbbbbbb, 0xffcbcbcb, 0xff57634f, 0xff5f6b57, 0xff7f2f2f, 
	0xff734f4f, 0xff8f2f2f, 0xff7f5b5b, 0xff57634f, 0xff5f6b57, 0xff67735f, 0xff734f4f, 0xff7f5b5b, 
	0xff57634f, 0xff5f6b57, 0xff67735f, 0xff7f5b5b, 0xff5f6b57, 0xff67735f, 0xff6f7b67, 0xff8f2f2f, 
	0xff734f4f, 0xff7f5b5b, 0xff9f2f2f, 0xff8b6363, 0xff734f4f, 0xff7f5b5b, 0xff67735f, 0xff8b6363, 
	0xff9f2f2f, 0xff734f4f, 0xff5f6b57, 0xff7f5b5b, 0xff67735f, 0xff8b6363, 0xff6f7b67, 0xff9f2f2f, 
	0xff7f5b5b, 0xff67735f, 0xff6f7b67, 0xff8b6363, 0xff7b836f, 0xff976b6b, 0xff5f6b57, 0xff67735f, 
	0xff6f7b67, 0xff7b836f, 0xff7f5b5b, 0xff8b6363, 0xff976b6b, 0xff5f6b57, 0xff67735f, 0xff6f7b67, 
	0xff7b836f, 0xff8b6363, 0xff67735f, 0xff6f7b67, 0xff7b836f, 0xff9f2f2f, 0xff8b6363, 0xff976b6b, 
	0xff7b836f, 0xffaf2b2b, 0xffa37373, 0xff8b6363, 0xff976b6b, 0xff7b836f, 0xffa37373, 0xffaf7b7b, 
	0xffaf2b2b, 0xff8b6363, 0xff976b6b, 0xff7b836f, 0xff6f7b67, 0xffa37373, 0xffaf7b7b, 0xffaf2b2b, 
	0xffffbf7f, 0xff7b836f, 0xff976b6b, 0xffa37373, 0xffaf7b7b, 0xffbb8383, 0xffffbf7f, 0xff67735f, 
	0xff6f7b67, 0xff7b836f, 0xff8b6363, 0xff976b6b, 0xffa37373, 0xffaf7b7b, 0xff7b836f, 0xff7b7b7b, 
	0xff8b8b8b, 0xff976b6b, 0xffa37373, 0xffaf7b7b, 0xff9b9b9b, 0xff7b836f, 0xff8b8b8b, 0xff9b9b9b, 
	0xff7b836f, 0xff8b8b8b, 0xff9b9b9b, 0xffaf7b7b, 0xff976b6b, 0xffa37373, 0xff7b836f, 0xffaf7b7b, 
	0xffbb8383, 0xffa37373, 0xffaf7b7b, 0xff8b8b8b, 0xff9b9b9b, 0xffbb8383, 0xffcb8b8b, 0xff7b836f, 
	0xffa37373, 0xffaf7b7b, 0xff8b8b8b, 0xff9b9b9b, 0xffbb8383, 0xffcb8b8b, 0xffffbf7f, 0xffaf7b7b, 
	0xff8b8b8b, 0xff9b9b9b, 0xff7b836f, 0xffbb8383, 0xffababab, 0xffcb8b8b, 0xff67735f, 0xff6f7b67, 
	0xff7b836f, 0xff9b9b9b, 0xffffbf7f, 0xffaf7b7b, 0xffbb8383, 0xffa37373, 0xff7b836f, 0xff9b9b9b, 
	0xff7b836f, 0xff8b8b8b, 0xff9b9b9b, 0xffababab, 0xff7b836f, 0xff9b9b9b, 0xffababab, 0xffffbf7f, 
	0xff7b836f, 0xff9b9b9b, 0xffababab, 0xffbbbbbb, 0xff7b836f, 0xff9b9b9b, 0xffbb8383, 0xffaf7b7b, 
	0xffffbf7f, 0xffababab, 0xffcb8b8b, 0xff9b9b9b, 0xffababab, 0xffbb8383, 0xffffbf7f, 0xffcb8b8b, 
	0xffbbbbbb, 0xff7b836f, 0xff9b9b9b, 0xffababab, 0xffffbf7f, 0xff9b9b9b, 0xffababab, 0xffbbbbbb, 
	0xffffbf7f, 0xffffe7ab, 0xffaf2b2b, 0xff976b6b, 0xffa37373, 0xffaf7b7b, 0xffbf2323, 0xffffbf7f, 
	0xffaf2b2b, 0xff976b6b, 0xffa37373, 0xffaf7b7b, 0xffbb8383, 0xffffbf7f, 0xffcb8b8b, 0xffaf2b2b, 
	0xff976b6b, 0xffa37373, 0xffaf7b7b, 0xffffbf7f, 0xffa37373, 0xffaf7b7b, 0xffbb8383, 0xffffbf7f, 
	0xffbf2323, 0xffaf2b2b, 0xffaf7b7b, 0xffffbf7f, 0xffcf1b1b, 0xffbf2323, 0xffaf2b2b, 0xffaf7b7b, 
	0xffbb8383, 0xffcb8b8b, 0xffffbf7f, 0xffcf1b1b, 0xffbf2323, 0xffffbf7f, 0xffffbf7f, 0xffa37373, 
	0xffaf7b7b, 0xffbb8383, 0xffcb8b8b, 0xffababab, 0xffffbf7f, 0xffa37373, 0xffffbf7f, 0xffffbf7f, 
	0xffcb8b8b, 0xffababab, 0xffbbbbbb, 0xffffe7ab, 0xff7b7b7b, 0xff8b8b8b, 0xff877393, 0xff877393, 
	0xff7b87a3, 0xff8b8b8b, 0xff977f9f, 0xff8b97af, 0xff9b9b9b, 0xff8b8b8b, 0xff9b9b9b, 0xff8b8b8b, 
	0xff7b87a3, 0xff8b97af, 0xff9b9b9b, 0xff8b8b8b, 0xff977f9f, 0xffa37373, 0xffaf7b7b, 0xff9b9b9b, 
	0xff8b8b8b, 0xff977f9f, 0xff9b9b9b, 0xffa38bab, 0xff8b8b8b, 0xff9b9b9b, 0xff8b8b8b, 0xff9b9b9b, 
	0xff7b87a3, 0xff8b97af, 0xff977f9f, 0xff7b87a3, 0xff6b87b7, 0xff7b93c3, 0xff8b97af, 0xff8f6baf, 
	0xff9f73bb, 0xff977f9f, 0xff7b87a3, 0xff8b97af, 0xff9b9b9b, 0xff8b97af, 0xff7b93c3, 0xff9ba3bf, 
	0xff977f9f, 0xff8b97af, 0xff9b9b9b, 0xffa38bab, 0xff977f9f, 0xff9f73bb, 0xff8b97af, 0xffa38bab, 
	0xff9ba3bf, 0xff9b9b9b, 0xff8b97af, 0xffa38bab, 0xff9ba3bf, 0xffababab, 0xff8b97af, 0xff9ba3bf, 
	0xffa38bab, 0xff8b8b8b, 0xff8b97af, 0xff9b9b9b, 0xffababab, 0xff8b97af, 0xff7b93c3, 0xff8ba3d3, 
	0xff9ba3bf, 0xff9b9b9b, 0xffababab, 0xffa7b3cb, 0xffaf7b7b, 0xff977f9f, 0xff8b8b8b, 0xffa38bab, 
	0xff9b9b9b, 0xffbb8383, 0xffababab, 0xffcb8b8b, 0xff977f9f, 0xffa38bab, 0xff9f73bb, 0xff9ba3bf, 
	0xff9b9b9b, 0xffababab, 0xffcb8b8b, 0xffbbbbbb, 0xff9b9b9b, 0xffababab, 0xffbb8383, 0xffcb8b8b, 
	0xffbbbbbb, 0xff9b9b9b, 0xffababab, 0xff9ba3bf, 0xffa7b3cb, 0xffbbbbbb, 0xff7b93c3, 0xff8ba3d3, 
	0xff9ba3bf, 0xff9f73bb, 0xff8b97af, 0xffa38bab, 0xff97b3e3, 0xff7b93c3, 0xff8ba3d3, 0xff5fabe7, 
	0xff77bfef, 0xff97b3e3, 0xff9f73bb, 0xff7b93c3, 0xff8ba3d3, 0xff77bfef, 0xff97b3e3, 0xff9ba3bf, 
	0xffa7b3cb, 0xff8ba3d3, 0xff77bfef, 0xff97b3e3, 0xff8bd3f7, 0xff9f73bb, 0xffa38bab, 0xff9ba3bf, 
	0xff9f73bb, 0xff8ba3d3, 0xff9ba3bf, 0xffa7b3cb, 0xff9ba3bf, 0xffa38bab, 0xffa7b3cb, 0xff9ba3bf, 
	0xff8ba3d3, 0xff97b3e3, 0xffa7b3cb, 0xff9f73bb, 0xffa38bab, 0xff9ba3bf, 0xffa7b3cb, 0xff9f73bb, 
	0xff9ba3bf, 0xffa7b3cb, 0xffa38bab, 0xff9ba3bf, 0xffa7b3cb, 0xffababab, 0xffbbbbbb, 0xff9ba3bf, 
	0xffa7b3cb, 0xffbbc3db, 0xff9f73bb, 0xff8ba3d3, 0xff97b3e3, 0xffa7b3cb, 0xff9ba3bf, 0xffbbc3db, 
	0xff9ba3bf, 0xff8ba3d3, 0xff97b3e3, 0xffa7b3cb, 0xffbbc3db, 0xffbbbbbb, 0xffababab, 0xff97b3e3, 
	0xff8bd3f7, 0xffbbc3db, 0xffa7b3cb, 0xff9b9b9b, 0xff8b97af, 0xffababab, 0xffbbbbbb, 0xff8b97af, 
	0xff9ba3bf, 0xffababab, 0xff9b9b9b, 0xffa7b3cb, 0xff9ba3bf, 0xff8ba3d3, 0xffa7b3cb, 0xffababab, 
	0xffababab, 0xff9ba3bf, 0xffa7b3cb, 0xffbbbbbb, 0xff9ba3bf, 0xffa7b3cb, 0xff77bfef, 0xff57e3e7, 
	0xff8bd3f7, 0xffababab, 0xffbbbbbb, 0xff9ba3bf, 0xffa7b3cb, 0xffababab, 0xffbbbbbb, 0xffababab, 
	0xffa7b3cb, 0xffbbbbbb, 0xffa7b3cb, 0xffbbbbbb, 0xffababab, 0xff9b9b9b, 0xffababab, 0xff57e3e7, 
	0xffbbbbbb, 0xffababab, 0xffa7b3cb, 0xff57e3e7, 0xff8bd3f7, 0xffbbbbbb, 0xff93f3ff, 0xffbbc3db, 
	0xffcbcbcb, 0xff9b9b9b, 0xffababab, 0xffbbbbbb, 0xffababab, 0xffa7b3cb, 0xffbbbbbb, 0xffcbcbcb, 
	0xffababab, 0xffbbbbbb, 0xffcbcbcb, 0xffffe7ab, 0xffbbbbbb, 0xffcbcbcb, 0xff93f3ff, 0xffdbdbdb, 
	0xff8ba3d3, 0xff77bfef, 0xffa7b3cb, 0xff97b3e3, 0xff9ba3bf, 0xff8ba3d3, 0xff77bfef, 0xff97b3e3, 
	0xff8bd3f7, 0xffa7b3cb, 0xff77bfef, 0xff8bd3f7, 0xff57e3e7, 0xff97b3e3, 0xff77bfef, 0xff8bd3f7, 
	0xff97b3e3, 0xffa7b3cb, 0xff97b3e3, 0xff97b3e3, 0xff8bd3f7, 0xffa7b3cb, 0xffbbc3db, 0xffa7b3cb, 
	0xff97b3e3, 0xff8bd3f7, 0xffbbc3db, 0xffbbbbbb, 0xff97b3e3, 0xff8bd3f7, 0xffa7b3cb, 0xffbbc3db, 
	0xff77bfef, 0xff8bd3f7, 0xff97b3e3, 0xff93f3ff, 0xff57e3e7, 0xff8bd3f7, 0xff93f3ff, 0xffa7b3cb, 
	0xffbbc3db, 0xffbbbbbb, 0xffcbcbcb, 0xff8bd3f7, 0xff93f3ff, 0xffa7b3cb, 0xff97b3e3, 0xffbbc3db, 
	0xff8bd3f7, 0xffbbbbbb, 0xffcbcbcb, 0xffdbdbdb, 0xff97b3e3, 0xff8bd3f7, 0xffbbc3db, 0xff93f3ff, 
	0xffc7f7ff, 0xffdbdbdb, 0xffbbbbbb, 0xffa7b3cb, 0xffbbc3db, 0xff8bd3f7, 0xff93f3ff, 0xffcbcbcb, 
	0xffc7f7ff, 0xffdbdbdb, 0xff8bd3f7, 0xff93f3ff, 0xffbbc3db, 0xffc7f7ff, 0xffdbdbdb, 0xffbb8383, 
	0xffcb8b8b, 0xffababab, 0xffcb8b8b, 0xffa38bab, 0xff9f73bb, 0xffababab, 0xffbbbbbb, 0xffcb8b8b, 
	0xffababab, 0xffbbbbbb, 0xffffbf7f, 0xffababab, 0xffbbbbbb, 0xffcb8b8b, 0xffcbcbcb, 0xffcb8b8b, 
	0xffffbf7f, 0xffcb8b8b, 0xffbbbbbb, 0xffcbcbcb, 0xffffbf7f, 0xffcb8b8b, 0xffffbf7f, 0xffcb8b8b, 
	0xffbbbbbb, 0xffcbcbcb, 0xffffbf7f, 0xffffe7ab, 0xff9f73bb, 0xffa38bab, 0xffa7b3cb, 0xffababab, 
	0xffbbbbbb, 0xffbbc3db, 0xffcb8b8b, 0xffcbcbcb, 0xff9f73bb, 0xff97b3e3, 0xffa7b3cb, 0xffbbc3db, 
	0xffbbbbbb, 0xffa7b3cb, 0xffbbc3db, 0xffcbcbcb, 0xffdbdbdb, 0xffbbc3db, 0xffcbcbcb, 0xffdbdbdb, 
	0xffcb8b8b, 0xff9f73bb, 0xffbbc3db, 0xffbbbbbb, 0xffcbcbcb, 0xffdbdbdb, 0xff9f73bb, 0xffbbc3db, 
	0xffcbcbcb, 0xffdbdbdb, 0xffbbbbbb, 0xffcbcbcb, 0xffbbc3db, 0xffdbdbdb, 0xffffe7ab, 0xffbbc3db, 
	0xffcbcbcb, 0xffdbdbdb, 0xffebebeb, 0xffababab, 0xffbbbbbb, 0xffcbcbcb, 0xffffe7ab, 0xffdbdbdb, 
	0xffffbf7f, 0xffcb8b8b, 0xffffffd7, 0xffbbbbbb, 0xffcbcbcb, 0xffbbc3db, 0xffdbdbdb, 0xffbbc3db, 
	0xffc7f7ff, 0xffdbdbdb, 0xffcbcbcb, 0xffebebeb, 0xffcbcbcb, 0xffdbdbdb, 0xffc7f7ff, 0xffebebeb, 
	0xffffffd7, 0xffdbdbdb, 0xffc7f7ff, 0xffebebeb, 0xffcbcbcb, 0xffdbdbdb, 0xffffe7ab, 0xffebebeb, 
	0xffffffd7, 0xffdbdbdb, 0xffebebeb, 0xffdbdbdb, 0xffebebeb, 0xffffffd7, 0xffffe7ab, 0xffdbdbdb, 
	0xffebebeb, 0xffc7f7ff, 0xffffffff, 0xffffffd7, 
};
// clang-format on

#define MAX_PALETTE_OCTREE_COLORS 8192
#define MAX_PALETTE_OCTREE_NODES  512
#define MAX_COLORS_IN_LEAF		  8

extern unsigned int d_8to24table[256];

#ifdef _DEBUG
/*
=================
CreatePaletteOctreeRec
=================
*/
static uint32_t CreatePaletteOctreeRec (
	int current_size, unsigned int *colors_lut, int x, int y, int z, int *num_nodes, palette_octree_node_t *nodes, int *num_leaf_colors,
	unsigned int *leaf_colors)
{
	assert ((*num_leaf_colors + MAX_COLORS_IN_LEAF) <= MAX_PALETTE_OCTREE_COLORS);
	int num_colors_in_leaf = 0;
	int first_leaf_color = *num_leaf_colors;
	for (int b = 0; b < current_size; ++b)
	{
		for (int g = 0; g < current_size; ++g)
		{
			for (int r = 0; r < current_size; ++r)
			{
				unsigned int color = colors_lut[(x + r) + ((y + g) * 256ull) + ((z + b) * 256ull * 256ull)];
				qboolean	 found = false;
				for (int i = 0; i < num_colors_in_leaf; ++i)
				{
					if (leaf_colors[first_leaf_color + i] == color)
					{
						found = true;
						break;
					}
				}
				if (!found)
				{
					if (num_colors_in_leaf == MAX_COLORS_IN_LEAF)
					{
						num_colors_in_leaf += 1;
						goto end_loops;
					}
					leaf_colors[first_leaf_color + num_colors_in_leaf++] = color;
				}
			}
		}
	}
end_loops:

	if (num_colors_in_leaf <= MAX_COLORS_IN_LEAF)
	{
		*num_leaf_colors += num_colors_in_leaf;
		return (1u << 31) | (first_leaf_color << 4) | num_colors_in_leaf;
	}

	int node_index = (*num_nodes)++;
	assert (node_index < MAX_PALETTE_OCTREE_NODES);
	palette_octree_node_t *node = &nodes[node_index];

	int half_size = current_size / 2;
	for (int i = 0; i < 8; ++i)
	{
		int offset = CreatePaletteOctreeRec (
			half_size, colors_lut, x + (((i % 2) >= 1) ? half_size : 0), y + (((i % 4) >= 2) ? half_size : 0), z + (((i % 8) >= 4) ? half_size : 0), num_nodes,
			nodes, num_leaf_colors, leaf_colors);
		node->child_offsets[i] = offset;
	}

	return node_index;
}

/*
=================
MakeColorsLUT
=================
*/
static void MakeColorsLUT (unsigned int *colors)
{
	for (int b = 0; b < 256; ++b)
	{
		for (int g = 0; g < 256; ++g)
		{
			for (int r = 0; r < 256; ++r)
			{
				unsigned best_color = 0;
				int		 best_dist_sq = INT_MAX;
				for (int i = 0; i < 256; ++i)
				{
					byte	 *c = (byte *)(&d_8to24table[i]);
					const int dist_sq = (((int)c[0] - r) * ((int)c[0] - r)) + (((int)c[1] - g) * ((int)c[1] - g)) + (((int)c[2] - b) * ((int)c[2] - b));
					if (dist_sq < best_dist_sq)
					{
						best_dist_sq = dist_sq;
						best_color = d_8to24table[i];
					}
				}
				colors[r + (g * 256ull) + (b * 256ull * 256ull)] = best_color;
			}
		}
	}
}

/*
=================
CreatePaletteOctree_f
=================
*/
void CreatePaletteOctree_f (void)
{
	unsigned int *colors_lut = Mem_Alloc (sizeof (unsigned int) * 256ull * 256ull * 256ull);

	TexMgr_LoadPalette ();
	MakeColorsLUT (colors_lut);

	int					  num_nodes = 0;
	int					  num_colors = 0;
	palette_octree_node_t nodes[MAX_PALETTE_OCTREE_NODES];
	uint32_t			  colors[MAX_PALETTE_OCTREE_COLORS];
	CreatePaletteOctreeRec (256, colors_lut, 0, 0, 0, &num_nodes, nodes, &num_colors, colors);

	Sys_Printf ("#define NUM_PALETTE_OCTREE_NODES %d\n", num_nodes);
	Sys_Printf ("#define NUM_PALETTE_OCTREE_COLORS %d\n", num_colors);

	Sys_Printf ("palette_octree_node_t palette_octree_nodes[NUM_PALETTE_OCTREE_NODES] =\n{\n");
	for (int i = 0; i < num_nodes; ++i)
	{
		Sys_Printf ("\t{");
		for (int j = 0; j < 8; ++j)
		{
			Sys_Printf ("0x%x, ", nodes[i].child_offsets[j]);
		}
		Sys_Printf ("},\n");
	}
	Sys_Printf ("};\n\n");

	Sys_Printf ("uint32_t palette_octree_colors[NUM_PALETTE_OCTREE_COLORS] =\n{\n");
	for (int i = 0; i < num_colors; i += 8)
	{
		Sys_Printf ("\t");
		for (int j = i; j < (i + 8) && (j < num_colors); ++j)
		{
			Sys_Printf ("0x%x, ", colors[j]);
		}
		Sys_Printf ("\n");
	}
	Sys_Printf ("};");

	Mem_Free (colors_lut);
}
#endif
