//       _________ __                 __
//      /   _____//  |_____________ _/  |______     ____  __ __  ______
//      \_____  \\   __\_  __ \__  \\   __\__  \   / ___\|  |  \/  ___/
//      /        \|  |  |  | \// __ \|  |  / __ \_/ /_/  >  |  /\___ |
//     /_______  /|__|  |__|  (____  /__| (____  /\___  /|____//____  >
//             \/                  \/          \//_____/            \/
//  ______________________                           ______________________
//                        T H E   W A R   B E G I N S
//         Stratagus - A free fantasy real time strategy game engine
//
//      (c) Copyright 2020-2022 by Andrettin
//
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; only version 2 of the License.
//
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
//
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
//      02111-1307, USA.

#pragma once

namespace wyrmgus {

class gsml_data;
class gsml_property;

template <typename property_function_type, typename data_function_type>
class gsml_element_visitor final
{
public:
	gsml_element_visitor(const property_function_type &property_function, const data_function_type &data_function)
		: property_function(property_function), data_function(data_function)
	{
	}

	gsml_element_visitor(property_function_type &&property_function, data_function_type &&data_function) = delete;

	void operator()(const gsml_property &property) const
	{
		this->property_function(property);
	}

	void operator()(const gsml_data &scope) const
	{
		this->data_function(scope);
	}

private:
	const property_function_type &property_function;
	const data_function_type &data_function;
};

}
