/*      _______   __   __   __   ______   __   __   _______   __   __
 *     / _____/\ / /\ / /\ / /\ / ____/\ / /\ / /\ / ___  /\ /  |\/ /\
 *    / /\____\// / // / // / // /\___\// /_// / // /\_/ / // , |/ / /
 *   / / /__   / / // / // / // / /    / ___  / // ___  / // /| ' / /
 *  / /_// /\ / /_// / // / // /_/_   / / // / // /\_/ / // / |  / /
 * /______/ //______/ //_/ //_____/\ /_/ //_/ //_/ //_/ //_/ /|_/ /
 * \______\/ \______\/ \_\/ \_____\/ \_\/ \_\/ \_\/ \_\/ \_\/ \_\/
 *
 * Copyright (c) 2004, 2005 darkbits                        Js_./
 * Per Larsson a.k.a finalman                          _RqZ{a<^_aa
 * Olof Naessén a.k.a jansem/yakslem                _asww7!uY`>  )\a//
 *                                                 _Qhm`] _f "'c  1!5m
 * Visit: http://guichan.darkbits.org             )Qk<P ` _: :+' .'  "{[
 *                                               .)j(] .d_/ '-(  P .   S
 * License: (BSD)                                <Td/Z <fP"5(\"??"\a.  .L
 * Redistribution and use in source and          _dV>ws?a-?'      ._/L  #'
 * binary forms, with or without                 )4d[#7r, .   '     )d`)[
 * modification, are permitted provided         _Q-5'5W..j/?'   -?!\)cam'
 * that the following conditions are met:       j<<WP+k/);.        _W=j f
 * 1. Redistributions of source code must       .$%w\/]Q  . ."'  .  mj$
 *    retain the above copyright notice,        ]E.pYY(Q]>.   a     J@\
 *    this list of conditions and the           j(]1u<sE"L,. .   ./^ ]{a
 *    following disclaimer.                     4'_uomm\.  )L);-4     (3=
 * 2. Redistributions in binary form must        )_]X{Z('a_"a7'<a"a,  ]"[
 *    reproduce the above copyright notice,       #}<]m7`Za??4,P-"'7. ).m
 *    this list of conditions and the            ]d2e)Q(<Q(  ?94   b-  LQ/
 *    following disclaimer in the                <B!</]C)d_, '(<' .f. =C+m
 *    documentation and/or other materials      .Z!=J ]e []('-4f _ ) -.)m]'
 *    provided with the distribution.          .w[5]' _[ /.)_-"+?   _/ <W"
 * 3. Neither the name of Guichan nor the      :$we` _! + _/ .        j?
 *    names of its contributors may be used     =3)= _f  (_yQmWW$#(    "
 *    to endorse or promote products derived     -   W,  sQQQQmZQ#Wwa]..
 *    from this software without specific        (js, \[QQW$QWW#?!V"".
 *    prior written permission.                    ]y:.<\..          .
 *                                                 -]n w/ '         [.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT       )/ )/           !
 * HOLDERS AND CONTRIBUTORS "AS IS" AND ANY         <  (; sac    ,    '
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING,               ]^ .-  %
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF            c <   r
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR            aga<  <La
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE          5%  )P'-3L
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR        _bQf` y`..)a
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,          ,J?4P'.P"_(\?d'.,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES               _Pa,)!f/<[]/  ?"
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT      _2-..:. .r+_,.. .
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,     ?a.<%"'  " -'.a_ _,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION)                     ^
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
 * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * For comments regarding functions please see the header file.
 */
#include "stratagus.h"

#include "guichan/widgets/button.h"
#include "guichan/exception.h"
#include "guichan/mouseinput.h"

namespace gcn
{
    Button::Button()
    {
        mAlignment = Graphics::CENTER;
        addMouseListener(this);
        addKeyListener(this);
        adjustSize();
        setBorderSize(1);
    }

    Button::Button(const std::string& caption)
    {
        mCaption = caption;
        //Wyrmgus start
        mTooltip = "";
        //Wyrmgus end
        mAlignment = Graphics::CENTER;
        setFocusable(true);
        adjustSize();
        setBorderSize(1);

        mMouseDown = false;
        mKeyDown = false;
        mHotKeyDown = false;
        //Wyrmgus start
        mActsPressed = false;
        //Wyrmgus end

        addMouseListener(this);
        addKeyListener(this);
    }

    void Button::setCaption(const std::string& caption)
    {
        mCaption = caption;
        setDirty(true);
    }

    const std::string& Button::getCaption() const
    {
        return mCaption;
    }

    void Button::setAlignment(unsigned int alignment)
    {
        mAlignment = alignment;
    }

    unsigned int Button::getAlignment() const
    {
        return mAlignment;
    }

    //Wyrmgus start
    void Button::setActsPressed(bool actsPressed)
    {
        mActsPressed = actsPressed;
    }

    bool Button::actsPressed() const
    {
        return mActsPressed;
    }
    //Wyrmgus end

    void Button::draw(Graphics* graphics, std::vector<std::function<void(renderer *)>> &render_commands)
    {
        Color faceColor = getBaseColor();
        Color highlightColor, shadowColor;
        int alpha = getBaseColor().a;

        if (isPressed())
        {
            faceColor = faceColor - 0x303030;
            faceColor.a = alpha;
            highlightColor = faceColor - 0x303030;
            highlightColor.a = alpha;
            shadowColor = faceColor + 0x303030;
            shadowColor.a = alpha;
        }
        else if (isEnabled())
        {
            highlightColor = faceColor + 0x303030;
            highlightColor.a = alpha;
            shadowColor = faceColor - 0x303030;
            shadowColor.a = alpha;
        }
        else
        {
            faceColor = getDisabledColor();
            highlightColor = faceColor + 0x303030;
            highlightColor.a = alpha;
            shadowColor = faceColor - 0x303030;
            shadowColor.a = alpha;
        }

        graphics->setColor(faceColor);
        graphics->fillRectangle(Rectangle(1, 1, getDimension().width-1, getHeight() - 1), render_commands);

        graphics->setColor(highlightColor);
        graphics->drawLine(0, 0, getWidth() - 1, 0, render_commands);
        graphics->drawLine(0, 1, 0, getHeight() - 1, render_commands);
        //graphics->drawHLine(0, 0, getWidth() - 1);
        //graphics->drawVLine(0, 1, 0, getHeight() - 1);

        graphics->setColor(shadowColor);
        graphics->drawLine(getWidth() - 1, 1, getWidth() - 1, getHeight() - 1, render_commands);
        graphics->drawLine(1, getHeight() - 1, getWidth() - 1, getHeight() - 1, render_commands);
        //graphics->drawVLine(getWidth() - 1, 1 , getHeight() - 1);
        //graphics->drawHLine(1, getHeight() - 1, getWidth() - 1);

        graphics->setColor(getForegroundColor());

        int textX;
        int textY = getHeight() / 2 - getFont()->getHeight() / 2;

        switch (getAlignment())
        {
          case Graphics::LEFT:
              textX = 4;
              break;
          case Graphics::CENTER:
              textX = getWidth() / 2;
              break;
          case Graphics::RIGHT:
              textX = getWidth() - 4;
              break;
          default:
              textX = 0;
              throw std::runtime_error("Unknown alignment.");
        }

        graphics->setFont(getFont());

        if (isPressed())
        {
            graphics->drawText(getCaption(), textX + 1, textY + 1, getAlignment(), true, render_commands);
        }
        else
        {
            graphics->drawText(getCaption(), textX, textY, getAlignment(), true, render_commands);

            if (hasFocus())
            {
                graphics->drawRectangle(Rectangle(2, 2, getWidth() - 4,
                                                  getHeight() - 4), render_commands);
            }
        }
    }

    void Button::drawBorder(Graphics* graphics, std::vector<std::function<void(renderer *)>> &render_commands)
    {
        Color faceColor = getBaseColor();
        Color highlightColor, shadowColor;
        int alpha = getBaseColor().a;
        int width = getWidth() + getBorderSize() * 2 - 1;
        int height = getHeight() + getBorderSize() * 2 - 1;
        highlightColor = faceColor + 0x303030;
        highlightColor.a = alpha;
        shadowColor = faceColor - 0x303030;
        shadowColor.a = alpha;

        unsigned int i;
        for (i = 0; i < getBorderSize(); ++i)
        {
            graphics->setColor(shadowColor);
            graphics->drawLine(i,i, width - i, i, render_commands);
            graphics->drawLine(i,i + 1, i, height - i - 1, render_commands);
            graphics->setColor(highlightColor);
            graphics->drawLine(width - i,i + 1, width - i, height - i, render_commands);
            graphics->drawLine(i,height - i, width - i - 1, height - i, render_commands);
        }
    }

    void Button::adjustSize()
    {
        setWidth(getFont()->getWidth(mCaption) + 8);
        setHeight(getFont()->getHeight() + 8);
    }

    bool Button::isPressed() const
    {
        return (hasMouse() && mMouseDown) || mKeyDown || mHotKeyDown;
    }

    void Button::mouseClick(int, int, int button, int)
    {
        if (button == MouseInput::LEFT)
        {
            generateAction();
        }
    }

    void Button::mousePress(int, int, int button)
    {
        if (button == MouseInput::LEFT && hasMouse())
        {
            mMouseDown = true;
        }
    }

    void Button::mouseRelease(int button)
    {
        if (button == MouseInput::LEFT)
        {
            mMouseDown = false;
        }
    }

    bool Button::keyPress(const Key& key)
    {
        bool ret = false;

        if (key.getValue() == Key::K_ENTER || key.getValue() == Key::K_SPACE)
        {
            mKeyDown = true;
            ret = true;
			//Wyrmgus start
			if (actsPressed()) //generate an action if it is pressed (held down)
			{
				generateAction();
			}
			//Wyrmgus end
        }

        mHotKeyDown = false;
        mMouseDown = false;

        return ret;
    }

    bool Button::keyRelease(const Key& key)
    {
        bool ret = false;

        if ((key.getValue() == Key::K_ENTER || key.getValue() == Key::K_SPACE) && mKeyDown)
        {
            mKeyDown = false;
			//Wyrmgus start
//            generateAction();		
			if (!actsPressed()) //generate an action if it is pressed (held down)
			{
				generateAction();
			}
			//Wyrmgus end
            ret = true;
        }
        return ret;
    }

    void Button::hotKeyPress()
    {
        mHotKeyDown = true;
        mMouseDown = false;
		//Wyrmgus start
		if (actsPressed()) //generate an action if it is pressed (held down)
		{
			generateAction();
		}
		//Wyrmgus end
    }

    void Button::hotKeyRelease()
    {
        if (mHotKeyDown)
        {
            mHotKeyDown = false;
			//Wyrmgus start
//            generateAction();		
			if (!actsPressed()) //generate an action if it is pressed (held down)
			{
				generateAction();
			}
			//Wyrmgus end
        }
    }

    void Button::lostFocus()
    {
        mMouseDown = false;
        mKeyDown = false;
		mHotKeyDown = false;
    }
}
