//       _________ __                 __
//      /   _____//  |_____________ _/  |______     ____  __ __  ______
//      \_____  \\   __\_  __ \__  \\   __\__  \   / ___\|  |  \/  ___/
//      /        \|  |  |  | \// __ \|  |  / __ \_/ /_/  >  |  /\___ |
//     /_______  /|__|  |__|  (____  /__| (____  /\___  /|____//____  >
//             \/                  \/          \//_____/            \/
//  ______________________                           ______________________
//                        T H E   W A R   B E G I N S
//         Stratagus - A free fantasy real time strategy game engine
//
//      (c) Copyright 2021-2022 by Andrettin
//
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; only version 2 of the License.
//
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
//
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
//      02111-1307, USA.

#pragma once

#include "database/data_entry_history.h"
#include "unit/unit_class_container.h"

namespace wyrmgus {

class region;

class region_history final : public data_entry_history
{
	Q_OBJECT

	Q_PROPERTY(qint64 population MEMBER population READ get_population)

public:
	virtual void process_gsml_scope(const gsml_data &scope) override;

	int64_t get_population() const
	{
		return this->population;
	}

	const unit_class_map<int64_t> &get_population_groups() const
	{
		return this->population_groups;
	}

private:
	int64_t population = 0; //used for creating units at scenario start
	unit_class_map<int64_t> population_groups; //population size for unit classes
};

}
