//       _________ __                 __
//      /   _____//  |_____________ _/  |______     ____  __ __  ______
//      \_____  \\   __\_  __ \__  \\   __\__  \   / ___\|  |  \/  ___/
//      /        \|  |  |  | \// __ \|  |  / __ \_/ /_/  >  |  /\___ |
//     /_______  /|__|  |__|  (____  /__| (____  /\___  /|____//____  >
//             \/                  \/          \//_____/            \/
//  ______________________                           ______________________
//                        T H E   W A R   B E G I N S
//         Stratagus - A free fantasy real time strategy game engine
//
//      (c) Copyright 2020-2022 by Andrettin
//
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; only version 2 of the License.
//
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
//
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
//      02111-1307, USA.

#pragma once

namespace wyrmgus {

class terrain_feature;
class terrain_type;

using terrain_geodata_key = std::variant<const terrain_type *, const terrain_feature *>;

struct terrain_geodata_map_compare
{
	bool operator()(const terrain_geodata_key &terrain_variant, const terrain_geodata_key &other_terrain_variant) const;
};

using terrain_geodata_map = std::map<terrain_geodata_key, std::vector<std::unique_ptr<QGeoShape>>, terrain_geodata_map_compare>;
using terrain_geodata_ptr_map = std::map<terrain_geodata_key, std::vector<const QGeoShape *>, terrain_geodata_map_compare>;

}
