local enemy = ...

-- Mini Mowatulla: a small spider that comes from an egg.
-- This enemy is usually be generated by a bigger one.

local in_shell = true

function enemy:on_created()

  enemy:set_life(2)
  enemy:set_damage(2)
  enemy:set_size(16, 16)
  enemy:set_origin(8, 13)
  enemy:set_invincible()

  local sprite = enemy:create_sprite("enemies/" .. enemy:get_breed())
  sprite:set_animation("shell")

  function sprite:on_animation_finished(animation)

    -- If the shell was breaking, let the mini mowatulla go.
    if animation == "shell_breaking" then
      sprite:set_animation("walking")
      enemy:snap_to_grid()
      enemy:set_default_attack_consequences()
      in_shell = false
      enemy:restart()
    end
  end

end

-- The enemy was stopped for some reason and should restart.
function enemy:on_restarted()

  if in_shell then
    enemy:get_sprite():set_animation("shell")
    local m = sol.movement.create("target")
    m:set_speed(64)
    m:start(enemy)

    sol.timer.start(enemy, 1000, function()
      -- Start breaking the shell.
      enemy:stop_movement()
      enemy:get_sprite():set_animation("shell_breaking")
    end)

  else
    local m = sol.movement.create("path_finding")
    m:set_speed(64)
    m:start(enemy)
  end
end

