/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.tools.I18n;

public enum OsmPrimitiveType {
    NODE(I18n.marktr("node"), Node.class, NodeData.class),
    WAY(I18n.marktr("way"), Way.class, WayData.class),
    RELATION(I18n.marktr("relation"), Relation.class, RelationData.class),
    CLOSEDWAY(I18n.marktr("closedway"), null, WayData.class),
    MULTIPOLYGON(I18n.marktr("multipolygon"), null, RelationData.class);

    private static final Collection<OsmPrimitiveType> DATA_VALUES;
    private final String apiTypeName;
    private final Class<? extends OsmPrimitive> osmClass;
    private final Class<? extends PrimitiveData> dataClass;

    private OsmPrimitiveType(String string2, Class<? extends OsmPrimitive> clazz, Class<? extends PrimitiveData> clazz2) {
        this.apiTypeName = string2;
        this.osmClass = clazz;
        this.dataClass = clazz2;
    }

    public String getAPIName() {
        return this.apiTypeName;
    }

    public Class<? extends OsmPrimitive> getOsmClass() {
        return this.osmClass;
    }

    public Class<? extends PrimitiveData> getDataClass() {
        return this.dataClass;
    }

    public static OsmPrimitiveType fromApiTypeName(String string) {
        for (OsmPrimitiveType osmPrimitiveType : OsmPrimitiveType.values()) {
            if (!osmPrimitiveType.getAPIName().equals(string)) continue;
            return osmPrimitiveType;
        }
        throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' is not a valid type name. Got ''{1}''.", "typeName", string));
    }

    public static OsmPrimitiveType from(IPrimitive iPrimitive) {
        if (iPrimitive instanceof INode) {
            return NODE;
        }
        if (iPrimitive instanceof IWay) {
            return WAY;
        }
        if (iPrimitive instanceof IRelation) {
            return RELATION;
        }
        throw new IllegalArgumentException("Unknown type: " + iPrimitive);
    }

    public static OsmPrimitiveType from(String string) {
        for (OsmPrimitiveType osmPrimitiveType : OsmPrimitiveType.values()) {
            if (!osmPrimitiveType.getAPIName().equalsIgnoreCase(string)) continue;
            return osmPrimitiveType;
        }
        return null;
    }

    public static Collection<OsmPrimitiveType> dataValues() {
        return DATA_VALUES;
    }

    public OsmPrimitive newInstance(long l, boolean bl) {
        switch (this) {
            case NODE: {
                return new Node(l, bl);
            }
            case WAY: {
                return new Way(l, bl);
            }
            case RELATION: {
                return new Relation(l, bl);
            }
        }
        throw new AssertionError();
    }

    public OsmPrimitive newVersionedInstance(long l, int n) {
        switch (this) {
            case NODE: {
                return new Node(l, n);
            }
            case WAY: {
                return new Way(l, n);
            }
            case RELATION: {
                return new Relation(l, n);
            }
        }
        throw new AssertionError();
    }

    public String toString() {
        return I18n.tr(this.getAPIName(), new Object[0]);
    }

    static {
        DATA_VALUES = Arrays.asList(NODE, WAY, RELATION);
    }
}

