/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.overlay.AdLauncherIntentInfoParcel;
import com.google.android.gms.ads.internal.overlay.zzk;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.internal.zzgd;

@zzgd
public class zza {
    public boolean zza(Context context, AdLauncherIntentInfoParcel adLauncherIntentInfoParcel, zzk zzk2) {
        String[] stringArray;
        if (adLauncherIntentInfoParcel == null) {
            zzb.zzaC("No intent data for launcher overlay.");
            return false;
        }
        Intent intent = new Intent();
        if (TextUtils.isEmpty((CharSequence)adLauncherIntentInfoParcel.zzzf)) {
            zzb.zzaC("Open GMSG did not contain a URL.");
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)adLauncherIntentInfoParcel.mimeType)) {
            intent.setDataAndType(Uri.parse((String)adLauncherIntentInfoParcel.zzzf), adLauncherIntentInfoParcel.mimeType);
        } else {
            intent.setData(Uri.parse((String)adLauncherIntentInfoParcel.zzzf));
        }
        intent.setAction("android.intent.action.VIEW");
        if (!TextUtils.isEmpty((CharSequence)adLauncherIntentInfoParcel.packageName)) {
            intent.setPackage(adLauncherIntentInfoParcel.packageName);
        }
        if (!TextUtils.isEmpty((CharSequence)adLauncherIntentInfoParcel.zzzg)) {
            stringArray = adLauncherIntentInfoParcel.zzzg.split("/", 2);
            if (stringArray.length < 2) {
                zzb.zzaC("Could not parse component name from open GMSG: " + adLauncherIntentInfoParcel.zzzg);
                return false;
            }
            intent.setClassName(stringArray[0], stringArray[1]);
        }
        if (!TextUtils.isEmpty((CharSequence)(stringArray = adLauncherIntentInfoParcel.zzzh))) {
            int n = 0;
            try {
                n = Integer.parseInt((String)stringArray);
            }
            catch (NumberFormatException numberFormatException) {
                zzb.zzaC("Could not parse intent flags.");
            }
            intent.addFlags(n);
        }
        try {
            zzb.zzaB("Launching an intent: " + intent.toURI());
            context.startActivity(intent);
            if (zzk2 != null) {
                zzk2.zzaO();
            }
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzb.zzaC(activityNotFoundException.getMessage());
            return false;
        }
        return true;
    }
}

