/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.MutableContextWrapper;
import android.graphics.Canvas;
import android.net.Uri;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.webkit.DownloadListener;
import android.webkit.ValueCallback;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zzk;
import com.google.android.gms.ads.internal.overlay.zzc;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzo;
import com.google.android.gms.internal.zzan;
import com.google.android.gms.internal.zzeu;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzid;
import com.google.android.gms.internal.zzie;
import com.google.android.gms.internal.zzih;
import com.google.android.gms.internal.zzlk;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzgd
public class zzig
extends WebView
implements ViewTreeObserver.OnGlobalLayoutListener,
DownloadListener,
zzid {
    private final zzie zzBd;
    private final zza zzHo;
    private final Object zzqt = new Object();
    private final zzan zzvA;
    private final VersionInfoParcel zzoM;
    private zzc zzHp;
    private AdSizeParcel zzxT;
    private boolean zzHq;
    private boolean zzHr;
    private boolean zzHs;
    private boolean zzHt;
    private boolean zzHu;
    private Boolean zzFO;
    private int zzHv;
    private zzc zzHw;
    boolean zzHx;
    private int zzyX = -1;
    private int zzyW = -1;
    private int zzyZ = -1;
    private int zzza = -1;
    private final WindowManager zzqF;

    static zzig zzb(Context context, AdSizeParcel adSizeParcel, boolean bl, boolean bl2, zzan zzan2, VersionInfoParcel versionInfoParcel) {
        zza zza2 = new zza(context);
        return new zzig(zza2, adSizeParcel, bl, bl2, zzan2, versionInfoParcel);
    }

    protected zzig(zza zza2, AdSizeParcel adSizeParcel, boolean bl, boolean bl2, zzan zzan2, VersionInfoParcel versionInfoParcel) {
        super((Context)zza2);
        this.zzHo = zza2;
        this.zzxT = adSizeParcel;
        this.zzHs = bl;
        this.zzHu = false;
        this.zzHv = -1;
        this.zzvA = zzan2;
        this.zzoM = versionInfoParcel;
        this.zzqF = (WindowManager)this.getContext().getSystemService("window");
        this.setBackgroundColor(0);
        WebSettings webSettings = this.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setSavePassword(false);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        if (Build.VERSION.SDK_INT >= 21) {
            webSettings.setMixedContentMode(0);
        }
        zzo.zzbv().zza((Context)zza2, versionInfoParcel.zzGG, webSettings);
        zzo.zzbx().zza(this.getContext(), webSettings);
        this.setDownloadListener(this);
        this.zzBd = zzo.zzbx().zzb(this, bl2);
        this.setWebViewClient(this.zzBd);
        this.setWebChromeClient(zzo.zzbx().zzf(this));
        this.zzgX();
        if (zzlk.zzoW()) {
            this.addJavascriptInterface(new zzih(this), "googleAdsJsInterface");
        }
    }

    @Override
    public WebView getWebView() {
        return this;
    }

    public boolean zzgT() {
        int n;
        int n2;
        if (!this.zzgF().zzbU()) {
            return false;
        }
        DisplayMetrics displayMetrics = zzo.zzbv().zza(this.zzqF);
        int n3 = zzk.zzcA().zzb(displayMetrics, displayMetrics.widthPixels);
        int n4 = zzk.zzcA().zzb(displayMetrics, displayMetrics.heightPixels);
        Activity activity = this.zzgB();
        if (activity == null || activity.getWindow() == null) {
            n2 = n3;
            n = n4;
        } else {
            int[] nArray = zzo.zzbv().zzg(activity);
            n2 = zzk.zzcA().zzb(displayMetrics, nArray[0]);
            n = zzk.zzcA().zzb(displayMetrics, nArray[1]);
        }
        if (this.zzyW == n3 && this.zzyX == n4 && this.zzyZ == n2 && this.zzza == n) {
            return false;
        }
        boolean bl = this.zzyW != n3 || this.zzyX != n4;
        this.zzyW = n3;
        this.zzyX = n4;
        this.zzyZ = n2;
        this.zzza = n;
        new zzeu(this).zza(n3, n4, n2, n, displayMetrics.density, this.zzqF.getDefaultDisplay().getRotation());
        return bl;
    }

    @Override
    public void zzc(String string2, Map<String, ?> map) {
        JSONObject jSONObject;
        try {
            jSONObject = zzo.zzbv().zzy(map);
        }
        catch (JSONException jSONException) {
            zzb.zzaC("Could not convert parameters to JSON.");
            return;
        }
        this.zzb(string2, jSONObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluateJavascript(String script, ValueCallback<String> resultCallback) {
        Object object = this.zzqt;
        synchronized (object) {
            if (this.isDestroyed()) {
                zzb.zzaC("The webview is destroyed. Ignoring action.");
                if (resultCallback != null) {
                    resultCallback.onReceiveValue(null);
                }
                return;
            }
            super.evaluateJavascript(script, resultCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzaE(String string2) {
        Object object = this.zzqt;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.loadUrl(string2);
            } else {
                zzb.zzaC("The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadUrl(String uri) {
        Object object = this.zzqt;
        synchronized (object) {
            if (!this.isDestroyed()) {
                super.loadUrl(uri);
            } else {
                zzb.zzaC("The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzaD(String string2) {
        Object object = this.zzqt;
        synchronized (object) {
            super.loadUrl(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadData(String data, String mimeType, String encoding) {
        Object object = this.zzqt;
        synchronized (object) {
            if (!this.isDestroyed()) {
                super.loadData(data, mimeType, encoding);
            } else {
                zzb.zzaC("The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadDataWithBaseURL(String baseUrl, String data, String mimeType, String encoding, String historyUrl) {
        Object object = this.zzqt;
        synchronized (object) {
            if (!this.isDestroyed()) {
                super.loadDataWithBaseURL(baseUrl, data, mimeType, encoding, historyUrl);
            } else {
                zzb.zzaC("The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zza(String string2, ValueCallback<String> valueCallback) {
        Object object = this.zzqt;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.evaluateJavascript(string2, valueCallback);
            } else {
                zzb.zzaC("The webview is destroyed. Ignoring action.");
                if (valueCallback != null) {
                    valueCallback.onReceiveValue(null);
                }
            }
        }
    }

    protected void zzaF(String string2) {
        if (zzlk.zzoX()) {
            if (this.zzgc() == null) {
                this.zzgU();
            }
            if (this.zzgc().booleanValue()) {
                this.zza(string2, (ValueCallback<String>)null);
            } else {
                this.zzaE("javascript:" + string2);
            }
        } else {
            this.zzaE("javascript:" + string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzgU() {
        Object object = this.zzqt;
        synchronized (object) {
            this.zzFO = zzo.zzby().zzgc();
            if (this.zzFO == null) {
                try {
                    String string2 = "(function(){})()";
                    this.evaluateJavascript(string2, null);
                    this.zzb(true);
                }
                catch (IllegalStateException illegalStateException) {
                    this.zzb(false);
                }
            }
        }
    }

    void zzb(Boolean bl) {
        this.zzFO = bl;
        zzo.zzby().zzb(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Boolean zzgc() {
        Object object = this.zzqt;
        synchronized (object) {
            return this.zzFO;
        }
    }

    @Override
    public void zza(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        this.zza(string2, string3);
    }

    @Override
    public void zza(String string2, String string3) {
        String string4 = string2 + "(" + string3 + ");";
        this.zzaF(string4);
    }

    @Override
    public void zzb(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AFMA_ReceiveMessage('");
        stringBuilder.append(string2);
        stringBuilder.append("'");
        stringBuilder.append(",");
        stringBuilder.append(string3);
        stringBuilder.append(");");
        zzb.zzaB("Dispatching AFMA event: " + stringBuilder.toString());
        this.zzaF(stringBuilder.toString());
    }

    @Override
    public void zzgA() {
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzoM.zzGG);
        this.zzc("onhide", hashMap);
    }

    @Override
    public void zzv(int n) {
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("closetype", String.valueOf(n));
        hashMap.put("version", this.zzoM.zzGG);
        this.zzc("onhide", hashMap);
    }

    @Override
    public void zzew() {
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzoM.zzGG);
        this.zzc("onshow", hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public zzc zzgD() {
        Object object = this.zzqt;
        synchronized (object) {
            return this.zzHp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public zzc zzgE() {
        Object object = this.zzqt;
        synchronized (object) {
            return this.zzHw;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdSizeParcel zzaN() {
        Object object = this.zzqt;
        synchronized (object) {
            return this.zzxT;
        }
    }

    @Override
    public zzie zzgF() {
        return this.zzBd;
    }

    @Override
    public boolean zzgG() {
        return this.zzHq;
    }

    @Override
    public zzan zzgH() {
        return this.zzvA;
    }

    @Override
    public VersionInfoParcel zzgI() {
        return this.zzoM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzgJ() {
        Object object = this.zzqt;
        synchronized (object) {
            return this.zzHs;
        }
    }

    public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimeType, long size) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.parse((String)url), mimeType);
            this.getContext().startActivity(intent);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzb.zzay("Couldn't find an Activity to view url/mimetype: " + url + " / " + mimeType);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.zzvA != null) {
            this.zzvA.zza(event);
        }
        if (this.isDestroyed()) {
            return false;
        }
        return super.onTouchEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Object object = this.zzqt;
        synchronized (object) {
            if (this.isDestroyed()) {
                this.setMeasuredDimension(0, 0);
                return;
            }
            if (this.isInEditMode() || this.zzHs) {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                return;
            }
            if (this.zzxT.zzsn) {
                DisplayMetrics displayMetrics = new DisplayMetrics();
                this.zzqF.getDefaultDisplay().getMetrics(displayMetrics);
                this.setMeasuredDimension(displayMetrics.widthPixels, displayMetrics.heightPixels);
                return;
            }
            int n = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int n2 = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int n3 = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int n4 = View.MeasureSpec.getSize((int)heightMeasureSpec);
            int n5 = Integer.MAX_VALUE;
            if (n == Integer.MIN_VALUE || n == 0x40000000) {
                n5 = n2;
            }
            int n6 = Integer.MAX_VALUE;
            if (n3 == Integer.MIN_VALUE || n3 == 0x40000000) {
                n6 = n4;
            }
            if (this.zzxT.widthPixels > n5 || this.zzxT.heightPixels > n6) {
                float f = this.zzHo.getResources().getDisplayMetrics().density;
                zzb.zzaC("Not enough space to show ad. Needs " + (int)((float)this.zzxT.widthPixels / f) + "x" + (int)((float)this.zzxT.heightPixels / f) + " dp, but only has " + (int)((float)n2 / f) + "x" + (int)((float)n4 / f) + " dp.");
                if (this.getVisibility() != 8) {
                    this.setVisibility(4);
                }
                this.setMeasuredDimension(0, 0);
            } else {
                if (this.getVisibility() != 8) {
                    this.setVisibility(0);
                }
                this.setMeasuredDimension(this.zzxT.widthPixels, this.zzxT.heightPixels);
            }
        }
    }

    public void onGlobalLayout() {
        boolean bl = this.zzgT();
        zzc zzc2 = this.zzgD();
        if (zzc2 != null && bl) {
            zzc2.zzev();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(Context context, AdSizeParcel adSizeParcel) {
        Object object = this.zzqt;
        synchronized (object) {
            this.zzgV();
            this.setContext(context);
            this.zzHp = null;
            this.zzxT = adSizeParcel;
            this.zzHs = false;
            this.zzHq = false;
            this.zzHv = -1;
            zzo.zzbx().zzb(this);
            this.loadUrl("about:blank");
            this.zzBd.reset();
            this.setOnTouchListener(null);
            this.setOnClickListener(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(zzc zzc2) {
        Object object = this.zzqt;
        synchronized (object) {
            this.zzHp = zzc2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(zzc zzc2) {
        Object object = this.zzqt;
        synchronized (object) {
            this.zzHw = zzc2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(AdSizeParcel adSizeParcel) {
        Object object = this.zzqt;
        synchronized (object) {
            this.zzxT = adSizeParcel;
            this.requestLayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzB(boolean bl) {
        Object object = this.zzqt;
        synchronized (object) {
            this.zzHs = bl;
            this.zzgX();
        }
    }

    private void zzgV() {
        Activity activity = this.zzgB();
        if (this.zzHu && activity != null) {
            zzo.zzbx().zzb(activity, this);
            this.zzHu = false;
        }
    }

    void zzgW() {
        Activity activity = this.zzgB();
        if (!this.zzHu && activity != null && this.zzHx) {
            zzo.zzbv().zza(activity, this);
            this.zzHu = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzgL() {
        Object object = this.zzqt;
        synchronized (object) {
            this.zzgW();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onAttachedToWindow() {
        Object object = this.zzqt;
        synchronized (object) {
            super.onAttachedToWindow();
            if (!this.isDestroyed()) {
                this.zzHx = true;
                if (this.zzBd.zzbU()) {
                    this.zzgW();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDetachedFromWindow() {
        Object object = this.zzqt;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.zzgV();
                this.zzHx = false;
            }
            super.onDetachedFromWindow();
        }
    }

    @Override
    public void setContext(Context context) {
        this.zzHo.setBaseContext(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzC(boolean bl) {
        Object object = this.zzqt;
        synchronized (object) {
            if (this.zzHp != null) {
                this.zzHp.zza(this.zzBd.zzbU(), bl);
            } else {
                this.zzHq = bl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRequestedOrientation() {
        Object object = this.zzqt;
        synchronized (object) {
            return this.zzHv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRequestedOrientation(int requestedOrientation) {
        Object object = this.zzqt;
        synchronized (object) {
            this.zzHv = requestedOrientation;
            if (this.zzHp != null) {
                this.zzHp.setRequestedOrientation(this.zzHv);
            }
        }
    }

    @Override
    public Activity zzgB() {
        return this.zzHo.zzgB();
    }

    @Override
    public Context zzgC() {
        return this.zzHo.zzgC();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzgX() {
        Object object = this.zzqt;
        synchronized (object) {
            if (this.zzHs || this.zzxT.zzsn) {
                if (Build.VERSION.SDK_INT < 14) {
                    zzb.zzay("Disabling hardware acceleration on an overlay.");
                    this.zzgY();
                } else {
                    zzb.zzay("Enabling hardware acceleration on an overlay.");
                    this.zzgZ();
                }
            } else if (Build.VERSION.SDK_INT < 18) {
                zzb.zzay("Disabling hardware acceleration on an AdView.");
                this.zzgY();
            } else {
                zzb.zzay("Enabling hardware acceleration on an AdView.");
                this.zzgZ();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzgY() {
        Object object = this.zzqt;
        synchronized (object) {
            if (!this.zzHt) {
                zzo.zzbx().zzm((View)this);
            }
            this.zzHt = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzgZ() {
        Object object = this.zzqt;
        synchronized (object) {
            if (this.zzHt) {
                zzo.zzbx().zzl((View)this);
            }
            this.zzHt = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.zzqt;
        synchronized (object) {
            this.zzgV();
            if (this.zzHp != null) {
                this.zzHp.close();
                this.zzHp.onDestroy();
                this.zzHp = null;
            }
            this.zzBd.reset();
            if (this.zzHr) {
                return;
            }
            zzo.zzbH().zza(this);
            this.zzHr = true;
            zzb.zzaB("Initiating WebView self destruct sequence in 3...");
            this.zzBd.zzgN();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzgK() {
        Object object = this.zzqt;
        synchronized (object) {
            zzb.zzaB("Destroying WebView!");
            super.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDestroyed() {
        Object object = this.zzqt;
        synchronized (object) {
            return this.zzHr;
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.isDestroyed()) {
            return;
        }
        if (Build.VERSION.SDK_INT == 21 && canvas.isHardwareAccelerated() && !this.isAttachedToWindow()) {
            return;
        }
        super.onDraw(canvas);
    }

    public void onPause() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.onPause();
        }
        catch (Exception exception) {
            zzb.zzb("Could not pause webview.", exception);
        }
    }

    public void onResume() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.onResume();
        }
        catch (Exception exception) {
            zzb.zzb("Could not resume webview.", exception);
        }
    }

    @Override
    public void stopLoading() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.stopLoading();
        }
        catch (Exception exception) {
            zzb.zzb("Could not stop loading webview.", exception);
        }
    }

    @zzgd
    public static class zza
    extends MutableContextWrapper {
        private Activity zzHy;
        private Context zzqw;
        private Context zzHz;

        public zza(Context context) {
            super(context);
            this.setBaseContext(context);
        }

        public void setBaseContext(Context base) {
            this.zzqw = base.getApplicationContext();
            this.zzHy = base instanceof Activity ? (Activity)base : null;
            this.zzHz = base;
            super.setBaseContext(this.zzqw);
        }

        public void startActivity(Intent intent) {
            if (this.zzHy != null && !zzlk.isAtLeastL()) {
                this.zzHy.startActivity(intent);
            } else {
                intent.setFlags(0x10000000);
                this.zzqw.startActivity(intent);
            }
        }

        public Activity zzgB() {
            return this.zzHy;
        }

        public Object getSystemService(String service) {
            return this.zzHz.getSystemService(service);
        }

        public Context zzgC() {
            return this.zzHz;
        }
    }
}

