/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.doubleclick;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.ads.doubleclick.PublisherAdRequest;
import com.google.android.gms.ads.internal.client.zzy;

public final class PublisherAdView
extends ViewGroup {
    private final zzy zznP;

    public PublisherAdView(Context context) {
        super(context);
        this.zznP = new zzy(this);
    }

    public PublisherAdView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.zznP = new zzy(this, attrs, true);
    }

    public PublisherAdView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.zznP = new zzy(this, attrs, true);
    }

    public void destroy() {
        this.zznP.destroy();
    }

    public AdListener getAdListener() {
        return this.zznP.getAdListener();
    }

    public AdSize getAdSize() {
        return this.zznP.getAdSize();
    }

    public AdSize[] getAdSizes() {
        return this.zznP.getAdSizes();
    }

    public String getAdUnitId() {
        return this.zznP.getAdUnitId();
    }

    public AppEventListener getAppEventListener() {
        return this.zznP.getAppEventListener();
    }

    public OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zznP.getOnCustomRenderedAdLoadedListener();
    }

    public void loadAd(PublisherAdRequest publisherAdRequest) {
        this.zznP.zza(publisherAdRequest.zzaF());
    }

    public void pause() {
        this.zznP.pause();
    }

    public void recordManualImpression() {
        this.zznP.recordManualImpression();
    }

    public void resume() {
        this.zznP.resume();
    }

    public void setAdListener(AdListener adListener) {
        this.zznP.setAdListener(adListener);
    }

    public void setAdSizes(AdSize ... adSizes) {
        if (adSizes == null || adSizes.length < 1) {
            throw new IllegalArgumentException("The supported ad sizes must contain at least one valid ad size.");
        }
        this.zznP.zza(adSizes);
    }

    public void setAdUnitId(String adUnitId) {
        this.zznP.setAdUnitId(adUnitId);
    }

    public void setAppEventListener(AppEventListener appEventListener) {
        this.zznP.setAppEventListener(appEventListener);
    }

    public void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        this.zznP.setOnCustomRenderedAdLoadedListener(onCustomRenderedAdLoadedListener);
    }

    public String getMediationAdapterClassName() {
        return this.zznP.getMediationAdapterClassName();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            int n = view.getMeasuredWidth();
            int n2 = view.getMeasuredHeight();
            int n3 = (right - left - n) / 2;
            int n4 = (bottom - top - n2) / 2;
            view.layout(n3, n4, n3 + n, n4 + n2);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n = 0;
        int n2 = 0;
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            this.measureChild(view, widthMeasureSpec, heightMeasureSpec);
            n = view.getMeasuredWidth();
            n2 = view.getMeasuredHeight();
        } else {
            AdSize adSize = this.getAdSize();
            if (adSize != null) {
                Context context = this.getContext();
                n = adSize.getWidthInPixels(context);
                n2 = adSize.getHeightInPixels(context);
            }
        }
        n = Math.max(n, this.getSuggestedMinimumWidth());
        n2 = Math.max(n2, this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(View.resolveSize((int)n, (int)widthMeasureSpec), View.resolveSize((int)n2, (int)heightMeasureSpec));
    }
}

