/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import com.google.android.gms.common.internal.zzk;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.common.internal.zzu;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

final class zzl
extends zzk
implements Handler.Callback {
    private final HashMap<zza, zzb> zzaaL = new HashMap();
    private final Context zzqw;
    private final Handler mHandler;
    private final com.google.android.gms.common.stats.zzb zzaaM;
    private final long zzaaN;

    zzl(Context context) {
        this.zzqw = context.getApplicationContext();
        this.mHandler = new Handler(context.getMainLooper(), (Handler.Callback)this);
        this.zzaaM = com.google.android.gms.common.stats.zzb.zzoO();
        this.zzaaN = 5000L;
    }

    @Override
    public boolean zza(String string2, ServiceConnection serviceConnection, String string3) {
        return this.zza(new zza(string2), serviceConnection, string3);
    }

    @Override
    public boolean zza(ComponentName componentName, ServiceConnection serviceConnection, String string2) {
        return this.zza(new zza(componentName), serviceConnection, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(zza zza2, ServiceConnection serviceConnection, String string2) {
        zzu.zzb(serviceConnection, (Object)"ServiceConnection must not be null");
        HashMap<zza, zzb> hashMap = this.zzaaL;
        synchronized (hashMap) {
            zzb zzb2 = this.zzaaL.get(zza2);
            if (zzb2 == null) {
                zzb2 = new zzb(zza2);
                zzb2.zza(serviceConnection, string2);
                zzb2.zzcc(string2);
                this.zzaaL.put(zza2, zzb2);
            } else {
                this.mHandler.removeMessages(0, (Object)zzb2);
                if (zzb2.zza(serviceConnection)) {
                    throw new IllegalStateException("Trying to bind a GmsServiceConnection that was already connected before.  config=" + zza2);
                }
                zzb2.zza(serviceConnection, string2);
                switch (zzb2.getState()) {
                    case 1: {
                        serviceConnection.onServiceConnected(zzb2.getComponentName(), zzb2.getBinder());
                        break;
                    }
                    case 2: {
                        zzb2.zzcc(string2);
                    }
                }
            }
            return zzb2.isBound();
        }
    }

    @Override
    public void zzb(String string2, ServiceConnection serviceConnection, String string3) {
        this.zzb(new zza(string2), serviceConnection, string3);
    }

    @Override
    public void zzb(ComponentName componentName, ServiceConnection serviceConnection, String string2) {
        this.zzb(new zza(componentName), serviceConnection, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzb(zza zza2, ServiceConnection serviceConnection, String string2) {
        zzu.zzb(serviceConnection, (Object)"ServiceConnection must not be null");
        HashMap<zza, zzb> hashMap = this.zzaaL;
        synchronized (hashMap) {
            zzb zzb2 = this.zzaaL.get(zza2);
            if (zzb2 == null) {
                throw new IllegalStateException("Nonexistent connection status for service config: " + zza2);
            }
            if (!zzb2.zza(serviceConnection)) {
                throw new IllegalStateException("Trying to unbind a GmsServiceConnection  that was not bound before.  config=" + zza2);
            }
            zzb2.zzb(serviceConnection, string2);
            if (zzb2.zznW()) {
                Message message = this.mHandler.obtainMessage(0, (Object)zzb2);
                this.mHandler.sendMessageDelayed(message, this.zzaaN);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                zzb zzb2 = (zzb)msg.obj;
                HashMap<zza, zzb> hashMap = this.zzaaL;
                synchronized (hashMap) {
                    if (zzb2.zznW()) {
                        if (zzb2.isBound()) {
                            zzb2.zzcd("GmsClientSupervisor");
                        }
                        this.zzaaL.remove(zzb2.zzaaS);
                    }
                }
                return true;
            }
        }
        return false;
    }

    private static final class zza {
        private final String zzuO;
        private final ComponentName zzaaO;

        public zza(String string2) {
            this.zzuO = zzu.zzcj(string2);
            this.zzaaO = null;
        }

        public zza(ComponentName componentName) {
            this.zzuO = null;
            this.zzaaO = zzu.zzu(componentName);
        }

        public String toString() {
            return this.zzuO == null ? this.zzaaO.flattenToString() : this.zzuO;
        }

        public Intent zznV() {
            Intent intent = this.zzuO != null ? new Intent(this.zzuO).setPackage("com.google.android.gms") : new Intent().setComponent(this.zzaaO);
            return intent;
        }

        public int hashCode() {
            return zzt.hashCode(this.zzuO, this.zzaaO);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof zza)) {
                return false;
            }
            zza zza2 = (zza)o;
            return zzt.equal(this.zzuO, zza2.zzuO) && zzt.equal(this.zzaaO, zza2.zzaaO);
        }
    }

    private final class zzb {
        private final zza zzaaP;
        private final Set<ServiceConnection> zzaaQ;
        private int mState;
        private boolean zzaaR;
        private IBinder zzZQ;
        private final com.google.android.gms.common.internal.zzl$zza zzaaS;
        private ComponentName zzaaO;

        public zzb(com.google.android.gms.common.internal.zzl$zza zza2) {
            this.zzaaS = zza2;
            this.zzaaP = new zza();
            this.zzaaQ = new HashSet<ServiceConnection>();
            this.mState = 2;
        }

        public void zzcc(String string2) {
            this.zzaaR = zzl.this.zzaaM.zza(zzl.this.zzqw, string2, this.zzaaS.zznV(), this.zzaaP, 129);
            if (this.zzaaR) {
                this.mState = 3;
            } else {
                try {
                    zzl.this.zzaaM.zza(zzl.this.zzqw, this.zzaaP);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }

        public void zzcd(String string2) {
            zzl.this.zzaaM.zza(zzl.this.zzqw, this.zzaaP);
            this.zzaaR = false;
            this.mState = 2;
        }

        public void zza(ServiceConnection serviceConnection, String string2) {
            zzl.this.zzaaM.zza(zzl.this.zzqw, serviceConnection, string2, this.zzaaS.zznV());
            this.zzaaQ.add(serviceConnection);
        }

        public void zzb(ServiceConnection serviceConnection, String string2) {
            zzl.this.zzaaM.zzb(zzl.this.zzqw, serviceConnection);
            this.zzaaQ.remove(serviceConnection);
        }

        public boolean isBound() {
            return this.zzaaR;
        }

        public int getState() {
            return this.mState;
        }

        public boolean zza(ServiceConnection serviceConnection) {
            return this.zzaaQ.contains(serviceConnection);
        }

        public boolean zznW() {
            return this.zzaaQ.isEmpty();
        }

        public IBinder getBinder() {
            return this.zzZQ;
        }

        public ComponentName getComponentName() {
            return this.zzaaO;
        }

        public class zza
        implements ServiceConnection {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onServiceConnected(ComponentName component, IBinder binder) {
                HashMap hashMap = zzl.this.zzaaL;
                synchronized (hashMap) {
                    zzb.this.zzZQ = binder;
                    zzb.this.zzaaO = component;
                    for (ServiceConnection serviceConnection : zzb.this.zzaaQ) {
                        serviceConnection.onServiceConnected(component, binder);
                    }
                    zzb.this.mState = 1;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onServiceDisconnected(ComponentName component) {
                HashMap hashMap = zzl.this.zzaaL;
                synchronized (hashMap) {
                    zzb.this.zzZQ = null;
                    zzb.this.zzaaO = component;
                    for (ServiceConnection serviceConnection : zzb.this.zzaaQ) {
                        serviceConnection.onServiceDisconnected(component);
                    }
                    zzb.this.mState = 2;
                }
            }
        }
    }
}

