/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.stats;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Debug;
import android.os.Parcelable;
import android.os.Process;
import android.os.SystemClock;
import android.util.Log;
import com.google.android.gms.common.stats.ConnectionEvent;
import com.google.android.gms.common.stats.zzc;
import com.google.android.gms.common.stats.zzd;
import com.google.android.gms.common.stats.zze;
import com.google.android.gms.internal.zzla;
import com.google.android.gms.internal.zzll;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class zzb {
    private static final Object zzaaJ = new Object();
    private static zzb zzack;
    private final List<String> zzacl;
    private final List<String> zzacm;
    private final List<String> zzacn;
    private final List<String> zzaco;
    private static final ComponentName zzacp;
    private zze zzacq;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzb zzoO() {
        Object object = zzaaJ;
        synchronized (object) {
            if (zzack == null) {
                zzack = new zzb();
            }
        }
        return zzack;
    }

    private zzb() {
        if (this.getLogLevel() == zzd.zzacz) {
            this.zzacl = Collections.EMPTY_LIST;
            this.zzacm = Collections.EMPTY_LIST;
            this.zzacn = Collections.EMPTY_LIST;
            this.zzaco = Collections.EMPTY_LIST;
            return;
        }
        String string2 = zzc.zza.zzacu.get();
        this.zzacl = string2 == null ? Collections.EMPTY_LIST : Arrays.asList(string2.split(","));
        string2 = zzc.zza.zzacv.get();
        this.zzacm = string2 == null ? Collections.EMPTY_LIST : Arrays.asList(string2.split(","));
        string2 = zzc.zza.zzacw.get();
        this.zzacn = string2 == null ? Collections.EMPTY_LIST : Arrays.asList(string2.split(","));
        string2 = zzc.zza.zzacx.get();
        this.zzaco = string2 == null ? Collections.EMPTY_LIST : Arrays.asList(string2.split(","));
        this.zzacq = new zze(1024, zzc.zza.zzacy.get());
    }

    private boolean zza(Context context, Intent intent) {
        ComponentName componentName = intent.getComponent();
        if (componentName == null || com.google.android.gms.common.internal.zzd.zzZR && "com.google.android.gms".equals(componentName.getPackageName())) {
            return false;
        }
        return zzla.zzi(context, componentName.getPackageName());
    }

    public boolean zza(Context context, String string2, Intent intent, ServiceConnection serviceConnection, int n) {
        if (this.zza(context, intent)) {
            Log.w((String)"ConnectionTracker", (String)"Attempted to bind to a service in a STOPPED package.");
            return false;
        }
        this.zza(context, serviceConnection, string2, intent, 2);
        return context.bindService(intent, serviceConnection, n);
    }

    public boolean zza(Context context, Intent intent, ServiceConnection serviceConnection, int n) {
        return this.zza(context, context.getClass().getName(), intent, serviceConnection, n);
    }

    public void zza(Context context, ServiceConnection serviceConnection) {
        this.zza(context, serviceConnection, null, null, 1);
        context.unbindService(serviceConnection);
    }

    public void zza(Context context, ServiceConnection serviceConnection, String string2, Intent intent) {
        this.zza(context, serviceConnection, string2, intent, 3);
    }

    public void zzb(Context context, ServiceConnection serviceConnection) {
        this.zza(context, serviceConnection, null, null, 4);
    }

    private void zza(Context context, ServiceConnection serviceConnection, String string2, Intent intent, int n) {
        ConnectionEvent connectionEvent;
        if (!com.google.android.gms.common.internal.zzd.zzZR) {
            return;
        }
        String string3 = this.zzb(serviceConnection);
        if (!this.zza(context, string2, intent, string3, n)) {
            return;
        }
        long l = System.currentTimeMillis();
        String string4 = null;
        if ((this.getLogLevel() & zzd.zzacD) != 0) {
            string4 = zzll.zzl(3, 5);
        }
        long l2 = 0L;
        if ((this.getLogLevel() & zzd.zzacF) != 0) {
            l2 = Debug.getNativeHeapAllocatedSize();
        }
        if (n == 1 || n == 4) {
            connectionEvent = new ConnectionEvent(l, n, null, null, null, null, string4, string3, SystemClock.elapsedRealtime(), l2);
        } else {
            ServiceInfo serviceInfo = zzb.zzb(context, intent);
            connectionEvent = new ConnectionEvent(l, n, zzll.zzaj(context), string2, serviceInfo.processName, serviceInfo.name, string4, string3, SystemClock.elapsedRealtime(), l2);
        }
        context.startService(new Intent().setComponent(zzacp).putExtra("com.google.android.gms.common.stats.EXTRA_LOG_EVENT", (Parcelable)connectionEvent));
    }

    private boolean zza(Context context, String string2, Intent intent, String string3, int n) {
        int n2 = this.getLogLevel();
        if (n2 == zzd.zzacz || this.zzacq == null) {
            return false;
        }
        if (n == 4 || n == 1) {
            return this.zzacq.zzcq(string3);
        }
        ServiceInfo serviceInfo = zzb.zzb(context, intent);
        if (serviceInfo == null) {
            Log.w((String)"ConnectionTracker", (String)String.format("Client %s made an invalid request %s", string2, intent.toUri(0)));
            return false;
        }
        String string4 = zzll.zzaj(context);
        String string5 = serviceInfo.processName;
        String string6 = serviceInfo.name;
        if (this.zzacl.contains(string4) || this.zzacm.contains(string2) || this.zzacn.contains(string5) || this.zzaco.contains(string6) || string5.equals(string4) && (n2 & zzd.zzacE) != 0) {
            return false;
        }
        this.zzacq.zzcp(string3);
        return true;
    }

    private static ServiceInfo zzb(Context context, Intent intent) {
        List list = context.getPackageManager().queryIntentServices(intent, 128);
        if (list == null || list.size() == 0) {
            Log.w((String)"ConnectionTracker", (String)String.format("There are no handler of this intent: %s\n Stack trace: %s", intent.toUri(0), zzll.zzl(3, 20)));
            return null;
        }
        if (list.size() > 1) {
            Log.w((String)"ConnectionTracker", (String)String.format("Multiple handlers found for this intent: %s\n Stack trace: %s", intent.toUri(0), zzll.zzl(3, 20)));
            Iterator iterator = list.iterator();
            if (iterator.hasNext()) {
                ResolveInfo resolveInfo = (ResolveInfo)iterator.next();
                Log.w((String)"ConnectionTracker", (String)resolveInfo.serviceInfo.name);
                return null;
            }
        }
        return ((ResolveInfo)list.get((int)0)).serviceInfo;
    }

    private String zzb(ServiceConnection serviceConnection) {
        return String.valueOf(Process.myPid() << 32 | System.identityHashCode(serviceConnection));
    }

    private int getLogLevel() {
        try {
            return zzla.zziW() ? zzc.zza.zzact.get() : zzd.zzacz;
        }
        catch (SecurityException securityException) {
            return zzd.zzacz;
        }
    }

    static {
        zzacp = new ComponentName("com.google.android.gms", "com.google.android.gms.common.stats.GmsCoreStatsService");
    }
}

