/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zzc;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.fitness.FitnessActivities;
import com.google.android.gms.fitness.data.Application;
import com.google.android.gms.fitness.data.zzp;
import java.util.concurrent.TimeUnit;

public class Session
implements SafeParcelable {
    public static final String EXTRA_SESSION = "vnd.google.fitness.session";
    public static final String MIME_TYPE_PREFIX = "vnd.google.fitness.session/";
    private final int zzCY;
    private final long zzKT;
    private final long zzajH;
    private final String mName;
    private final String zzakL;
    private final String zzakM;
    private final int zzajR;
    private final Application zzake;
    private final Long zzakN;
    public static final Parcelable.Creator<Session> CREATOR = new zzp();

    Session(int versionCode, long startTimeMillis, long endTimeMillis, String name, String identifier, String description, int activityType, Application application, Long activeTimeMillis) {
        this.zzCY = versionCode;
        this.zzKT = startTimeMillis;
        this.zzajH = endTimeMillis;
        this.mName = name;
        this.zzakL = identifier;
        this.zzakM = description;
        this.zzajR = activityType;
        this.zzake = application;
        this.zzakN = activeTimeMillis;
    }

    public Session(long startTimeMillis, long endTimeMillis, String name, String identifier, String description, int activityType, Application application, Long activeTimeMillis) {
        this(3, startTimeMillis, endTimeMillis, name, identifier, description, activityType, application, activeTimeMillis);
    }

    private Session(Builder builder) {
        this(builder.zzKT, builder.zzajH, builder.mName, builder.zzakL, builder.zzakM, builder.zzajR, builder.zzake, builder.zzakN);
    }

    public static Session extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return zzc.zza(intent, EXTRA_SESSION, CREATOR);
    }

    public static String getMimeType(String activity) {
        return MIME_TYPE_PREFIX + activity;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzKT, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzajH, TimeUnit.MILLISECONDS);
    }

    public long getActiveTime(TimeUnit timeUnit) {
        zzu.zza(this.zzakN != null, (Object)"Active time is not set");
        return timeUnit.convert(this.zzakN, TimeUnit.MILLISECONDS);
    }

    public boolean hasActiveTime() {
        return this.zzakN != null;
    }

    public boolean isOngoing() {
        return this.zzajH == 0L;
    }

    public String getName() {
        return this.mName;
    }

    public String getIdentifier() {
        return this.zzakL;
    }

    public String getDescription() {
        return this.zzakM;
    }

    public String getActivity() {
        return FitnessActivities.getName(this.zzajR);
    }

    public int zzqq() {
        return this.zzajR;
    }

    public Application zzqB() {
        return this.zzake;
    }

    public String getAppPackageName() {
        return this.zzake == null ? null : this.zzake.getPackageName();
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Session && this.zza((Session)o);
    }

    private boolean zza(Session session) {
        return this.zzKT == session.zzKT && this.zzajH == session.zzajH && zzt.equal(this.mName, session.mName) && zzt.equal(this.zzakL, session.zzakL) && zzt.equal(this.zzakM, session.zzakM) && zzt.equal(this.zzake, session.zzake) && this.zzajR == session.zzajR;
    }

    public int hashCode() {
        return zzt.hashCode(this.zzKT, this.zzajH, this.zzakL);
    }

    public String toString() {
        return zzt.zzt(this).zzg("startTime", this.zzKT).zzg("endTime", this.zzajH).zzg("name", this.mName).zzg("identifier", this.zzakL).zzg("description", this.zzakM).zzg("activity", this.zzajR).zzg("application", this.zzake).toString();
    }

    int getVersionCode() {
        return this.zzCY;
    }

    public long zzkt() {
        return this.zzKT;
    }

    public long zzqs() {
        return this.zzajH;
    }

    public Long zzqJ() {
        return this.zzakN;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzp.zza(this, dest, flags);
    }

    public static class Builder {
        private long zzKT = 0L;
        private long zzajH = 0L;
        private String mName = null;
        private String zzakL;
        private String zzakM;
        private int zzajR = 4;
        private Application zzake;
        private Long zzakN;

        public Builder setStartTime(long time, TimeUnit timeUnit) {
            zzu.zza(time > 0L, (Object)"Start time should be positive.");
            this.zzKT = timeUnit.toMillis(time);
            return this;
        }

        public Builder setEndTime(long time, TimeUnit timeUnit) {
            zzu.zza(time >= 0L, (Object)"End time should be positive.");
            this.zzajH = timeUnit.toMillis(time);
            return this;
        }

        public Builder setName(String name) {
            zzu.zzb(name.length() <= 100, "Session name cannot exceed %d characters", 100);
            this.mName = name;
            return this;
        }

        public Builder setIdentifier(String identifier) {
            zzu.zzV(identifier != null && TextUtils.getTrimmedLength((CharSequence)identifier) > 0);
            this.zzakL = identifier;
            return this;
        }

        public Builder setDescription(String description) {
            zzu.zzb(description.length() <= 1000, "Session description cannot exceed %d characters", 1000);
            this.zzakM = description;
            return this;
        }

        public Builder setActivity(String activity) {
            return this.zzeo(FitnessActivities.zzcF(activity));
        }

        public Builder zzeo(int n) {
            this.zzajR = n;
            return this;
        }

        public Builder setActiveTime(long time, TimeUnit timeUnit) {
            this.zzakN = timeUnit.toMillis(time);
            return this;
        }

        public Session build() {
            zzu.zza(this.zzKT > 0L, (Object)"Start time should be specified.");
            zzu.zza(this.zzajH == 0L || this.zzajH > this.zzKT, (Object)"End time should be later than start time.");
            if (this.zzakL == null) {
                this.zzakL = (this.mName == null ? "" : this.mName) + this.zzKT;
            }
            return new Session(this);
        }
    }
}

