/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.service;

import android.app.AppOpsManager;
import android.app.Service;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.internal.service.FitnessDataSourcesRequest;
import com.google.android.gms.fitness.internal.service.FitnessUnregistrationRequest;
import com.google.android.gms.fitness.internal.service.zzc;
import com.google.android.gms.fitness.result.DataSourcesResult;
import com.google.android.gms.fitness.service.FitnessSensorServiceRequest;
import com.google.android.gms.internal.zzlk;
import com.google.android.gms.internal.zzmg;
import com.google.android.gms.internal.zzmu;
import java.util.List;

public abstract class FitnessSensorService
extends Service {
    public static final String SERVICE_INTERFACE = "com.google.android.gms.fitness.service.FitnessSensorService";
    private zza zzamY;

    public void onCreate() {
        super.onCreate();
        this.zzamY = new zza(this);
    }

    public final IBinder onBind(Intent intent) {
        if (SERVICE_INTERFACE.equals(intent.getAction())) {
            if (Log.isLoggable((String)"FitnessSensorService", (int)3)) {
                Log.d((String)"FitnessSensorService", (String)("Intent " + intent + " received by " + ((Object)((Object)this)).getClass().getName()));
            }
            return this.zzamY.asBinder();
        }
        return null;
    }

    public abstract List<DataSource> onFindDataSources(List<DataType> var1);

    public abstract boolean onRegister(FitnessSensorServiceRequest var1);

    public abstract boolean onUnregister(DataSource var1);

    protected void zzrA() throws SecurityException {
        int n = Binder.getCallingUid();
        String string2 = "com.google.android.gms";
        if (zzlk.zzoX()) {
            AppOpsManager appOpsManager = (AppOpsManager)this.getSystemService("appops");
            appOpsManager.checkPackage(n, "com.google.android.gms");
            return;
        }
        PackageManager packageManager = this.getPackageManager();
        String[] stringArray = packageManager.getPackagesForUid(n);
        if (stringArray != null) {
            for (String string3 : stringArray) {
                if (!string3.equals("com.google.android.gms")) continue;
                return;
            }
        }
        throw new SecurityException("Unauthorized caller");
    }

    private static class zza
    extends zzc.zza {
        private final FitnessSensorService zzamZ;

        private zza(FitnessSensorService fitnessSensorService) {
            this.zzamZ = fitnessSensorService;
        }

        @Override
        public void zza(FitnessDataSourcesRequest fitnessDataSourcesRequest, zzmg zzmg2) throws RemoteException {
            this.zzamZ.zzrA();
            List<DataSource> list = this.zzamZ.onFindDataSources(fitnessDataSourcesRequest.getDataTypes());
            zzmg2.zza(new DataSourcesResult(list, Status.zzXP));
        }

        @Override
        public void zza(FitnessSensorServiceRequest fitnessSensorServiceRequest, zzmu zzmu2) throws RemoteException {
            this.zzamZ.zzrA();
            if (this.zzamZ.onRegister(fitnessSensorServiceRequest)) {
                zzmu2.zzm(Status.zzXP);
            } else {
                zzmu2.zzm(new Status(13));
            }
        }

        @Override
        public void zza(FitnessUnregistrationRequest fitnessUnregistrationRequest, zzmu zzmu2) throws RemoteException {
            this.zzamZ.zzrA();
            if (this.zzamZ.onUnregister(fitnessUnregistrationRequest.getDataSource())) {
                zzmu2.zzm(Status.zzXP);
            } else {
                zzmu2.zzm(new Status(13));
            }
        }
    }
}

