/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.Task;

public class PeriodicTask
extends Task {
    protected long mIntervalInSeconds = -1L;
    protected long mFlexInSeconds = -1L;
    public static final Parcelable.Creator<PeriodicTask> CREATOR = new Parcelable.Creator<PeriodicTask>(){

        public PeriodicTask zzdX(Parcel parcel) {
            return new PeriodicTask(parcel);
        }

        public PeriodicTask[] zzgj(int n) {
            return new PeriodicTask[n];
        }

        public /* synthetic */ Object[] newArray(int x0) {
            return this.zzgj(x0);
        }

        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.zzdX(x0);
        }
    };

    private PeriodicTask(Builder builder) {
        super(builder);
        this.mIntervalInSeconds = builder.zzawd;
        this.mFlexInSeconds = builder.zzawe;
    }

    @Deprecated
    private PeriodicTask(Parcel in) {
        super(in);
        this.mIntervalInSeconds = in.readLong();
        this.mFlexInSeconds = in.readLong();
    }

    @Override
    public void toBundle(Bundle bundle) {
        super.toBundle(bundle);
        bundle.putLong("period", this.mIntervalInSeconds);
        bundle.putLong("period_flex", this.mFlexInSeconds);
    }

    public long getPeriod() {
        return this.mIntervalInSeconds;
    }

    public long getFlex() {
        return this.mFlexInSeconds;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        super.writeToParcel(parcel, flags);
        parcel.writeLong(this.mIntervalInSeconds);
        parcel.writeLong(this.mFlexInSeconds);
    }

    public String toString() {
        return super.toString() + " " + "period=" + this.getPeriod() + " " + "flex=" + this.getFlex();
    }

    public static class Builder
    extends Task.Builder {
        private long zzawd = -1L;
        private long zzawe = -1L;

        public Builder() {
            this.isPersisted = true;
        }

        public Builder setPeriod(long intervalInSeconds) {
            this.zzawd = intervalInSeconds;
            return this;
        }

        public Builder setFlex(long flexInSeconds) {
            this.zzawe = flexInSeconds;
            return this;
        }

        @Override
        public Builder setService(Class<? extends GcmTaskService> gcmTaskService) {
            this.gcmTaskService = gcmTaskService.getName();
            return this;
        }

        @Override
        public Builder setRequiredNetwork(int requiredNetworkState) {
            this.requiredNetworkState = requiredNetworkState;
            return this;
        }

        @Override
        public Builder setRequiresCharging(boolean requiresCharging) {
            this.requiresCharging = requiresCharging;
            return this;
        }

        @Override
        public Builder setTag(String tag) {
            this.tag = tag;
            return this;
        }

        @Override
        public Builder setPersisted(boolean isPersisted) {
            this.isPersisted = isPersisted;
            return this;
        }

        @Override
        public Builder setUpdateCurrent(boolean updateCurrent) {
            this.updateCurrent = updateCurrent;
            return this;
        }

        @Override
        public PeriodicTask build() {
            this.checkConditions();
            return new PeriodicTask(this);
        }

        @Override
        protected void checkConditions() {
            super.checkConditions();
            if (this.zzawd == -1L) {
                throw new IllegalArgumentException("Must call setPeriod(long) to establish an execution interval for this periodic task.");
            }
            if (this.zzawe == -1L) {
                this.zzawe = (long)((float)this.zzawd * 0.1f);
            }
        }
    }
}

