/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Color;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;

class zza {
    static zza zzavF;
    private Context mContext;

    static synchronized zza zzar(Context context) {
        if (zzavF == null) {
            zzavF = new zza(context);
        }
        return zzavF;
    }

    static boolean zzt(Bundle bundle) {
        return zza.zzb(bundle, "gcm.n.title") != null;
    }

    static String zzb(Bundle bundle, String string2) {
        String string3 = bundle.getString(string2);
        if (string3 == null) {
            string3 = bundle.getString(string2.replace("gcm.n.", "gcm.notification."));
        }
        return string3;
    }

    private zza(Context context) {
        this.mContext = context.getApplicationContext();
    }

    boolean zzu(Bundle bundle) {
        try {
            Notification notification = this.zzv(bundle);
            this.zza(zza.zzb(bundle, "gcm.n.tag"), notification);
            return true;
        }
        catch (zza zza2) {
            Log.w((String)"GcmNotification", (String)("Failed to show notification: " + zza2.getMessage()));
            return false;
        }
    }

    private Notification zzv(Bundle bundle) {
        Notification notification;
        String string2 = zza.zzb(bundle, "gcm.n.title");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new zza("Missing title");
        }
        String string3 = zza.zzb(bundle, "gcm.n.body");
        int n = this.zzda(zza.zzb(bundle, "gcm.n.icon"));
        Uri uri = this.zzdb(zza.zzb(bundle, "gcm.n.sound"));
        PendingIntent pendingIntent = this.zzw(bundle);
        if (Build.VERSION.SDK_INT >= 11) {
            String string4;
            Notification.Builder builder = new Notification.Builder(this.mContext).setAutoCancel(true).setSmallIcon(n).setContentTitle((CharSequence)string2).setContentText((CharSequence)string3);
            if (Build.VERSION.SDK_INT >= 21 && !TextUtils.isEmpty((CharSequence)(string4 = zza.zzb(bundle, "gcm.n.color")))) {
                builder.setColor(Color.parseColor((String)string4));
            }
            if (uri != null) {
                builder.setSound(uri);
            }
            if (pendingIntent != null) {
                builder.setContentIntent(pendingIntent);
            }
            notification = Build.VERSION.SDK_INT >= 16 ? builder.build() : builder.getNotification();
        } else {
            notification = new Notification();
            notification.flags |= 0x10;
            notification.icon = n;
            if (uri != null) {
                notification.sound = uri;
            }
            if (pendingIntent == null) {
                Intent intent = new Intent();
                intent.setPackage("com.google.example.invalidpackage");
                pendingIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)intent, (int)0);
            }
            notification.setLatestEventInfo(this.mContext, (CharSequence)string2, (CharSequence)string3, pendingIntent);
        }
        return notification;
    }

    private void zza(String string2, Notification notification) {
        if (Log.isLoggable((String)"GcmNotification", (int)3)) {
            Log.d((String)"GcmNotification", (String)"Showing notification");
        }
        NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string2 = "GCM-Notification:" + SystemClock.uptimeMillis();
        }
        notificationManager.notify(string2, 0, notification);
    }

    private int zzda(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new zza("Missing icon");
        }
        Resources resources = this.mContext.getResources();
        int n = resources.getIdentifier(string2, "drawable", this.mContext.getPackageName());
        if (n != 0) {
            return n;
        }
        n = resources.getIdentifier(string2, "mipmap", this.mContext.getPackageName());
        if (n != 0) {
            return n;
        }
        throw new zza("Icon resource not found: " + string2);
    }

    private Uri zzdb(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        if ("default".equals(string2)) {
            return RingtoneManager.getDefaultUri((int)2);
        }
        throw new zza("Invalid sound: " + string2);
    }

    private PendingIntent zzw(Bundle bundle) {
        String string2 = zza.zzb(bundle, "gcm.n.click_action");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        Intent intent = new Intent(string2);
        intent.setPackage(this.mContext.getPackageName());
        intent.setFlags(0x10000000);
        intent.putExtras(bundle);
        for (String string3 : bundle.keySet()) {
            if (!string3.startsWith("gcm.n.") && !string3.startsWith("gcm.notification.")) continue;
            intent.removeExtra(string3);
        }
        return PendingIntent.getActivity((Context)this.mContext, (int)0, (Intent)intent, (int)0x40000000);
    }

    private class zza
    extends IllegalArgumentException {
        private zza(String string2) {
            super(string2);
        }
    }
}

