/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.provider.CalendarContract;
import android.text.TextUtils;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzo;
import com.google.android.gms.internal.zzbq;
import com.google.android.gms.internal.zzeu;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzid;
import java.util.Map;

@zzgd
public class zzeo
extends zzeu {
    private final Map<String, String> zzyn;
    private final Context mContext;
    private String zzyo;
    private long zzyp;
    private long zzyq;
    private String zzyr;
    private String zzys;

    public zzeo(zzid zzid2, Map<String, String> map) {
        super(zzid2, "createCalendarEvent");
        this.zzyn = map;
        this.mContext = zzid2.zzgB();
        this.zzeb();
    }

    private void zzeb() {
        this.zzyo = this.zzab("description");
        this.zzyr = this.zzab("summary");
        this.zzyp = this.zzac("start_ticks");
        this.zzyq = this.zzac("end_ticks");
        this.zzys = this.zzab("location");
    }

    private String zzab(String string2) {
        return TextUtils.isEmpty((CharSequence)this.zzyn.get(string2)) ? "" : this.zzyn.get(string2);
    }

    private long zzac(String string2) {
        String string3 = this.zzyn.get(string2);
        if (string3 == null) {
            return -1L;
        }
        try {
            return Long.parseLong(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public void execute() {
        if (this.mContext == null) {
            this.zzae("Activity context is not available.");
            return;
        }
        zzbq zzbq2 = zzo.zzbv().zzK(this.mContext);
        if (!zzbq2.zzcV()) {
            this.zzae("This feature is not available on the device.");
            return;
        }
        AlertDialog.Builder builder = zzo.zzbv().zzJ(this.mContext);
        builder.setTitle((CharSequence)zzo.zzby().zzc(R.string.create_calendar_title, "Create calendar event"));
        builder.setMessage((CharSequence)zzo.zzby().zzc(R.string.create_calendar_message, "Allow Ad to create a calendar event?"));
        builder.setPositiveButton((CharSequence)zzo.zzby().zzc(R.string.accept, "Accept"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                Intent intent = zzeo.this.createIntent();
                zzeo.this.mContext.startActivity(intent);
            }
        });
        builder.setNegativeButton((CharSequence)zzo.zzby().zzc(R.string.decline, "Decline"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                zzeo.this.zzae("Operation denied by user.");
            }
        });
        builder.create().show();
    }

    Intent createIntent() {
        Intent intent = new Intent("android.intent.action.EDIT").setData(CalendarContract.Events.CONTENT_URI);
        intent.putExtra("title", this.zzyo);
        intent.putExtra("eventLocation", this.zzys);
        intent.putExtra("description", this.zzyr);
        if (this.zzyp > -1L) {
            intent.putExtra("beginTime", this.zzyp);
        }
        if (this.zzyq > -1L) {
            intent.putExtra("endTime", this.zzyq);
        }
        intent.setFlags(0x10000000);
        return intent;
    }
}

